/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.spark.sql.connect.client.Artifact$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u0012$\u0001AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005s!AA\t\u0001BC\u0002\u0013\u0005Q\tC\u0005\u00024\u0001\u0011\t\u0011)A\u0005\r\"1A\n\u0001C\u0005\u0003kA\u0001B\u001a\u0001\t\u0006\u0004%\taZ\u0004\u0006\u0013\u000eB\tA\u0013\u0004\u0006E\rB\ta\u0013\u0005\u0006\u0019\"!\t!\u0014\u0005\b\u001d\"\u0011\r\u0011\"\u00019\u0011\u0019y\u0005\u0002)A\u0005s!9\u0001\u000b\u0003b\u0001\n\u0003A\u0004BB)\tA\u0003%\u0011\bC\u0004S\u0011\t\u0007I\u0011\u0001\u001d\t\rMC\u0001\u0015!\u0003:\u0011\u0015!\u0006\u0002\"\u0001V\u0011\u0015i\b\u0002\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0003C\u0001\u0003\u000bAq!a\t\t\t\u0013\t)CB\u0004]\u0011A\u0005\u0019\u0013E/\t\u000by#b\u0011A0\t\u000b\u0019$b\u0011A4\u0007\taD\u0001!\u001f\u0005\to]\u0011)\u0019!C\u0001q!A1i\u0006B\u0001B\u0003%\u0011\bC\u0003M/\u0011\u0005!\u0010C\u0003g/\u0011\u0005s\rC\u0003_/\u0011\u0005sL\u0002\u0003m\u0011\u0001i\u0007\u0002\u00038\u001e\u0005\u0003\u0005\u000b\u0011B8\t\u000b1kB\u0011A;\t\u000b\u0019lB\u0011I4\t\u000bykB\u0011I0\u0003\u0011\u0005\u0013H/\u001b4bGRT!\u0001J\u0013\u0002\r\rd\u0017.\u001a8u\u0015\t1s%A\u0004d_:tWm\u0019;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g-\u0001\u0003qCRDW#A\u001d\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001\u00024jY\u0016T!AP \u0002\u00079LwNC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\t[$\u0001\u0002)bi\"\fQ\u0001]1uQ\u0002\nqa\u001d;pe\u0006<W-F\u0001G!\t9EC\u0004\u0002I\u000f5\t1%\u0001\u0005BeRLg-Y2u!\tA\u0005b\u0005\u0002\tc\u00051A(\u001b8jiz\"\u0012AS\u0001\r\u00072\u000b5kU0Q%\u00163\u0015\nW\u0001\u000e\u00072\u000b5kU0Q%\u00163\u0015\n\u0017\u0011\u0002\u0015)\u000b%k\u0018)S\u000b\u001aK\u0005,A\u0006K\u0003J{\u0006KU#G\u0013b\u0003\u0013\u0001D\"B\u0007\"+u\f\u0015*F\r&C\u0016!D\"B\u0007\"+u\f\u0015*F\r&C\u0006%\u0001\boK^T\u0015M]!si&4\u0017m\u0019;\u0015\u0007Y;\u0016\f\u0005\u0002I\u0001!)\u0001\f\u0005a\u0001s\u0005Aa-\u001b7f\u001d\u0006lW\rC\u0003E!\u0001\u0007!\f\u0005\u0002\\)5\t\u0001BA\u0005M_\u000e\fG\u000eR1uCN\u0011A#M\u0001\u0007gR\u0014X-Y7\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY \u0002\u0005%|\u0017BA3c\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\tML'0Z\u000b\u0002QB\u0011!'[\u0005\u0003UN\u0012A\u0001T8oO&\u001aA#H\f\u0003\u0011%sW*Z7pef\u001c2!H\u0019[\u0003\u0015\u0011\u0017\u0010^3t!\r\u0011\u0004O]\u0005\u0003cN\u0012Q!\u0011:sCf\u0004\"AM:\n\u0005Q\u001c$\u0001\u0002\"zi\u0016$\"A^<\u0011\u0005mk\u0002\"\u00028 \u0001\u0004y'!\u0003'pG\u0006dg)\u001b7f'\r9\u0012G\u0017\u000b\u0003wr\u0004\"aW\f\t\u000b]R\u0002\u0019A\u001d\u0002!9,wo\u00117bgN\f%\u000f^5gC\u000e$H\u0003\u0002,\u0000\u0003\u0003AQ\u0001W\tA\u0002eBQ\u0001R\tA\u0002i\u000b\u0001C\\3x\u0007\u0006\u001c\u0007.Z!si&4\u0017m\u0019;\u0015\u000bY\u000b9!!\t\t\u000f\u0005%!\u00031\u0001\u0002\f\u0005\u0011\u0011\u000e\u001a\t\u0005\u0003\u001b\tYB\u0004\u0003\u0002\u0010\u0005]\u0001cAA\tg5\u0011\u00111\u0003\u0006\u0004\u0003+y\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001aM\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\rg!)AI\u0005a\u00015\u0006Ya.Z<BeRLg-Y2u)%1\u0016qEA\u0016\u0003_\t\t\u0004\u0003\u0004\u0002*M\u0001\r!O\u0001\u0007aJ,g-\u001b=\t\u000f\u000552\u00031\u0001\u0002\f\u0005q!/Z9vSJ,GmU;gM&D\b\"\u0002-\u0014\u0001\u0004I\u0004\"\u0002#\u0014\u0001\u0004Q\u0016\u0001C:u_J\fw-\u001a\u0011\u0015\u000bY\u000b9$!\u000f\t\u000b]*\u0001\u0019A\u001d\t\u000b\u0011+\u0001\u0019\u0001$")
public class Artifact {
    private long size;
    private final Path path;
    private final LocalData storage;
    private volatile boolean bitmap$0;

    public static Artifact newCacheArtifact(String id, LocalData storage) {
        return Artifact$.MODULE$.newCacheArtifact(id, storage);
    }

    public static Artifact newClassArtifact(Path fileName, LocalData storage) {
        return Artifact$.MODULE$.newClassArtifact(fileName, storage);
    }

    public static Artifact newJarArtifact(Path fileName, LocalData storage) {
        return Artifact$.MODULE$.newJarArtifact(fileName, storage);
    }

    public static Path CACHE_PREFIX() {
        return Artifact$.MODULE$.CACHE_PREFIX();
    }

    public static Path JAR_PREFIX() {
        return Artifact$.MODULE$.JAR_PREFIX();
    }

    public static Path CLASS_PREFIX() {
        return Artifact$.MODULE$.CLASS_PREFIX();
    }

    public Path path() {
        return this.path;
    }

    public LocalData storage() {
        return this.storage;
    }

    private long size$lzycompute() {
        Artifact artifact = this;
        synchronized (artifact) {
            if (!this.bitmap$0) {
                LocalData localData = this.storage();
                if (localData == null) {
                    throw new MatchError((Object)localData);
                }
                LocalData localData2 = localData;
                long l = localData2.size();
                this.size = l;
                this.bitmap$0 = true;
            }
        }
        return this.size;
    }

    public long size() {
        return !this.bitmap$0 ? this.size$lzycompute() : this.size;
    }

    public Artifact(Path path, LocalData storage) {
        this.path = path;
        this.storage = storage;
        Predef$.MODULE$.require(!path.isAbsolute(), (Function0 & Serializable)() -> new StringBuilder(10).append("Bad path: ").append(this.path()).toString());
    }

    public static class InMemory
    implements LocalData {
        private final byte[] bytes;

        @Override
        public long size() {
            return this.bytes.length;
        }

        @Override
        public InputStream stream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public InMemory(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    public static interface LocalData {
        public InputStream stream();

        public long size();
    }

    public static class LocalFile
    implements LocalData {
        private final Path path;

        public Path path() {
            return this.path;
        }

        @Override
        public long size() {
            return Files.size(this.path());
        }

        @Override
        public InputStream stream() {
            return Files.newInputStream(this.path(), new OpenOption[0]);
        }

        public LocalFile(Path path) {
            this.path = path;
        }
    }
}

