/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.LocalSparkContext$class;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.graphx.lib.GridPageRank$;
import org.apache.spark.graphx.lib.PageRankSuite$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001-2A!\u0001\u0002\u0001\u001b\ti\u0001+Y4f%\u0006t7nU;ji\u0016T!a\u0001\u0003\u0002\u00071L'M\u0003\u0002\u0006\r\u00051qM]1qQbT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005EaunY1m'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\tAbY8na\u0006\u0014XMU1oWN$2A\b\u0013*!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019!u.\u001e2mK\")Qe\u0007a\u0001M\u0005\t\u0011\rE\u0002\u0014OyI!\u0001\u000b\u0003\u0003\u0013Y+'\u000f^3y%\u0012#\u0005\"\u0002\u0016\u001c\u0001\u00041\u0013!\u00012")
public class PageRankSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext$class.withSpark(this, f);
    }

    public double compareRanks(VertexRDD<Object> a, VertexRDD<Object> b) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(a.leftJoin(b, (Function3)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(long x0$1, double x1$1, Option<Object> x2$1) {
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), x2$1);
                if (tuple3 != null) {
                    double a = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    Option bOpt = (Option)tuple3._3();
                    double d = (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }))) * (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    })));
                    return d;
                }
                throw new MatchError((Object)tuple3);
            }
        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double error;
                    double d = error = tuple2._2$mcD$sp();
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    public PageRankSuite() {
        LocalSparkContext$class.$init$(this);
        this.test("Star PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(SparkContext sc) {
                        int nVertices = 100;
                        Graph starGraph2 = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
                        double resetProb = 0.15;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks1 = Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(1, resetProb).vertices();
                        VertexRDD staticRanks2 = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(2, resetProb).vertices().cache();
                        double notMatching = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticRanks1.innerZipJoin(staticRanks2, (Function3)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(long vid, double pr1, double pr2) {
                                return pr1 != pr2 ? 1 : 0;
                            }
                        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Tuple2<Object, Object> x0$3) {
                                Tuple2<Object, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int test;
                                    int n = test = tuple2._2$mcI$sp();
                                    return n;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)notMatching));
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        RDD staticErrors = staticRanks2.map((Function1)new Serializable(this, nVertices, resetProb){
                            public static final long serialVersionUID = 0L;
                            private final int nVertices$1;
                            private final double resetProb$2;

                            public final int apply(Tuple2<Object, Object> x0$4) {
                                Tuple2<Object, Object> tuple2 = x0$4;
                                if (tuple2 != null) {
                                    long vid = tuple2._1$mcJ$sp();
                                    double pr = tuple2._2$mcD$sp();
                                    double p = package$.MODULE$.abs(pr - (this.resetProb$2 + (1.0 - this.resetProb$2) * (this.resetProb$2 * (double)(this.nVertices$1 - 1))));
                                    boolean correct = vid > 0L && pr == this.resetProb$2 || vid == 0L && p < 1.0E-5;
                                    int n = correct ? 0 : 1;
                                    return n;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.nVertices$1 = nVertices$1;
                                this.resetProb$2 = resetProb$2;
                            }
                        }, ClassTag$.MODULE$.Int());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticErrors, (Numeric)Numeric.IntIsIntegral$.MODULE$).sum()));
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(0.0, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks2, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Star PersonalPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(SparkContext sc) {
                        int nVertices = 100;
                        Graph starGraph2 = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
                        double resetProb = 0.15;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks1 = Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(0L, 1, resetProb).vertices();
                        VertexRDD staticRanks2 = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(0L, 2, resetProb).vertices().cache();
                        double notMatching = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticRanks1.innerZipJoin(staticRanks2, (Function3)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(long vid, double pr1, double pr2) {
                                return pr1 != pr2 ? 1 : 0;
                            }
                        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Tuple2<Object, Object> x0$5) {
                                Tuple2<Object, Object> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    int test;
                                    int n = test = tuple2._2$mcI$sp();
                                    return n;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)notMatching));
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        RDD staticErrors = staticRanks2.map((Function1)new Serializable(this, resetProb){
                            public static final long serialVersionUID = 0L;
                            private final double resetProb$3;

                            public final int apply(Tuple2<Object, Object> x0$6) {
                                Tuple2<Object, Object> tuple2 = x0$6;
                                if (tuple2 != null) {
                                    long vid = tuple2._1$mcJ$sp();
                                    double pr = tuple2._2$mcD$sp();
                                    boolean correct = vid > 0L && pr == 0.0 || vid == 0L && pr == this.resetProb$3;
                                    int n = correct ? 0 : 1;
                                    return n;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.resetProb$3 = resetProb$3;
                            }
                        }, ClassTag$.MODULE$.Int());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticErrors, (Numeric)Numeric.IntIsIntegral$.MODULE$).sum()));
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(0L, 0.0, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks2, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        VertexRDD otherStaticRanks2 = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, 2, resetProb).vertices().cache();
                        VertexRDD otherDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(1L, 0.0, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherStaticRanks2);
                        double $org_scalatest_assert_macro_right4 = errorTol;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Grid PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(SparkContext sc) {
                        int rows = 10;
                        int cols = 10;
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 50;
                        double errorTol = 1.0E-5;
                        Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
                        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).staticPageRank(numIter, resetProb).vertices().cache();
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).pageRank(tol, resetProb).vertices().cache();
                        VertexRDD referenceRanks = (VertexRDD)VertexRDD$.MODULE$.apply(sc.parallelize(GridPageRank$.MODULE$.apply(rows, cols, numIter, resetProb), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).cache();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)referenceRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)referenceRanks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Chain PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(SparkContext sc) {
                        IndexedSeq chain1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x) {
                                return new Tuple2.mcII.sp(x, x + 1);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$7) {
                                Tuple2<Object, Object> tuple2 = x0$7;
                                if (tuple2 != null) {
                                    int s = tuple2._1$mcI$sp();
                                    int d = tuple2._2$mcI$sp();
                                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 10;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
                        VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Chain PersonalizedPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(SparkContext sc) {
                        IndexedSeq chain1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x) {
                                return new Tuple2.mcII.sp(x, x + 1);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$8) {
                                Tuple2<Object, Object> tuple2 = x0$8;
                                if (tuple2 != null) {
                                    int s = tuple2._1$mcI$sp();
                                    int d = tuple2._2$mcI$sp();
                                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 10;
                        double errorTol = 0.1;
                        VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(4L, numIter, resetProb).vertices();
                        VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).personalizedPageRank(4L, tol, resetProb).vertices();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

