/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.LocalSparkContext$class;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.graphx.util.GraphGeneratorsSuite$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m1A!\u0001\u0002\u0001\u001b\t!rI]1qQ\u001e+g.\u001a:bi>\u00148oU;ji\u0016T!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\taa\u001a:ba\"D(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\t\tBj\\2bYN\u0003\u0018M]6D_:$X\r\u001f;\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001")
public class GraphGeneratorsSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext$class.withSpark(this, f);
    }

    public GraphGeneratorsSuite() {
        LocalSparkContext$class.$init$(this);
        this.test("GraphGenerators.generateRandomEdges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphGeneratorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Edge[] edges20;
                Edge[] edges10;
                int src = 5;
                int numEdges10 = 10;
                int numEdges20 = 20;
                int maxVertexId = 100;
                Edge[] $org_scalatest_assert_macro_left = edges10 = GraphGenerators$.MODULE$.generateRandomEdges(src, numEdges10, maxVertexId, GraphGenerators$.MODULE$.generateRandomEdges$default$4());
                int $org_scalatest_assert_macro_right = numEdges10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                boolean correctSrc = Predef$.MODULE$.refArrayOps((Object[])edges10).forall((Function1)new Serializable(this, src){
                    public static final long serialVersionUID = 0L;
                    private final int src$1;

                    public final boolean apply(Edge<Object> e) {
                        return e.srcId() == (long)this.src$1;
                    }
                    {
                        this.src$1 = src$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(correctSrc, "correctSrc");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                boolean correctWeight = Predef$.MODULE$.refArrayOps((Object[])edges10).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Edge<Object> e) {
                        return e.attr$mcI$sp() == 1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(correctWeight, "correctWeight");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                boolean correctRange = Predef$.MODULE$.refArrayOps((Object[])edges10).forall((Function1)new Serializable(this, maxVertexId){
                    public static final long serialVersionUID = 0L;
                    private final int maxVertexId$1;

                    public final boolean apply(Edge<Object> e) {
                        return e.dstId() >= 0L && e.dstId() <= (long)this.maxVertexId$1;
                    }
                    {
                        this.maxVertexId$1 = maxVertexId$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(correctRange, "correctRange");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Edge[] $org_scalatest_assert_macro_left2 = edges20 = GraphGenerators$.MODULE$.generateRandomEdges(src, numEdges20, maxVertexId, GraphGenerators$.MODULE$.generateRandomEdges$default$4());
                int $org_scalatest_assert_macro_right2 = numEdges20;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length, (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Edge[] edges10_round1 = GraphGenerators$.MODULE$.generateRandomEdges(src, numEdges10, maxVertexId, 12345L);
                Edge[] edges10_round2 = GraphGenerators$.MODULE$.generateRandomEdges(src, numEdges10, maxVertexId, 12345L);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])edges10_round1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])edges10_round2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Edge<Object>, Edge<Object>> x0$1) {
                        Tuple2<Edge<Object>, Edge<Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Edge e1 = (Edge)tuple2._1();
                            Edge e2 = (Edge)tuple2._2();
                            boolean bl = e1.srcId() == e2.srcId() && e1.dstId() == e2.dstId() && e1.attr$mcI$sp() == e2.attr$mcI$sp();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }), "scala.this.Predef.refArrayOps[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](scala.this.Predef.refArrayOps[org.apache.spark.graphx.Edge[Int]](edges10_round1).zip[org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int], Array[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])]](scala.this.Predef.wrapRefArray[org.apache.spark.graphx.Edge[Int]](edges10_round2))(scala.this.Array.canBuildFrom[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](ClassTag.apply[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](classOf[scala.Tuple2])))).forall(((x0$1: (org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])) => x0$1 match {\n  case (_1: org.apache.spark.graphx.Edge[Int], _2: org.apache.spark.graphx.Edge[Int])(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])((e1 @ _), (e2 @ _)) => e1.srcId.==(e2.srcId).&&(e1.dstId.==(e2.dstId)).&&(e1.attr.==(e2.attr))\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Edge[] edges10_round3 = GraphGenerators$.MODULE$.generateRandomEdges(src, numEdges10, maxVertexId, 3467L);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])edges10_round1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])edges10_round3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Edge<Object>, Edge<Object>> x0$2) {
                        Tuple2<Edge<Object>, Edge<Object>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Edge e1 = (Edge)tuple2._1();
                            Edge e2 = (Edge)tuple2._2();
                            boolean bl = e1.srcId() == e2.srcId() && e1.dstId() == e2.dstId() && e1.attr$mcI$sp() == e2.attr$mcI$sp();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }), "scala.this.Predef.refArrayOps[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](scala.this.Predef.refArrayOps[org.apache.spark.graphx.Edge[Int]](edges10_round1).zip[org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int], Array[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])]](scala.this.Predef.wrapRefArray[org.apache.spark.graphx.Edge[Int]](edges10_round3))(scala.this.Array.canBuildFrom[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](ClassTag.apply[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](classOf[scala.Tuple2])))).forall(((x0$2: (org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])) => x0$2 match {\n  case (_1: org.apache.spark.graphx.Edge[Int], _2: org.apache.spark.graphx.Edge[Int])(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])((e1 @ _), (e2 @ _)) => e1.srcId.==(e2.srcId).&&(e1.dstId.==(e2.dstId)).&&(e1.attr.==(e2.attr))\n}))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("GraphGenerators.sampleLogNormal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphGeneratorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double mu = 4.0;
                double sigma = 1.3;
                int maxVal = 100;
                int trials = 1000;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), trials).foreach$mVc$sp((Function1)new Serializable(this, mu, sigma, maxVal){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final double mu$1;
                    private final double sigma$1;
                    private final int maxVal$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        int dstId;
                        int $org_scalatest_assert_macro_left = dstId = GraphGenerators$.MODULE$.sampleLogNormal(this.mu$1, this.sigma$1, this.maxVal$1, GraphGenerators$.MODULE$.sampleLogNormal$default$4());
                        int $org_scalatest_assert_macro_right = this.maxVal$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mu$1 = mu$1;
                        this.sigma$1 = sigma$1;
                        this.maxVal$1 = maxVal$1;
                    }
                });
                int dstId_round1 = GraphGenerators$.MODULE$.sampleLogNormal(mu, sigma, maxVal, 12345L);
                int dstId_round2 = GraphGenerators$.MODULE$.sampleLogNormal(mu, sigma, maxVal, 12345L);
                int $org_scalatest_assert_macro_left = dstId_round1;
                int $org_scalatest_assert_macro_right = dstId_round2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int dstId_round3 = GraphGenerators$.MODULE$.sampleLogNormal(mu, sigma, maxVal, 789L);
                int $org_scalatest_assert_macro_left2 = dstId_round1;
                int $org_scalatest_assert_macro_right2 = dstId_round3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ GraphGeneratorsSuite org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("GraphGenerators.logNormalGraph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphGeneratorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(SparkContext sc) {
                        double mu = 4.0;
                        double sigma = 1.3;
                        int numVertices100 = 100;
                        SparkContext x$1 = sc;
                        int x$2 = numVertices100;
                        double x$3 = mu;
                        double x$4 = sigma;
                        int x$5 = GraphGenerators$.MODULE$.logNormalGraph$default$3();
                        long x$6 = GraphGenerators$.MODULE$.logNormalGraph$default$6();
                        Graph graph = GraphGenerators$.MODULE$.logNormalGraph(x$1, x$2, x$5, x$3, x$4, x$6);
                        long $org_scalatest_assert_macro_left = graph.vertices().count();
                        int $org_scalatest_assert_macro_right = numVertices100;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        SparkContext x$7 = sc;
                        int x$8 = numVertices100;
                        double x$9 = mu;
                        double x$10 = sigma;
                        long x$11 = 12345L;
                        int x$12 = GraphGenerators$.MODULE$.logNormalGraph$default$3();
                        Graph graph_round1 = GraphGenerators$.MODULE$.logNormalGraph(x$7, x$8, x$12, x$9, x$10, x$11);
                        SparkContext x$13 = sc;
                        int x$14 = numVertices100;
                        double x$15 = mu;
                        double x$16 = sigma;
                        long x$17 = 12345L;
                        int x$18 = GraphGenerators$.MODULE$.logNormalGraph$default$3();
                        Graph graph_round2 = GraphGenerators$.MODULE$.logNormalGraph(x$13, x$14, x$18, x$15, x$16, x$17);
                        Edge[] graph_round1_edges = (Edge[])graph_round1.edges().collect();
                        Edge[] graph_round2_edges = (Edge[])graph_round2.edges().collect();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])graph_round1_edges).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])graph_round2_edges), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Edge<Object>, Edge<Object>> x0$3) {
                                Tuple2<Edge<Object>, Edge<Object>> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    Edge e1 = (Edge)tuple2._1();
                                    Edge e2 = (Edge)tuple2._2();
                                    boolean bl = e1.srcId() == e2.srcId() && e1.dstId() == e2.dstId() && e1.attr$mcI$sp() == e2.attr$mcI$sp();
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                        }), "scala.this.Predef.refArrayOps[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](scala.this.Predef.refArrayOps[org.apache.spark.graphx.Edge[Int]](graph_round1_edges).zip[org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int], Array[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])]](scala.this.Predef.wrapRefArray[org.apache.spark.graphx.Edge[Int]](graph_round2_edges))(scala.this.Array.canBuildFrom[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](ClassTag.apply[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](classOf[scala.Tuple2])))).forall(((x0$3: (org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])) => x0$3 match {\n  case (_1: org.apache.spark.graphx.Edge[Int], _2: org.apache.spark.graphx.Edge[Int])(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])((e1 @ _), (e2 @ _)) => e1.srcId.==(e2.srcId).&&(e1.dstId.==(e2.dstId)).&&(e1.attr.==(e2.attr))\n}))");
                        this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        SparkContext x$19 = sc;
                        int x$20 = numVertices100;
                        double x$21 = mu;
                        double x$22 = sigma;
                        long x$23 = 567L;
                        int x$24 = GraphGenerators$.MODULE$.logNormalGraph$default$3();
                        Graph graph_round3 = GraphGenerators$.MODULE$.logNormalGraph(x$19, x$20, x$24, x$21, x$22, x$23);
                        Edge[] graph_round3_edges = (Edge[])graph_round3.edges().collect();
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])graph_round1_edges).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])graph_round3_edges), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Edge<Object>, Edge<Object>> x0$4) {
                                Tuple2<Edge<Object>, Edge<Object>> tuple2 = x0$4;
                                if (tuple2 != null) {
                                    Edge e1 = (Edge)tuple2._1();
                                    Edge e2 = (Edge)tuple2._2();
                                    boolean bl = e1.srcId() == e2.srcId() && e1.dstId() == e2.dstId() && e1.attr$mcI$sp() == e2.attr$mcI$sp();
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                        }), "scala.this.Predef.refArrayOps[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](scala.this.Predef.refArrayOps[org.apache.spark.graphx.Edge[Int]](graph_round1_edges).zip[org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int], Array[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])]](scala.this.Predef.wrapRefArray[org.apache.spark.graphx.Edge[Int]](graph_round3_edges))(scala.this.Array.canBuildFrom[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](ClassTag.apply[(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])](classOf[scala.Tuple2])))).forall(((x0$4: (org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])) => x0$4 match {\n  case (_1: org.apache.spark.graphx.Edge[Int], _2: org.apache.spark.graphx.Edge[Int])(org.apache.spark.graphx.Edge[Int], org.apache.spark.graphx.Edge[Int])((e1 @ _), (e2 @ _)) => e1.srcId.==(e2.srcId).&&(e1.dstId.==(e2.dstId)).&&(e1.attr.==(e2.attr))\n}))"));
                        this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GraphGeneratorsSuite org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-5064 GraphGenerators.rmatGraph numEdges upper bound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphGeneratorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final IllegalArgumentException apply(SparkContext sc) {
                        Graph g1 = GraphGenerators$.MODULE$.rmatGraph(sc, 4, 4);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)g1.edges().count()));
                        int $org_scalatest_assert_macro_right = 4;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        return (IllegalArgumentException)this.$outer.org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, sc){
                            public static final long serialVersionUID = 0L;
                            private final SparkContext sc$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                Graph graph = GraphGenerators$.MODULE$.rmatGraph(this.sc$1, 4, 8);
                            }
                            {
                                this.sc$1 = sc$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GraphGeneratorsSuite org$apache$spark$graphx$util$GraphGeneratorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

