/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u0001-\u0011\u0001b\u0012:ba\"|\u0005o\u001d\u0006\u0003\u0007\u0011\taa\u001a:ba\"D(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001U\u0019AB\b\u0015\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dQI!!F\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011]\u0001!\u0011!Q\u0001\na\tQa\u001a:ba\"\u0004B!\u0007\u000e\u001dO5\t!!\u0003\u0002\u001c\u0005\t)qI]1qQB\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001!\u0005\t1F)\u0005\u0002\"IA\u0011aBI\u0005\u0003G=\u0011qAT8uQ&tw\r\u0005\u0002\u000fK%\u0011ae\u0004\u0002\u0004\u0003:L\bCA\u000f)\t\u0015I\u0003A1\u0001!\u0005\t)E\t\u0003\u0005,\u0001\t\r\t\u0015a\u0003-\u0003))g/\u001b3f]\u000e,G%\r\t\u0004[AbR\"\u0001\u0018\u000b\u0005=z\u0011a\u0002:fM2,7\r^\u0005\u0003c9\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\tg\u0001\u0011\u0019\u0011)A\u0006i\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u00075\u0002t\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0003qq\"2!\u000f\u001e<!\u0011I\u0002\u0001H\u0014\t\u000b-*\u00049\u0001\u0017\t\u000bM*\u00049\u0001\u001b\t\u000b])\u0004\u0019\u0001\r\t\u000by\u0002A\u0011B \u0002\u0015\u0011,wM]3fgJ#E\t\u0006\u0002A\rB\u0019\u0011$Q\"\n\u0005\t\u0013!!\u0003,feR,\u0007P\u0015#E!\tqA)\u0003\u0002F\u001f\t\u0019\u0011J\u001c;\t\u000b\u001dk\u0004\u0019\u0001%\u0002\u001b\u0015$w-\u001a#je\u0016\u001cG/[8o!\tI\u0012*\u0003\u0002K\u0005\tiQ\tZ4f\t&\u0014Xm\u0019;j_:DQ\u0001\u0014\u0001\u0005\u00025\u000b!cY8mY\u0016\u001cGOT3jO\"\u0014wN]%egR\u0011a*\u0017\t\u00043\u0005{\u0005c\u0001\bQ%&\u0011\u0011k\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'Zs!!\u0007+\n\u0005U\u0013\u0011a\u00029bG.\fw-Z\u0005\u0003/b\u0013\u0001BV3si\u0016D\u0018\n\u001a\u0006\u0003+\nAQaR&A\u0002!CQa\u0017\u0001\u0005\u0002q\u000b\u0001cY8mY\u0016\u001cGOT3jO\"\u0014wN]:\u0015\u0005u\u0013\u0007cA\rB=B\u0019a\u0002U0\u0011\t9\u0001'\u000bH\u0005\u0003C>\u0011a\u0001V;qY\u0016\u0014\u0004\"B$[\u0001\u0004A\u0005\"\u00023\u0001\t\u0003)\u0017\u0001D2pY2,7\r^#eO\u0016\u001cHC\u00014l!\rI\u0012i\u001a\t\u0004\u001dAC\u0007cA\rjO%\u0011!N\u0001\u0002\u0005\u000b\u0012<W\rC\u0003HG\u0002\u0007\u0001\nC\u0003n\u0001\u0011\u0005a.\u0001\u0007k_&tg+\u001a:uS\u000e,7/\u0006\u0002pmR\u0011\u0001/ \u000b\u0003cb$\"\u0001\u0007:\t\u000fMd\u0017\u0011!a\u0002i\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u00075\u0002T\u000f\u0005\u0002\u001em\u0012)q\u000f\u001cb\u0001A\t\tQ\u000bC\u0003zY\u0002\u0007!0A\u0004nCB4UO\\2\u0011\r9Y(\u000bH;\u001d\u0013\taxBA\u0005Gk:\u001cG/[8og!)a\u0010\u001ca\u0001\u007f\u0006)A/\u00192mKB1\u0011\u0011AA\u0004\u0003\u0017i!!a\u0001\u000b\u0007\u0005\u0015A!A\u0002sI\u0012LA!!\u0003\u0002\u0004\t\u0019!\u000b\u0012#\u0011\t9\u0001'+\u001e\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003\u00191\u0017\u000e\u001c;feV1\u00111CA\u0010\u0003W!\u0002\"!\u0006\u00020\u0005m\u0012Q\n\u000b\u00061\u0005]\u00111\u0005\u0005\u000b\u00033\ti!!AA\u0004\u0005m\u0011AC3wS\u0012,gnY3%iA!Q\u0006MA\u000f!\ri\u0012q\u0004\u0003\b\u0003C\tiA1\u0001!\u0005\r1FI\r\u0005\u000b\u0003K\ti!!AA\u0004\u0005\u001d\u0012AC3wS\u0012,gnY3%kA!Q\u0006MA\u0015!\ri\u00121\u0006\u0003\b\u0003[\tiA1\u0001!\u0005\r)EI\r\u0005\t\u0003c\ti\u00011\u0001\u00024\u0005Q\u0001O]3qe>\u001cWm]:\u0011\r9\t)\u0004GA\u001d\u0013\r\t9d\u0004\u0002\n\rVt7\r^5p]F\u0002b!\u0007\u000e\u0002\u001e\u0005%\u0002BCA\u001f\u0003\u001b\u0001\n\u00111\u0001\u0002@\u0005)Q\r\u001d:fIB9a\"!\u000e\u0002B\u0005\u001d\u0003cB\r\u0002D\u0005u\u0011\u0011F\u0005\u0004\u0003\u000b\u0012!aC#eO\u0016$&/\u001b9mKR\u00042ADA%\u0013\r\tYe\u0004\u0002\b\u0005>|G.Z1o\u0011)\ty%!\u0004\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u0006mB\u0014X\r\u001a\t\t\u001d\u0005M#+!\b\u0002H%\u0019\u0011QK\b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004bBA-\u0001\u0011\u0005\u00111L\u0001\u0011a&\u001c7NU1oI>lg+\u001a:uKb$\u0012A\u0015\u0005\b\u0003?\u0002A\u0011AA1\u0003\u0019\u0001(/Z4fYV!\u00111MA9)!\t)'!)\u0002&\u0006%F\u0003CA4\u0003k\nY(a'\u0015\u0007a\tI\u0007\u0003\u0006\u0002l\u0005u\u0013\u0011!a\u0002\u0003[\n!\"\u001a<jI\u0016t7-\u001a\u00137!\u0011i\u0003'a\u001c\u0011\u0007u\t\t\bB\u0004\u0002t\u0005u#\u0019\u0001\u0011\u0003\u0003\u0005C\u0001\"a\u001e\u0002^\u0001\u0007\u0011\u0011P\u0001\u0006mB\u0014xn\u001a\t\b\u001dm\u0014F$a\u001c\u001d\u0011!\ti(!\u0018A\u0002\u0005}\u0014aB:f]\u0012l5o\u001a\t\b\u001d\u0005U\u0012\u0011QAB!\u0015I\u00121\t\u000f(!\u0019\t))a%\u0002\u001a:!\u0011qQAI\u001d\u0011\tI)a$\u000e\u0005\u0005-%bAAG\u0015\u00051AH]8pizJ\u0011\u0001E\u0005\u0003+>IA!!&\u0002\u0018\nA\u0011\n^3sCR|'O\u0003\u0002V\u001fA)a\u0002\u0019*\u0002p!A\u0011QTA/\u0001\u0004\ty*\u0001\u0005nKJ<W-T:h!%q\u00111KA8\u0003_\ny\u0007\u0003\u0005\u0002$\u0006u\u0003\u0019AA8\u0003)Ig.\u001b;jC2l5o\u001a\u0005\n\u0003O\u000bi\u0006%AA\u0002\r\u000bQ\"\\1y\u0013R,'/\u0019;j_:\u001c\b\"CAV\u0003;\u0002\n\u00111\u0001I\u0003=\t7\r^5wK\u0012K'/Z2uS>t\u0007bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\ta\u0006<WMU1oWR1\u00111WA^\u0003\u007f\u0003b!\u0007\u000e\u00026\u0006U\u0006c\u0001\b\u00028&\u0019\u0011\u0011X\b\u0003\r\u0011{WO\u00197f\u0011!\ti,!,A\u0002\u0005U\u0016a\u0001;pY\"Q\u0011\u0011YAW!\u0003\u0005\r!!.\u0002\u0013I,7/\u001a;Qe>\u0014\u0007bBAc\u0001\u0011\u0005\u0011qY\u0001\u000fgR\fG/[2QC\u001e,'+\u00198l)\u0019\t\u0019,!3\u0002N\"9\u00111ZAb\u0001\u0004\u0019\u0015a\u00028v[&#XM\u001d\u0005\u000b\u0003\u0003\f\u0019\r%AA\u0002\u0005U\u0006bBAi\u0001\u0011\u0005\u00111[\u0001\u0014G>tg.Z2uK\u0012\u001cu.\u001c9p]\u0016tGo\u001d\u000b\u0003\u0003+\u0004B!\u0007\u000eSO!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0017!\u0004;sS\u0006tw\r\\3D_VtG\u000f\u0006\u0002\u0002^B!\u0011DG\"(\u0011\u001d\t\t\u000f\u0001C\u0001\u0003G\f1d\u001d;s_:<G._\"p]:,7\r^3e\u0007>l\u0007o\u001c8f]R\u001cH\u0003BAk\u0003KDq!a3\u0002`\u0002\u00071\t\u0003\u0006\u0002j\u0002A)\u0019!C\u0001\u0003W\f\u0001B\\;n\u000b\u0012<Wm]\u000b\u0003\u0003[\u00042ADAx\u0013\r\t\tp\u0004\u0002\u0005\u0019>tw\r\u0003\u0006\u0002v\u0002A\t\u0011)Q\u0005\u0003[\f\u0011B\\;n\u000b\u0012<Wm\u001d\u0011)\t\u0005M\u0018\u0011 \t\u0004\u001d\u0005m\u0018bAA\u007f\u001f\tIAO]1og&,g\u000e\u001e\u0005\u000b\u0005\u0003\u0001\u0001R1A\u0005\u0002\u0005-\u0018a\u00038v[Z+'\u000f^5dKND!B!\u0002\u0001\u0011\u0003\u0005\u000b\u0015BAw\u00031qW/\u001c,feRL7-Z:!Q\u0011\u0011\u0019!!?\t\u0015\t-\u0001\u0001#b\u0001\n\u0003\u0011i!A\u0005j]\u0012+wM]3fgV\t\u0001\tC\u0005\u0003\u0012\u0001A\t\u0011)Q\u0005\u0001\u0006Q\u0011N\u001c#fOJ,Wm\u001d\u0011)\t\t=\u0011\u0011 \u0005\u000b\u0005/\u0001\u0001R1A\u0005\u0002\t5\u0011AC8vi\u0012+wM]3fg\"I!1\u0004\u0001\t\u0002\u0003\u0006K\u0001Q\u0001\f_V$H)Z4sK\u0016\u001c\b\u0005\u000b\u0003\u0003\u001a\u0005e\bB\u0003B\u0011\u0001!\u0015\r\u0011\"\u0001\u0003\u000e\u00059A-Z4sK\u0016\u001c\b\"\u0003B\u0013\u0001!\u0005\t\u0015)\u0003A\u0003!!Wm\u001a:fKN\u0004\u0003\u0006\u0002B\u0012\u0003sD\u0011Ba\u000b\u0001#\u0003%\tA!\f\u0002!\u0019LG\u000e^3sI\u0011,g-Y;mi\u0012\u0012TC\u0002B\u0018\u0005s\u0011i$\u0006\u0002\u00032)\"!1\u0007B !\u001dq\u0011Q\u0007B\u001b\u0003\u000f\u0002r!GA\"\u0005o\u0011Y\u0004E\u0002\u001e\u0005s!q!!\t\u0003*\t\u0007\u0001\u0005E\u0002\u001e\u0005{!q!!\f\u0003*\t\u0007\u0001e\u000b\u0002\u0003BA!!1\tB'\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013!C;oG\",7m[3e\u0015\r\u0011YeD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B(\u0005\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011)&\u0001\tgS2$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU1!q\u000bB0\u0005C*\"A!\u0017+\t\tm#q\b\t\t\u001d\u0005M#K!\u0018\u0002HA\u0019QDa\u0018\u0005\u000f\u0005\u0005\"\u0011\u000bb\u0001A\u00119\u0011Q\u0006B)\u0005\u0004\u0001\u0003\"\u0003B3\u0001E\u0005I\u0011\u0001B4\u0003A\u0001(/Z4fY\u0012\"WMZ1vYR$#'\u0006\u0003\u0003j\t5TC\u0001B6U\r\u0019%q\b\u0003\b\u0003g\u0012\u0019G1\u0001!\u0011%\u0011\t\bAI\u0001\n\u0003\u0011\u0019(\u0001\tqe\u0016<W\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU!!Q\u000fB=+\t\u00119HK\u0002I\u0005\u007f!q!a\u001d\u0003p\t\u0007\u0001\u0005C\u0005\u0003~\u0001\t\n\u0011\"\u0001\u0003\u0000\u0005\u0011\u0002/Y4f%\u0006t7\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tI\u000b\u0003\u00026\n}\u0002\"\u0003BC\u0001E\u0005I\u0011\u0001B@\u0003a\u0019H/\u0019;jGB\u000bw-\u001a*b].$C-\u001a4bk2$HE\r")
public class GraphOps<VD, ED>
implements Serializable {
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.numEdges;
        }
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.numVertices;
        }
    }

    private VertexRDD inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.inDegrees;
        }
    }

    private VertexRDD outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.outDegrees;
        }
    }

    private VertexRDD degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.degrees;
        }
    }

    public long numEdges() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.numEdges$lzycompute() : this.numEdges;
    }

    public long numVertices() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numVertices$lzycompute() : this.numVertices;
    }

    public VertexRDD<Object> inDegrees() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inDegrees$lzycompute() : this.inDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.outDegrees$lzycompute() : this.outDegrees;
    }

    public VertexRDD<Object> degrees() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.degrees$lzycompute() : this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                public final void apply(EdgeContext<VD, ED, Object> x$1) {
                    x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){

                public final int apply(int x$2, int x$3) {
                    return this.apply$mcIII$sp(x$2, x$3);
                }

                public int apply$mcIII$sp(int x$2, int x$3) {
                    return x$2 + x$3;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int());
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            vertexRDD = !(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) ? this.graph.aggregateMessages(new Serializable(this){

                public final void apply(EdgeContext<VD, ED, Object> x$4) {
                    x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){

                public final int apply(int x$5, int x$6) {
                    return this.apply$mcIII$sp(x$5, x$6);
                }

                public int apply$mcIII$sp(int x$5, int x$6) {
                    return x$5 + x$6;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int()) : this.graph.aggregateMessages(new Serializable(this){

                public final void apply(EdgeContext<VD, ED, Object> ctx) {
                    ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                    ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
                }
            }, new Serializable(this){

                public final int apply(int x$7, int x$8) {
                    return this.apply$mcIII$sp(x$7, x$8);
                }

                public int apply$mcIII$sp(int x$7, int x$8) {
                    return x$7 + x$8;
                }
            }, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return vertexRDD;
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        block5: {
            VertexRDD vertexRDD;
            block3: {
                block4: {
                    block2: {
                        EdgeDirection edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        if (edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null) break block2;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                            public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                                ctx.sendToSrc(new long[]{ctx.dstId()});
                                ctx.sendToDst(new long[]{ctx.srcId()});
                            }
                        }, new Serializable(this){

                            public final long[] apply(long[] x$9, long[] x$10) {
                                return (long[])Predef$.MODULE$.longArrayOps(x$9).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$10), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                            }
                        }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                        break block3;
                    }
                    EdgeDirection edgeDirection4 = edgeDirection;
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
                    if (edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) break block4;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                        public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                            ctx.sendToSrc(new long[]{ctx.dstId()});
                        }
                    }, new Serializable(this){

                        public final long[] apply(long[] x$11, long[] x$12) {
                            return (long[])Predef$.MODULE$.longArrayOps(x$11).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$12), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                        }
                    }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                    break block3;
                }
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null) break block5;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                    public final void apply(EdgeContext<VD, ED, long[]> ctx) {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                    }
                }, new Serializable(this){

                    public final long[] apply(long[] x$13, long[] x$14) {
                        return (long[])Predef$.MODULE$.longArrayOps(x$13).$plus$plus((GenTraversableOnce)Predef$.MODULE$.longArrayOps(x$14), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE)));
                    }
                }, TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            }
            VertexRDD nbrs = vertexRDD;
            return this.graph.vertices().leftZipJoin(nbrs, new Serializable(this){

                public final long[] apply(long vid, VD vdata, Option<long[]> nbrsOpt) {
                    return (long[])nbrsOpt.getOrElse((Function0)new Serializable(this){

                        public final long[] apply() {
                            return (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE));
                        }
                    });
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        }
        throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2;
        block7: {
            VertexRDD vertexRDD;
            block5: {
                block6: {
                    block4: {
                        edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        EdgeDirection edgeDirection4 = edgeDirection2;
                        if (edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null) break block4;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                            public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                                ctx.sendToSrc((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                                ctx.sendToDst((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                            }
                        }, new Serializable(this){

                            public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            }
                        }, TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                        break block5;
                    }
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
                    EdgeDirection edgeDirection6 = edgeDirection2;
                    if (edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null) break block6;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                        public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                            ctx.sendToDst((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                        }
                    }, new Serializable(this){

                        public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                            return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                        }
                    }, TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                    break block5;
                }
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null) break block7;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                    public final void apply(EdgeContext<VD, ED, Tuple2<Object, VD>[]> ctx) {
                        ctx.sendToSrc((Tuple2<Object, VD>[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                    }
                }, new Serializable(this){

                    public final Tuple2<Object, VD>[] apply(Tuple2<Object, VD>[] a, Tuple2<Object, VD>[] b) {
                        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    }
                }, TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            }
            VertexRDD nbrs = vertexRDD;
            return this.graph.vertices().leftJoin(nbrs, new Serializable(this){

                public final Tuple2<Object, VD>[] apply(long vid, VD vdata, Option<Tuple2<Object, VD>[]> nbrsOpt) {
                    return (Tuple2[])nbrsOpt.getOrElse((Function0)new Serializable(this){

                        public final Tuple2<Object, VD>[] apply() {
                            return (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
                        }
                    });
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        }
        EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
        EdgeDirection edgeDirection10 = edgeDirection2;
        if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
            throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
        }
        throw new MatchError((Object)edgeDirection2);
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2;
        block7: {
            VertexRDD<Object> vertexRDD;
            block5: {
                block6: {
                    block4: {
                        edgeDirection2 = edgeDirection;
                        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
                        EdgeDirection edgeDirection4 = edgeDirection2;
                        if (edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null) break block4;
                        vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                            public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                                ctx.sendToSrc((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                                ctx.sendToDst((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                            }
                        }, new Serializable(this){

                            public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                                return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                            }
                        }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                        break block5;
                    }
                    EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
                    EdgeDirection edgeDirection6 = edgeDirection2;
                    if (edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null) break block6;
                    vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                        public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                            ctx.sendToDst((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                        }
                    }, new Serializable(this){

                        public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                            return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                        }
                    }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                    break block5;
                }
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null) break block7;
                vertexRDD = this.graph.aggregateMessages(new Serializable(this){

                    public final void apply(EdgeContext<VD, ED, Edge<ED>[]> ctx) {
                        ctx.sendToSrc((Edge<ED>[])((Object[])new Edge[]{new Edge<ED>(ctx.srcId(), ctx.dstId(), ctx.attr())}));
                    }
                }, new Serializable(this){

                    public final Edge<ED>[] apply(Edge<ED>[] a, Edge<ED>[] b) {
                        return (Edge[])Predef$.MODULE$.refArrayOps((Object[])a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class)));
                    }
                }, TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
            }
            return vertexRDD;
        }
        EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
        EdgeDirection edgeDirection10 = edgeDirection2;
        if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
            throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
        }
        throw new MatchError((Object)edgeDirection2);
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Serializable uf = new Serializable(this, mapFunc){
            private final Function3 mapFunc$1;

            public final VD apply(long id, VD data, Option<U> o) {
                Option<U> option;
                block4: {
                    Object object;
                    block3: {
                        block2: {
                            option = o;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object u = some.x();
                            object = this.mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        object = data;
                    }
                    return object;
                }
                throw new MatchError(option);
            }
            {
                this.mapFunc$1 = mapFunc$1;
            }
        };
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return new Serializable(this){

            public final boolean apply(EdgeTriplet<VD2, ED2> x) {
                return true;
            }
        };
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return new Serializable(this){

            public final boolean apply(long v, VD2 d) {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            void var1_1;
            RDD selectedVertices = this.graph.vertices().flatMap((Function1)new Serializable(this, (double)var1_1){
                private final double probability$1;

                public final Iterable<Object> apply(Tuple2<Object, VD> vidVvals) {
                    return Random$.MODULE$.nextDouble() < this.probability$1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                {
                    this.probability$1 = probability$1;
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 1L) continue;
            boolean bl = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            long l = collectedVertices[Random$.MODULE$.nextInt(Predef$.MODULE$.longArrayOps(collectedVertices).size())];
        }
        return retVal;
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg2, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg2, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

