/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import org.apache.spark.Logging;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class PageRank$
implements Logging {
    public static final PageRank$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new PageRank$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public <VD, ED> Graph<Object, Object> run(Graph<VD, ED> graph, int numIter, double resetProb, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        VertexRDD<Object> x$4 = Graph$.MODULE$.graphToGraphOps(graph, evidence$1, evidence$2).outDegrees();
        Serializable x$5 = new Serializable(){

            public final int apply(long vid, VD vdata, Option<Object> deg) {
                return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
        };
        ClassTag x$6 = ClassTag$.MODULE$.Int();
        ClassTag x$7 = ClassTag$.MODULE$.Int();
        graph.outerJoinVertices$default$5(x$4, x$5);
        Object x$8 = null;
        Graph qual$1 = graph.outerJoinVertices(x$4, x$5, x$6, x$7, null).mapTriplets(new Serializable(){

            public final double apply(EdgeTriplet<Object, ED> e) {
                return 1.0 / (double)BoxesRunTime.unboxToInt((Object)e.srcAttr());
            }
        }, TripletFields.Src, ClassTag$.MODULE$.Double());
        Serializable x$9 = new Serializable(resetProb){
            private final double resetProb$2;

            public final double apply(long id, int attr) {
                return this.apply$mcDJI$sp(id, attr);
            }

            public double apply$mcDJI$sp(long id, int attr) {
                return this.resetProb$2;
            }
            {
                this.resetProb$2 = resetProb$2;
            }
        };
        ClassTag x$10 = ClassTag$.MODULE$.Double();
        qual$1.mapVertices$default$3(x$9);
        Object x$11 = null;
        Graph<Object, Object> rankGraph = qual$1.mapVertices(x$9, x$10, null);
        IntRef iteration = IntRef.create((int)0);
        Graph<Object, Object> prevRankGraph = null;
        while (iteration.elem < numIter) {
            rankGraph.cache();
            VertexRDD rankUpdates = rankGraph.aggregateMessages(new Serializable(){

                public final void apply(EdgeContext<Object, Object, Object> ctx) {
                    ctx.sendToDst(BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)ctx.srcAttr()) * BoxesRunTime.unboxToDouble((Object)ctx.attr()))));
                }
            }, new Serializable(){

                public final double apply(double x$1, double x$2) {
                    return this.apply$mcDDD$sp(x$1, x$2);
                }

                public double apply$mcDDD$sp(double x$1, double x$2) {
                    return x$1 + x$2;
                }
            }, TripletFields.Src, ClassTag$.MODULE$.Double());
            prevRankGraph = rankGraph;
            rankGraph = Graph$.MODULE$.graphToGraphOps(rankGraph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).joinVertices(rankUpdates, new Serializable(resetProb){
                private final double resetProb$2;

                public final double apply(long id, double oldRank, double msgSum) {
                    return this.resetProb$2 + (1.0 - this.resetProb$2) * msgSum;
                }
                {
                    this.resetProb$2 = resetProb$2;
                }
            }, ClassTag$.MODULE$.Double()).cache();
            rankGraph.edges().foreachPartition((Function1)new Serializable(){

                public final void apply(Iterator<Edge<Object>> x) {
                }
            });
            this.logInfo((Function0<String>)new Serializable(iteration){
                private final IntRef iteration$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PageRank finished iteration ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                }
                {
                    this.iteration$1 = iteration$1;
                }
            });
            prevRankGraph.vertices().unpersist(false);
            prevRankGraph.edges().unpersist(false);
            ++iteration.elem;
        }
        return rankGraph;
    }

    public <VD, ED> double run$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runUntilConvergence(Graph<VD, ED> graph, double tol, double resetProb, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        VertexRDD<Object> x$12 = Graph$.MODULE$.graphToGraphOps(graph, evidence$3, evidence$4).outDegrees();
        Serializable x$13 = new Serializable(){

            public final int apply(long vid, VD vdata, Option<Object> deg) {
                return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
        };
        ClassTag x$14 = ClassTag$.MODULE$.Int();
        ClassTag x$15 = ClassTag$.MODULE$.Int();
        graph.outerJoinVertices$default$5(x$12, x$13);
        Object x$16 = null;
        Graph qual$2 = graph.outerJoinVertices(x$12, x$13, x$14, x$15, null).mapTriplets(new Serializable(){

            public final double apply(EdgeTriplet<Object, ED> e) {
                return 1.0 / (double)BoxesRunTime.unboxToInt((Object)e.srcAttr());
            }
        }, ClassTag$.MODULE$.Double());
        Serializable x$17 = new Serializable(){

            public final Tuple2<Object, Object> apply(long id, int attr) {
                return new Tuple2.mcDD.sp(0.0, 0.0);
            }
        };
        ClassTag x$18 = ClassTag$.MODULE$.apply(Tuple2.class);
        qual$2.mapVertices$default$3(x$17);
        Object x$19 = null;
        Graph pagerankGraph = qual$2.mapVertices(x$17, x$18, null).cache();
        double initialMessage = resetProb / (1.0 - resetProb);
        Graph x$20 = pagerankGraph;
        double x$21 = initialMessage;
        EdgeDirection x$22 = EdgeDirection$.MODULE$.Out();
        int x$23 = Pregel$.MODULE$.apply$default$3();
        Serializable x$24 = new Serializable(resetProb){
            private final double resetProb$1;

            public final Tuple2<Object, Object> apply(long id, Tuple2<Object, Object> attr, double msgSum) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$vertexProgram$1(id, attr, msgSum, this.resetProb$1);
            }
            {
                this.resetProb$1 = resetProb$1;
            }
        };
        Serializable x$25 = new Serializable(tol){
            private final double tol$1;

            public final Iterator<Tuple2<Object, Object>> apply(EdgeTriplet<Tuple2<Object, Object>, Object> edge) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$sendMessage$1(edge, this.tol$1);
            }
            {
                this.tol$1 = tol$1;
            }
        };
        Serializable x$26 = new Serializable(){

            public final double apply(double a, double b) {
                return this.apply$mcDDD$sp(a, b);
            }

            public double apply$mcDDD$sp(double a, double b) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$messageCombiner$1(a, b);
            }
        };
        Graph qual$3 = Pregel$.MODULE$.apply(x$20, BoxesRunTime.boxToDouble((double)x$21), x$23, x$22, x$24, x$25, x$26, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
        Serializable x$27 = new Serializable(){

            public final double apply(long vid, Tuple2<Object, Object> attr) {
                return attr._1$mcD$sp();
            }
        };
        ClassTag x$28 = ClassTag$.MODULE$.Double();
        qual$3.mapVertices$default$3(x$27);
        Object x$29 = null;
        return qual$3.mapVertices(x$27, x$28, null);
    }

    public <VD, ED> double runUntilConvergence$default$3() {
        return 0.15;
    }

    public final Tuple2 org$apache$spark$graphx$lib$PageRank$$vertexProgram$1(long id, Tuple2 attr, double msgSum, double resetProb$1) {
        Tuple2 tuple2 = attr;
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double oldPR = tuple2._1$mcD$sp();
            double lastDelta = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(oldPR, lastDelta);
            double oldPR2 = sp3._1$mcD$sp();
            double lastDelta2 = sp3._2$mcD$sp();
            double newPR = oldPR2 + (1.0 - resetProb$1) * msgSum;
            return new Tuple2.mcDD.sp(newPR, newPR - oldPR2);
        }
        throw new MatchError((Object)tuple2);
    }

    public final Iterator org$apache$spark$graphx$lib$PageRank$$sendMessage$1(EdgeTriplet edge, double tol$1) {
        return ((Tuple2)edge.srcAttr())._2$mcD$sp() > tol$1 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(edge.dstId(), ((Tuple2)edge.srcAttr())._2$mcD$sp() * edge.attr$mcD$sp())})) : package$.MODULE$.Iterator().empty();
    }

    public final double org$apache$spark$graphx$lib$PageRank$$messageCombiner$1(double a, double b) {
        return a + b;
    }

    private PageRank$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

