/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.GraphLoader$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005a1AAA\u0002\u0001\u0019!)Q\u0003\u0001C\u0001-\t\u0001rI]1qQ2{\u0017\rZ3s'VLG/\u001a\u0006\u0003\t\u0015\taa\u001a:ba\"D(B\u0001\u0004\b\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0011\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!D\t\u0011\u00059yQ\"A\u0003\n\u0005A)!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0013'5\t1!\u0003\u0002\u0015\u0007\t\tBj\\2bYN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\n\u0001\u0001")
public class GraphLoaderSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext.withSpark$(this, f);
    }

    public GraphLoaderSuite() {
        LocalSparkContext.$init$(this);
        this.test("GraphLoader.edgeListFile", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.withSpark((Function1 & Serializable)sc -> {
            Assertion assertion;
            File tmpDir = Utils$.MODULE$.createTempDir();
            File graphFile = new File(tmpDir.getAbsolutePath(), "graph.txt");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(graphFile), StandardCharsets.UTF_8);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 101).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> writer.write(new StringBuilder(3).append(i).append(" 0\n").toString()));
            writer.close();
            try {
                Graph graph = GraphLoader$.MODULE$.edgeListFile(sc, tmpDir.getAbsolutePath(), GraphLoader$.MODULE$.edgeListFile$default$3(), GraphLoader$.MODULE$.edgeListFile$default$4(), GraphLoader$.MODULE$.edgeListFile$default$5(), GraphLoader$.MODULE$.edgeListFile$default$6());
                VertexRDD neighborAttrSums = graph.aggregateMessages((Function1 & Serializable)ctx -> {
                    ctx.sendToDst(ctx.srcAttr());
                    return BoxedUnit.UNIT;
                }, (Function2)(JFunction2.mcIII.sp & Serializable)(x$1, x$2) -> x$1 + x$2, graph.aggregateMessages$default$3(), (ClassTag)ClassTag$.MODULE$.Int());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray((Object[])neighborAttrSums.collect()).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJI.sp(0L, 100)}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tmpDir);
            }
            return assertion;
        }), new Position("GraphLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }
}

