/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.graphx.lib.GridPageRank$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000593A\u0001B\u0003\u0001!!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)A\u0006\u0001C\u0001[\ti\u0001+Y4f%\u0006t7nU;ji\u0016T!AB\u0004\u0002\u00071L'M\u0003\u0002\t\u0013\u00051qM]1qQbT!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011#\u0006\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\f\u0018\u001b\u00059\u0011B\u0001\r\b\u0005EaunY1m'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\u0015\tAbY8na\u0006\u0014XMU1oWN$2aH\u0013+!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019!u.\u001e2mK\")aE\u0001a\u0001O\u0005\t\u0011\rE\u0002\u0017Q}I!!K\u0004\u0003\u0013Y+'\u000f^3y%\u0012#\u0005\"B\u0016\u0003\u0001\u00049\u0013!\u00012\u0002+\r|gN^3sO\u0016t7-Z%uKJ\fG/[8ogV\u0019a\u0006\u0010$\u0015\u000b=*\u0004J\u0013'\u0011\t\u0001\u0002$GM\u0005\u0003c\u0005\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u00114\u0013\t!\u0014EA\u0002J]RDQAN\u0002A\u0002]\nQa\u001a:ba\"\u0004BA\u0006\u001d;\u000b&\u0011\u0011h\u0002\u0002\u0006\u000fJ\f\u0007\u000f\u001b\t\u0003wqb\u0001\u0001B\u0003>\u0007\t\u0007aH\u0001\u0002W\tF\u0011qH\u0011\t\u0003A\u0001K!!Q\u0011\u0003\u000f9{G\u000f[5oOB\u0011\u0001eQ\u0005\u0003\t\u0006\u00121!\u00118z!\tYd\tB\u0003H\u0007\t\u0007aH\u0001\u0002F\t\")\u0011j\u0001a\u0001?\u0005I!/Z:fiB\u0013xN\u0019\u0005\u0006\u0017\u000e\u0001\raH\u0001\u0004i>d\u0007\"B'\u0004\u0001\u0004y\u0012\u0001C3se>\u0014Hk\u001c7")
public class PageRankSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext.withSpark$(this, f);
    }

    public double compareRanks(VertexRDD<Object> a, VertexRDD<Object> b) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(a.leftJoin(b, (Function3 & Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$compareRanks$1(BoxesRunTime.unboxToLong((Object)x0$1), BoxesRunTime.unboxToDouble((Object)x1$1), x2$1)), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$compareRanks$4(x0$2)), (ClassTag)ClassTag$.MODULE$.Double())).sum();
    }

    public <VD, ED> Tuple2<Object, Object> convergenceIterations(Graph<VD, ED> graph, double resetProb, double tol, double errorTol) {
        VertexRDD dynamicRanks = (VertexRDD)graph.ops().pageRank(tol, resetProb).vertices().cache();
        int iter = 1;
        VertexRDD staticGraphRank = (VertexRDD)graph.ops().staticPageRank(iter, resetProb).vertices().cache();
        while (!(this.compareRanks((VertexRDD<Object>)staticGraphRank, (VertexRDD<Object>)dynamicRanks) < errorTol)) {
            staticGraphRank = (VertexRDD)graph.ops().staticPageRank(++iter, resetProb).vertices().cache();
        }
        int convergenceIter = iter;
        int checkPointIter = convergenceIter / 2;
        Graph staticGraphRankPartial = graph.ops().staticPageRank(checkPointIter, resetProb);
        int iterWithCheckPoint = 1;
        VertexRDD staticGraphRankWithCheckPoint = (VertexRDD)graph.ops().staticPageRank(iterWithCheckPoint, resetProb, staticGraphRankPartial).vertices().cache();
        while (this.compareRanks((VertexRDD<Object>)staticGraphRankWithCheckPoint, (VertexRDD<Object>)dynamicRanks) >= errorTol) {
            staticGraphRankWithCheckPoint = (VertexRDD)graph.ops().staticPageRank(++iterWithCheckPoint, resetProb, staticGraphRankPartial).vertices().cache();
        }
        int convergenceIterWithCheckPoint = iterWithCheckPoint;
        return new Tuple2.mcII.sp(convergenceIterWithCheckPoint, convergenceIter);
    }

    public static final /* synthetic */ double $anonfun$compareRanks$1(long x0$1, double x1$1, Option x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), (Object)x2$1);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double a = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        Option bOpt = (Option)tuple3._3();
        double d = (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))) * (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        return d;
    }

    public static final /* synthetic */ double $anonfun$compareRanks$4(Tuple2 x0$2) {
        double error;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = error = tuple2._2$mcD$sp();
        return d;
    }

    public static final /* synthetic */ int $anonfun$new$3(long vid, double pr1, double pr2) {
        return pr1 != pr2 ? 1 : 0;
    }

    public static final /* synthetic */ int $anonfun$new$4(Tuple2 x0$1) {
        int test;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = test = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ double $anonfun$new$8(long x0$2, Vector x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(0);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$10(long x0$3, Vector x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$3), (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(1);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 rankA = (Tuple2)tuple2._1();
        Tuple2 rankB = (Tuple2)tuple2._2();
        Tuple2 tuple22 = rankA;
        Tuple2 tuple23 = rankB;
        boolean bl = !(tuple22 != null ? !tuple22.equals(tuple23) : tuple23 != null);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$21(int x) {
        return new Tuple2.mcII.sp(x, x + 1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$25(int x) {
        return new Tuple2.mcII.sp(x, x + 1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$30(long source$1, double a$1, double resetProb$2, long vid) {
        double rank = vid < source$1 ? 0.0 : a$1 * Math.pow(1.0 - resetProb$2, vid - source$1);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)vid)), (Object)BoxesRunTime.boxToDouble((double)rank));
    }

    public static final /* synthetic */ double $anonfun$new$31(long x0$8, Vector x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$8), (Object)x1$3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(0);
        return d;
    }

    public PageRankSuite() {
        LocalSparkContext.$init$(this);
        this.test("Star PageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int nVertices = 100;
            Graph starGraph = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 2;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD staticRanks2 = Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPageRank(numIter + 1, resetProb).vertices();
            double notMatching = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticRanks.innerZipJoin(staticRanks2, (Function3 & Serializable)(vid, pr1, pr2) -> BoxesRunTime.boxToInteger((int)PageRankSuite.$anonfun$new$3(BoxesRunTime.unboxToLong((Object)vid), BoxesRunTime.unboxToDouble((Object)pr1), BoxesRunTime.unboxToDouble((Object)pr2))), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PageRankSuite.$anonfun$new$4(x0$1)), (ClassTag)ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)notMatching));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            double centerRank = 0.462394787 * (double)nVertices;
            double othersRank = 0.005430356 * (double)nVertices;
            double d = centerRank;
            Seq igraphPR = (Seq)((SeqOps)package$.MODULE$.Seq().fill(nVertices - 1, (Function0)(JFunction0.mcD.sp & Serializable)() -> othersRank)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d));
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((IterableOnce)igraphPR), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Star PersonalPageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int nVertices = 100;
            Graph starGraph = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 2;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(0L, numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).personalizedPageRank(0L, tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Graph qual$1 = Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L}, numIter, resetProb);
            Function2 & Serializable x$1 = (Function2 & Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$8(BoxesRunTime.unboxToLong((Object)x0$2), x1$1));
            ManifestFactory.DoubleManifest x$2 = ClassTag$.MODULE$.Double();
            Null$ x$3 = qual$1.mapVertices$default$3((Function2)x$1);
            VertexRDD parallelStaticRanks = (VertexRDD)qual$1.mapVertices((Function2)x$1, (ClassTag)x$2, null).vertices().cache();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)parallelStaticRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            Seq igraphPR0 = (Seq)((SeqOps)package$.MODULE$.Seq().fill(nVertices - 1, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)1.0));
            VertexRDD ranks0 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((IterableOnce)igraphPR0), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks0);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks0);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            VertexRDD otherStaticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
            VertexRDD otherDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
            Graph qual$2 = Graph$.MODULE$.graphToGraphOps(starGraph, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L, 1L}, numIter, resetProb);
            Function2 & Serializable x$4 = (Function2 & Serializable)(x0$3, x1$2) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$10(BoxesRunTime.unboxToLong((Object)x0$3), x1$2));
            ManifestFactory.DoubleManifest x$5 = ClassTag$.MODULE$.Double();
            Null$ x$6 = qual$2.mapVertices$default$3((Function2)x$4);
            VertexRDD otherParallelStaticRanks = (VertexRDD)qual$2.mapVertices((Function2)x$4, (ClassTag)x$5, null).vertices().cache();
            double $org_scalatest_assert_macro_left5 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherStaticRanks);
            double $org_scalatest_assert_macro_right5 = errorTol;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            double $org_scalatest_assert_macro_left6 = this.compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)otherParallelStaticRanks);
            double $org_scalatest_assert_macro_right6 = errorTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            double $org_scalatest_assert_macro_left7 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherParallelStaticRanks);
            double $org_scalatest_assert_macro_right7 = errorTol;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 < $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            double centerRank = 0.4594595;
            double sourceRank = 0.5405405;
            double d = centerRank;
            double d2 = sourceRank;
            Seq igraphPR1 = (Seq)((SeqOps)((SeqOps)package$.MODULE$.Seq().fill(nVertices - 2, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d2))).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d));
            VertexRDD ranks1 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((IterableOnce)igraphPR1), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left8 = this.compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right8 = errorTol;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            double $org_scalatest_assert_macro_left9 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right9 = errorTol;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 < $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            double $org_scalatest_assert_macro_left10 = this.compareRanks((VertexRDD<Object>)otherParallelStaticRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right10 = errorTol;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 < $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("Grid PageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int rows = 10;
            int cols = 10;
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 50;
            double errorTol = 1.0E-5;
            Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double()).pageRank(tol, resetProb).vertices().cache();
            VertexRDD referenceRanks = (VertexRDD)VertexRDD$.MODULE$.apply(sc.parallelize(GridPageRank$.MODULE$.apply(rows, cols, numIter, resetProb), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)referenceRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)referenceRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("Grid PageRank with checkpoint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int totalIters;
            int rows = 10;
            int cols = 10;
            double resetProb = 0.15;
            double errorTol = 1.0E-5;
            double tol = 1.0E-4;
            Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
            Tuple2<Object, Object> tuple2 = this.convergenceIterations(gridGraph, resetProb, tol, errorTol);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int iterAfterHalfCheckPoint = tuple2._1$mcI$sp();
            int totalIters2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(iterAfterHalfCheckPoint, totalIters2);
            Tuple2.mcII.sp sp3 = sp2;
            int iterAfterHalfCheckPoint2 = sp3._1$mcI$sp();
            int $org_scalatest_assert_macro_left = totalIters = sp3._2$mcI$sp();
            int $org_scalatest_assert_macro_right = 19;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            int $org_scalatest_assert_macro_left2 = iterAfterHalfCheckPoint2;
            int $org_scalatest_assert_macro_right2 = 18;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("Grid PageRank with checkpoint without intermediate normalization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int rows = 10;
            int cols = 10;
            double resetProb = 0.15;
            Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
            Tuple2[] ranksA = (Tuple2[])PageRank$.MODULE$.runWithOptions(gridGraph, 6, resetProb, (Option)None$.MODULE$, true, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double()).vertices().collect();
            Graph preRankGraph1 = PageRank$.MODULE$.runWithOptions(gridGraph, 2, resetProb, (Option)None$.MODULE$, false, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double());
            Graph preRankGraph2 = PageRank$.MODULE$.runWithOptionsWithPreviousPageRank(gridGraph, 2, resetProb, (Option)None$.MODULE$, false, preRankGraph1, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double());
            Tuple2[] ranksB = (Tuple2[])PageRank$.MODULE$.runWithOptionsWithPreviousPageRank(gridGraph, 2, resetProb, (Option)None$.MODULE$, true, preRankGraph2, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double()).vertices().collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ranksA), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ranksB))), (Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PageRankSuite.$anonfun$new$18(x0$4))), "scala.Predef.refArrayOps[((org.apache.spark.graphx.VertexId, Double), (org.apache.spark.graphx.VertexId, Double))](scala.Predef.refArrayOps[(org.apache.spark.graphx.VertexId, Double)](ranksA).zip[(org.apache.spark.graphx.VertexId, Double)](scala.Predef.wrapRefArray[(org.apache.spark.graphx.VertexId, Double)](ranksB))).forall(((x0$4: ((org.apache.spark.graphx.VertexId, Double), (org.apache.spark.graphx.VertexId, Double))) => x0$4 match {\n  case (_1: (org.apache.spark.graphx.VertexId, Double), _2: (org.apache.spark.graphx.VertexId, Double)): ((org.apache.spark.graphx.VertexId, Double), (org.apache.spark.graphx.VertexId, Double))((rankA @ _), (rankB @ _)) => rankA.==(rankB)\n}))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("Chain PageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            IndexedSeq chain1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable)x -> PageRankSuite.$anonfun$new$21(BoxesRunTime.unboxToInt((Object)x)));
            RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int s = tuple2._1$mcI$sp();
                int d = tuple2._2$mcI$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                return sp2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 10;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("Chain PageRank with checkpoint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int totalIters;
            double errorTol;
            double tol;
            double resetProb;
            IndexedSeq chain1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable)x -> PageRankSuite.$anonfun$new$25(BoxesRunTime.unboxToInt((Object)x)));
            RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int s = tuple2._1$mcI$sp();
                int d = tuple2._2$mcI$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                return sp2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            Tuple2<Object, Object> tuple2 = this.convergenceIterations(chain, resetProb = 0.15, tol = 1.0E-4, errorTol = 1.0E-5);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int iterAfterHalfCheckPoint = tuple2._1$mcI$sp();
            int totalIters2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(iterAfterHalfCheckPoint, totalIters2);
            Tuple2.mcII.sp sp3 = sp2;
            int iterAfterHalfCheckPoint2 = sp3._1$mcI$sp();
            int $org_scalatest_assert_macro_left = totalIters = sp3._2$mcI$sp();
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            int $org_scalatest_assert_macro_left2 = iterAfterHalfCheckPoint2;
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("Chain PersonalizedPageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            long vertexIdOffset = (long)Integer.MAX_VALUE + 1L;
            int sourceOffset = 4;
            long source = vertexIdOffset + (long)sourceOffset;
            int numIter = 10;
            NumericRange.Exclusive vertices = new RichLong(Predef$.MODULE$.longWrapper(vertexIdOffset)).until((Object)BoxesRunTime.boxToLong((long)(vertexIdOffset + (long)numIter)));
            IndexedSeq chain1 = (IndexedSeq)vertices.zip((IterableOnce)vertices.tail());
            RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long s = tuple2._1$mcJ$sp();
                long d = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(s, d);
                return sp2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            double errorTol = 0.1;
            double a = resetProb / (1.0 - Math.pow(1.0 - resetProb, numIter - sourceOffset));
            RDD expectedRanks = sc.parallelize((Seq)vertices, sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Long()).map((Function1 & Serializable)vid -> PageRankSuite.$anonfun$new$30(source, a, resetProb, BoxesRunTime.unboxToLong((Object)vid)), ClassTag$.MODULE$.apply(Tuple2.class));
            VertexRDD expected = VertexRDD$.MODULE$.apply(expectedRanks, (ClassTag)ClassTag$.MODULE$.Double());
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(source, numIter, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).personalizedPageRank(source, tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            Graph qual$3 = Graph$.MODULE$.graphToGraphOps(chain, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{source}, numIter, resetProb);
            Function2 & Serializable x$7 = (Function2 & Serializable)(x0$8, x1$3) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$31(BoxesRunTime.unboxToLong((Object)x0$8), x1$3));
            ManifestFactory.DoubleManifest x$8 = ClassTag$.MODULE$.Double();
            Null$ x$9 = qual$3.mapVertices$default$3((Function2)x$7);
            VertexRDD parallelStaticRanks = (VertexRDD)qual$3.mapVertices((Function2)x$7, (ClassTag)x$8, null).vertices().cache();
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)parallelStaticRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("Loop with source PageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 4L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(4L, 2L);
            RDD edges = sc.parallelize((Seq)package$.MODULE$.Nil().$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Int());
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 50;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            Seq igraphPR = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0375, 0.3326045, 0.3202138, 0.3096817})).map((Function1)(JFunction1.mcDD.sp & Serializable)x$4 -> x$4 * (double)4);
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((IterableOnce)igraphPR), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("Loop with source PageRank with checkpoint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int totalIters;
            double errorTol;
            double tol;
            double resetProb;
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 4L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(4L, 2L);
            RDD edges = sc.parallelize((Seq)package$.MODULE$.Nil().$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Int());
            Tuple2<Object, Object> tuple2 = this.convergenceIterations(g, resetProb = 0.15, tol = 1.0E-4, errorTol = 1.0E-5);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int iterAfterHalfCheckPoint = tuple2._1$mcI$sp();
            int totalIters2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(iterAfterHalfCheckPoint, totalIters2);
            Tuple2.mcII.sp sp7 = sp6;
            int iterAfterHalfCheckPoint2 = sp7._1$mcI$sp();
            int $org_scalatest_assert_macro_left = totalIters = sp7._2$mcI$sp();
            int $org_scalatest_assert_macro_right = 34;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            int $org_scalatest_assert_macro_left2 = iterAfterHalfCheckPoint2;
            int $org_scalatest_assert_macro_right2 = 17;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.test("Loop with sink PageRank", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 1L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(1L, 4L);
            RDD edges = sc.parallelize((Seq)package$.MODULE$.Nil().$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Int());
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 20;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            Seq igraphPR = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.3078534, 0.2137622, 0.2646223, 0.2137622})).map((Function1)(JFunction1.mcDD.sp & Serializable)x$6 -> x$6 * (double)4);
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((IterableOnce)igraphPR), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            VertexRDD p1staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
            VertexRDD p1dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
            VertexRDD p1parallelDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{1L, 2L, 3L, 4L}, numIter, resetProb).vertices().mapValues((Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)v.apply(0)), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            Seq igraphPR2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.4522329, 0.192199, 0.1633691, 0.192199}));
            VertexRDD ranks2 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((IterableOnce)igraphPR2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)p1staticRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
            double $org_scalatest_assert_macro_left5 = this.compareRanks((VertexRDD<Object>)p1dynamicRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right5 = errorTol;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
            double $org_scalatest_assert_macro_left6 = this.compareRanks((VertexRDD<Object>)p1parallelDynamicRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right6 = errorTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("Loop with sink PageRank with checkpoint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable)sc -> {
            int totalIters;
            double errorTol;
            double tol;
            double resetProb;
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 1L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(1L, 4L);
            RDD edges = sc.parallelize((Seq)package$.MODULE$.Nil().$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), (ClassTag)ClassTag$.MODULE$.Int());
            Tuple2<Object, Object> tuple2 = this.convergenceIterations(g, resetProb = 0.15, tol = 1.0E-4, errorTol = 1.0E-5);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int iterAfterHalfCheckPoint = tuple2._1$mcI$sp();
            int totalIters2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(iterAfterHalfCheckPoint, totalIters2);
            Tuple2.mcII.sp sp7 = sp6;
            int iterAfterHalfCheckPoint2 = sp7._1$mcI$sp();
            int $org_scalatest_assert_macro_left = totalIters = sp7._2$mcI$sp();
            int $org_scalatest_assert_macro_right = 15;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
            int $org_scalatest_assert_macro_left2 = iterAfterHalfCheckPoint2;
            int $org_scalatest_assert_macro_right2 = 9;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
    }
}

