/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io.cloud.abortable;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Abortable;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class AbortableFileSystem
extends RawLocalFileSystem {
    public static String ABORTABLE_FS_SCHEME = "abortable";

    public URI getUri() {
        return URI.create(ABORTABLE_FS_SCHEME + ":///");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, bufferSize, replication, blockSize, progress, permission);
        return out;
    }

    private FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, FsPermission permission) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream(this.createOutputStreamWithMode(f, false, permission), null);
    }

    protected OutputStream createOutputStreamWithMode(Path f, boolean append, FsPermission permission) throws IOException {
        return new AbortableOutputStream(f, append, permission);
    }

    class AbortableOutputStream
    extends ByteArrayOutputStream
    implements Abortable,
    StreamCapabilities {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private Path f;
        private boolean append;
        private FsPermission permission;

        AbortableOutputStream(Path f, boolean append, FsPermission permission) {
            this.f = f;
            this.append = append;
            this.permission = permission;
        }

        @Override
        public void close() throws IOException {
            if (this.closed.getAndSet(true)) {
                return;
            }
            OutputStream output = AbortableFileSystem.super.createOutputStreamWithMode(this.f, this.append, this.permission);
            this.writeTo(output);
            output.close();
        }

        public Abortable.AbortableResult abort() {
            final boolean isAlreadyClosed = this.closed.getAndSet(true);
            return new Abortable.AbortableResult(){

                public boolean alreadyClosed() {
                    return isAlreadyClosed;
                }

                public IOException anyCleanupException() {
                    return null;
                }
            };
        }

        public boolean hasCapability(String capability) {
            return capability == "fs.capability.outputstream.abortable";
        }
    }
}

