/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.DriverKubernetesCredentialsFeatureStep$;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.spark_project.guava.io.BaseEncoding;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!B\u0001\u0003\u0001!q!A\n#sSZ,'oS;cKJtW\r^3t\u0007J,G-\u001a8uS\u0006d7OR3biV\u0014Xm\u0015;fa*\u00111\u0001B\u0001\tM\u0016\fG/\u001e:fg*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;fa\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u0012Qd\t\t\u0004=}\tS\"\u0001\u0003\n\u0005\u0001\"!AD&vE\u0016\u0014h.\u001a;fg\u000e{gN\u001a\t\u0003E\rb\u0001\u0001B\u0005%3\u0005\u0005\t\u0011!B\u0001K\t\u0019q\fJ\u0019\u0012\u0005\u0019J\u0003C\u0001\t(\u0013\tA\u0013CA\u0004O_RD\u0017N\\4\u0011\u0005AQ\u0013BA\u0016\u0012\u0005\r\te.\u001f\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0002\u0004C\u0001\f\u0001\u0011\u0015QB\u00061\u00012a\t\u0011D\u0007E\u0002\u001f?M\u0002\"A\t\u001b\u0005\u0013\u0011\u0002\u0014\u0011!A\u0001\u0006\u0003)\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u001b[\u0006L(-Z'pk:$X\rZ(BkRDGk\\6f]\u001aKG.Z\u000b\u0002qA\u0019\u0001#O\u001e\n\u0005i\n\"AB(qi&|g\u000e\u0005\u0002=\u007f9\u0011\u0001#P\u0005\u0003}E\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a(\u0005\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001d\u000275\f\u0017PY3N_VtG/\u001a3P\u0003V$\b\u000eV8lK:4\u0015\u000e\\3!\u0011\u001d)\u0005A1A\u0005\n]\n\u0011$\\1zE\u0016lu.\u001e8uK\u0012\u001cE.[3oi.+\u0017PR5mK\"1q\t\u0001Q\u0001\na\n!$\\1zE\u0016lu.\u001e8uK\u0012\u001cE.[3oi.+\u0017PR5mK\u0002Bq!\u0013\u0001C\u0002\u0013%q'\u0001\u000enCf\u0014W-T8v]R,Gm\u00117jK:$8)\u001a:u\r&dW\r\u0003\u0004L\u0001\u0001\u0006I\u0001O\u0001\u001c[\u0006L(-Z'pk:$X\rZ\"mS\u0016tGoQ3si\u001aKG.\u001a\u0011\t\u000f5\u0003!\u0019!C\u0005o\u00051R.Y=cK6{WO\u001c;fI\u000e\u000b7)\u001a:u\r&dW\r\u0003\u0004P\u0001\u0001\u0006I\u0001O\u0001\u0018[\u0006L(-Z'pk:$X\rZ\"b\u0007\u0016\u0014HOR5mK\u0002Bq!\u0015\u0001C\u0002\u0013%q'\u0001\u000bee&4XM]*feZL7-Z!dG>,h\u000e\u001e\u0005\u0007'\u0002\u0001\u000b\u0011\u0002\u001d\u0002+\u0011\u0014\u0018N^3s'\u0016\u0014h/[2f\u0003\u000e\u001cw.\u001e8uA!9Q\u000b\u0001b\u0001\n\u00131\u0016\u0001E8bkRDGk\\6f]\n\u000b7/\u001a\u001c5+\u00059\u0006c\u0001\t:1B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005\u0001S\u0006B\u00021\u0001A\u0003%q+A\tpCV$\b\u000eV8lK:\u0014\u0015m]37i\u0001BqA\u0019\u0001C\u0002\u0013%q'\u0001\tdC\u000e+'\u000f\u001e#bi\u0006\u0014\u0015m]37i!1A\r\u0001Q\u0001\na\n\u0011cY1DKJ$H)\u0019;b\u0005\u0006\u001cXM\u000e\u001b!\u0011\u001d1\u0007A1A\u0005\n]\n1c\u00197jK:$8*Z=ECR\f')Y:fmQBa\u0001\u001b\u0001!\u0002\u0013A\u0014\u0001F2mS\u0016tGoS3z\t\u0006$\u0018MQ1tKZ\"\u0004\u0005C\u0004k\u0001\t\u0007I\u0011B\u001c\u0002)\rd\u0017.\u001a8u\u0007\u0016\u0014H\u000fR1uC\n\u000b7/\u001a\u001c5\u0011\u0019a\u0007\u0001)A\u0005q\u0005)2\r\\5f]R\u001cUM\u001d;ECR\f')Y:fmQ\u0002\u0003b\u00028\u0001\u0005\u0004%Ia\\\u0001\u0012g\"|W\u000f\u001c3N_VtGoU3de\u0016$X#\u00019\u0011\u0005A\t\u0018B\u0001:\u0012\u0005\u001d\u0011un\u001c7fC:Da\u0001\u001e\u0001!\u0002\u0013\u0001\u0018AE:i_VdG-T8v]R\u001cVm\u0019:fi\u0002BqA\u001e\u0001C\u0002\u0013%q/A\u000eee&4XM]\"sK\u0012,g\u000e^5bYN\u001cVm\u0019:fi:\u000bW.Z\u000b\u0002w!1\u0011\u0010\u0001Q\u0001\nm\nA\u0004\u001a:jm\u0016\u00148I]3eK:$\u0018.\u00197t'\u0016\u001c'/\u001a;OC6,\u0007\u0005C\u0003|\u0001\u0011\u0005C0\u0001\u0007d_:4\u0017nZ;sKB{G\rF\u0002~\u0003\u0003\u0001\"A\b@\n\u0005}$!\u0001C*qCJ\\\u0007k\u001c3\t\r\u0005\r!\u00101\u0001~\u0003\r\u0001x\u000e\u001a\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0005\u0005-\u0001#\u0002\u001f\u0002\u000emZ\u0014bAA\b\u0003\n\u0019Q*\u00199\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\u0005\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\t\t9\u0002\u0005\u0004\u0002\u001a\u0005%\u0012q\u0006\b\u0005\u00037\t)C\u0004\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tcG\u0001\u0007yI|w\u000e\u001e \n\u0003II1!a\n\u0012\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000b\u0002.\t\u00191+Z9\u000b\u0007\u0005\u001d\u0012\u0003\u0005\u0003\u00022\u0005\u001dSBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000b5|G-\u001a7\u000b\t\u0005e\u00121H\u0001\u0004CBL'\u0002BA\u001f\u0003\u007f\t!b[;cKJtW\r^3t\u0015\u0011\t\t%a\u0011\u0002\u000f\u0019\f'M]5dq)\u0011\u0011QI\u0001\u0003S>LA!!\u0013\u00024\tY\u0001*Y:NKR\fG-\u0019;b\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f\nAc]1gK\u001aKG.Z\"p]\u001a$vNQ1tKZ\"D#\u0002\u001d\u0002R\u0005U\u0003bBA*\u0003\u0017\u0002\raO\u0001\u0005G>tg\rC\u0004\u0002X\u0005-\u0003\u0019A\u001e\u0002\u0011\u0019LG.\u001a+za\u0016Dq!a\u0017\u0001\t\u0013\ti&A\tsKN|GN^3TK\u000e\u0014X\r\u001e#bi\u0006$b!a\u0003\u0002`\u0005\r\u0004bBA1\u00033\u0002\r\u0001O\u0001\u0018kN,'o\u00159fG&4\u0017.\u001a3De\u0016$WM\u001c;jC2Dq!!\u001a\u0002Z\u0001\u00071(\u0001\u0006tK\u000e\u0014X\r\u001e(b[\u0016Dq!!\u001b\u0001\t\u0013\tY'A\u000bsKN|GN^3TK\u000e\u0014X\r\u001e'pG\u0006$\u0018n\u001c8\u0015\u000fa\ni'!\u001d\u0002v!9\u0011qNA4\u0001\u0004A\u0014\u0001F7pk:$X\rZ+tKJ\u001c\u0006/Z2jM&,G\rC\u0004\u0002t\u0005\u001d\u0004\u0019\u0001\u001d\u00023Y\fG.^3N_VtG/\u001a3Ge>l7+\u001e2nSR$XM\u001d\u0005\b\u0003o\n9\u00071\u0001<\u0003aiw.\u001e8uK\u0012\u001c\u0015M\\8oS\u000e\fG\u000eT8dCRLwN\u001c\u0005\b\u0003w\u0002A\u0011BA?\u0003]\u0019'/Z1uK\u000e\u0013X\rZ3oi&\fGn]*fGJ,G\u000f\u0006\u0002\u0002\u0000A!\u0011\u0011GAA\u0013\u0011\t\u0019)a\r\u0003\rM+7M]3u\u0001")
public class DriverKubernetesCredentialsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<?> kubernetesConf;
    private final Option<String> maybeMountedOAuthTokenFile;
    private final Option<String> maybeMountedClientKeyFile;
    private final Option<String> maybeMountedClientCertFile;
    private final Option<String> maybeMountedCaCertFile;
    private final Option<String> driverServiceAccount;
    private final Option<String> oauthTokenBase64;
    private final Option<String> caCertDataBase64;
    private final Option<String> clientKeyDataBase64;
    private final Option<String> clientCertDataBase64;
    private final boolean shouldMountSecret;
    private final String driverCredentialsSecretName;

    private Option<String> maybeMountedOAuthTokenFile() {
        return this.maybeMountedOAuthTokenFile;
    }

    private Option<String> maybeMountedClientKeyFile() {
        return this.maybeMountedClientKeyFile;
    }

    private Option<String> maybeMountedClientCertFile() {
        return this.maybeMountedClientCertFile;
    }

    private Option<String> maybeMountedCaCertFile() {
        return this.maybeMountedCaCertFile;
    }

    private Option<String> driverServiceAccount() {
        return this.driverServiceAccount;
    }

    private Option<String> oauthTokenBase64() {
        return this.oauthTokenBase64;
    }

    private Option<String> caCertDataBase64() {
        return this.caCertDataBase64;
    }

    private Option<String> clientKeyDataBase64() {
        return this.clientKeyDataBase64;
    }

    private Option<String> clientCertDataBase64() {
        return this.clientCertDataBase64;
    }

    private boolean shouldMountSecret() {
        return this.shouldMountSecret;
    }

    private String driverCredentialsSecretName() {
        return this.driverCredentialsSecretName;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        SparkPod sparkPod;
        if (this.shouldMountSecret()) {
            Pod driverPodWithMountedKubernetesCredentials = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)new PodBuilder(pod.pod()).editOrNewSpec().addNewVolume().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withNewSecret().withSecretName(this.driverCredentialsSecretName())).endSecret()).endVolume()).endSpec()).build();
            Container driverContainerWithMountedSecretVolume = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(pod.container()).addNewVolumeMount().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withMountPath(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR())).endVolumeMount()).build();
            sparkPod = new SparkPod(driverPodWithMountedKubernetesCredentials, driverContainerWithMountedSecretVolume);
        } else {
            sparkPod = pod.copy((Pod)this.driverServiceAccount().map((Function1)new Serializable(this, pod){
                public static final long serialVersionUID = 0L;
                private final SparkPod pod$1;

                public final Pod apply(String account) {
                    return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(this.pod$1.pod()).editOrNewSpec().withServiceAccount(account).withServiceAccountName(account)).endSpec()).build();
                }
                {
                    this.pod$1 = pod$1;
                }
            }).getOrElse((Function0)new Serializable(this, pod){
                public static final long serialVersionUID = 0L;
                private final SparkPod pod$1;

                public final Pod apply() {
                    return this.pod$1.pod();
                }
                {
                    this.pod$1 = pod$1;
                }
            }), pod.copy$default$2());
        }
        return sparkPod;
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        Option<String> resolvedMountedOAuthTokenFile = this.resolveSecretLocation(this.maybeMountedOAuthTokenFile(), this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH());
        Option<String> resolvedMountedClientKeyFile = this.resolveSecretLocation(this.maybeMountedClientKeyFile(), this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH());
        Option<String> resolvedMountedClientCertFile = this.resolveSecretLocation(this.maybeMountedClientCertFile(), this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH());
        Option<String> resolvedMountedCaCertFile = this.resolveSecretLocation(this.maybeMountedCaCertFile(), this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH());
        scala.collection.immutable.Map redactedTokens = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.kubernetesConf.sparkConf().getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$1) {
                return ((String)x$1._1()).endsWith(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX());
            }
        })).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return "<present_but_redacted>";
            }
        });
        return redactedTokens.$plus$plus((GenTraversableOnce)resolvedMountedCaCertFile.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(String file) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()}))), (Object)file)}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        })).$plus$plus((GenTraversableOnce)resolvedMountedClientKeyFile.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(String file) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()}))), (Object)file)}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        })).$plus$plus((GenTraversableOnce)resolvedMountedClientCertFile.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(String file) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()}))), (Object)file)}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        })).$plus$plus((GenTraversableOnce)resolvedMountedOAuthTokenFile.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(String file) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()}))), (Object)file)}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        }));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.shouldMountSecret() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{this.createCredentialsSecret()})) : (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> safeFileConfToBase64(String conf, String fileType) {
        return this.kubernetesConf.getOption(conf).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }).map((Function1)new Serializable(this, fileType){
            public static final long serialVersionUID = 0L;
            public final String fileType$1;

            public final String apply(File file) {
                Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$safeFileConfToBase64$2 $outer;
                    private final File file$1;

                    public final String apply() {
                        return String.format("%s provided at %s does not exist or is not a file.", this.$outer.fileType$1, this.file$1.getAbsolutePath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
                return BaseEncoding.base64().encode(Files.toByteArray((File)file));
            }
            {
                this.fileType$1 = fileType$1;
            }
        });
    }

    private scala.collection.immutable.Map<String, String> resolveSecretData(Option<String> userSpecifiedCredential, String secretName) {
        return (scala.collection.immutable.Map)userSpecifiedCredential.map((Function1)new Serializable(this, secretName){
            public static final long serialVersionUID = 0L;
            private final String secretName$1;

            public final scala.collection.immutable.Map<String, String> apply(String valueBase64) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.secretName$1), (Object)valueBase64)}));
            }
            {
                this.secretName$1 = secretName$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
    }

    private Option<String> resolveSecretLocation(Option<String> mountedUserSpecified, Option<String> valueMountedFromSubmitter, String mountedCanonicalLocation) {
        return mountedUserSpecified.orElse((Function0)new Serializable(this, valueMountedFromSubmitter, mountedCanonicalLocation){
            public static final long serialVersionUID = 0L;
            private final Option valueMountedFromSubmitter$1;
            public final String mountedCanonicalLocation$1;

            public final Option<String> apply() {
                return this.valueMountedFromSubmitter$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$resolveSecretLocation$1 $outer;

                    public final String apply(String x$4) {
                        return this.$outer.mountedCanonicalLocation$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.valueMountedFromSubmitter$1 = valueMountedFromSubmitter$1;
                this.mountedCanonicalLocation$1 = mountedCanonicalLocation$1;
            }
        });
    }

    private Secret createCredentialsSecret() {
        scala.collection.immutable.Map allSecretData = this.resolveSecretData(this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()).$plus$plus(this.resolveSecretData(this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()));
        return ((SecretBuilder)((SecretFluentImpl)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(this.driverCredentialsSecretName())).endMetadata()).withData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)allSecretData).asJava())).build();
    }

    public DriverKubernetesCredentialsFeatureStep(KubernetesConf<?> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        this.maybeMountedOAuthTokenFile = kubernetesConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()})));
        this.maybeMountedClientKeyFile = kubernetesConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})));
        this.maybeMountedClientCertFile = kubernetesConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})));
        this.maybeMountedCaCertFile = kubernetesConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})));
        this.driverServiceAccount = (Option)kubernetesConf.get((ConfigEntry<?>)Config$.MODULE$.KUBERNETES_SERVICE_ACCOUNT_NAME());
        this.oauthTokenBase64 = kubernetesConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String token) {
                return BaseEncoding.base64().encode(token.getBytes(StandardCharsets.UTF_8));
            }
        });
        this.caCertDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})), "Driver CA cert file");
        this.clientKeyDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})), "Driver client key file");
        this.clientCertDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})), "Driver client cert file");
        this.shouldMountSecret = this.oauthTokenBase64().isDefined() || this.caCertDataBase64().isDefined() || this.clientKeyDataBase64().isDefined() || this.clientCertDataBase64().isDefined();
        this.driverCredentialsSecretName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-kubernetes-credentials"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesConf.appResourceNamePrefix()}));
    }
}

