/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.mockito.MockitoAnnotations;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001=\u0011QDQ1tS\u000e,\u00050Z2vi>\u0014h)Z1ukJ,7\u000b^3q'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u000b\u0019\t1a\u001b\u001dt\u0015\t9\u0001\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011)i\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\u0002$D\u0001\u0017\u0015\t9B\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011D\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s!\t)2$\u0003\u0002\u001d-\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\u0001C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002\r\u0005\u0003\u0006kX%E+\u0005)\u0003C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011a\u0017M\\4\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0007'R\u0014\u0018N\\4\t\r9\u0002\u0001\u0015!\u0003&\u0003\u001d\t\u0005\u000bU0J\t\u0002Bq\u0001\r\u0001C\u0002\u0013%A%A\bE%&3VIU0I\u001fN#f*Q'F\u0011\u0019\u0011\u0004\u0001)A\u0005K\u0005\u0001BIU%W\u000bJ{\u0006jT*U\u001d\u0006kU\t\t\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0003-!%+\u0013,F%~\u0003vJ\u0015+\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u00121!\u00138u\u0011\u0019i\u0004\u0001)A\u0005m\u0005aAIU%W\u000bJ{\u0006k\u0014*UA!9q\b\u0001b\u0001\n\u0013\u0001\u0015A\u0004#S\u0013Z+%kX!E\tJ+5kU\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A\tC\u0001\u0004eB\u001c\u0017B\u0001$D\u0005I\u0011\u0006oY#oIB|\u0017N\u001c;BI\u0012\u0014Xm]:\t\r!\u0003\u0001\u0015!\u0003B\u0003=!%+\u0013,F%~\u000bE\t\u0012*F'N\u0003\u0003b\u0002&\u0001\u0005\u0004%I\u0001J\u0001\u0010\tJKe+\u0012*`!>#uLT!N\u000b\"1A\n\u0001Q\u0001\n\u0015\n\u0001\u0003\u0012*J-\u0016\u0013v\fU(E?:\u000bU*\u0012\u0011\t\u000f9\u0003!\u0019!C\u0005I\u0005qAIU%W\u000bJ{\u0006k\u0014#`+&#\u0005B\u0002)\u0001A\u0003%Q%A\bE%&3VIU0Q\u001f\u0012{V+\u0013#!\u0011\u001d\u0011\u0006A1A\u0005\n\u0011\nACU#T\u001fV\u00136)R0O\u00036+u\f\u0015*F\r&C\u0006B\u0002+\u0001A\u0003%Q%A\u000bS\u000bN{UKU\"F?:\u000bU*R0Q%\u00163\u0015\n\u0017\u0011\t\u000fY\u0003!\u0019!C\u0005I\u0005qQ\tW#D+R{%kX%N\u0003\u001e+\u0005B\u0002-\u0001A\u0003%Q%A\bF1\u0016\u001bU\u000bV(S?&k\u0015iR#!\u0011\u001dQ\u0006A1A\u0005\nm\u000ba\u0001T!C\u000b2\u001bV#\u0001/\u0011\tu\u0013W%J\u0007\u0002=*\u0011q\fY\u0001\nS6lW\u000f^1cY\u0016T!!\u0019\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n\u0019Q*\u00199\t\r\u0015\u0004\u0001\u0015!\u0003]\u0003\u001da\u0015IQ#M'\u0002Bqa\u001a\u0001C\u0002\u0013%1,A\u0006B\u001d:{E+\u0011+J\u001f:\u001b\u0006BB5\u0001A\u0003%A,\u0001\u0007B\u001d:{E+\u0011+J\u001f:\u001b\u0006\u0005C\u0004l\u0001\t\u0007I\u0011\u00027\u0002/Q+5\u000bV0J\u001b\u0006;Ui\u0018)V\u00192{6+R\"S\u000bR\u001bV#A7\u0011\u00079|W%D\u0001a\u0013\t\u0001\bMA\u0002TKFDaA\u001d\u0001!\u0002\u0013i\u0017\u0001\u0007+F'R{\u0016*T!H\u000b~\u0003V\u000b\u0014'`'\u0016\u001b%+\u0012+TA!9A\u000f\u0001b\u0001\n\u0013)\u0018A\b+F'R{\u0016*T!H\u000b~\u0003V\u000b\u0014'`'\u0016\u001b%+\u0012+`\u001f\nSUi\u0011+T+\u00051\bc\u00018poB\u0019\u00010a\u0002\u000e\u0003eT!A_>\u0002\u000b5|G-\u001a7\u000b\u0005ql\u0018aA1qS*\u0011ap`\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA\u0001\u0003\u0007\tqAZ1ce&\u001c\u0007H\u0003\u0002\u0002\u0006\u0005\u0011\u0011n\\\u0005\u0004\u0003\u0013I(\u0001\u0006'pG\u0006dwJ\u00196fGR\u0014VMZ3sK:\u001cW\rC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002<\u0002?Q+5\u000bV0J\u001b\u0006;Ui\u0018)V\u00192{6+R\"S\u000bR{vJ\u0011&F\u0007R\u001b\u0006\u0005C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014\u0005QAIU%W\u000bJ{\u0006k\u0014#\u0016\u0005\u0005U\u0001c\u0001=\u0002\u0018%\u0019\u0011\u0011D=\u0003\u0007A{G\r\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u000b\u0003-!%+\u0013,F%~\u0003v\n\u0012\u0011\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\tE\u0006\u001cXmQ8oMV\u0011\u0011Q\u0005\t\u0004#\u0005\u001d\u0012bAA\u0015\u0011\tI1\u000b]1sW\u000e{gN\u001a\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty#\u0001\u0007cCN,7i\u001c8g?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005]\u0002cA\u001c\u00024%\u0019\u0011Q\u0007\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003s\tY#!AA\u0002\u0005\u0015\u0012a\u0001=%c!A\u0011Q\b\u0001!B\u0013\t)#A\u0005cCN,7i\u001c8gA!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0013\u0001F2iK\u000e\\wj\u001e8feJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u00022\u0005\u0015\u0013\u0011\n\u0005\t\u0003\u000f\ny\u00041\u0001\u0002\u0016\u0005AQ\r_3dkR|'\u000f\u0003\u0005\u0002L\u0005}\u0002\u0019AA'\u00031!'/\u001b<feB{G-V5e!\u0011\ty%!\u0016\u000f\u0007]\n\t&C\u0002\u0002Ta\na\u0001\u0015:fI\u00164\u0017b\u0001\u0017\u0002X)\u0019\u00111\u000b\u001d\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\u0005A1\r[3dW\u0016sg\u000f\u0006\u0004\u00022\u0005}\u00131\u000e\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005YQ\r_3dkR|'\u000fU8e!\u0011\t)'a\u001a\u000e\u0003\u0011I1!!\u001b\u0005\u0005!\u0019\u0006/\u0019:l!>$\u0007\u0002CA7\u00033\u0002\r!a\u001c\u0002#\u0005$G-\u001b;j_:\fG.\u00128w-\u0006\u00148\u000f\u0005\u0005\u0002P\u0005E\u0014QJA'\u0013\r\u0019\u0017q\u000b")
public class BasicExecutorFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID;
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME;
    private final int org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT;
    private final RpcEndpointAddress DRIVER_ADDRESS;
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME;
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID;
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX;
    private final String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE;
    private final scala.collection.immutable.Map<String, String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS;
    private final scala.collection.immutable.Map<String, String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS;
    private final Seq<String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS;
    private final Seq<LocalObjectReference> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRET_OBJECTS;
    private final Pod org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD;
    private SparkConf org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID;
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME;
    }

    public int org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT;
    }

    private RpcEndpointAddress DRIVER_ADDRESS() {
        return this.DRIVER_ADDRESS;
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME;
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID;
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX;
    }

    public String org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE;
    }

    public scala.collection.immutable.Map<String, String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS;
    }

    public scala.collection.immutable.Map<String, String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS;
    }

    public Seq<String> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS;
    }

    public Seq<LocalObjectReference> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    public Pod org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD;
    }

    public SparkConf org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf;
    }

    public void org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf_$eq(SparkConf x$1) {
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf = x$1;
    }

    public void org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkOwnerReferences(Pod executor, String driverPodUid) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getOwnerReferences().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getUid());
        String $org_scalatest_assert_macro_right2 = driverPodUid;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getController());
        boolean $org_scalatest_assert_macro_right3 = true;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public void org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkEnv(SparkPod executorPod, scala.collection.immutable.Map<String, String> additionalEnvVars) {
        scala.collection.immutable.Map defaultEnvs = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.DRIVER_ADDRESS().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)"1g"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP()), null)}))).$plus$plus(additionalEnvVars);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executorPod.container().getEnv().size()));
        int $org_scalatest_assert_macro_right = defaultEnvs.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        scala.collection.immutable.Map mapEnvs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorPod.container().getEnv()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EnvVar x) {
                return new Tuple2((Object)x.getName(), (Object)x.getValue());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(defaultEnvs);
        scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = mapEnvs;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }

    public BasicExecutorFeatureStepSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID = "app-id";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME = "localhost";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT = 7098;
        this.DRIVER_ADDRESS = RpcEndpointAddress$.MODULE$.apply(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME(), this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME());
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME = "driver-pod";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID = "driver-uid";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX = "base";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE = "executor-image";
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value")}));
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"annotation1key"), (Object)"annotation1value")}));
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my-1secret-1", "my-secret-2"}));
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LocalObjectReference apply(String secret) {
                return ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD = ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME()).withUid(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID())).endMetadata()).withNewSpec().withNodeName("some-node")).endSpec()).withNewStatus().withHostIP("192.168.99.100")).endStatus()).build();
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf_$eq(new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_NAME()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX()).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE()).set(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set("spark.driver.host", this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_HOSTNAME()).set("spark.driver.port", ((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_PORT())).toString()).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), (Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRETS().mkString(",")).set("spark.kubernetes.resource.type", "java"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("basic executor pod has reasonable defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf(), (KubernetesRoleSpecificConf)new KubernetesExecutorSpecificConf("1", (Option)new Some((Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD())), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()));
                SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(executor.pod().getMetadata().getName());
                String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-exec-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX()}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(executor.pod().getMetadata().getLabels()).asScala());
                scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_right2 = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(executor.pod().getSpec().getImagePullSecrets()).asScala());
                Seq<LocalObjectReference> $org_scalatest_assert_macro_right3 = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$TEST_IMAGE_PULL_SECRET_OBJECTS();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(executor.container().getImage());
                String $org_scalatest_assert_macro_right4 = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$EXECUTOR_IMAGE();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                List $org_scalatest_assert_macro_left5 = executor.container().getVolumeMounts();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(((Quantity)executor.container().getResources().getLimits().get("memory")).getAmount());
                String $org_scalatest_assert_macro_right6 = "1408Mi";
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                Map $org_scalatest_assert_macro_left8 = executor.pod().getSpec().getNodeSelector();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                List $org_scalatest_assert_macro_left9 = executor.pod().getSpec().getVolumes();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkEnv(executor, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkOwnerReferences(executor.pod(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("executor pod hostnames get truncated to 63 characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStepSuite $outer;

            public final Assertion apply() {
                SparkConf conf = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf().clone();
                String longPodNamePrefix = "loremipsumdolorsitametvimatelitrefficiendisuscipianturvixlegeresple";
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(new KubernetesConf(conf, (KubernetesRoleSpecificConf)new KubernetesExecutorSpecificConf("1", (Option)new Some((Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD())), longPodNamePrefix, this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname().length()));
                int $org_scalatest_assert_macro_right = 63;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("classpath and extra java options get translated into environment variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf().clone();
                conf.set(package$.MODULE$.EXECUTOR_JAVA_OPTIONS(), (Object)"foo=bar");
                conf.set(package$.MODULE$.EXECUTOR_CLASS_PATH(), (Object)"bar=baz");
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(new KubernetesConf(conf, (KubernetesRoleSpecificConf)new KubernetesExecutorSpecificConf("1", (Option)new Some((Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD())), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")})), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()));
                SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
                this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkEnv(executor, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_JAVA_OPT_0"), (Object)"foo=bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), (Object)"bar=baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
                this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$checkOwnerReferences(executor.pod(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD_UID());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("test executor pyspark memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStepSuite $outer;

            public final Assertion apply() {
                SparkConf conf = this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$baseConf().clone();
                conf.set("spark.kubernetes.resource.type", "python");
                conf.set(package$.MODULE$.PYSPARK_EXECUTOR_MEMORY(), (Object)BoxesRunTime.boxToLong((long)42L));
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(new KubernetesConf(conf, (KubernetesRoleSpecificConf)new KubernetesExecutorSpecificConf("1", (Option)new Some((Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$DRIVER_POD())), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$APP_ID(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$LABELS(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStepSuite$$ANNOTATIONS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()));
                SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((Quantity)executor.container().getResources().getRequests().get("memory")).getAmount());
                String $org_scalatest_assert_macro_right = "1450Mi";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }
}

