/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001=\u0011Q\u0004\u0012:jm\u0016\u00148+\u001a:wS\u000e,g)Z1ukJ,7\u000b^3q'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u000b\u0019\t1a\u001b\u001dt\u0015\t9\u0001\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005UAR\"\u0001\f\u000b\u0005]a\u0011!C:dC2\fG/Z:u\u0013\tIbC\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u001b'\"{%\u000bV0S\u000bN{UKU\"F?:\u000bU*R0Q%\u00163\u0015\nW\u000b\u0002EA\u00111%\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&J\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)K!1Q\u0006\u0001Q\u0001\n\t\n1d\u0015%P%R{&+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b\u0003\u0003bB\u0018\u0001\u0005\u0004%I!I\u0001\u001a\u0019>sui\u0018*F'>+&kQ#`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005\f\u0003\u00042\u0001\u0001\u0006IAI\u0001\u001b\u0019>sui\u0018*F'>+&kQ#`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005\f\t\u0005\bg\u0001\u0011\r\u0011\"\u00035\u00035!%+\u0013,F%~c\u0015IQ#M'V\tQ\u0007\u0005\u00037wujT\"A\u001c\u000b\u0005aJ\u0014!C5n[V$\u0018M\u00197f\u0015\tQT%\u0001\u0006d_2dWm\u0019;j_:L!\u0001P\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!AK \t\r\u0015\u0003\u0001\u0015!\u00036\u00039!%+\u0013,F%~c\u0015IQ#M'\u0002B\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002%\u0002\u000b\rdwnY6\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003\u001d.\u0013Qa\u00117pG.D\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011B)\u0002\u0013\rdwnY6`I\u0015\fHC\u0001*V!\t!3+\u0003\u0002UK\t!QK\\5u\u0011\u001d1v*!AA\u0002%\u000b1\u0001\u001f\u00132\u0011\u0019A\u0006\u0001)Q\u0005\u0013\u000611\r\\8dW\u0002B#a\u0016.\u0011\u0005msV\"\u0001/\u000b\u0005uc\u0011aB7pG.LGo\\\u0005\u0003?r\u0013A!T8dW\"I\u0011\r\u0001a\u0001\u0002\u0004%IAY\u0001\ngB\f'o[\"p]\u001a,\u0012a\u0019\t\u0003#\u0011L!!\u001a\u0005\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u00035\u0019\b/\u0019:l\u0007>tgm\u0018\u0013fcR\u0011!+\u001b\u0005\b-\u001a\f\t\u00111\u0001d\u0011\u0019Y\u0007\u0001)Q\u0005G\u0006Q1\u000f]1sW\u000e{gN\u001a\u0011\t\u000b5\u0004A\u0011\u00028\u0002\u001bY,'/\u001b4z'\u0016\u0014h/[2f)\u0015\u0011v\u000e\u001e<y\u0011\u0015\u0001H\u000e1\u0001r\u0003)!'/\u001b<feB{'\u000f\u001e\t\u0003IIL!a]\u0013\u0003\u0007%sG\u000fC\u0003vY\u0002\u0007\u0011/\u0001\tcY>\u001c7.T1oC\u001e,'\u000fU8si\")q\u000f\u001ca\u0001E\u0005\u0019R\r\u001f9fGR,GmU3sm&\u001cWMT1nK\")\u0011\u0010\u001ca\u0001u\u000691/\u001a:wS\u000e,\u0007cA>\u0002\u000e5\tAP\u0003\u0002~}\u0006)Qn\u001c3fY*\u0019q0!\u0001\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0004\u0005\u0015\u0011AC6vE\u0016\u0014h.\u001a;fg*!\u0011qAA\u0005\u0003\u001d1\u0017M\u0019:jGbR!!a\u0003\u0002\u0005%|\u0017bAA\by\n91+\u001a:wS\u000e,\u0007bBA\n\u0001\u0011%\u0011QC\u0001\u0019m\u0016\u0014\u0018NZ=Ta\u0006\u00148nQ8oM\"{7\u000f\u001e(b[\u0016\u001cH#\u0002*\u0002\u0018\u0005}\u0001\u0002CA\r\u0003#\u0001\r!a\u0007\u0002\u001f\u0011\u0014\u0018N^3s'B\f'o[\"p]\u001a\u0004RaIA\u000fE\tJ!\u0001P\u0016\t\u000f\u0005\u0005\u0012\u0011\u0003a\u0001E\u0005\u0001R\r\u001f9fGR,G\rS8ti:\u000bW.\u001a")
public class DriverServiceFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX;
    private final String org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX;
    private final Map<String, String> org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS;
    @Mock
    private Clock org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock;
    private SparkConf org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX;
    }

    public String org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX;
    }

    public Map<String, String> org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS() {
        return this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS;
    }

    public Clock org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock() {
        return this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock;
    }

    private void org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock_$eq(Clock x$1) {
        this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock = x$1;
    }

    public SparkConf org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf() {
        return this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf;
    }

    public void org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf_$eq(SparkConf x$1) {
        this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf = x$1;
    }

    public void org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifyService(int driverPort, int blockManagerPort, String expectedServiceName, Service service) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getName());
        String $org_scalatest_assert_macro_right = expectedServiceName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(service.getSpec().getClusterIP());
        String $org_scalatest_assert_macro_right2 = "None";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(service.getSpec().getSelector()).asScala());
        Map<String, String> $org_scalatest_assert_macro_right3 = this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)service.getSpec().getPorts().size()));
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        Buffer driverServicePorts = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(service.getSpec().getPorts()).asScala();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getName());
        String $org_scalatest_assert_macro_right5 = Constants$.MODULE$.DRIVER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.head()).getPort()));
        int $org_scalatest_assert_macro_right6 = driverPort;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right7 = driverPort;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getName());
        String $org_scalatest_assert_macro_right8 = Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(1)).getPort()));
        int $org_scalatest_assert_macro_right9 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right10 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
    }

    public void org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifySparkConfHostNames(Map<String, String> driverSparkConf, String expectedHostName) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverSparkConf.apply((Object)package$.MODULE$.DRIVER_HOST_ADDRESS().key()));
        String $org_scalatest_assert_macro_right = expectedHostName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }

    public DriverServiceFeatureStepSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX = new StringOps(Predef$.MODULE$.augmentString("a")).$times(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX().length());
        this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX = new StringOps(Predef$.MODULE$.augmentString("a")).$times(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX().length() + 1);
        this.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label2key"), (Object)"label2value")}));
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf_$eq(new SparkConf(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("Headless service has a port for the driver RPC and the block manager.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf_$eq(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().set("spark.driver.port", "9000").set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)));
                DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf(), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
                SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)configurationStep.getAdditionalKubernetesResources().size()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                HasMetadata $org_scalatest_assert_macro_left3 = (HasMetadata)configurationStep.getAdditionalKubernetesResources().head();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "io.fabric8.kubernetes.api.model.Service", $org_scalatest_assert_macro_left3 instanceof Service, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifyService(9000, 8080, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()})), driverService);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("Hostname and ports are set according to the service name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().set("spark.driver.port", "9000").set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace"), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
                String expectedServiceName = new StringBuilder().append((Object)this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX()).append((Object)DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
                String expectedHostName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".my-namespace.svc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedServiceName}));
                Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifySparkConfHostNames((Map<String, String>)additionalProps, expectedHostName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("Ports should resolve to defaults in SparkConf and in the service.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final Assertion apply() {
                DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf(), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
                Service resolvedService = (Service)configurationStep.getAdditionalKubernetesResources().head();
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifyService(Constants$.MODULE$.DEFAULT_DRIVER_PORT(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()})), resolvedService);
                Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(additionalProps.apply((Object)"spark.driver.port"));
                String $org_scalatest_assert_macro_right = ((Object)BoxesRunTime.boxToInteger((int)Constants$.MODULE$.DEFAULT_DRIVER_PORT())).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(additionalProps.apply((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()));
                String $org_scalatest_assert_macro_right2 = ((Object)BoxesRunTime.boxToInteger((int)Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT())).toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Long prefixes should switch to using a generated name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock().getTimeMillis())).thenReturn((Object)BoxesRunTime.boxToLong((long)10000L));
                DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace"), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock());
                Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
                String expectedServiceName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-10000", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(driverService.getMetadata().getName());
                String $org_scalatest_assert_macro_right = expectedServiceName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                String expectedHostName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".my-namespace.svc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedServiceName}));
                Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
                this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$verifySparkConfHostNames((Map<String, String>)additionalProps, expectedHostName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("Disallow bind address and driver host to be set explicitly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceFeatureStepSuite $outer;

            public final Object apply() {
                try {
                    new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().set(package$.MODULE$.DRIVER_BIND_ADDRESS(), (Object)"host"), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock());
                    throw this.$outer.fail("The driver bind address should not be allowed.", new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                }
                catch (Throwable throwable) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(throwable.getMessage());
                    String $org_scalatest_assert_macro_right = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", " is"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()}))).append((Object)" not supported in Kubernetes mode, as the driver's bind address is managed").append((Object)" and set to the driver pod's IP address.").toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                    this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().remove(package$.MODULE$.DRIVER_BIND_ADDRESS());
                    this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf().set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)"host");
                    try {
                        new DriverServiceFeatureStep(new KubernetesConf(this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$sparkConf(), (KubernetesRoleSpecificConf)new KubernetesDriverSpecificConf((Option)None$.MODULE$, "main", "app", (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$LONG_RESOURCE_NAME_PREFIX(), "app-id", this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$DRIVER_LABELS(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (Iterable)Nil$.MODULE$, (Seq)Seq$.MODULE$.empty()), this.$outer.org$apache$spark$deploy$k8s$features$DriverServiceFeatureStepSuite$$clock());
                        throw this.$outer.fail("The driver host address should not be allowed.", new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                    }
                    catch (Throwable throwable2) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(throwable2.getMessage());
                        String $org_scalatest_assert_macro_right2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", " is"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()}))).append((Object)" not supported in Kubernetes mode, as the driver's hostname will be managed via").append((Object)" a Kubernetes service.").toString();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
    }
}

