/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class KubernetesFeaturesTestUtils$ {
    public static final KubernetesFeaturesTestUtils$ MODULE$;

    static {
        new KubernetesFeaturesTestUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public <T extends KubernetesFeatureConfigStep> T getMockConfigStepForStepType(String stepType, Class<T> stepClass) {
        void var3_3;
        KubernetesFeatureConfigStep mockStep = (KubernetesFeatureConfigStep)Mockito.mock(stepClass);
        Mockito.when((Object)mockStep.getAdditionalKubernetesResources()).thenReturn(this.getSecretsForStepType(stepType));
        Mockito.when((Object)mockStep.getAdditionalPodSystemProperties()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)stepType), (Object)stepType)})));
        Mockito.when((Object)mockStep.configurePod((SparkPod)Matchers.any(SparkPod.class))).thenAnswer((Answer)new Answer<SparkPod>(stepType){
            private final String stepType$1;

            public SparkPod answer(InvocationOnMock invocation) {
                SparkPod originalPod = (SparkPod)invocation.getArgumentAt(0, SparkPod.class);
                Pod configuredPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(originalPod.pod()).editOrNewMetadata().addToLabels(this.stepType$1, this.stepType$1)).endMetadata()).build();
                return new SparkPod(configuredPod, originalPod.container());
            }
            {
                this.stepType$1 = stepType$1;
            }
        });
        return var3_3;
    }

    public <T extends KubernetesFeatureConfigStep> Seq<HasMetadata> getSecretsForStepType(String stepType) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(stepType)).endMetadata()).build()}));
    }

    public boolean containerHasEnvVar(Container container, String envVarName) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(container.getEnv()).asScala()).exists((Function1)new Serializable(envVarName){
            public static final long serialVersionUID = 0L;
            private final String envVarName$1;

            public final boolean apply(EnvVar envVar) {
                String string = envVar.getName();
                String string2 = this.envVarName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.envVarName$1 = envVarName$1;
            }
        });
    }

    private KubernetesFeaturesTestUtils$() {
        MODULE$ = this;
    }
}

