/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocatorSuite$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001=\u0011!$\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'oU;ji\u0016T!a\u0001\u0003\u0002\u0007-D4O\u0003\u0002\u0006\r\u000591\r\\;ti\u0016\u0014(BA\u0004\t\u0003%\u00198\r[3ek2,'O\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e1\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%A\u0007ee&4XM\u001d)pI:\u000bW.Z\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw\r\u0003\u0004,\u0001\u0001\u0006IAI\u0001\u000fIJLg/\u001a:Q_\u0012t\u0015-\\3!\u0011\u001di\u0003A1A\u0005\n9\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0003=\u0002\"\u0001M\u001e\u000e\u0003ER!AM\u001a\u0002\u000b5|G-\u001a7\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001\u001d:\u0003\u001d1\u0017M\u0019:jGbR\u0011AO\u0001\u0003S>L!\u0001P\u0019\u0003\u0007A{G\r\u0003\u0004?\u0001\u0001\u0006IaL\u0001\u000bIJLg/\u001a:Q_\u0012\u0004\u0003b\u0002!\u0001\u0005\u0004%I!Q\u0001\u0005G>tg-F\u0001C!\t\t2)\u0003\u0002E\u0011\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\"\u0002\u000b\r|gN\u001a\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u00131!\u00138u\u0011\u0019\t\u0006\u0001)A\u0005\u0015\u0006\u0011\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3!\u0011\u001d\u0019\u0006A1A\u0005\nQ\u000b!\u0003]8e\u00032dwnY1uS>tG)\u001a7bsV\tQ\u000b\u0005\u0002L-&\u0011q\u000b\u0014\u0002\u0005\u0019>tw\r\u0003\u0004Z\u0001\u0001\u0006I!V\u0001\u0014a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u0017\u0010\t\u0005\b7\u0002\u0011\r\u0011\"\u0003U\u0003I\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;\t\ru\u0003\u0001\u0015!\u0003V\u0003M\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;!\u0011%y\u0006\u00011AA\u0002\u0013%\u0001-\u0001\rxC&$hi\u001c:Fq\u0016\u001cW\u000f^8s!>$7o\u00117pG.,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\"\tA!\u001e;jY&\u0011am\u0019\u0002\f\u001b\u0006tW/\u00197DY>\u001c7\u000eC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\u0006ar/Y5u\r>\u0014X\t_3dkR|'\u000fU8eg\u000ecwnY6`I\u0015\fHC\u00016n!\tY5.\u0003\u0002m\u0019\n!QK\\5u\u0011\u001dqw-!AA\u0002\u0005\f1\u0001\u001f\u00132\u0011\u0019\u0001\b\u0001)Q\u0005C\u0006Ir/Y5u\r>\u0014X\t_3dkR|'\u000fU8eg\u000ecwnY6!\u0011%\u0011\b\u00011AA\u0002\u0013%1/\u0001\tlk\n,'O\\3uKN\u001cE.[3oiV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002xk\u000511\r\\5f]RL!!\u001f<\u0003!-+(-\u001a:oKR,7o\u00117jK:$\b\"C>\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u0003QYWOY3s]\u0016$Xm]\"mS\u0016tGo\u0018\u0013fcR\u0011!. \u0005\b]j\f\t\u00111\u0001u\u0011\u0019y\b\u0001)Q\u0005i\u0006\t2.\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0011)\u0007y\f\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001D\u0001\b[>\u001c7.\u001b;p\u0013\u0011\ti!a\u0002\u0003\t5{7m\u001b\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"A\u0007q_\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003+\u0001B!a\u0006\u0002>9!\u0011\u0011DA\u001c\u001d\u0011\tY\"a\r\u000f\t\u0005u\u0011q\u0006\b\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005-b\u0002BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001db\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I1!!\r\t\u0003\u0019!W\r\u001d7ps&\u00191!!\u000e\u000b\u0007\u0005E\u0002\"\u0003\u0003\u0002:\u0005m\u0012A\u0004$bEJL7\rO!mS\u0006\u001cXm\u001d\u0006\u0004\u0007\u0005U\u0012\u0002BA \u0003\u0003\u0012A\u0001U(E'*!\u0011\u0011HA\u001e\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002k\u0003\u0013B\u0011B\\A\"\u0003\u0003\u0005\r!!\u0006\t\u0011\u00055\u0003\u0001)Q\u0005\u0003+\ta\u0002]8e\u001fB,'/\u0019;j_:\u001c\b\u0005\u000b\u0003\u0002L\u0005\r\u0001bCA*\u0001\u0001\u0007\t\u0019!C\u0005\u0003+\n1\u0002\\1cK2,G\rU8egV\u0011\u0011q\u000b\t\u0005\u0003/\tI&\u0003\u0003\u0002\\\u0005\u0005#\u0001\u0004'B\u0005\u0016cU\tR0Q\u001f\u0012\u001b\u0006bCA0\u0001\u0001\u0007\t\u0019!C\u0005\u0003C\nq\u0002\\1cK2,G\rU8eg~#S-\u001d\u000b\u0004U\u0006\r\u0004\"\u00038\u0002^\u0005\u0005\t\u0019AA,\u0011!\t9\u0007\u0001Q!\n\u0005]\u0013\u0001\u00047bE\u0016dW\r\u001a)pIN\u0004\u0003\u0006BA3\u0003\u0007A1\"!\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p\u0005\u0019BM]5wKJ\u0004v\u000eZ(qKJ\fG/[8ogV\u0011\u0011\u0011\u000f\t\b\u0003g\nIhLA?\u001b\t\t)HC\u0002\u0002xY\f1\u0001Z:m\u0013\u0011\tY(!\u001e\u0003\u0017A{GMU3t_V\u00148-\u001a\t\u0004a\u0005}\u0014bAAAc\tYAi\u001c8fC\ndW\rU8e\u0011-\t)\t\u0001a\u0001\u0002\u0004%I!a\"\u0002/\u0011\u0014\u0018N^3s!>$w\n]3sCRLwN\\:`I\u0015\fHc\u00016\u0002\n\"Ia.a!\u0002\u0002\u0003\u0007\u0011\u0011\u000f\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002r\u0005!BM]5wKJ\u0004v\u000eZ(qKJ\fG/[8og\u0002BC!a#\u0002\u0004!Y\u00111\u0013\u0001A\u0002\u0003\u0007I\u0011BAK\u0003=)\u00070Z2vi>\u0014()^5mI\u0016\u0014XCAAL!\rq\u0012\u0011T\u0005\u0004\u00037\u0013!!G&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u0014U/\u001b7eKJD1\"a(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"\u0006\u0019R\r_3dkR|'OQ;jY\u0012,'o\u0018\u0013fcR\u0019!.a)\t\u00139\fi*!AA\u0002\u0005]\u0005\u0002CAT\u0001\u0001\u0006K!a&\u0002!\u0015DXmY;u_J\u0014U/\u001b7eKJ\u0004\u0003\u0006BAS\u0003\u0007A1\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\u0006q1O\\1qg\"|Go]*u_J,WCAAY!\rq\u00121W\u0005\u0004\u0003k\u0013!a\n#fi\u0016\u0014X.\u001b8jgRL7-\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016D1\"!/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\u0006\u00112O\\1qg\"|Go]*u_J,w\fJ3r)\rQ\u0017Q\u0018\u0005\n]\u0006]\u0016\u0011!a\u0001\u0003cC\u0001\"!1\u0001A\u0003&\u0011\u0011W\u0001\u0010g:\f\u0007o\u001d5piN\u001cFo\u001c:fA!Y\u0011Q\u0019\u0001A\u0002\u0003\u0007I\u0011BAd\u0003Y\u0001x\u000eZ:BY2|7-\u0019;peVsG-\u001a:UKN$XCAAe!\rq\u00121Z\u0005\u0004\u0003\u001b\u0014!!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN\u001d\u0005\f\u0003#\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019.\u0001\u000eq_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]+oI\u0016\u0014H+Z:u?\u0012*\u0017\u000fF\u0002k\u0003+D\u0011B\\Ah\u0003\u0003\u0005\r!!3\t\u0011\u0005e\u0007\u0001)Q\u0005\u0003\u0013\fq\u0003]8eg\u0006cGn\\2bi>\u0014XK\u001c3feR+7\u000f\u001e\u0011\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\u0006\tR\r_3dkR|'\u000fU8e\u0003:\u001cx/\u001a:\u0015\u0005\u0005\u0005\bCBAr\u0003S\fi/\u0004\u0002\u0002f*!\u0011q]A\u0004\u0003!\u0019H/\u001e2cS:<\u0017\u0002BAv\u0003K\u0014a!\u00118to\u0016\u0014\b\u0003BAx\u0003cl!!a\u000f\n\t\u0005M\u00181\b\u0002\t'B\f'o\u001b)pI\"9\u0011q\u001f\u0001\u0005\n\u0005e\u0018aH6vE\u0016\u0014h.\u001a;fg\u000e{gNZ,ji\"\u001cuN\u001d:fGR4\u0015.\u001a7egR\u0011\u00111 \t\u0007\u0003_\fiP!\u0001\n\t\u0005}\u00181\b\u0002\u000f\u0017V\u0014WM\u001d8fi\u0016\u001c8i\u001c8g!\u0011\tyOa\u0001\n\t\t\u0015\u00111\b\u0002\u001f\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'o\u00159fG&4\u0017nY\"p]\u001a\u0004")
public class ExecutorPodsAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName;
    private final Pod org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod;
    private final SparkConf org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf;
    private final int org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize;
    private final long podAllocationDelay;
    private final long org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podCreationTimeout;
    private ManualClock org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock;
    @Mock
    private KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods;
    @Mock
    private PodResource<Pod, DoneablePod> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations;
    @Mock
    private KubernetesExecutorBuilder org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder;
    private DeterministicExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore;
    private ExecutorPodsAllocator org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName;
    }

    public Pod org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod;
    }

    public SparkConf org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf;
    }

    public int org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    public long org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podCreationTimeout() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podCreationTimeout;
    }

    public ManualClock org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock_$eq(ManualClock x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock = x$1;
    }

    public KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient_$eq(KubernetesClient x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient = x$1;
    }

    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations = x$1;
    }

    public FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods = x$1;
    }

    public PodResource<Pod, DoneablePod> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations = x$1;
    }

    public KubernetesExecutorBuilder org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder = x$1;
    }

    public DeterministicExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore = x$1;
    }

    public ExecutorPodsAllocator org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest_$eq(ExecutorPodsAllocator x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest = x$1;
    }

    public Answer<SparkPod> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorPodAnswer() {
        return new Answer<SparkPod>(this){

            public SparkPod answer(InvocationOnMock invocation) {
                KubernetesConf k8sConf = (KubernetesConf)invocation.getArgumentAt(0, KubernetesConf.class);
                return ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(new StringOps(Predef$.MODULE$.augmentString(((KubernetesExecutorSpecificConf)k8sConf.roleSpecificConf()).executorId())).toInt());
            }
        };
    }

    public KubernetesConf<KubernetesExecutorSpecificConf> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesConfWithCorrectFields() {
        return (KubernetesConf)Matchers.argThat((Matcher)new ArgumentMatcher<KubernetesConf<KubernetesExecutorSpecificConf>>(this){
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean matches(Object argument) {
                if (!(argument instanceof KubernetesConf)) return false;
                KubernetesConf k8sConf = (KubernetesConf)argument;
                KubernetesExecutorSpecificConf executorSpecificConf = (KubernetesExecutorSpecificConf)k8sConf.roleSpecificConf();
                KubernetesConf expectedK8sConf = KubernetesConf$.MODULE$.createExecutorConf(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf(), executorSpecificConf.executorId(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), (Option)new Some((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod()));
                String x$1 = "";
                SparkConf x$2 = k8sConf.copy$default$1();
                KubernetesExecutorSpecificConf x$3 = (KubernetesExecutorSpecificConf)k8sConf.copy$default$2();
                String x$4 = k8sConf.copy$default$4();
                Map x$5 = k8sConf.copy$default$5();
                Map x$6 = k8sConf.copy$default$6();
                Map x$7 = k8sConf.copy$default$7();
                Map x$8 = k8sConf.copy$default$8();
                Map x$9 = k8sConf.copy$default$9();
                Iterable x$10 = k8sConf.copy$default$10();
                Seq x$11 = k8sConf.copy$default$11();
                KubernetesConf qual$1 = k8sConf.copy(x$2, (KubernetesRoleSpecificConf)x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
                SparkConf x$12 = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf();
                KubernetesExecutorSpecificConf x$13 = (KubernetesExecutorSpecificConf)qual$1.copy$default$2();
                String x$14 = qual$1.copy$default$3();
                String x$15 = qual$1.copy$default$4();
                Map x$16 = qual$1.copy$default$5();
                Map x$17 = qual$1.copy$default$6();
                Map x$18 = qual$1.copy$default$7();
                Map x$19 = qual$1.copy$default$8();
                Map x$20 = qual$1.copy$default$9();
                Iterable x$21 = qual$1.copy$default$10();
                Seq x$22 = qual$1.copy$default$11();
                KubernetesConf k8sConfCopy = qual$1.copy(x$12, (KubernetesRoleSpecificConf)x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
                String x$23 = "";
                SparkConf x$24 = expectedK8sConf.copy$default$1();
                KubernetesExecutorSpecificConf x$25 = (KubernetesExecutorSpecificConf)expectedK8sConf.copy$default$2();
                String x$26 = expectedK8sConf.copy$default$4();
                Map x$27 = expectedK8sConf.copy$default$5();
                Map x$28 = expectedK8sConf.copy$default$6();
                Map x$29 = expectedK8sConf.copy$default$7();
                Map x$30 = expectedK8sConf.copy$default$8();
                Map x$31 = expectedK8sConf.copy$default$9();
                Iterable x$32 = expectedK8sConf.copy$default$10();
                Seq x$33 = expectedK8sConf.copy$default$11();
                KubernetesConf qual$2 = expectedK8sConf.copy(x$24, (KubernetesRoleSpecificConf)x$25, x$23, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33);
                SparkConf x$34 = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf();
                KubernetesExecutorSpecificConf x$35 = (KubernetesExecutorSpecificConf)qual$2.copy$default$2();
                String x$36 = qual$2.copy$default$3();
                String x$37 = qual$2.copy$default$4();
                Map x$38 = qual$2.copy$default$5();
                Map x$39 = qual$2.copy$default$6();
                Map x$40 = qual$2.copy$default$7();
                Map x$41 = qual$2.copy$default$8();
                Map x$42 = qual$2.copy$default$9();
                Iterable x$43 = qual$2.copy$default$10();
                Seq x$44 = qual$2.copy$default$11();
                KubernetesConf expectedK8sConfCopy = qual$2.copy(x$34, (KubernetesRoleSpecificConf)x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
                Map map = Predef$.MODULE$.refArrayOps((Object[])k8sConf.sparkConf().getAll()).toMap(Predef$.MODULE$.$conforms());
                Map map2 = Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf().getAll()).toMap(Predef$.MODULE$.$conforms());
                if (map == null) {
                    if (map2 != null) {
                        return false;
                    }
                } else if (!map.equals(map2)) return false;
                KubernetesConf kubernetesConf = k8sConfCopy;
                KubernetesConf kubernetesConf2 = expectedK8sConfCopy;
                if (kubernetesConf == null) {
                    if (kubernetesConf2 == null) return true;
                    return false;
                } else {
                    if (!kubernetesConf.equals(kubernetesConf2)) return false;
                    return true;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public ExecutorPodsAllocatorSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName = "driver";
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName());
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize = BoxesRunTime.unboxToInt((Object)this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient().pods()).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations().withName(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodName())).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPodOperations().get()).thenReturn((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$driverPod());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder().buildFromFeatures(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesConfWithCorrectFields())).thenAnswer(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorPodAnswer());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock_$eq(new ManualClock(0L));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$conf(), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$executorBuilder(), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$kubernetesClient(), (ExecutorPodsSnapshotsStore)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore(), (Clock)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("Initially request executors in batches. Do not request another batch if the first has not finished.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            public final Pod apply() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest().setTotalExpectedExecutors(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Pod apply(int nextId) {
                        return (Pod)((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(nextId)});
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return (Pod)((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations(), (VerificationMode)Mockito.never())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1)});
            }

            public /* synthetic */ ExecutorPodsAllocatorSuite org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Request executors in batches. Allow another batch to be requested if all pending executors start running.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            public final Pod apply() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest().setTotalExpectedExecutors(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize()).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(int execId) {
                        this.apply$mcVI$sp(execId);
                    }

                    public void apply$mcVI$sp(int execId) {
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                ((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations(), (VerificationMode)Mockito.never())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1)});
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                ((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1)});
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                return (Pod)((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations(), (VerificationMode)Mockito.times((int)(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1)))).create((Object[])new Pod[]{(Pod)Matchers.any(Pod.class)});
            }

            public /* synthetic */ ExecutorPodsAllocatorSuite org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("When a current batch reaches error states immediately, re-request them on the next batch.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            public final Pod apply() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest().setTotalExpectedExecutors(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize()).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(int execId) {
                        this.apply$mcVI$sp(execId);
                    }

                    public void apply$mcVI$sp(int execId) {
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().updatePod(failedPod);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                return (Pod)((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podAllocationSize() + 1)});
            }

            public /* synthetic */ ExecutorPodsAllocatorSuite org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("When an executor is requested but the API does not report it in a reasonable time, retry requesting that executor.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsAllocatorSuite $outer;

            public final Pod apply() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podsAllocatorUnderTest().setTotalExpectedExecutors(1);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$waitForExecutorPodsClock().setTime(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podCreationTimeout() + 1L);
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations().withLabel(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), "1")).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$snapshotsStore().notifySubscribers();
                ((Deletable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$labeledPods())).delete();
                return (Pod)((Createable)Mockito.verify(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsAllocatorSuite$$podOperations())).create((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L)});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

