/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001=\u0011\u0011%\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'oU;ji\u0016T!a\u0001\u0003\u0002\u0007-D4O\u0003\u0002\u0006\r\u000591\r\\;ti\u0016\u0014(BA\u0004\t\u0003%\u00198\r[3ek2,'O\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e1\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tA\u0011\u0002\t\u0001A\u0002\u0003\u0007I\u0011B\u0011\u0002#9\fW.\u001a3Fq\u0016\u001cW\u000f^8s!>$7/F\u0001#!\u0011\u0019#\u0006\f\u001b\u000e\u0003\u0011R!!\n\u0014\u0002\u000f5,H/\u00192mK*\u0011q\u0005K\u0001\u000bG>dG.Z2uS>t'\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-\"#aA'baB\u0011Q&\r\b\u0003]=j\u0011\u0001K\u0005\u0003a!\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001\u0007\u000b\t\u0005k\u0001\u0013%*D\u00017\u0015\t9\u0004(A\u0002eg2T!!\u000f\u001e\u0002\r\rd\u0017.\u001a8u\u0015\tYD(\u0001\u0006lk\n,'O\\3uKNT!!\u0010 \u0002\u000f\u0019\f'M]5dq)\tq(\u0001\u0002j_&\u0011\u0011I\u000e\u0002\f!>$'+Z:pkJ\u001cW\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006)Qn\u001c3fY*\u0011qIO\u0001\u0004CBL\u0017BA%E\u0005\r\u0001v\u000e\u001a\t\u0003\u0007.K!\u0001\u0014#\u0003\u0017\u0011{g.Z1cY\u0016\u0004v\u000e\u001a\u0005\n\u001d\u0002\u0001\r\u00111A\u0005\n=\u000bQC\\1nK\u0012,\u00050Z2vi>\u0014\bk\u001c3t?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011a&U\u0005\u0003%\"\u0012A!\u00168ji\"9A+TA\u0001\u0002\u0004\u0011\u0013a\u0001=%c!1a\u000b\u0001Q!\n\t\n!C\\1nK\u0012,\u00050Z2vi>\u0014\bk\u001c3tA!I\u0001\f\u0001a\u0001\u0002\u0004%I!W\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\u0012A\u0017\t\u00037rk\u0011\u0001O\u0005\u0003;b\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0017\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002QC\"9AKXA\u0001\u0002\u0004Q\u0006BB2\u0001A\u0003&!,A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B#AY3\u0011\u0005\u0019LW\"A4\u000b\u0005!d\u0011aB7pG.LGo\\\u0005\u0003U\u001e\u0014A!T8dW\"IA\u000e\u0001a\u0001\u0002\u0004%I!\\\u0001\u000ea>$w\n]3sCRLwN\\:\u0016\u00039\u00042a\\A\u0003\u001d\t\u0001xP\u0004\u0002r{:\u0011!o\u001f\b\u0003gjt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]t\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011A\u0010C\u0001\u0007I\u0016\u0004Hn\\=\n\u0005\rq(B\u0001?\t\u0013\u0011\t\t!a\u0001\u0002\u001d\u0019\u000b'M]5dq\u0005c\u0017.Y:fg*\u00111A`\u0005\u0005\u0003\u000f\tIA\u0001\u0003Q\u001f\u0012\u001b&\u0002BA\u0001\u0003\u0007A1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010\u0005\t\u0002o\u001c3Pa\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0007A\u000b\t\u0002\u0003\u0005U\u0003\u0017\t\t\u00111\u0001o\u0011\u001d\t)\u0002\u0001Q!\n9\fa\u0002]8e\u001fB,'/\u0019;j_:\u001c\b\u0005K\u0002\u0002\u0014\u0015D1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e\u0005yQ\r_3dkR|'OQ;jY\u0012,'/\u0006\u0002\u0002 A\u0019a$!\t\n\u0007\u0005\r\"AA\rLk\n,'O\\3uKN,\u00050Z2vi>\u0014()^5mI\u0016\u0014\bbCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003S\t1#\u001a=fGV$xN\u001d\"vS2$WM]0%KF$2\u0001UA\u0016\u0011%!\u0016QEA\u0001\u0002\u0004\ty\u0002\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u0010\u0003A)\u00070Z2vi>\u0014()^5mI\u0016\u0014\b\u0005K\u0002\u0002.\u0015D1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028\u0005\u00012o\u00195fIVdWM\u001d\"bG.,g\u000eZ\u000b\u0003\u0003s\u00012AHA\u001e\u0013\r\tiD\u0001\u0002\"\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019%\u0001\u000btG\",G-\u001e7fe\n\u000b7m[3oI~#S-\u001d\u000b\u0004!\u0006\u0015\u0003\"\u0003+\u0002@\u0005\u0005\t\u0019AA\u001d\u0011!\tI\u0005\u0001Q!\n\u0005e\u0012!E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8eA!\u001a\u0011qI3\t\u0017\u0005=\u0003\u00011AA\u0002\u0013%\u0011\u0011K\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f+\t\t\u0019\u0006E\u0002\u001f\u0003+J1!a\u0016\u0003\u0005\u001d\"U\r^3s[&t\u0017n\u001d;jG\u0016CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011QL\u0001\u0013g:\f\u0007o\u001d5piN\u001cFo\u001c:f?\u0012*\u0017\u000fF\u0002Q\u0003?B\u0011\u0002VA-\u0003\u0003\u0005\r!a\u0015\t\u0011\u0005\r\u0004\u0001)Q\u0005\u0003'\nqb\u001d8baNDw\u000e^:Ti>\u0014X\r\t\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0013\tI'A\u000bfm\u0016tG\u000fS1oI2,'/\u00168eKJ$Vm\u001d;\u0016\u0005\u0005-\u0004c\u0001\u0010\u0002n%\u0019\u0011q\u000e\u0002\u00039\u0015CXmY;u_J\u0004v\u000eZ:MS\u001a,7-_2mK6\u000bg.Y4fe\"Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011BA;\u0003e)g/\u001a8u\u0011\u0006tG\r\\3s+:$WM\u001d+fgR|F%Z9\u0015\u0007A\u000b9\bC\u0005U\u0003c\n\t\u00111\u0001\u0002l!A\u00111\u0010\u0001!B\u0013\tY'\u0001\ffm\u0016tG\u000fS1oI2,'/\u00168eKJ$Vm\u001d;!\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u000b\u0011#\u001a=jiJ+\u0017m]8o\u001b\u0016\u001c8/Y4f)\u0015a\u00131QAG\u0011!\t))! A\u0002\u0005\u001d\u0015\u0001\u00054bS2,G-\u0012=fGV$xN]%e!\rq\u0013\u0011R\u0005\u0004\u0003\u0017C#aA%oi\"9\u0011qRA?\u0001\u0004\u0011\u0015!\u00034bS2,G\rU8e\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+\u000bqB\\1nK\u0012\u0004v\u000eZ:B]N<XM\u001d\u000b\u0003\u0003/\u0003R!!'\u0002 Rj!!a'\u000b\u0007\u0005uu-\u0001\u0005tiV\u0014'-\u001b8h\u0013\u0011\t\t+a'\u0003\r\u0005s7o^3s\u0001")
public class ExecutorPodsLifecycleManagerSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private Map<String, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods;
    @Mock
    private KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations;
    @Mock
    private KubernetesExecutorBuilder org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder;
    @Mock
    private KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore;
    private ExecutorPodsLifecycleManager org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public Map<String, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods_$eq(Map<String, PodResource<Pod, DoneablePod>> x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods = x$1;
    }

    public KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient_$eq(KubernetesClient x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient = x$1;
    }

    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations = x$1;
    }

    public KubernetesExecutorBuilder org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder = x$1;
    }

    public KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend;
    }

    private void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend = x$1;
    }

    public DeterministicExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore = x$1;
    }

    public ExecutorPodsLifecycleManager org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest_$eq(ExecutorPodsLifecycleManager x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest = x$1;
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$exitReasonMessage(int failedExecutorId, Pod failedPod) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |The executor with id ", " exited with exit code 1.\n       |The API gave the following brief reason: ", "\n       |The API gave the following message: ", "\n       |The API gave the following container statuses:\n       |\n       |", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)failedExecutorId), failedPod.getStatus().getReason(), failedPod.getStatus().getMessage(), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(failedPod.getStatus().getContainerStatuses()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ContainerStatus x$1) {
                return x$1.toString();
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("\n===\n")})))).stripMargin();
    }

    public Answer<PodResource<Pod, DoneablePod>> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedPodsAnswer() {
        return new Answer<PodResource<Pod, DoneablePod>>(this){
            private final /* synthetic */ ExecutorPodsLifecycleManagerSuite $outer;

            public PodResource<Pod, DoneablePod> answer(InvocationOnMock invocation) {
                String podName = (String)invocation.getArgumentAt(0, String.class);
                return (PodResource)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods().getOrElseUpdate((Object)podName, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PodResource<Pod, DoneablePod> apply() {
                        return (PodResource)Mockito.mock(PodResource.class);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public ExecutorPodsLifecycleManagerSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                Cache removedExecutorsCache = CacheBuilder.newBuilder().build();
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods_$eq((Map<String, PodResource<Pod, DoneablePod>>)Map$.MODULE$.empty());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.empty());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient().pods()).thenReturn(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$podOperations().withName((String)Matchers.any(String.class))).thenAnswer(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedPodsAnswer());
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest_$eq(new ExecutorPodsLifecycleManager(new SparkConf(), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$executorBuilder(), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$kubernetesClient(), (ExecutorPodsSnapshotsStore)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore(), removedExecutorsCache));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$eventHandlerUnderTest().start(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("When an executor reaches error states immediately, remove from the scheduler backend.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManagerSuite $outer;

            public final Boolean apply() {
                Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().updatePod(failedPod);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().notifySubscribers();
                String msg = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$exitReasonMessage(1, failedPod);
                ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
                ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
                return (Boolean)((Deletable)Mockito.verify((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Don't remove executors twice from Spark but remove from K8s repeatedly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManagerSuite $outer;

            public final Boolean apply() {
                Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().updatePod(failedPod);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().updatePod(failedPod);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().notifySubscribers();
                String msg = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$exitReasonMessage(1, failedPod);
                ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
                ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend(), (VerificationMode)Mockito.times((int)1))).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
                return (Boolean)((Deletable)Mockito.verify((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.times((int)2))).delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("When the scheduler backend lists executor ids that aren't present in the cluster, remove those executors from Spark.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"})));
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The executor with ID 1 was not found in the cluster but we didn't"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" get a reason why. Marking the executor as failed. The executor may have been"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" deleted but the driver missed the deletion event."})).s((Seq)Nil$.MODULE$)).toString();
                ExecutorExited expectedLossReason = new ExecutorExited(-1, false, msg);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$snapshotsStore().notifySubscribers();
                ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManagerSuite$$schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }
}

