/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!\u0002\u0011\"\u0001\u001dj\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000f\u0015\u0003!\u0019!C\u0005\r\"1Q\u000b\u0001Q\u0001\n\u001dCqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004Y\u0001\u0001\u0006IA\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019q\u0006\u0001)A\u00057\"9q\f\u0001b\u0001\n\u00139\u0006B\u00021\u0001A\u0003%!\nC\u0004b\u0001\t\u0007I\u0011B,\t\r\t\u0004\u0001\u0015!\u0003K\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da\u0001\u001b\u0001!\u0002\u0013)\u0007bB5\u0001\u0005\u0004%Ia\u0016\u0005\u0007U\u0002\u0001\u000b\u0011\u0002&\t\u000f-\u0004!\u0019!C\u0005I\"1A\u000e\u0001Q\u0001\n\u0015Dq!\u001c\u0001C\u0002\u0013%A\r\u0003\u0004o\u0001\u0001\u0006I!\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0003e\u0011\u0019\u0001\b\u0001)A\u0005K\"9\u0011\u000f\u0001b\u0001\n\u0013Q\u0006B\u0002:\u0001A\u0003%1\fC\u0004t\u0001\t\u0007I\u0011B,\t\rQ\u0004\u0001\u0015!\u0003K\u0011\u001d)\bA1A\u0005\n\u0019CaA\u001e\u0001!\u0002\u00139\u0005\"B<\u0001\t\u0003B\b\"\u0002@\u0001\t\u0003z\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0002\u0019\u0005\u0006\u001c\u0018nY#yK\u000e,Ho\u001c:GK\u0006$XO]3Ti\u0016\u0004(B\u0001\u0012$\u0003!1W-\u0019;ve\u0016\u001c(B\u0001\u0013&\u0003\rY\u0007h\u001d\u0006\u0003M\u001d\na\u0001Z3qY>L(B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kYj\u0011!I\u0005\u0003o\u0005\u00121dS;cKJtW\r^3t\r\u0016\fG/\u001e:f\u0007>tg-[4Ti\u0016\u0004\u0018AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0002\u0001!\rYDHP\u0007\u0002G%\u0011Qh\t\u0002\u000f\u0017V\u0014WM\u001d8fi\u0016\u001c8i\u001c8g!\tYt(\u0003\u0002AG\tq2*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s'B,7-\u001b4jG\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r#\u0005CA\u001b\u0001\u0011\u0015A$\u00011\u0001;\u0003Y)\u00070Z2vi>\u0014X\t\u001f;sC\u000ec\u0017m]:qCRDW#A$\u0011\u0007=B%*\u0003\u0002Ja\t1q\n\u001d;j_:\u0004\"a\u0013*\u000f\u00051\u0003\u0006CA'1\u001b\u0005q%BA(:\u0003\u0019a$o\\8u}%\u0011\u0011\u000bM\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002Ra\u00059R\r_3dkR|'/\u0012=ue\u0006\u001cE.Y:ta\u0006$\b\u000eI\u0001\u0017Kb,7-\u001e;pe\u000e{g\u000e^1j]\u0016\u0014\u0018*\\1hKV\t!*A\ffq\u0016\u001cW\u000f^8s\u0007>tG/Y5oKJLU.Y4fA\u0005\u0001\"\r\\8dW6\u000bg.Y4feB{'\u000f^\u000b\u00027B\u0011q\u0006X\u0005\u0003;B\u00121!\u00138u\u0003E\u0011Gn\\2l\u001b\u0006t\u0017mZ3s!>\u0014H\u000fI\u0001\u0016Kb,7-\u001e;peB{GMT1nKB\u0013XMZ5y\u0003Y)\u00070Z2vi>\u0014\bk\u001c3OC6,\u0007K]3gSb\u0004\u0013!\u00033sSZ,'/\u0016:m\u0003)!'/\u001b<feV\u0013H\u000eI\u0001\u0012Kb,7-\u001e;pe6+Wn\u001c:z\u001b&\u0014U#A3\u0011\u0005=2\u0017BA41\u0005\u0011auN\\4\u0002%\u0015DXmY;u_JlU-\\8ss6K'\tI\u0001\u0015Kb,7-\u001e;pe6+Wn\u001c:z'R\u0014\u0018N\\4\u0002+\u0015DXmY;u_JlU-\\8ssN#(/\u001b8hA\u0005\tR.Z7pef|e/\u001a:iK\u0006$W*\u001b\"\u0002%5,Wn\u001c:z\u001fZ,'\u000f[3bI6K'\tI\u0001\u001bKb,7-\u001e;pe6+Wn\u001c:z/&$\bn\u0014<fe\",\u0017\rZ\u0001\u001cKb,7-\u001e;pe6+Wn\u001c:z/&$\bn\u0014<fe\",\u0017\r\u001a\u0011\u0002'\u0015DXmY;u_JlU-\\8ssR{G/\u00197\u0002)\u0015DXmY;u_JlU-\\8ssR{G/\u00197!\u00035)\u00070Z2vi>\u00148i\u001c:fg\u0006qQ\r_3dkR|'oQ8sKN\u0004\u0013\u0001F3yK\u000e,Ho\u001c:D_J,7OU3rk\u0016\u001cH/A\u000bfq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d*fcV,7\u000f\u001e\u0011\u0002%\u0015DXmY;u_Jd\u0015.\\5u\u0007>\u0014Xm]\u0001\u0014Kb,7-\u001e;pe2KW.\u001b;D_J,7\u000fI\u0001\rG>tg-[4ve\u0016\u0004v\u000e\u001a\u000b\u0003sr\u0004\"a\u000f>\n\u0005m\u001c#\u0001C*qCJ\\\u0007k\u001c3\t\u000bul\u0002\u0019A=\u0002\u0007A|G-\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\u001c)pINK8\u000f^3n!J|\u0007/\u001a:uS\u0016\u001cHCAA\u0001!\u0015Y\u00151\u0001&K\u0013\r\t)\u0001\u0016\u0002\u0004\u001b\u0006\u0004\u0018\u0001I4fi\u0006#G-\u001b;j_:\fGnS;cKJtW\r^3t%\u0016\u001cx.\u001e:dKN$\"!a\u0003\u0011\r\u00055\u0011qCA\u000f\u001d\u0011\ty!a\u0005\u000f\u00075\u000b\t\"C\u00012\u0013\r\t)\u0002M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI\"a\u0007\u0003\u0007M+\u0017OC\u0002\u0002\u0016A\u0002B!a\b\u000265\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0003n_\u0012,GN\u0003\u0003\u0002(\u0005%\u0012aA1qS*!\u00111FA\u0017\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0005\u0003_\t\t$A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0005\u0005M\u0012AA5p\u0013\u0011\t9$!\t\u0003\u0017!\u000b7/T3uC\u0012\fG/\u0019")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesExecutorSpecificConf> kubernetesConf;
    private final Option<String> executorExtraClasspath;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final long executorMemoryMiB;
    private final String executorMemoryString;
    private final long memoryOverheadMiB;
    private final long executorMemoryWithOverhead;
    private final long executorMemoryTotal;
    private final int executorCores;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;

    private Option<String> executorExtraClasspath() {
        return this.executorExtraClasspath;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private long executorMemoryMiB() {
        return this.executorMemoryMiB;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long executorMemoryWithOverhead() {
        return this.executorMemoryWithOverhead;
    }

    private long executorMemoryTotal() {
        return this.executorMemoryTotal;
    }

    private int executorCores() {
        return this.executorCores;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        String name = new StringBuilder(6).append(this.executorPodNamePrefix()).append("-exec-").append(this.kubernetesConf.roleSpecificConf().executorId()).toString();
        String hostname = name.substring(Math.max(0, name.length() - 63));
        Quantity executorMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringBuilder(2).append(this.executorMemoryTotal()).append("Mi").toString())).build();
        Quantity executorCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.executorCoresRequest())).build();
        Option executorExtraClasspathEnv = this.executorExtraClasspath().map((Function1 & Serializable & scala.Serializable)cp -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build());
        Seq executorExtraJavaOptionsEnv = (Seq)((Option)this.kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).map((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.roleSpecificConf().executorId());
            Seq delimitedOpts = Utils$.MODULE$.splitCommandString(subsOpts);
            return (Seq)((TraversableLike)delimitedOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String opt = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(index).toString())).withValue(opt)).build();
                return envVar;
            }, Seq$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq executorEnv = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)this.driverUrl()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.kubernetesConf.appId()), new Tuple2((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR(), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)this.kubernetesConf.roleSpecificConf().executorId())}))).$plus$plus(this.kubernetesConf.roleEnvs(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)executorExtraJavaOptionsEnv, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(executorExtraClasspathEnv).toSeq(), Seq$.MODULE$.canBuildFrom());
        Seq requiredPorts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
            return containerPort;
        }, Seq$.MODULE$.canBuildFrom());
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod2.container()).withName("executor")).withImage(this.executorContainerImage())).withImagePullPolicy(this.kubernetesConf.imagePullPolicy())).withNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity)).endResources()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter(requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container containerWithLimitCores = (Container)this.executorLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> {
            Quantity executorCpuLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build();
            return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainer).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> executorContainer);
        Option<Pod> driverPod = this.kubernetesConf.roleSpecificConf().driverPod();
        Option ownerReference = driverPod.map((Function1 & Serializable & scala.Serializable)pod -> ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build());
        Pod executorPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name).withLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleLabels()).asJava()).withAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleAnnotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy("Never").withNodeSelector((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(executorPod, containerWithLimitCores);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ long $anonfun$executorMemoryTotal$1(BasicExecutorFeatureStep $this, String res) {
        String string = res;
        int n = "python".equals(string) ? BoxesRunTime.unboxToInt((Object)((Option)$this.kubernetesConf.sparkConf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PYSPARK_EXECUTOR_MEMORY())).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$1 -> (int)x$1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) : 0;
        int additionalPySparkMemory = n;
        return $this.executorMemoryWithOverhead() + (long)additionalPySparkMemory;
    }

    public BasicExecutorFeatureStep(KubernetesConf<KubernetesExecutorSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        this.executorExtraClasspath = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH());
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt("spark.blockmanager.port", Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.executorPodNamePrefix = kubernetesConf.appResourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply(kubernetesConf.get("spark.driver.host"), kubernetesConf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.executorMemoryMiB = BoxesRunTime.unboxToLong((Object)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorMemoryString = kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)$this.kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.executorMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.executorMemoryWithOverhead = this.executorMemoryMiB() + this.memoryOverheadMiB();
        this.executorMemoryTotal = BoxesRunTime.unboxToLong((Object)kubernetesConf.sparkConf().getOption(Config$.MODULE$.APP_RESOURCE_TYPE().key()).map((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToLong((long)BasicExecutorFeatureStep.$anonfun$executorMemoryTotal$1(this, res))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.executorMemoryWithOverhead()));
        this.executorCores = kubernetesConf.sparkConf().getInt("spark.executor.cores", 1);
        this.executorCoresRequest = kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : ((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString();
        this.executorLimitCores = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

