/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Properties;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\u0007\u000e\u0001MI\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u00111\u0002!\u0011!Q\u0001\n5B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!)\u0006A!A!\u0002\u00131\u0005\"\u0002,\u0001\t\u00039\u0006\"\u00021\u0001\t\u0003\t\u0007\"B3\u0001\t\u00131\u0007BB@\u0001\t\u0013\t\tA\u0001\u0004DY&,g\u000e\u001e\u0006\u0003\u001d=\taa];c[&$(B\u0001\t\u0012\u0003\rY\u0007h\u001d\u0006\u0003%M\ta\u0001Z3qY>L(B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003GM\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\t\u0012q\u0001T8hO&tw-A\u0004ck&dG-\u001a:\u0004\u0001A\u0011\u0011FK\u0007\u0002\u001b%\u00111&\u0004\u0002\u0018\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0014U/\u001b7eKJ\fab[;cKJtW\r^3t\u0007>tg\rE\u0002/_Ej\u0011aD\u0005\u0003a=\u0011abS;cKJtW\r^3t\u0007>tg\r\u0005\u0002/e%\u00111g\u0004\u0002\u001d\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001c\u0006/Z2jM&\u001c7i\u001c8g\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0005\u00027\u007f5\tqG\u0003\u00029s\u000511\r\\5f]RT!AO\u001e\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002={\u00059a-\u00192sS\u000eD$\"\u0001 \u0002\u0005%|\u0017B\u0001!8\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000bxC&$hi\u001c:BaB\u001cu.\u001c9mKRLwN\u001c\t\u00037\rK!\u0001\u0012\u000f\u0003\u000f\t{w\u000e\\3b]\u00069\u0011\r\u001d9OC6,\u0007CA$O\u001d\tAE\n\u0005\u0002J95\t!J\u0003\u0002LO\u00051AH]8pizJ!!\u0014\u000f\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001br\tqa^1uG\",'\u000f\u0005\u0002*'&\u0011A+\u0004\u0002\u0018\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ\fAd[;cKJtW\r^3t%\u0016\u001cx.\u001e:dK:\u000bW.\u001a)sK\u001aL\u00070\u0001\u0004=S:LGO\u0010\u000b\t1fS6\fX/_?B\u0011\u0011\u0006\u0001\u0005\u0006M!\u0001\r\u0001\u000b\u0005\u0006Y!\u0001\r!\f\u0005\u0006i!\u0001\r!\u000e\u0005\u0006\u0003\"\u0001\rA\u0011\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006+\"\u0001\rAR\u0001\u0004eVtG#\u00012\u0011\u0005m\u0019\u0017B\u00013\u001d\u0005\u0011)f.\u001b;\u0002/\u0005$G\r\u0012:jm\u0016\u0014xj\u001e8feJ+g-\u001a:f]\u000e,Gc\u00012hc\")\u0001N\u0003a\u0001S\u0006IAM]5wKJ\u0004v\u000e\u001a\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fQ!\\8eK2T!A\\\u001d\u0002\u0007\u0005\u0004\u0018.\u0003\u0002qW\n\u0019\u0001k\u001c3\t\u000bIT\u0001\u0019A:\u0002\u0013I,7o\\;sG\u0016\u001c\bc\u0001;zy:\u0011Qo\u001e\b\u0003\u0013ZL\u0011!H\u0005\u0003qr\tq\u0001]1dW\u0006<W-\u0003\u0002{w\n\u00191+Z9\u000b\u0005ad\u0002C\u00016~\u0013\tq8NA\u0006ICNlU\r^1eCR\f\u0017A\u00042vS2$7i\u001c8gS\u001el\u0015\r\u001d\u000b\u0007\u0003\u0007\tI!!\u0004\u0011\u0007)\f)!C\u0002\u0002\b-\u0014\u0011bQ8oM&<W*\u00199\t\r\u0005-1\u00021\u0001G\u00035\u0019wN\u001c4jO6\u000b\u0007OT1nK\"9\u0011qB\u0006A\u0002\u0005E\u0011\u0001B2p]\u001a\u0004RaRA\n\r\u001aK1!!\u0006Q\u0005\ri\u0015\r\u001d")
public class Client
implements Logging {
    private final KubernetesDriverBuilder builder;
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;
    private final KubernetesClient kubernetesClient;
    private final boolean waitForAppCompletion;
    private final String appName;
    private final LoggingPodStatusWatcher watcher;
    private final String kubernetesResourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.kubernetesConf);
        String configMapName = new StringBuilder(16).append(this.kubernetesResourceNamePrefix).append("-driver-conf-map").toString();
        ConfigMap configMap = this.buildConfigMap(configMapName, resolvedDriverSpec.systemProperties());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withNewConfigMap().withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (Watch)((Watchable)$this.kubernetesClient.pods().withName(resolvedDriverPod.getMetadata().getName())).watch((Object)$this.watcher), (Function1 & Serializable & scala.Serializable)x$1 -> {
            Client.$anonfun$run$2(this, resolvedDriverPod, resolvedDriverSpec, configMap, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void addDriverOwnerReference(Pod driverPod, Seq<HasMetadata> resources) {
        OwnerReference driverPodOwnerReference = ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withName(driverPod.getMetadata().getName())).withApiVersion(driverPod.getApiVersion())).withUid(driverPod.getMetadata().getUid())).withKind(driverPod.getKind())).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Client.$anonfun$addDriverOwnerReference$1(driverPodOwnerReference, resource);
            return BoxedUnit.UNIT;
        });
    }

    private ConfigMap buildConfigMap(String configMapName, Map<String, String> conf) {
        Properties properties = new Properties();
        conf.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.setProperty(k, v);
            return object;
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, new StringBuilder(60).append("Java properties built from Kubernetes config map with name: ").append(configMapName).toString());
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), propertiesWriter.toString())).build();
    }

    public static final /* synthetic */ void $anonfun$run$2(Client $this, Pod resolvedDriverPod$1, KubernetesDriverSpec resolvedDriverSpec$1, ConfigMap configMap$1, Watch x$1) {
        Pod createdDriverPod = (Pod)$this.kubernetesClient.pods().create((Object[])new Pod[]{resolvedDriverPod$1});
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec$1.driverKubernetesResources().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{configMap$1})), Seq$.MODULE$.canBuildFrom());
            $this.addDriverOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            $this.kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdDriverPod});
                throw e;
            }
            throw throwable;
        }
        if ($this.waitForAppCompletion) {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Waiting for application ").append($this.appName).append(" to finish...").toString());
            $this.watcher.awaitCompletion();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Application ").append($this.appName).append(" finished.").toString());
        } else {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deployed Spark application ").append($this.appName).append(" into Kubernetes.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$addDriverOwnerReference$1(OwnerReference driverPodOwnerReference$1, HasMetadata resource) {
        ObjectMeta originalMetadata = resource.getMetadata();
        originalMetadata.setOwnerReferences(Collections.singletonList(driverPodOwnerReference$1));
    }

    public Client(KubernetesDriverBuilder builder, KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf, KubernetesClient kubernetesClient, boolean waitForAppCompletion, String appName, LoggingPodStatusWatcher watcher, String kubernetesResourceNamePrefix) {
        this.builder = builder;
        this.kubernetesConf = kubernetesConf;
        this.kubernetesClient = kubernetesClient;
        this.waitForAppCompletion = waitForAppCompletion;
        this.appName = appName;
        this.watcher = watcher;
        this.kubernetesResourceNamePrefix = kubernetesResourceNamePrefix;
        Logging.$init$((Logging)this);
    }
}

