/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue!\u0002\u000f\u001e\u0001\rJ\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0004b\u0001\t\u0007I\u0011\u00022\t\r9\u0004\u0001\u0015!\u0003d\u0011\u001dy\u0007A1A\u0005\nADa\u0001\u001e\u0001!\u0002\u0013\t\bbB;\u0001\u0005\u0004%IA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011\u0011\u0001\u0001!\u0002\u0013i\b\u0002CA\u0002\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005\u0015\u0001\u0001)A\u0005{\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002(!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u00024!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002L!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0005U)\u00050Z2vi>\u0014\bk\u001c3t\u00032dwnY1u_JT!AH\u0010\u0002\u0007-D4O\u0003\u0002!C\u000591\r\\;ti\u0016\u0014(B\u0001\u0012$\u0003%\u00198\r[3ek2,'O\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u001a\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005U\u0012$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005eRT\"A\u0012\n\u0005m\u001a#!C*qCJ\\7i\u001c8g\u0003=)\u00070Z2vi>\u0014()^5mI\u0016\u0014\bC\u0001 @\u001b\u0005i\u0012B\u0001!\u001e\u0005eYUOY3s]\u0016$Xm]#yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0002!-,(-\u001a:oKR,7o\u00117jK:$\bCA\"M\u001b\u0005!%BA#G\u0003\u0019\u0019G.[3oi*\u0011q\tS\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA%K\u0003\u001d1\u0017M\u0019:jGbR\u0011aS\u0001\u0003S>L!!\u0014#\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003}AK!!U\u000f\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\u000b\rdwnY6\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0013\u0001B;uS2L!\u0001W+\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u0019YF,\u00180`AB\u0011a\b\u0001\u0005\u0006m\u0019\u0001\r\u0001\u000f\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006\u001d\u001a\u0001\ra\u0014\u0005\u0006%\u001a\u0001\raU\u0001\u0014\u000bb+5)\u0016+P%~KEiX\"P+:#VIU\u000b\u0002GB\u0011A\r\\\u0007\u0002K*\u0011amZ\u0001\u0007CR|W.[2\u000b\u0005!L\u0017AC2p]\u000e,(O]3oi*\u0011aK\u001b\u0006\u0002W\u0006!!.\u0019<b\u0013\tiWM\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fA#\u0012-F\u0007V#vJU0J\t~\u001bu*\u0016(U\u000bJ\u0003\u0013A\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0016\u0003E\u0004\"\u0001\u001a:\n\u0005M,'!D!u_6L7-\u00138uK\u001e,'/A\fu_R\fG.\u0012=qK\u000e$X\rZ#yK\u000e,Ho\u001c:tA\u0005\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0016\u0003]\u0004\"a\u000b=\n\u0005ed#aA%oi\u0006\u0011\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3!\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]\u0012+G.Y=\u0016\u0003u\u0004\"a\u000b@\n\u0005}d#\u0001\u0002'p]\u001e\f1\u0003]8e\u00032dwnY1uS>tG)\u001a7bs\u0002\n!\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0006\u0019\u0002o\u001c3De\u0016\fG/[8o)&lWm\\;uA\u0005Ia.Y7fgB\f7-Z\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u001c9!\u0011qBA\f!\r\t\t\u0002L\u0007\u0003\u0003'Q1!!\u00068\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0004\u0017\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\rM#(/\u001b8h\u0015\r\tI\u0002L\u0001\u000b]\u0006lWm\u001d9bG\u0016\u0004\u0013aF6vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s!>$g*Y7f+\t\t9\u0003E\u0003,\u0003S\tY!C\u0002\u0002,1\u0012aa\u00149uS>t\u0017\u0001G6vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s!>$g*Y7fA\u0005IAM]5wKJ\u0004v\u000eZ\u000b\u0003\u0003g\u0001RaKA\u0015\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0003n_\u0012,GNC\u0002\u0002@\u0019\u000b1!\u00199j\u0013\u0011\t\u0019%!\u000f\u0003\u0007A{G-\u0001\u0006ee&4XM\u001d)pI\u0002\nQC\\3xYf\u001c%/Z1uK\u0012,\u00050Z2vi>\u00148/\u0006\u0002\u0002LA1\u0011QJA,{vl!!a\u0014\u000b\t\u0005E\u00131K\u0001\b[V$\u0018M\u00197f\u0015\r\t)\u0006L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003\u001f\u00121!T1q\u0003YqWm\u001e7z\u0007J,\u0017\r^3e\u000bb,7-\u001e;peN\u0004\u0013!B:uCJ$H\u0003BA1\u0003O\u00022aKA2\u0013\r\t)\u0007\f\u0002\u0005+:LG\u000fC\u0004\u0002je\u0001\r!a\u0003\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0003e\u0019X\r\u001e+pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0015\t\u0005\u0005\u0014q\u000e\u0005\u0007\u0003cR\u0002\u0019A<\u0002\u000bQ|G/\u00197\u0002\u001d=tg*Z<T]\u0006\u00048\u000f[8ugR1\u0011\u0011MA<\u0003sBq!!\u001b\u001c\u0001\u0004\tY\u0001C\u0004\u0002|m\u0001\r!! \u0002\u0013Mt\u0017\r]:i_R\u001c\bCBA@\u0003\u0013\u000byI\u0004\u0003\u0002\u0002\u0006\u0015e\u0002BA\t\u0003\u0007K\u0011!L\u0005\u0004\u0003\u000fc\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biIA\u0002TKFT1!a\"-!\rq\u0014\u0011S\u0005\u0004\u0003'k\"\u0001F#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|G\u000f")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final AtomicInteger totalExpectedExecutors;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final Option<Pod> driverPod;
    private final Map<Object, Object> newlyCreatedExecutors;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private AtomicInteger totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private Option<Pod> driverPod() {
        return this.driverPod;
    }

    private Map<Object, Object> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    public void start(String applicationId) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(int total) {
        this.totalExpectedExecutors().set(total);
    }

    private void onNewSnapshots(String applicationId, Seq<ExecutorPodsSnapshot> snapshots) {
        block0: {
            int currentPendingExecutors;
            block2: {
                int currentTotalExpectedExecutors;
                int currentRunningExecutors;
                block1: {
                    this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom()));
                    this.newlyCreatedExecutors().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        BoxedUnit boxedUnit;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            long execId = tuple2._1$mcJ$sp();
                            long timeCreated = tuple2._2$mcJ$sp();
                            long currentTime = $this.clock.getTimeMillis();
                            if (currentTime - timeCreated > this.podCreationTimeout()) {
                                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(234).append("Executor with id ").append(execId).append(" was not detected in the Kubernetes").append(" cluster after ").append(this.podCreationTimeout()).append(" milliseconds despite the fact that a").append(" previous allocation attempt tried to create it. The executor may have been").append(" deleted but the application missed the deletion event.").toString());
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabel(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), ((Object)BoxesRunTime.boxToLong((long)execId)).toString())).delete());
                                boxedUnit = this.newlyCreatedExecutors().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                            } else {
                                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return boxedUnit2;
                    });
                    if (!snapshots.nonEmpty()) break block0;
                    ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
                    currentRunningExecutors = latestSnapshot.executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$6(x0$2)));
                    currentPendingExecutors = latestSnapshot.executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$7(x0$3)));
                    currentTotalExpectedExecutors = this.totalExpectedExecutors().get();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(131).append("Currently have ").append(currentRunningExecutors).append(" running executors and").append(" ").append(currentPendingExecutors).append(" pending executors. ").append(this.newlyCreatedExecutors()).append(" executors").append(" have been requested but are pending appearance in the cluster.").toString());
                    if (!this.newlyCreatedExecutors().isEmpty() || currentPendingExecutors != 0 || currentRunningExecutors >= currentTotalExpectedExecutors) break block1;
                    int numExecutorsToAllocate = package$.MODULE$.min(currentTotalExpectedExecutors - currentRunningExecutors, this.podAllocationSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes.").toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                        long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                        KubernetesConf<KubernetesExecutorSpecificConf> executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod());
                        SparkPod executorPod = $this.executorBuilder.buildFromFeatures(executorConf);
                        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                        $this.kubernetesClient.pods().create((Object[])new Pod[]{podWithAttachedContainer});
                        this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)BoxesRunTime.boxToLong((long)$this.clock.getTimeMillis()));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                    });
                    break block0;
                }
                if (currentRunningExecutors < currentTotalExpectedExecutors) break block2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current number of running executors is equal to the number of requested executors. Not scaling up further.");
                break block0;
            }
            if (!this.newlyCreatedExecutors().nonEmpty() && currentPendingExecutors == 0) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(234).append("Still waiting for ").append(this.newlyCreatedExecutors().size() + currentPendingExecutors).append(" executors to begin running before requesting for more executors. # of executors in").append(" pending status in the cluster: ").append(currentPendingExecutors).append(". # of executors that we have").append(" created but we have not observed as being present in the cluster yet:").append(" ").append(this.newlyCreatedExecutors().size()).append(".").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$6(ExecutorPodState x0$2) {
        ExecutorPodState executorPodState = x0$2;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$7(ExecutorPodState x0$3) {
        ExecutorPodState executorPodState = x0$3;
        boolean bl = executorPodState instanceof PodPending;
        return bl;
    }

    public ExecutorPodsAllocator(SparkConf conf, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutors = new AtomicInteger(0);
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = Map$.MODULE$.empty();
    }
}

