/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.resource.ResourceProfile$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001F\u000b\u0001A!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001d\u0001A\u0003%1\u0006C\u0004;\u0001\t\u0007I\u0011B\u001e\t\r\u0011\u0003\u0001\u0015!\u0003=\u0011\u001d)\u0005A1A\u0005\nmBaA\u0012\u0001!\u0002\u0013a\u0004bB$\u0001\u0005\u0004%Ia\u000f\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f%\u0003!\u0019!C\u0005w!1!\n\u0001Q\u0001\nqBqa\u0013\u0001C\u0002\u0013%1\b\u0003\u0004M\u0001\u0001\u0006I\u0001\u0010\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u0019i\u0006\u0001)A\u0005\u001f\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00021\u0001A\u0003%\u0011\u0007C\u0004b\u0001\t\u0007I\u0011B\u001e\t\r\t\u0004\u0001\u0015!\u0003=\u0005MYUOY3s]\u0016$Xm]\"p]\u001a\u001cV/\u001b;f\u0015\t1r#A\u0002lqMT!\u0001G\r\u0002\r\u0011,\u0007\u000f\\8z\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003eI!\u0001J\r\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\tQ#\u0001\u0005B!B{\u0016IU$T+\u0005Y\u0003c\u0001\u00170c5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0003BeJ\f\u0017\u0010\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0003%\t\u0005\u000bU0B%\u001e\u001b\u0006%A\u0007D+N#v*T0M\u0003\n+EjU\u000b\u0002yA!QHQ\u00192\u001b\u0005q$BA A\u0003%IW.\\;uC\ndWM\u0003\u0002B[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rs$aA'ba\u0006q1)V*U\u001f6{F*\u0011\"F\u0019N\u0003\u0013AE\"V'R{UjX!O\u001d>#\u0016\tV%P\u001dN\u000b1cQ+T)>ku,\u0011(O\u001fR\u000bE+S(O'\u0002\n1dU#D%\u0016#vLT!N\u000bN{FkT0N\u001fVsEk\u0018)B)\"\u001b\u0016\u0001H*F\u0007J+Ek\u0018(B\u001b\u0016\u001bv\fV(`\u001b>+f\nV0Q\u0003RC5\u000bI\u0001\u0010'\u0016\u001b%+\u0012+`\u000b:3vLV!S'\u0006\u00012+R\"S\u000bR{VI\u0014,`-\u0006\u00136\u000bI\u0001\f\u0007V\u001bFkT'`\u000b:36+\u0001\u0007D+N#v*T0F\u001dZ\u001b\u0006%\u0001\u0006E%&3VIU0Q\u001f\u0012+\u0012a\u0014\t\u0003!nk\u0011!\u0015\u0006\u0003%N\u000bQ!\\8eK2T!\u0001V+\u0002\u0007\u0005\u0004\u0018N\u0003\u0002W/\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005aK\u0016a\u00024bEJL7\r\u000f\u0006\u00025\u0006\u0011\u0011n\\\u0005\u00039F\u00131\u0001U8e\u0003-!%+\u0013,F%~\u0003v\n\u0012\u0011\u0002\u0017\u0015CViQ+U\u001fJ{\u0016\nR\u000b\u0002c\u0005aQ\tW#D+R{%kX%EA\u0005\tR\tW#D+R{%kX#O-~3\u0016IU*\u0002%\u0015CViQ+U\u001fJ{VI\u0014,`-\u0006\u00136\u000b\t")
public class KubernetesConfSuite
extends SparkFunSuite {
    private final String[] APP_ARGS = (String[])((Object[])new String[]{"arg1", "arg2"});
    private final Map<String, String> CUSTOM_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customLabel1Key"), (Object)"customLabel1Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customLabel2Key"), (Object)"customLabel2Value")}));
    private final Map<String, String> CUSTOM_ANNOTATIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation1Key"), (Object)"customAnnotation1Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation2Key"), (Object)"customAnnotation2Value")}));
    private final Map<String, String> SECRET_NAMES_TO_MOUNT_PATHS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret1"), (Object)"/mnt/secrets/secret1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret2"), (Object)"/mnt/secrets/secret2")}));
    private final Map<String, String> SECRET_ENV_VARS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"envName1"), (Object)"name1:key1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"envName2"), (Object)"name2:key2")}));
    private final Map<String, String> CUSTOM_ENVS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customEnvKey1"), (Object)"customEnvValue1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customEnvKey2"), (Object)"customEnvValue2")}));
    private final Pod DRIVER_POD = new PodBuilder().build();
    private final String EXECUTOR_ID;
    private final Map<String, String> EXECUTOR_ENV_VARS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.1executorEnvVars1/var1"), (Object)"executorEnvVars1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars2*var2"), (Object)"executorEnvVars2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars3_var3"), (Object)"executorEnvVars3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars4-var4"), (Object)"executorEnvVars4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars5-var5"), (Object)"executorEnvVars5/var5")}));

    private String[] APP_ARGS() {
        return this.APP_ARGS;
    }

    private Map<String, String> CUSTOM_LABELS() {
        return this.CUSTOM_LABELS;
    }

    private Map<String, String> CUSTOM_ANNOTATIONS() {
        return this.CUSTOM_ANNOTATIONS;
    }

    private Map<String, String> SECRET_NAMES_TO_MOUNT_PATHS() {
        return this.SECRET_NAMES_TO_MOUNT_PATHS;
    }

    private Map<String, String> SECRET_ENV_VARS() {
        return this.SECRET_ENV_VARS;
    }

    private Map<String, String> CUSTOM_ENVS() {
        return this.CUSTOM_ENVS;
    }

    private Pod DRIVER_POD() {
        return this.DRIVER_POD;
    }

    private String EXECUTOR_ID() {
        return this.EXECUTOR_ID;
    }

    private Map<String, String> EXECUTOR_ENV_VARS() {
        return this.EXECUTOR_ENV_VARS;
    }

    public KubernetesConfSuite() {
        this.EXECUTOR_ID = "executor-id";
        this.test("Resolve driver labels, annotations, secret mount paths, envs, and memory overhead", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)0.3));
            this.CUSTOM_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.CUSTOM_ANNOTATIONS().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.SECRET_NAMES_TO_MOUNT_PATHS().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.SECRET_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.CUSTOM_ENVS().foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            KubernetesDriverConf conf = KubernetesConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.APP_ID(), (MainAppResource)new JavaMainAppResource((Option)None$.MODULE$), KubernetesTestConf$.MODULE$.MAIN_CLASS(), this.APP_ARGS(), (Option)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.labels());
            Map $org_scalatest_assert_macro_right = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_DRIVER_ROLE())}))).$plus$plus(this.CUSTOM_LABELS());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.annotations());
            Map<String, String> $org_scalatest_assert_macro_right2 = this.CUSTOM_ANNOTATIONS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(conf.secretNamesToMountPaths());
            Map<String, String> $org_scalatest_assert_macro_right3 = this.SECRET_NAMES_TO_MOUNT_PATHS();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(conf.secretEnvNamesToKeyRefs());
            Map<String, String> $org_scalatest_assert_macro_right4 = this.SECRET_ENV_VARS();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(conf.environment());
            Map<String, String> $org_scalatest_assert_macro_right5 = this.CUSTOM_ENVS();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", $org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq($org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(conf.sparkConf().get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
            double $org_scalatest_assert_macro_right6 = 0.3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Basic executor translated fields.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.executorId());
            String $org_scalatest_assert_macro_right = this.EXECUTOR_ID();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.driverPod().get());
            Pod $org_scalatest_assert_macro_right2 = this.DRIVER_POD();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)conf.resourceProfileId()));
            int $org_scalatest_assert_macro_right3 = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("resource profile not default.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), 10);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)conf.resourceProfileId()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Image pull secrets.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my-secret-1", "my-secret-2 "}))), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.imagePullSecrets());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalObjectReference[]{((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("my-secret-1")).build(), ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("my-secret-2")).build()}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("Set executor labels, annotations, and secrets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            this.CUSTOM_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.CUSTOM_ANNOTATIONS().foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.SECRET_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            this.SECRET_NAMES_TO_MOUNT_PATHS().foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX()).append(key).toString(), value);
                return sparkConf;
            });
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(sparkConf, this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.labels());
            Map $org_scalatest_assert_macro_right = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.EXECUTOR_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()), (Object)((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())).toString())}))).$plus$plus(this.CUSTOM_LABELS());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.annotations());
            Map<String, String> $org_scalatest_assert_macro_right2 = this.CUSTOM_ANNOTATIONS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(conf.secretNamesToMountPaths());
            Map<String, String> $org_scalatest_assert_macro_right3 = this.SECRET_NAMES_TO_MOUNT_PATHS();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(conf.secretEnvNamesToKeyRefs());
            Map<String, String> $org_scalatest_assert_macro_right4 = this.SECRET_ENV_VARS();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("Verify that executorEnv key conforms to the regular specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            this.EXECUTOR_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(key, value);
                return sparkConf;
            });
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(sparkConf, this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.environment());
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars3_var3"), (Object)"executorEnvVars3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars4-var4"), (Object)"executorEnvVars4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars5-var5"), (Object)"executorEnvVars5/var5")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }
}

