/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001E\t\u0001=!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u001e\u0001A\u0003%\u0011\u0006C\u0004=\u0001\t\u0007I\u0011B\u001f\t\ry\u0002\u0001\u0015!\u00034\u0011\u001dy\u0004A1A\u0005\n!Ba\u0001\u0011\u0001!\u0002\u0013I\u0003bB!\u0001\u0005\u0004%I\u0001\u000b\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u0015\t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0011\n\u0001Q\u0001\n\u0015CqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0014\u0005\u00069\u0002!\t!\u0018\u0005\u0006g\u0002!I\u0001\u001e\u0002\u001c\u0005\u0006\u001c\u0018n\u0019#sSZ,'OR3biV\u0014Xm\u0015;faN+\u0018\u000e^3\u000b\u0005I\u0019\u0012\u0001\u00034fCR,(/Z:\u000b\u0005Q)\u0012aA69g*\u0011acF\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001%I\u0007\u0002/%\u0011!e\u0006\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\t\u0012!\u0004#S\u0013Z+%k\u0018'B\u0005\u0016c5+F\u0001*!\u0011Q\u0013gM\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0013%lW.\u001e;bE2,'B\u0001\u00180\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002a\u0005)1oY1mC&\u0011!g\u000b\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u001d\u0011\u0013\u0016JV#S?2\u000b%)\u0012'TA\u0005Y2i\u0014(U\u0003&sUIU0J\u001b\u0006;Ui\u0018)V\u00192{\u0006k\u0014'J\u0007f+\u0012aM\u0001\u001d\u0007>sE+Q%O\u000bJ{\u0016*T!H\u000b~\u0003V\u000b\u0014'`!>c\u0015jQ-!\u0003I!%+\u0013,F%~\u000beJT(U\u0003RKuJT*\u0002'\u0011\u0013\u0016JV#S?\u0006sej\u0014+B)&{ej\u0015\u0011\u0002\u0017\u0011\u0013\u0016JV#S?\u0016sekU\u0001\r\tJKe+\u0012*`\u000b:36\u000bI\u0001\u0018)\u0016\u001bFkX%N\u0003\u001e+u\fU+M\u0019~\u001bVi\u0011*F)N+\u0012!\u0012\t\u0004\r\u001e\u001bT\"A\u0017\n\u0005!k#aA*fc\u0006AB+R*U?&k\u0015iR#`!VcEjX*F\u0007J+Ek\u0015\u0011\u0002=Q+5\u000bV0J\u001b\u0006;Ui\u0018)V\u00192{6+R\"S\u000bR{vJ\u0011&F\u0007R\u001bV#\u0001'\u0011\u0007\u0019;U\n\u0005\u0002O36\tqJ\u0003\u0002Q#\u0006)Qn\u001c3fY*\u0011!kU\u0001\u0004CBL'B\u0001+V\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003-^\u000bqAZ1ce&\u001c\u0007HC\u0001Y\u0003\tIw.\u0003\u0002[\u001f\n!Bj\\2bY>\u0013'.Z2u%\u00164WM]3oG\u0016\fq\u0004V#T)~KU*Q$F?B+F\nT0T\u000b\u000e\u0013V\tV0P\u0005*+5\tV*!\u00035\u0019wN\u001c;bS:,'\u000fU8siR\u0019a,Y7\u0011\u00059{\u0016B\u00011P\u00055\u0019uN\u001c;bS:,'\u000fU8si\")!M\u0004a\u0001G\u0006!a.Y7f!\t!7N\u0004\u0002fSB\u0011amL\u0007\u0002O*\u0011\u0001.H\u0001\u0007yI|w\u000e\u001e \n\u0005)|\u0013A\u0002)sK\u0012,g-\u0003\u0002;Y*\u0011!n\f\u0005\u0006]:\u0001\ra\\\u0001\u000ba>\u0014HOT;nE\u0016\u0014\bC\u00019r\u001b\u0005y\u0013B\u0001:0\u0005\rIe\u000e^\u0001\u0010C6|WO\u001c;B]\u00124uN]7biR\u00111-\u001e\u0005\u0006m>\u0001\ra^\u0001\tcV\fg\u000e^5usB\u0011a\n_\u0005\u0003s>\u0013\u0001\"U;b]RLG/\u001f")
public class BasicDriverFeatureStepSuite
extends SparkFunSuite {
    private final Map<String, String> DRIVER_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelkey"), (Object)"labelvalue")}));
    private final String CONTAINER_IMAGE_PULL_POLICY;
    private final Map<String, String> DRIVER_ANNOTATIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation"), (Object)"customAnnotationValue")}));
    private final Map<String, String> DRIVER_ENVS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customDriverEnv1"), (Object)"customDriverEnv2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customDriverEnv2"), (Object)"customDriverEnv2")}));
    private final Seq<String> TEST_IMAGE_PULL_SECRETS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my-secret-1", "my-secret-2"}));
    private final Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.TEST_IMAGE_PULL_SECRETS().map((Function1 & Serializable & scala.Serializable)secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build(), Seq$.MODULE$.canBuildFrom());

    private Map<String, String> DRIVER_LABELS() {
        return this.DRIVER_LABELS;
    }

    private String CONTAINER_IMAGE_PULL_POLICY() {
        return this.CONTAINER_IMAGE_PULL_POLICY;
    }

    private Map<String, String> DRIVER_ANNOTATIONS() {
        return this.DRIVER_ANNOTATIONS;
    }

    private Map<String, String> DRIVER_ENVS() {
        return this.DRIVER_ENVS;
    }

    private Seq<String> TEST_IMAGE_PULL_SECRETS() {
        return this.TEST_IMAGE_PULL_SECRETS;
    }

    private Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    public ContainerPort containerPort(String name, int portNumber) {
        return ((ContainerPortBuilder)((ContainerPortFluentImpl)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(portNumber))).withProtocol("TCP")).build();
    }

    private String amountAndFormat(Quantity quantity) {
        return new StringBuilder(0).append(quantity.getAmount()).append(quantity.getFormat()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$5(EnvVar envVar) {
        return envVar.getName().equals(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()) && envVar.getValueFrom().getFieldRef().getApiVersion().equals("v1") && envVar.getValueFrom().getFieldRef().getFieldPath().equals("status.podIP");
    }

    public static final /* synthetic */ void $anonfun$new$11(BasicDriverFeatureStepSuite $this, Tuple4 x0$5) {
        Tuple4 tuple4 = x0$5;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String name = (String)tuple4._1();
        Product resource = (Product)tuple4._2();
        Option factor = (Option)tuple4._3();
        double expectedFactor = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        $this.test(new StringBuilder(24).append("memory overhead factor: ").append(name).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double driverMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / BoxesRunTime.unboxToDouble((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get()) * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(package$.MODULE$.DRIVER_MEMORY().key(), new StringBuilder(1).append((int)driverMem).append("m").toString());
            factor.foreach((Function1 & Serializable & scala.Serializable)value -> sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value))));
            SparkConf x$29 = sparkConf;
            Product x$30 = resource;
            String x$31 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            String x$32 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(x$29, x$31, (MainAppResource)x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
            BasicDriverFeatureStep step = new BasicDriverFeatureStep(conf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = $this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(driverMem + driverMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(systemProperties.apply((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()));
            String $org_scalatest_assert_macro_right2 = ((Object)BoxesRunTime.boxToDouble((double)expectedFactor)).toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BasicDriverFeatureStepSuite() {
        this.CONTAINER_IMAGE_PULL_POLICY = "IfNotPresent";
        this.test("Check the pod respects all configurations from the user.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ResourceID resourceID = new ResourceID(package$.MODULE$.SPARK_DRIVER_PREFIX(), ResourceUtils$.MODULE$.GPU());
            Map resources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia.com/gpu"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(resourceID, "2", "nvidia.com"))}));
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)"spark-driver-pod").set(package$.MODULE$.DRIVER_CORES(), (Object)BoxesRunTime.boxToInteger((int)2)).set(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES(), (Object)"4").set(package$.MODULE$.DRIVER_MEMORY().key(), "256M").set(package$.MODULE$.DRIVER_MEMORY_OVERHEAD(), (Object)BoxesRunTime.boxToLong((long)200L)).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(Config$.MODULE$.IMAGE_PULL_SECRETS(), this.TEST_IMAGE_PULL_SECRETS());
            resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                sparkConf.set(testRInfo.rId().amountConf(), testRInfo.count());
                SparkConf sparkConf = sparkConf.set(testRInfo.rId().vendorConf(), testRInfo.vendor());
                return sparkConf;
            });
            SparkConf x$1 = sparkConf;
            Map<String, String> x$2 = this.DRIVER_LABELS();
            Map<String, String> x$3 = this.DRIVER_ENVS();
            Map<String, String> x$4 = this.DRIVER_ANNOTATIONS();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$5, x$6, x$7, x$8, x$9, x$2, x$3, x$4, x$10, x$11, x$12, x$13, x$14);
            BasicDriverFeatureStep featureStep = new BasicDriverFeatureStep(kubernetesConf);
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            SparkPod configuredPod = featureStep.configurePod(basePod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configuredPod.container().getName());
            String $org_scalatest_assert_macro_right = Constants$.MODULE$.DEFAULT_DRIVER_CONTAINER_NAME();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(configuredPod.container().getImage());
            String $org_scalatest_assert_macro_right2 = "spark-driver:latest";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(configuredPod.container().getImagePullPolicy());
            String $org_scalatest_assert_macro_right3 = this.CONTAINER_IMAGE_PULL_POLICY();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Set expectedPortNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ContainerPort[]{this.containerPort(Constants$.MODULE$.DRIVER_PORT_NAME(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), this.containerPort(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT()), this.containerPort(Constants$.MODULE$.UI_PORT_NAME(), BoxesRunTime.unboxToInt((Object)UI$.MODULE$.UI_PORT().defaultValue().get()))}));
            Set foundPortNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getPorts()).asScala()).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(expectedPortNames);
            Set $org_scalatest_assert_macro_right4 = foundPortNames;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Map envs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)env -> new Tuple2((Object)env.getName(), (Object)env.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.DRIVER_ENVS().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(envs.apply((Object)v));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(envs.apply((Object)Constants$.MODULE$.ENV_SPARK_USER()));
            String $org_scalatest_assert_macro_right5 = Utils$.MODULE$.getCurrentUserName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(envs.apply((Object)Constants$.MODULE$.ENV_APPLICATION_ID()));
            String $org_scalatest_assert_macro_right6 = kubernetesConf.appId();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.pod().getSpec().getImagePullSecrets()).asScala());
            Seq<LocalObjectReference> $org_scalatest_assert_macro_right7 = this.TEST_IMAGE_PULL_SECRET_OBJECTS();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", $org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq($org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getEnv()).asScala()).exists((Function1 & Serializable & scala.Serializable)envVar -> BoxesRunTime.boxToBoolean((boolean)BasicDriverFeatureStepSuite.$anonfun$new$5(envVar))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.EnvVar](configuredPod.container.getEnv()).asScala.exists(((envVar: io.fabric8.kubernetes.api.model.EnvVar) => envVar.getName().equals(org.apache.spark.deploy.k8s.Constants.ENV_DRIVER_BIND_ADDRESS).&&(envVar.getValueFrom().getFieldRef().getApiVersion().equals(\"v1\")).&&(envVar.getValueFrom().getFieldRef().getFieldPath().equals(\"status.podIP\"))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            ResourceRequirements resourceRequirements = configuredPod.container().getResources();
            scala.collection.mutable.Map requests = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(resourceRequirements.getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right8 = "2";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests.apply((Object)"memory")));
            String $org_scalatest_assert_macro_right9 = "456Mi";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            scala.collection.mutable.Map limits = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(resourceRequirements.getLimits()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)"memory")));
            String $org_scalatest_assert_macro_right10 = "456Mi";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right11 = "4";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            resources.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k8sName = (String)tuple2._1();
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)k8sName)));
                String $org_scalatest_assert_macro_right = testRInfo.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                return assertion;
            });
            ObjectMeta driverPodMetadata = configuredPod.pod().getMetadata();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(driverPodMetadata.getName());
            String $org_scalatest_assert_macro_right12 = "spark-driver-pod";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            this.DRIVER_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverPodMetadata.getLabels().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(driverPodMetadata.getAnnotations()).asScala());
            Map<String, String> $org_scalatest_assert_macro_right13 = this.DRIVER_ANNOTATIONS();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", $org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq($org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(configuredPod.pod().getSpec().getRestartPolicy());
            String $org_scalatest_assert_macro_right14 = "Never";
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Map expectedSparkConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)"spark-driver-pod"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.submitInDriver"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()), (Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get().toString())}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(featureStep.getAdditionalPodSystemProperties());
            Map $org_scalatest_assert_macro_right15 = expectedSparkConf;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("Check driver pod respects kubernetes driver request cores", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)"spark-driver-pod").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest");
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            scala.collection.mutable.Map requests1 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14())).configurePod(basePod).container().getResources().getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)requests1.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            sparkConf.set(package$.MODULE$.DRIVER_CORES(), (Object)BoxesRunTime.boxToInteger((int)10));
            scala.collection.mutable.Map requests2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14())).configurePod(basePod).container().getResources().getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests2.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right2 = "10";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.1", "100m"}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                sparkConf.set(Config$.MODULE$.KUBERNETES_DRIVER_REQUEST_CORES(), value);
                scala.collection.mutable.Map requests3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14())).configurePod(basePod).container().getResources().getRequests()).asScala();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)requests3.apply((Object)"cpu")));
                String $org_scalatest_assert_macro_right = value;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            });
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("Check appropriate entrypoint rerouting for various bindings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf javaSparkConf = new SparkConf().set(package$.MODULE$.DRIVER_MEMORY().key(), "4g").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest");
            SparkConf pythonSparkConf = new SparkConf().set(package$.MODULE$.DRIVER_MEMORY().key(), "4g").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver-py:latest");
            KubernetesDriverConf javaKubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(javaSparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            SparkConf x$15 = pythonSparkConf;
            PythonMainAppResource x$16 = new PythonMainAppResource("");
            String x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            KubernetesDriverConf pythonKubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$15, x$17, (MainAppResource)x$16, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28);
            BasicDriverFeatureStep javaFeatureStep = new BasicDriverFeatureStep(javaKubernetesConf);
            BasicDriverFeatureStep pythonFeatureStep = new BasicDriverFeatureStep(pythonKubernetesConf);
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            SparkPod configuredJavaPod = javaFeatureStep.configurePod(basePod);
            SparkPod configuredPythonPod = pythonFeatureStep.configurePod(basePod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configuredJavaPod.container().getImage());
            String $org_scalatest_assert_macro_right = "spark-driver:latest";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(configuredPythonPod.container().getImage());
            String $org_scalatest_assert_macro_right2 = "spark-driver-py:latest";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"java", (Object)new JavaMainAppResource((Option)None$.MODULE$), (Object)None$.MODULE$, Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get()), new Tuple4((Object)"python default", (Object)new PythonMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR())), new Tuple4((Object)"python w/ override", (Object)new PythonMainAppResource(null), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)BoxesRunTime.boxToDouble((double)0.9)), new Tuple4((Object)"r default", (Object)new RMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR()))}))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            BasicDriverFeatureStepSuite.$anonfun$new$11(this, x0$5);
            return BoxedUnit.UNIT;
        });
    }
}

