/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.net.InternetDomainName;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils$;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.resource.TestResourceIDs$;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\u0013&\u0001IBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019!\u0006\u0001)A\u0005\u001d\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB/\u0001A\u0003%q\u000bC\u0004_\u0001\t\u0007I\u0011\u0002\"\t\r}\u0003\u0001\u0015!\u0003D\u0011\u001d\u0001\u0007A1A\u0005\n\tCa!\u0019\u0001!\u0002\u0013\u0019\u0005b\u00022\u0001\u0005\u0004%IA\u0011\u0005\u0007G\u0002\u0001\u000b\u0011B\"\t\u000f\u0011\u0004!\u0019!C\u0005\u0005\"1Q\r\u0001Q\u0001\n\rCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004q\u0001\u0001\u0006I\u0001\u001b\u0005\nc\u0002\u0001\r\u00111A\u0005\nID\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&1\u000fC\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011q\u0002\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\u0007\u0001!\u0002\u0013\t)\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\b\u0001!\u0002\u0013\tI\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bB1\"!\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002F!9\u00111\u000b\u0001\u0005\n\u0005U\u0003\"CA>\u0001E\u0005I\u0011BA?\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!'\u0001\t\u0013\tY\nC\u0004\u0002&\u0002!I!a*\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\ni\")Y:jG\u0016CXmY;u_J4U-\u0019;ve\u0016\u001cF/\u001a9Tk&$XM\u0003\u0002'O\u0005Aa-Z1ukJ,7O\u0003\u0002)S\u0005\u00191\u000eO:\u000b\u0005)Z\u0013A\u00023fa2|\u0017P\u0003\u0002-[\u0005)1\u000f]1sW*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u00192\u0001A\u001a8!\t!T'D\u0001,\u0013\t14FA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u=\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005qJ$A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"\u0001\u0011\u0001\u000e\u0003\u0015\nq\u0002\u0012*J-\u0016\u0013v\fS(T):\u000bU*R\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0005Y\u0006twMC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%AB*ue&tw-\u0001\tE%&3VIU0I\u001fN#f*Q'FA\u0005YAIU%W\u000bJ{\u0006k\u0014*U+\u0005q\u0005CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&aA%oi\u0006aAIU%W\u000bJ{\u0006k\u0014*UA\u0005qAIU%W\u000bJ{\u0016\t\u0012#S\u000bN\u001bV#A,\u0011\u0005a[V\"A-\u000b\u0005i[\u0013a\u0001:qG&\u0011A,\u0017\u0002\u0013%B\u001cWI\u001c3q_&tG/\u00113ee\u0016\u001c8/A\bE%&3VIU0B\t\u0012\u0013ViU*!\u0003=!%+\u0013,F%~\u0003v\nR0O\u00036+\u0015\u0001\u0005#S\u0013Z+%k\u0018)P\t~s\u0015)T#!\u00039!%+\u0013,F%~\u0003v\nR0V\u0013\u0012\u000bq\u0002\u0012*J-\u0016\u0013v\fU(E?VKE\tI\u0001\u0015%\u0016\u001bv*\u0016*D\u000b~s\u0015)T#`!J+e)\u0013-\u0002+I+5kT+S\u0007\u0016{f*Q'F?B\u0013VIR%YA\u0005qQ\tW#D+R{%kX%N\u0003\u001e+\u0015aD#Y\u000b\u000e+Fk\u0014*`\u00136\u000bu)\u0012\u0011\u0002\r1\u000b%)\u0012'T+\u0005A\u0007\u0003B5o\u0007\u000ek\u0011A\u001b\u0006\u0003W2\f\u0011\"[7nkR\f'\r\\3\u000b\u00055\u0004\u0016AC2pY2,7\r^5p]&\u0011qN\u001b\u0002\u0004\u001b\u0006\u0004\u0018a\u0002'B\u0005\u0016c5\u000bI\u0001\u000fI\u00164\u0017-\u001e7u!J|g-\u001b7f+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<,\u0003!\u0011Xm]8ve\u000e,\u0017B\u0001=v\u0005=\u0011Vm]8ve\u000e,\u0007K]8gS2,\u0017A\u00053fM\u0006,H\u000e\u001e)s_\u001aLG.Z0%KF$\"a\u001f@\u0011\u0005=c\u0018BA?Q\u0005\u0011)f.\u001b;\t\u000f}\u001c\u0012\u0011!a\u0001g\u0006\u0019\u0001\u0010J\u0019\u0002\u001f\u0011,g-Y;miB\u0013xNZ5mK\u0002\nq\u0003V#T)~KU*Q$F?B+F\nT0T\u000b\u000e\u0013V\tV*\u0016\u0005\u0005\u001d\u0001#BA\u0005\u0003\u0017\u0019U\"\u00017\n\u0007\u00055ANA\u0002TKF\f\u0001\u0004V#T)~KU*Q$F?B+F\nT0T\u000b\u000e\u0013V\tV*!\u0003y!Vi\u0015+`\u00136\u000bu)R0Q+2culU#D%\u0016#vl\u0014\"K\u000b\u000e#6+\u0006\u0002\u0002\u0016A1\u0011\u0011BA\u0006\u0003/\u0001B!!\u0007\u000205\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0003n_\u0012,GN\u0003\u0003\u0002\"\u0005\r\u0012aA1qS*!\u0011QEA\u0014\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0005\u0003S\tY#A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0005\u00055\u0012AA5p\u0013\u0011\t\t$a\u0007\u0003)1{7-\u00197PE*,7\r\u001e*fM\u0016\u0014XM\\2f\u0003}!Vi\u0015+`\u00136\u000bu)R0Q+2culU#D%\u0016#vl\u0014\"K\u000b\u000e#6\u000bI\u0001\u000b\tJKe+\u0012*`!>#UCAA\u001d!\u0011\tI\"a\u000f\n\t\u0005u\u00121\u0004\u0002\u0004!>$\u0017a\u0003#S\u0013Z+%k\u0018)P\t\u0002\n\u0001BY1tK\u000e{gNZ\u000b\u0003\u0003\u000b\u00022\u0001NA$\u0013\r\tIe\u000b\u0002\n'B\f'o[\"p]\u001a\fABY1tK\u000e{gNZ0%KF$2a_A(\u0011!yH$!AA\u0002\u0005\u0015\u0013!\u00032bg\u0016\u001cuN\u001c4!\u0003=qWm^#yK\u000e,Ho\u001c:D_:4G\u0003BA,\u0003?\u0002B!!\u0017\u0002\\5\tq%C\u0002\u0002^\u001d\u0012acS;cKJtW\r^3t\u000bb,7-\u001e;pe\u000e{gN\u001a\u0005\n\u0003Cr\u0002\u0013!a\u0001\u0003G\n1\"\u001a8wSJ|g.\\3oiBA\u0011QMA:\u0003o\n9H\u0004\u0003\u0002h\u0005=\u0004cAA5!6\u0011\u00111\u000e\u0006\u0004\u0003[\n\u0014A\u0002\u001fs_>$h(C\u0002\u0002rA\u000ba\u0001\u0015:fI\u00164\u0017bA8\u0002v)\u0019\u0011\u0011\u000f)\u0011\t\u0005\u0015\u0014\u0011P\u0005\u0004\u0015\u0006U\u0014!\u00078fo\u0016CXmY;u_J\u001cuN\u001c4%I\u00164\u0017-\u001e7uIE*\"!a +\t\u0005\r\u0014\u0011Q\u0016\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0012)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0006\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\u0012N\\5u\t\u00164\u0017-\u001e7u!J|g-\u001b7f)\rY\u0018q\u0013\u0005\b\u0003\u0003\u0002\u0003\u0019AA#\u0003Q\u0019\u0007.Z2l\u001f^tWM\u001d*fM\u0016\u0014XM\\2fgR)10!(\u0002\"\"9\u0011qT\u0011A\u0002\u0005e\u0012\u0001C3yK\u000e,Ho\u001c:\t\u000f\u0005\r\u0016\u00051\u0001\u0002x\u0005aAM]5wKJ\u0004v\u000eZ+jI\u0006A1\r[3dW\u0016sg\u000fF\u0004|\u0003S\u000b\u0019,a.\t\u000f\u0005-&\u00051\u0001\u0002.\u0006YQ\r_3dkR|'\u000fU8e!\u0011\tI&a,\n\u0007\u0005EvE\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u001d\t)L\ta\u0001\u0003\u000b\nAaY8oM\"9\u0011\u0011\u0018\u0012A\u0002\u0005\r\u0014!E1eI&$\u0018n\u001c8bY\u0016sgOV1sg\u0006y\u0011-\\8v]R\fe\u000e\u001a$pe6\fG\u000f\u0006\u0003\u0002x\u0005}\u0006bBAaG\u0001\u0007\u00111Y\u0001\tcV\fg\u000e^5usB!\u0011\u0011DAc\u0013\u0011\t9-a\u0007\u0003\u0011E+\u0018M\u001c;jif\u0004")
public class BasicExecutorFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_HOSTNAME;
    private final int DRIVER_PORT;
    private final RpcEndpointAddress DRIVER_ADDRESS;
    private final String DRIVER_POD_NAME;
    private final String DRIVER_POD_UID;
    private final String RESOURCE_NAME_PREFIX;
    private final String EXECUTOR_IMAGE;
    private final scala.collection.immutable.Map<String, String> LABELS;
    private ResourceProfile defaultProfile;
    private final Seq<String> TEST_IMAGE_PULL_SECRETS;
    private final Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS;
    private final Pod DRIVER_POD;
    private SparkConf baseConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String DRIVER_HOSTNAME() {
        return this.DRIVER_HOSTNAME;
    }

    private int DRIVER_PORT() {
        return this.DRIVER_PORT;
    }

    private RpcEndpointAddress DRIVER_ADDRESS() {
        return this.DRIVER_ADDRESS;
    }

    private String DRIVER_POD_NAME() {
        return this.DRIVER_POD_NAME;
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String RESOURCE_NAME_PREFIX() {
        return this.RESOURCE_NAME_PREFIX;
    }

    private String EXECUTOR_IMAGE() {
        return this.EXECUTOR_IMAGE;
    }

    private scala.collection.immutable.Map<String, String> LABELS() {
        return this.LABELS;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private void defaultProfile_$eq(ResourceProfile x$1) {
        this.defaultProfile = x$1;
    }

    private Seq<String> TEST_IMAGE_PULL_SECRETS() {
        return this.TEST_IMAGE_PULL_SECRETS;
    }

    private Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    private Pod DRIVER_POD() {
        return this.DRIVER_POD;
    }

    private SparkConf baseConf() {
        return this.baseConf;
    }

    private void baseConf_$eq(SparkConf x$1) {
        this.baseConf = x$1;
    }

    private KubernetesExecutorConf newExecutorConf(scala.collection.immutable.Map<String, String> environment) {
        return KubernetesTestConf$.MODULE$.createExecutorConf(this.baseConf(), (Option<Pod>)new Some((Object)this.DRIVER_POD()), this.LABELS(), environment, KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
    }

    private scala.collection.immutable.Map<String, String> newExecutorConf$default$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private void initDefaultProfile(SparkConf baseConf) {
        ResourceProfile$.MODULE$.clearDefaultProfile();
        this.defaultProfile_$eq(ResourceProfile$.MODULE$.getOrCreateDefaultProfile(baseConf));
    }

    private void checkOwnerReferences(Pod executor, String driverPodUid) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getOwnerReferences().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getUid());
        String $org_scalatest_assert_macro_right2 = driverPodUid;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getController()), "scala.Predef.Boolean2boolean(executor.getMetadata().getOwnerReferences().get(0).getController())", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    private void checkEnv(SparkPod executorPod, SparkConf conf, scala.collection.immutable.Map<String, String> additionalEnvVars) {
        scala.collection.immutable.Map defaultEnvs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.DRIVER_ADDRESS().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_USER()), (Object)Utils$.MODULE$.getCurrentUserName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_RESOURCE_PROFILE_ID()), (Object)"0")}));
        int extraJavaOptsStart = additionalEnvVars.keys().count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX())));
        Seq extraJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        scala.collection.immutable.Map extraJavaOptsEnvs = ((TraversableOnce)((TraversableLike)extraJavaOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String opt = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(ind + extraJavaOptsStart).toString()), (Object)opt);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map containerEnvs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorPod.container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.getName(), (Object)x.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map expectedEnvs = defaultEnvs.$plus$plus(additionalEnvVars).$plus$plus((GenTraversableOnce)extraJavaOptsEnvs);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(containerEnvs);
        scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedEnvs;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
    }

    private String amountAndFormat(Quantity quantity) {
        return new StringBuilder(0).append(quantity.getAmount()).append(quantity.getFormat()).toString();
    }

    public BasicExecutorFeatureStepSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_HOSTNAME = "localhost";
        this.DRIVER_PORT = 7098;
        this.DRIVER_ADDRESS = RpcEndpointAddress$.MODULE$.apply(this.DRIVER_HOSTNAME(), this.DRIVER_PORT(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME());
        this.DRIVER_POD_NAME = "driver-pod";
        this.DRIVER_POD_UID = "driver-uid";
        this.RESOURCE_NAME_PREFIX = "base";
        this.EXECUTOR_IMAGE = "executor-image";
        this.LABELS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value")}));
        this.TEST_IMAGE_PULL_SECRETS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my-1secret-1", "my-secret-2"}));
        this.TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.TEST_IMAGE_PULL_SECRETS().map((Function1 & Serializable & scala.Serializable)secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build(), Seq$.MODULE$.canBuildFrom());
        this.DRIVER_POD = ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.DRIVER_POD_NAME()).withUid(this.DRIVER_POD_UID())).endMetadata()).withNewSpec().withNodeName("some-node")).endSpec()).withNewStatus().withHostIP("192.168.99.100")).endStatus()).build();
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.baseConf_$eq(new SparkConf(false).set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.DRIVER_POD_NAME()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.RESOURCE_NAME_PREFIX()).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)this.EXECUTOR_IMAGE()).set(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)this.DRIVER_HOSTNAME()).set(package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)this.DRIVER_PORT())).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), this.TEST_IMAGE_PULL_SECRETS()).set("spark.kubernetes.resource.type", "java"));
            this.initDefaultProfile(this.baseConf());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("test spark resource missing vendor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().amountConf(), "2");
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.initDefaultProfile(this.baseConf());
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107))).getMessage();
            String $org_scalatest_assert_macro_right = "Resource: gpu was requested, but vendor was not specified";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("test spark resource missing amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().vendorConf(), "nvidia.com");
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.initDefaultProfile(this.baseConf());
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118))).getMessage();
            String $org_scalatest_assert_macro_right = "You must specify an amount for gpu";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("basic executor pod with resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResourceID fpgaResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.FPGA());
            ResourceID gpuExecutorResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.GPU());
            scala.collection.immutable.Map gpuResources = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia.com/gpu"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(gpuExecutorResourceID, "2", "nvidia.com")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.com/fpga"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(fpgaResourceID, "1", "foo.com"))}));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                this.baseConf().set(testRInfo.rId().amountConf(), testRInfo.count());
                SparkConf sparkConf = this.baseConf().set(testRInfo.rId().vendorConf(), testRInfo.vendor());
                return sparkConf;
            });
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right2 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k8sName = (String)tuple2._1();
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get(k8sName)));
                String $org_scalatest_assert_macro_right = testRInfo.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                return assertion;
            });
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("basic executor pod has reasonable defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getName());
            String $org_scalatest_assert_macro_right = new StringBuilder(7).append(this.RESOURCE_NAME_PREFIX()).append("-exec-1").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            this.LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getLabels().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(executor.pod().getSpec().getImagePullSecrets()).asScala());
            Seq<LocalObjectReference> $org_scalatest_assert_macro_right2 = this.TEST_IMAGE_PULL_SECRET_OBJECTS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(executor.container().getImage());
            String $org_scalatest_assert_macro_right3 = this.EXECUTOR_IMAGE();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            List $org_scalatest_assert_macro_left4 = executor.container().getVolumeMounts();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right6 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Map $org_scalatest_assert_macro_left7 = executor.pod().getSpec().getNodeSelector();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            List $org_scalatest_assert_macro_left8 = executor.pod().getSpec().getVolumes();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("executor pod hostnames get truncated to 63 characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String longPodNamePrefix = "loremipsumdolorsitametvimatelitrefficiendisuscipianturvixlegeresple";
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)longPodNamePrefix);
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname().length()));
            int $org_scalatest_assert_macro_right = 63;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("hostname truncation generates valid host names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String invalidPrefix = "abcdef-*_/[]{}+==.,;'\"-----------------------------------------------";
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)invalidPrefix);
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            String hostname = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname();
            int $org_scalatest_assert_macro_left = hostname.length();
            int $org_scalatest_assert_macro_right = 63;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(InternetDomainName.isValid((String)hostname), "com.google.common.net.InternetDomainName.isValid(hostname)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("classpath and extra java options get translated into environment variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.baseConf().set(package$.MODULE$.EXECUTOR_JAVA_OPTIONS(), (Object)"foo=bar");
            this.baseConf().set(package$.MODULE$.EXECUTOR_CLASS_PATH(), (Object)"bar=baz");
            this.initDefaultProfile(this.baseConf());
            KubernetesExecutorConf kconf = this.newExecutorConf((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(kconf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_JAVA_OPT_0"), (Object)"foo=bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), (Object)"bar=baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("SPARK-32655 Support appId/execId placeholder in SPARK_EXECUTOR_DIRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf kconf = this.newExecutorConf((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_DIRS()), (Object)"/p1/SPARK_APPLICATION_ID/SPARK_EXECUTOR_ID,/p2/SPARK_APPLICATION_ID/SPARK_EXECUTOR_ID")}))));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(kconf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_DIRS()), (Object)new StringBuilder(13).append("/p1/").append(KubernetesTestConf$.MODULE$.APP_ID()).append("/1,/p2/").append(KubernetesTestConf$.MODULE$.APP_ID()).append("/1").toString())}))));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("test executor pyspark memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set("spark.kubernetes.resource.type", "python");
            this.baseConf().set(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY(), (Object)BoxesRunTime.boxToLong((long)42L));
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("memory")));
            String $org_scalatest_assert_macro_right = "1450Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("auth secret propagation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr, this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, conf, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)secMgr.getSecretKey())}))));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("Auth secret shouldn't propagate if files are loaded.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File secretDir = Utils$.MODULE$.createTempDir("temp-secret", Utils$.MODULE$.createTempDir$default$2());
            File secretFile = new File(secretDir, "secret-file.txt");
            Files.write(secretFile.toPath(), "some-secret".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.AUTH_SECRET_FILE(), (Object)secretFile.getAbsolutePath()).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr, this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(KubernetesFeaturesTestUtils$.MODULE$.containerHasEnvVar(executor.container(), SecurityManager$.MODULE$.ENV_AUTH_SECRET()), "KubernetesFeaturesTestUtils.containerHasEnvVar(executor.container, org.apache.spark.SecurityManager.ENV_AUTH_SECRET)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("SPARK-32661 test executor offheap memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.baseConf().set("spark.memory.offHeap.size", "42m");
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("memory")));
            String $org_scalatest_assert_macro_right = "1450Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("basic resourceprofile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set("spark.kubernetes.resource.type", "python");
            this.initDefaultProfile(this.baseConf());
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g").memoryOverhead("1g").pysparkMemory("3g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("cpu")));
            String $org_scalatest_assert_macro_right = "4";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right2 = "6144Mi";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("resourceprofile with gpus", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(2).resource("gpu", 2L, "/path/getGpusResources.sh", "nvidia.com");
            treq.cpus(1);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right = "1408Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("cpu")));
            String $org_scalatest_assert_macro_right2 = "2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("nvidia.com/gpu")));
            String $org_scalatest_assert_macro_right4 = "2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("Verify spark conf dir is mounted as configmap volume on executor pod's container.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod podConfigured = step.configurePod(baseDriverPod);
            SecretVolumeUtils$.MODULE$.containerHasVolume(podConfigured.container(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC(), Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL());
            return SecretVolumeUtils$.MODULE$.podHasVolume(podConfigured.pod(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }
}

