/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.PodTemplateConfigMapStep;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\ti\u0002k\u001c3UK6\u0004H.\u0019;f\u0007>tg-[4NCB\u001cF/\u001a9Tk&$XM\u0003\u0002\u0005\u000b\u0005Aa-Z1ukJ,7O\u0003\u0002\u0007\u000f\u0005\u00191\u000eO:\u000b\u0005!I\u0011A\u00023fa2|\u0017P\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0005\n\u0005QI!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0007\u0001")
public class PodTemplateConfigMapStepSuite
extends SparkFunSuite {
    public PodTemplateConfigMapStepSuite() {
        this.test("Do nothing when executor template is not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(KubernetesTestConf$.MODULE$.createDriverConf$default$1(), KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            PodTemplateConfigMapStep step = new PodTemplateConfigMapStep((KubernetesConf)conf);
            SparkPod initialPod = SparkPod$.MODULE$.initialPod();
            SparkPod configuredPod = step.configurePod(initialPod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configuredPod);
            SparkPod $org_scalatest_assert_macro_right = initialPod;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Seq $org_scalatest_assert_macro_left2 = step.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Map $org_scalatest_assert_macro_left3 = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Mounts executor template volume if config specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File templateFile = Files.createTempFile("pod-template", "yml", new FileAttribute[0]).toFile();
            templateFile.deleteOnExit();
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE(), (Object)templateFile.getAbsolutePath());
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(templateFile), (Function1 & Serializable & scala.Serializable)writer -> {
                writer.write("pod-template-contents");
                return BoxedUnit.UNIT;
            });
            PodTemplateConfigMapStep step = new PodTemplateConfigMapStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Volume volume = (Volume)configuredPod.pod().getSpec().getVolumes().get(0);
            String generatedResourceName = new StringBuilder(1).append(kubernetesConf.resourceNamePrefix()).append("-").append(Constants$.MODULE$.POD_TEMPLATE_CONFIGMAP()).toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(volume.getName());
            String $org_scalatest_assert_macro_right2 = Constants$.MODULE$.POD_TEMPLATE_VOLUME();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(volume.getConfigMap().getName());
            String $org_scalatest_assert_macro_right3 = generatedResourceName;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)volume.getConfigMap().getItems().size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((KeyToPath)volume.getConfigMap().getItems().get(0)).getKey());
            String $org_scalatest_assert_macro_right5 = Constants$.MODULE$.POD_TEMPLATE_KEY();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((KeyToPath)volume.getConfigMap().getItems().get(0)).getPath());
            String $org_scalatest_assert_macro_right6 = Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            VolumeMount volumeMount = (VolumeMount)configuredPod.container().getVolumeMounts().get(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(volumeMount.getMountPath());
            String $org_scalatest_assert_macro_right8 = Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(volumeMount.getName());
            String $org_scalatest_assert_macro_right9 = Constants$.MODULE$.POD_TEMPLATE_VOLUME();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            Seq resources = step.getAdditionalKubernetesResources();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)resources.size()));
            int $org_scalatest_assert_macro_right10 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(((HasMetadata)resources.head()).getMetadata().getName());
            String $org_scalatest_assert_macro_right11 = generatedResourceName;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            HasMetadata $org_scalatest_assert_macro_left12 = (HasMetadata)resources.head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "io.fabric8.kubernetes.api.model.ConfigMap", $org_scalatest_assert_macro_left12 instanceof ConfigMap, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            ConfigMap configMap = (ConfigMap)resources.head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configMap.getData().size()));
            int $org_scalatest_assert_macro_right12 = 1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.POD_TEMPLATE_KEY()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.POD_TEMPLATE_KEY)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsValue("pod-template-contents"), "configMap.getData().containsValue(\"pod-template-contents\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)systemProperties.size()));
            int $org_scalatest_assert_macro_right13 = 1;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Map $org_scalatest_assert_macro_left15 = systemProperties;
            String $org_scalatest_assert_macro_right14 = Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE().key();
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "contains", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left15.contains((Object)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(systemProperties.get((Object)Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE().key()).get());
            String $org_scalatest_assert_macro_right15 = new StringBuilder(1).append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH()).append("/").append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME()).toString();
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("PodTemplateConfigMapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
    }
}

