/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001\u0002 @\u00011CQa\u0016\u0001\u0005\u0002aCQa\u0017\u0001\u0005\nqCq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004x\u0001\u0001\u0006Ia\u001c\u0005\bq\u0002\u0011\r\u0011\"\u0003o\u0011\u0019I\b\u0001)A\u0005_\"9!\u0010\u0001b\u0001\n\u0013q\u0007BB>\u0001A\u0003%q\u000eC\u0004}\u0001\t\u0007I\u0011\u00028\t\ru\u0004\u0001\u0015!\u0003p\u0011\u001dq\bA1A\u0005\n9Daa \u0001!\u0002\u0013y\u0007\u0002CA\u0001\u0001\t\u0007I\u0011\u00028\t\u000f\u0005\r\u0001\u0001)A\u0005_\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002 !I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002B!I\u0011\u0011\n\u0001C\u0002\u0013%\u00111\n\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002N!I\u0011Q\f\u0001C\u0002\u0013%\u0011q\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002b!I\u00111\u000e\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002B!I\u0011q\u000e\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002t!9\u00111\u0010\u0001\u0005\n\u0005u\u0004\"CAN\u0001E\u0005I\u0011BAO\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kC\u0011\"!/\u0001#\u0003%I!!(\t\u0013\u0005m\u0006A1A\u0005\n\u0005-\u0003\u0002CA_\u0001\u0001\u0006I!!\u0014\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u001f\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u000eC\u0006\u0002^\u0002\u0001\r\u0011!Q!\n\u0005\r\u0007bCAu\u0001\u0001\u0007\t\u0019!C\u0005\u0003WD1Ba\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0012!Y!Q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015BAw\u0011-\u0011I\u0002\u0001a\u0001\u0002\u0004%IAa\u0007\t\u0017\t=\u0002\u00011AA\u0002\u0013%!\u0011\u0007\u0005\f\u0005k\u0001\u0001\u0019!A!B\u0013\u0011i\u0002C\u0006\u0003:\u0001\u0001\r\u00111A\u0005\n\tm\u0002b\u0003B\"\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u000bB1B!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003>!Y!Q\n\u0001A\u0002\u0003\u0007I\u0011\u0002B(\u0011-\u00119\u0006\u0001a\u0001\u0002\u0004%IA!\u0017\t\u0017\tu\u0003\u00011A\u0001B\u0003&!\u0011\u000b\u0005\f\u0005C\u0002\u0001\u0019!a\u0001\n\u0013\u0011\u0019\u0007C\u0006\u0003l\u0001\u0001\r\u00111A\u0005\n\t5\u0004b\u0003B9\u0001\u0001\u0007\t\u0011)Q\u0005\u0005KB1B!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003x!Y!q\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002BA\u0011-\u0011)\t\u0001a\u0001\u0002\u0003\u0006KA!\u001f\t\u0017\t\u001d\u0005\u00011AA\u0002\u0013%!\u0011\u0012\u0005\f\u0005#\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0019\nC\u0006\u0003\u0018\u0002\u0001\r\u0011!Q!\n\t-\u0005b\u0003BM\u0001\u0001\u0007\t\u0019!C\u0005\u00057C1B!*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003(\"Y!1\u0016\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BO\u0005-\u0019E.[3oiN+\u0018\u000e^3\u000b\u0005\u0001\u000b\u0015AB:vE6LGO\u0003\u0002C\u0007\u0006\u00191\u000eO:\u000b\u0005\u0011+\u0015A\u00023fa2|\u0017P\u0003\u0002G\u000f\u0006)1\u000f]1sW*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0007\u0001\u00192\u0001A'R!\tqu*D\u0001F\u0013\t\u0001VIA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003%Vk\u0011a\u0015\u0006\u0003)&\u000b\u0011b]2bY\u0006$Xm\u001d;\n\u0005Y\u001b&A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0003\"A\u0017\u0001\u000e\u0003}\n\u0001\u0002Z8SKR,(O\u001c\u000b\u0003;\u0016\u0004\"AX2\u000e\u0003}S!\u0001Y1\u0002\u0011M$XO\u00192j]\u001eT!AY%\u0002\u000f5|7m[5u_&\u0011Am\u0018\u0002\b'R,(MY3s\u0011\u00151'\u00011\u0001h\u0003\u00151\u0018\r\\;f!\tA7.D\u0001j\u0015\u0005Q\u0017!B:dC2\f\u0017B\u00017j\u0005\r\te._\u0001\u000f\tJKe+\u0012*`!>#u,V%E+\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\u0011\u0013\u0016JV#S?B{EiX+J\t\u0002\na\u0003\u0012*J-\u0016\u0013v\fU(E?\u0006\u0003\u0016j\u0018,F%NKuJT\u0001\u0018\tJKe+\u0012*`!>#u,\u0011)J?Z+%kU%P\u001d\u0002\nq\u0002\u0012*J-\u0016\u0013v\fU(E?.Ke\nR\u0001\u0011\tJKe+\u0012*`!>#ulS%O\t\u0002\n!dS+C\u000bJsU\tV#T?J+5kT+S\u0007\u0016{\u0006KU#G\u0013b\u000b1dS+C\u000bJsU\tV#T?J+5kT+S\u0007\u0016{\u0006KU#G\u0013b\u0003\u0013\u0001\u0003)P\t~s\u0015)T#\u0002\u0013A{Ei\u0018(B\u001b\u0016\u0003\u0013AD\"P\u001dR\u000b\u0015JT#S?:\u000bU*R\u0001\u0010\u0007>sE+Q%O\u000bJ{f*Q'FA\u0005)\"+R*P\u0019Z+Ei\u0018&B-\u0006{v\n\u0015+J\u001f:\u001bVCAA\u0005!\u0019\tY!!\u0006p_6\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005j[6,H/\u00192mK*\u0019\u00111C5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u00055!aA'ba\u00061\"+R*P\u0019Z+Ei\u0018&B-\u0006{v\n\u0015+J\u001f:\u001b\u0006%\u0001\tC+&cEk\u0018#S\u0013Z+%k\u0018)P\tV\u0011\u0011q\u0004\t\u0005\u0003C\t9$\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0015iw\u000eZ3m\u0015\u0011\tI#a\u000b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002.\u0005=\u0012AC6vE\u0016\u0014h.\u001a;fg*!\u0011\u0011GA\u001a\u0003\u001d1\u0017M\u0019:jGbR!!!\u000e\u0002\u0005%|\u0017\u0002BA\u001d\u0003G\u00111\u0001U8e\u0003E\u0011U+\u0013'U?\u0012\u0013\u0016JV#S?B{E\tI\u0001\u0017\u0005VKE\nV0E%&3VIU0D\u001f:#\u0016)\u0013(F%V\u0011\u0011\u0011\t\t\u0005\u0003C\t\u0019%\u0003\u0003\u0002F\u0005\r\"!C\"p]R\f\u0017N\\3s\u0003]\u0011U+\u0013'U?\u0012\u0013\u0016JV#S?\u000e{e\nV!J\u001d\u0016\u0013\u0006%\u0001\u000bB\t\u0012KE+S(O\u00032{&+R*P+J\u001bUiU\u000b\u0003\u0003\u001b\u0002b!a\u0014\u0002R\u0005USBAA\t\u0013\u0011\t\u0019&!\u0005\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\"\u0005]\u0013\u0002BA-\u0003G\u0011aaU3de\u0016$\u0018!F!E\t&#\u0016j\u0014(B\u0019~\u0013ViU(V%\u000e+5\u000bI\u0001\u0016\u0005VKE\nV0L+\n+%KT#U\u000bN{6\u000bU#D+\t\t\t\u0007\u0005\u0003\u0002d\u0005\u0015T\"A!\n\u0007\u0005\u001d\u0014I\u0001\u000bLk\n,'O\\3uKN$%/\u001b<feN\u0003XmY\u0001\u0017\u0005VKE\nV0L+\n+%KT#U\u000bN{6\u000bU#DA\u00059b)\u0016'M?\u0016C\u0006+R\"U\u000b\u0012{6i\u0014(U\u0003&sUIU\u0001\u0019\rVcEjX#Y!\u0016\u001bE+\u0012#`\u0007>sE+Q%O\u000bJ\u0003\u0013aC&F3~#vj\u0018)B)\"+\"!a\u001d\u0011\t\u0005\u0005\u0012QO\u0005\u0005\u0003o\n\u0019CA\u0005LKf$v\u000eU1uQ\u0006a1*R-`)>{\u0006+\u0011+IA\u0005ya-\u001e7m\u000bb\u0004Xm\u0019;fIB{G\r\u0006\u0003\u0002 \u0005}\u0004\"CAA;A\u0005\t\u0019AAB\u0003)YW-\u001f+p!\u0006$\bn\u001d\t\u0007\u0003\u000b\u000b)*a\u001d\u000f\t\u0005\u001d\u0015\u0011\u0013\b\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011QR&\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0017bAAJS\u00069\u0001/Y2lC\u001e,\u0017\u0002BAL\u00033\u0013A\u0001T5ti*\u0019\u00111S5\u00023\u0019,H\u000e\\#ya\u0016\u001cG/\u001a3Q_\u0012$C-\u001a4bk2$H%M\u000b\u0003\u0003?SC!a!\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.&\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bq_\u0012<\u0016\u000e\u001e5Po:,'OU3gKJ,gnY3\u0015\t\u0005}\u0011q\u0017\u0005\n\u0003\u0003{\u0002\u0013!a\u0001\u0003\u0007\u000bq\u0004]8e/&$\bnT<oKJ\u0014VMZ3sK:\u001cW\r\n3fM\u0006,H\u000e\u001e\u00132\u0003)\nE\tR%U\u0013>s\u0015\tT0S\u000bN{UKU\"F'~;\u0016\n\u0016%`\u001f^sUIU0S\u000b\u001a+%+\u0012(D\u000bN\u000b1&\u0011#E\u0013RKuJT!M?J+5kT+S\u0007\u0016\u001bvlV%U\u0011~{uKT#S?J+e)\u0012*F\u001d\u000e+5\u000bI\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\"!a1\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002,\u000511\r\\5f]RLA!!4\u0002H\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0015WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R|F%Z9\u0015\t\u0005M\u0017\u0011\u001c\t\u0004Q\u0006U\u0017bAAlS\n!QK\\5u\u0011%\tY\u000eJA\u0001\u0002\u0004\t\u0019-A\u0002yIE\n\u0011c[;cKJtW\r^3t\u00072LWM\u001c;!Q\r)\u0013\u0011\u001d\t\u0005\u0003G\f)/D\u0001b\u0013\r\t9/\u0019\u0002\u0005\u001b>\u001c7.A\u0007q_\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003[\u0004B!a<\u0003\n9!\u0011\u0011\u001fB\u0003\u001d\u0011\t\u0019Pa\u0001\u000f\t\u0005U(\u0011\u0001\b\u0005\u0003o\fyP\u0004\u0003\u0002z\u0006uh\u0002BAE\u0003wL\u0011AS\u0005\u0003\u0011&K!AR$\n\u0005\u0011+\u0015B\u0001\"D\u0013\r\u00119!Q\u0001\u000f\r\u0006\u0014'/[29\u00032L\u0017m]3t\u0013\u0011\u0011YA!\u0004\u0003\tA{Ei\u0015\u0006\u0004\u0005\u000f\t\u0015!\u00059pI>\u0003XM]1uS>t7o\u0018\u0013fcR!\u00111\u001bB\n\u0011%\tYnJA\u0001\u0002\u0004\ti/\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0007!\n\t/A\u0005oC6,G\rU8egV\u0011!Q\u0004\t\t\u0005?\u0011)#a\b\u0003*5\u0011!\u0011\u0005\u0006\u0005\u0005G\t9-A\u0002eg2LAAa\n\u0003\"\tY\u0001k\u001c3SKN|WO]2f!\u0011\t\tCa\u000b\n\t\t5\u00121\u0005\u0002\f\t>tW-\u00192mKB{G-A\u0007oC6,G\rU8eg~#S-\u001d\u000b\u0005\u0003'\u0014\u0019\u0004C\u0005\u0002\\*\n\t\u00111\u0001\u0003\u001e\u0005Qa.Y7fIB{Gm\u001d\u0011)\u0007-\n\t/A\fm_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195feV\u0011!Q\b\t\u00045\n}\u0012b\u0001B!\u007f\t9Bj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]\u0001\u001cY><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ|F%Z9\u0015\t\u0005M'q\t\u0005\n\u00037l\u0013\u0011!a\u0001\u0005{\t\u0001\u0004\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:!Q\rq\u0013\u0011]\u0001\u000eIJLg/\u001a:Ck&dG-\u001a:\u0016\u0005\tE\u0003c\u0001.\u0003T%\u0019!QK \u0003/-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u0014()^5mI\u0016\u0014\u0018!\u00053sSZ,'OQ;jY\u0012,'o\u0018\u0013fcR!\u00111\u001bB.\u0011%\tY\u000eMA\u0001\u0002\u0004\u0011\t&\u0001\bee&4XM\u001d\"vS2$WM\u001d\u0011)\u0007E\n\t/\u0001\u0007sKN|WO]2f\u0019&\u001cH/\u0006\u0002\u0003fA!\u0011q\u001eB4\u0013\u0011\u0011IG!\u0004\u0003\u001bI+5kT+S\u0007\u0016{F*S*U\u0003A\u0011Xm]8ve\u000e,G*[:u?\u0012*\u0017\u000f\u0006\u0003\u0002T\n=\u0004\"CAng\u0005\u0005\t\u0019\u0001B3\u00035\u0011Xm]8ve\u000e,G*[:uA!\u001aA'!9\u0002\u000b-\u001cwN\u001c4\u0016\u0005\te\u0004\u0003BA2\u0005wJ1A! B\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oM\u0006I1nY8oM~#S-\u001d\u000b\u0005\u0003'\u0014\u0019\tC\u0005\u0002\\Z\n\t\u00111\u0001\u0003z\u000511nY8oM\u0002\n\u0001d\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s+\t\u0011Y\t\u0005\u0004\u0002d\n5\u0015qD\u0005\u0004\u0005\u001f\u000b'AD!sOVlWM\u001c;DCB$xN]\u0001\u001dGJ,\u0017\r^3e!>$\u0017I]4v[\u0016tGoQ1qi>\u0014x\fJ3r)\u0011\t\u0019N!&\t\u0013\u0005m\u0017(!AA\u0002\t-\u0015!G2sK\u0006$X\r\u001a)pI\u0006\u0013x-^7f]R\u001c\u0015\r\u001d;pe\u0002\nad\u0019:fCR,GMU3t_V\u00148-Z:Be\u001e,X.\u001a8u\u0007\u0006\u0004Ho\u001c:\u0016\u0005\tu\u0005CBAr\u0005\u001b\u0013y\n\u0005\u0003\u0002\"\t\u0005\u0016\u0002\u0002BR\u0003G\u00111\u0002S1t\u001b\u0016$\u0018\rZ1uC\u0006\u00113M]3bi\u0016$'+Z:pkJ\u001cWm]!sOVlWM\u001c;DCB$xN]0%KF$B!a5\u0003*\"I\u00111\u001c\u001f\u0002\u0002\u0003\u0007!QT\u0001 GJ,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f%oZ;nK:$8)\u00199u_J\u0004\u0003")
public class ClientSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_POD_UID;
    private final String DRIVER_POD_API_VERSION;
    private final String DRIVER_POD_KIND;
    private final String KUBERNETES_RESOURCE_PREFIX;
    private final String POD_NAME;
    private final String CONTAINER_NAME;
    private final Map<String, String> RESOLVED_JAVA_OPTIONS;
    private final Pod BUILT_DRIVER_POD;
    private final Container BUILT_DRIVER_CONTAINER;
    private final Seq<Secret> ADDITIONAL_RESOURCES;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC;
    private final Container FULL_EXPECTED_CONTAINER;
    private final KeyToPath KEY_TO_PATH;
    private final Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private PodResource<Pod, DoneablePod> namedPods;
    @Mock
    private LoggingPodStatusWatcher loggingPodStatusWatcher;
    @Mock
    private KubernetesDriverBuilder driverBuilder;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> resourceList;
    private KubernetesDriverConf kconf;
    private ArgumentCaptor<Pod> createdPodArgumentCaptor;
    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String DRIVER_POD_API_VERSION() {
        return this.DRIVER_POD_API_VERSION;
    }

    private String DRIVER_POD_KIND() {
        return this.DRIVER_POD_KIND;
    }

    private String KUBERNETES_RESOURCE_PREFIX() {
        return this.KUBERNETES_RESOURCE_PREFIX;
    }

    private String POD_NAME() {
        return this.POD_NAME;
    }

    private String CONTAINER_NAME() {
        return this.CONTAINER_NAME;
    }

    private Map<String, String> RESOLVED_JAVA_OPTIONS() {
        return this.RESOLVED_JAVA_OPTIONS;
    }

    private Pod BUILT_DRIVER_POD() {
        return this.BUILT_DRIVER_POD;
    }

    private Container BUILT_DRIVER_CONTAINER() {
        return this.BUILT_DRIVER_CONTAINER;
    }

    private Seq<Secret> ADDITIONAL_RESOURCES() {
        return this.ADDITIONAL_RESOURCES;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC() {
        return this.BUILT_KUBERNETES_SPEC;
    }

    private Container FULL_EXPECTED_CONTAINER() {
        return this.FULL_EXPECTED_CONTAINER;
    }

    private KeyToPath KEY_TO_PATH() {
        return this.KEY_TO_PATH;
    }

    private Pod fullExpectedPod(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(this.BUILT_DRIVER_POD()).editSpec().addToContainers(new Container[]{this.FULL_EXPECTED_CONTAINER()}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withNewConfigMap().withItems((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyToPaths).asJava()).withName(KubernetesClientUtils$.MODULE$.configMapNameDriver())).endConfigMap()).endVolume()).endSpec()).build();
    }

    private List<KeyToPath> fullExpectedPod$default$1() {
        return new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$);
    }

    private Pod podWithOwnerReference(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluentImpl)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(this.fullExpectedPod(keyToPaths)).editMetadata().withUid(this.DRIVER_POD_UID())).endMetadata()).withApiVersion(this.DRIVER_POD_API_VERSION())).withKind(this.DRIVER_POD_KIND())).build();
    }

    private List<KeyToPath> podWithOwnerReference$default$1() {
        return new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$);
    }

    private Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private PodResource<Pod, DoneablePod> namedPods() {
        return this.namedPods;
    }

    private void namedPods_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.namedPods = x$1;
    }

    private LoggingPodStatusWatcher loggingPodStatusWatcher() {
        return this.loggingPodStatusWatcher;
    }

    private void loggingPodStatusWatcher_$eq(LoggingPodStatusWatcher x$1) {
        this.loggingPodStatusWatcher = x$1;
    }

    private KubernetesDriverBuilder driverBuilder() {
        return this.driverBuilder;
    }

    private void driverBuilder_$eq(KubernetesDriverBuilder x$1) {
        this.driverBuilder = x$1;
    }

    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> resourceList() {
        return this.resourceList;
    }

    private void resourceList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> x$1) {
        this.resourceList = x$1;
    }

    private KubernetesDriverConf kconf() {
        return this.kconf;
    }

    private void kconf_$eq(KubernetesDriverConf x$1) {
        this.kconf = x$1;
    }

    private ArgumentCaptor<Pod> createdPodArgumentCaptor() {
        return this.createdPodArgumentCaptor;
    }

    private void createdPodArgumentCaptor_$eq(ArgumentCaptor<Pod> x$1) {
        this.createdPodArgumentCaptor = x$1;
    }

    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor() {
        return this.createdResourcesArgumentCaptor;
    }

    private void createdResourcesArgumentCaptor_$eq(ArgumentCaptor<HasMetadata> x$1) {
        this.createdResourcesArgumentCaptor = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Object x$1) {
        return x$1 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Object x$2) {
        return x$2 instanceof ConfigMap;
    }

    public static final /* synthetic */ String $anonfun$new$8(int i) {
        return new StringBuilder(9).append("testConf.").append(i).toString();
    }

    private static final Tuple2 testSetup$1() {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        SparkConf sparkConf = new SparkConf(false).setSparkHome(tempDir.getAbsolutePath());
        File tempConfDir = new File(new StringBuilder(5).append(tempDir.getAbsolutePath()).append("/conf").toString());
        tempConfDir.mkdir();
        Set filteredConfFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-env.sh.template", "spark.properties", "spark-defaults.conf", "test.gz", "test2.jar", "non_utf8.txt"}));
        IndexedSeq confFileNames = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)i -> ClientSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"spark-env.sh", (List)Nil$.MODULE$), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)filteredConfFileNames, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testConfFiles = (IndexedSeq)confFileNames.map((Function1 & Serializable & scala.Serializable)i -> {
            File file = new File(new StringBuilder(1).append(tempConfDir.getAbsolutePath()).append("/").append((String)i).toString());
            Path path = i.startsWith("non_utf8") ? Files.write(file.toPath(), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)0, (byte)161}), ClassTag$.MODULE$.Byte()), new OpenOption[0]) : Files.write(file.toPath(), "conf1key=conf1value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return file.getName();
        }, IndexedSeq$.MODULE$.canBuildFrom());
        File[] $org_scalatest_assert_macro_left = tempConfDir.listFiles();
        int $org_scalatest_assert_macro_right = confFileNames.length();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        Seq expectedConfFiles = (Seq)testConfFiles.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)filteredConfFileNames.contains((Object)elem)));
        return new Tuple2((Object)sparkConf, (Object)expectedConfFiles);
    }

    public static final /* synthetic */ boolean $anonfun$new$13(Object x$5) {
        return x$5 instanceof ConfigMap;
    }

    public ClientSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_POD_UID = "pod-id";
        this.DRIVER_POD_API_VERSION = "v1";
        this.DRIVER_POD_KIND = "pod";
        this.KUBERNETES_RESOURCE_PREFIX = "resource-example";
        this.POD_NAME = "driver";
        this.CONTAINER_NAME = "container";
        this.RESOLVED_JAVA_OPTIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf1key"), (Object)"conf1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf2key"), (Object)"conf2value")}));
        this.BUILT_DRIVER_POD = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.POD_NAME())).endMetadata()).withNewSpec().withHostname("localhost")).endSpec()).build();
        this.BUILT_DRIVER_CONTAINER = ((ContainerBuilder)new ContainerBuilder().withName(this.CONTAINER_NAME())).build();
        this.ADDITIONAL_RESOURCES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName("secret")).endMetadata()).build()}));
        this.BUILT_KUBERNETES_SPEC = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.FULL_EXPECTED_CONTAINER = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(this.BUILT_DRIVER_CONTAINER()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        this.KEY_TO_PATH = new KeyToPath(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), Predef$.MODULE$.int2Integer(420), Constants$.MODULE$.SPARK_CONF_FILE_NAME());
        this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.ADDITIONAL_RESOURCES().map((Function1 & Serializable & scala.Serializable)secret -> ((SecretBuilder)((SecretFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new SecretBuilder(secret).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build(), Seq$.MODULE$.canBuildFrom());
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Some x$1 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, (Option<String>)x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.POD_NAME())).thenReturn(this.namedPods());
            this.createdPodArgumentCaptor_$eq((ArgumentCaptor<Pod>)ArgumentCaptor.forClass(Pod.class));
            this.createdResourcesArgumentCaptor_$eq((ArgumentCaptor<HasMetadata>)ArgumentCaptor.forClass(HasMetadata.class));
            Mockito.when((Object)this.podOperations().create((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()))).thenReturn((Object)this.podWithOwnerReference(this.podWithOwnerReference$default$1()));
            Mockito.when((Object)this.namedPods().watch((Object)this.loggingPodStatusWatcher())).thenReturn(MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Watch.class)));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.loggingPodStatusWatcher().watchOrStop(new StringBuilder(1).append(this.kconf().namespace()).append(":").append(this.POD_NAME()).toString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return ((KubernetesClient)this.doReturn(this.resourceList()).when((Object)this.kubernetesClient())).resourceList(new HasMetadata[]{(HasMetadata)this.createdResourcesArgumentCaptor().capture()});
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("The client should configure the pod using the builder.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("The client should create Kubernetes resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Seq secrets = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$4(x$1))))).toSeq();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right2 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$5(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ConfigMap)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Seq $org_scalatest_assert_macro_left3 = secrets;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left4).nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right3 = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            String $org_scalatest_assert_macro_left6 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right4 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            String $org_scalatest_assert_macro_left7 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right5 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("All files from SPARK_CONF_DIR, except templates, spark config, binary files and are within size limit, should be populated to pod's configMap.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            Seq expectedConfFiles;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = ClientSuite.testSetup$1();
                    if (tuple2 == null) break block2;
                    SparkConf sparkConf2 = (SparkConf)tuple2._1();
                    expectedConfFiles = (Seq)tuple2._2();
                    if (sparkConf2 == null) break block2;
                    sparkConf = sparkConf2;
                    if (expectedConfFiles != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Seq seq = expectedConfFiles;
            Tuple2 tuple2 = new Tuple2((Object)sparkConf, (Object)seq);
            Tuple2 tuple22 = tuple2;
            SparkConf sparkConf3 = (SparkConf)tuple22._1();
            Seq expectedConfFiles2 = (Seq)tuple22._2();
            List expectedKeyToPaths = (List)((SeqLike)((TraversableOnce)expectedConfFiles2.map((Function1 & Serializable & scala.Serializable)x -> new KeyToPath(x, Predef$.MODULE$.int2Integer(420), x), Seq$.MODULE$.canBuildFrom())).toList().$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x -> x.getKey(), (Ordering)Ordering.String$.MODULE$);
            Mockito.when((Object)this.podOperations().create((Object)this.fullExpectedPod((List<KeyToPath>)expectedKeyToPaths))).thenReturn((Object)this.podWithOwnerReference((List<KeyToPath>)expectedKeyToPaths));
            SparkConf x$15 = sparkConf3;
            Some x$16 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            String x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$15, x$17, x$18, x$19, x$20, (Option<String>)x$16, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.kconf().sparkConf().getOption("spark.home").isDefined(), "ClientSuite.this.kconf.sparkConf.getOption(\"spark.home\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$13(x$5))))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ConfigMap)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            String configMapName = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            String $org_scalatest_assert_macro_left2 = configMap.getMetadata().getName();
            String $org_scalatest_assert_macro_right = configMapName;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            Set configMapLoadedFiles = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(configMap.getData().keySet()).asScala()).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(configMapLoadedFiles);
            Set $org_scalatest_assert_macro_right2 = (Set)expectedConfFiles2.toSet().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Constants$.MODULE$.SPARK_CONF_FILE_NAME()})));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            configMapLoadedFiles.foreach((Function1 & Serializable & scala.Serializable)f -> {
                String $org_scalatest_assert_macro_left = (String)configMap.getData().get(f);
                String $org_scalatest_assert_macro_right = "conf1key=conf1value";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            });
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("Waiting for app completion should stall on the watcher", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return ((LoggingPodStatusWatcher)Mockito.verify((Object)this.loggingPodStatusWatcher())).watchOrStop(new StringBuilder(7).append(this.kconf().namespace()).append(":driver").toString());
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
    }
}

