/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import java.time.Instant;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.resource.ResourceProfile$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class ExecutorLifecycleTestUtils$ {
    public static ExecutorLifecycleTestUtils$ MODULE$;
    private final String TEST_SPARK_APP_ID;

    static {
        new ExecutorLifecycleTestUtils$();
    }

    public String TEST_SPARK_APP_ID() {
        return this.TEST_SPARK_APP_ID;
    }

    public Pod failedExecutorWithoutDeletion(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("failed").withStartTime(Instant.now().toString()).addNewContainerStatus().withName("spark-executor").withImage("k8s-spark").withNewState().withNewTerminated().withMessage("Failed").withExitCode(Predef$.MODULE$.int2Integer(1))).endTerminated()).endState()).endContainerStatus()).addNewContainerStatus().withName("spark-executor-sidecar").withImage("k8s-spark-sidecar").withNewState().withNewTerminated().withMessage("Failed").withExitCode(Predef$.MODULE$.int2Integer(1))).endTerminated()).endState()).endContainerStatus()).withMessage("Executor failed.").withReason("Executor failed because of a thrown error.")).endStatus()).build();
    }

    public int failedExecutorWithoutDeletion$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod pendingExecutor(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("pending").withStartTime(Instant.now().toString())).endStatus()).build();
    }

    public int pendingExecutor$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod runningExecutor(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("running").withStartTime(Instant.now().toString())).endStatus()).build();
    }

    public int runningExecutor$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod runningExecutorWithFailedContainer(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("running").addNewContainerStatus().withNewState().withNewTerminated().withExitCode(Predef$.MODULE$.int2Integer(1))).endTerminated()).endState()).endContainerStatus()).addNewContainerStatus().withNewState().withNewRunning().endRunning()).endState()).endContainerStatus()).endStatus()).build();
    }

    public int runningExecutorWithFailedContainer$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod finishedExecutorWithRunningSidecar(long executorId, int exitCode) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())).editOrNewStatus().withPhase("running").addNewContainerStatus().withName(Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME()).withNewState().withNewTerminated().withMessage("message").withExitCode(Predef$.MODULE$.int2Integer(exitCode))).endTerminated()).endState()).endContainerStatus()).addNewContainerStatus().withName("SIDECARFRIEND").withNewState().withNewRunning().endRunning()).endState()).endContainerStatus()).endStatus()).build();
    }

    public Pod succeededExecutor(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("succeeded")).endStatus()).build();
    }

    public int succeededExecutor$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod deletedExecutor(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewMetadata().withDeletionTimestamp("523012521")).endMetadata()).build();
    }

    public int deletedExecutor$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod unknownExecutor(long executorId, int rpId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId, rpId)).editOrNewStatus().withPhase("unknown")).endStatus()).build();
    }

    public int unknownExecutor$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public Pod podWithAttachedContainerForId(long executorId, int rpId) {
        SparkPod sparkPod = this.executorPodWithId(executorId, rpId);
        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(sparkPod.pod()).editOrNewSpec().addToContainers(new Container[]{sparkPod.container()})).endSpec()).build();
        return podWithAttachedContainer;
    }

    public int podWithAttachedContainerForId$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public SparkPod executorPodWithId(long executorId, int rpId) {
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(new StringBuilder(15).append("spark-executor-").append(executorId).toString()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), ((Object)BoxesRunTime.boxToLong((long)executorId)).toString()).addToLabels(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL(), ((Object)BoxesRunTime.boxToInteger((int)rpId)).toString())).endMetadata()).editOrNewSpec().withRestartPolicy("Never")).endSpec()).build();
        Container container = ((ContainerBuilder)((ContainerFluentImpl)new ContainerBuilder().withName("spark-executor")).withImage("k8s-spark")).build();
        return new SparkPod(pod, container);
    }

    public int executorPodWithId$default$2() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    private ExecutorLifecycleTestUtils$() {
        MODULE$ = this;
        this.TEST_SPARK_APP_ID = "spark-app-id";
    }
}

