/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0017/\u0001mBQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004U\u0001\u0001\u0006I\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019)\u0007\u0001)A\u0005/\"9a\r\u0001b\u0001\n\u00139\u0007BB6\u0001A\u0003%\u0001\u000eC\u0004m\u0001\t\u0007I\u0011B7\t\rQ\u0004\u0001\u0015!\u0003o\u0011\u001d)\bA1A\u0005\nYDa! \u0001!\u0002\u00139\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003\u000f\u0001\u0001\u0015!\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0001\u0011!\ti\u0001\u0001b\u0001\n\u0013y\b\u0002CA\b\u0001\u0001\u0006I!!\u0001\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011q\u0004\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0003C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005\u0005\u0002bCA\u001f\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fA1\"!\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002P!Y\u00111\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA!\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\t\u0017\u0005U\u0005\u00011AA\u0002\u0013%\u0011q\u0013\u0005\f\u00037\u0003\u0001\u0019!A!B\u0013\t9\u0007C\u0006\u0002 \u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0006bCAU\u0001\u0001\u0007\t\u0019!C\u0005\u0003WC1\"a,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002$\"Y\u00111\u0017\u0001A\u0002\u0003\u0007I\u0011BA[\u0011-\tI\r\u0001a\u0001\u0002\u0004%I!a3\t\u0017\u0005=\u0007\u00011A\u0001B\u0003&\u0011q\u0017\u0005\f\u0003'\u0004\u0001\u0019!a\u0001\n\u0013\t)\u000eC\u0006\u0002^\u0002\u0001\r\u00111A\u0005\n\u0005}\u0007bCAr\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/D1\"a:\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002j\"Y\u0011\u0011\u001f\u0001A\u0002\u0003\u0007I\u0011BAz\u0011-\t9\u0010\u0001a\u0001\u0002\u0003\u0006K!a;\t\u0017\u0005e\b\u00011AA\u0002\u0013%\u00111 \u0005\f\u0005\u0007\u0001\u0001\u0019!a\u0001\n\u0013\u0011)\u0001C\u0006\u0003\n\u0001\u0001\r\u0011!Q!\n\u0005u\bb\u0002B\u0006\u0001\u0011%!Q\u0002\u0002\u001b\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s'VLG/\u001a\u0006\u0003_A\n1a\u001b\u001dt\u0015\t\t$'A\u0004dYV\u001cH/\u001a:\u000b\u0005M\"\u0014!C:dQ\u0016$W\u000f\\3s\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0002\u0005CA\u001f?\u001b\u0005!\u0014BA 5\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tO\u0001\ng\u000e\fG.\u0019;fgRL!!\u0012\"\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u00061A(\u001b8jiz\"\u0012\u0001\u0013\t\u0003\u0013\u0002i\u0011AL\u0001\u000eIJLg/\u001a:Q_\u0012t\u0015-\\3\u0016\u00031\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0004TiJLgnZ\u0001\u000fIJLg/\u001a:Q_\u0012t\u0015-\\3!\u0003%!'/\u001b<feB{G-F\u0001X!\tA6-D\u0001Z\u0015\tQ6,A\u0003n_\u0012,GN\u0003\u0002];\u0006\u0019\u0011\r]5\u000b\u0005y{\u0016AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0001-Y\u0001\bM\u0006\u0014'/[29\u0015\u0005\u0011\u0017AA5p\u0013\t!\u0017LA\u0002Q_\u0012\f!\u0002\u001a:jm\u0016\u0014\bk\u001c3!\u0003\u0011\u0019wN\u001c4\u0016\u0003!\u0004\"!P5\n\u0005)$$!C*qCJ\\7i\u001c8g\u0003\u0015\u0019wN\u001c4!\u00039!WMZ1vYR\u0004&o\u001c4jY\u0016,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cR\n\u0001B]3t_V\u00148-Z\u0005\u0003gB\u0014qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0010I\u00164\u0017-\u001e7u!J|g-\u001b7fA\u0005\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT\u0011A_\u0001\u0006g\u000e\fG.Y\u0005\u0003yf\u00141!\u00138u\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]NK'0\u001a\u0011\u0002%A|G-\u00117m_\u000e\fG/[8o\t\u0016d\u0017-_\u000b\u0003\u0003\u0003\u00012\u0001_A\u0002\u0013\r\t)!\u001f\u0002\u0005\u0019>tw-A\nq_\u0012\fE\u000e\\8dCRLwN\u001c#fY\u0006L\b%A\nfq\u0016\u001cW\u000f^8s\u0013\u0012dW\rV5nK>,H/\u0001\u000bfq\u0016\u001cW\u000f^8s\u0013\u0012dW\rV5nK>,H\u000fI\u0001\u0013a>$7I]3bi&|g\u000eV5nK>,H/A\nq_\u0012\u001c%/Z1uS>tG+[7f_V$\b%\u0001\u0004tK\u000eluM]\u000b\u0003\u0003+\u00012!PA\f\u0013\r\tI\u0002\u000e\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u000691/Z2NOJ\u0004\u0013\u0001G<bSR4uN]#yK\u000e,Ho\u001c:Q_\u0012\u001c8\t\\8dWV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\t)CA\u0006NC:,\u0018\r\\\"m_\u000e\\\u0017\u0001H<bSR4uN]#yK\u000e,Ho\u001c:Q_\u0012\u001c8\t\\8dW~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u0002y\u0003gI1!!\u000ez\u0005\u0011)f.\u001b;\t\u0013\u0005eR#!AA\u0002\u0005\u0005\u0012a\u0001=%c\u0005Ir/Y5u\r>\u0014X\t_3dkR|'\u000fU8eg\u000ecwnY6!\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG/\u0006\u0002\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002Hu\u000baa\u00197jK:$\u0018\u0002BA&\u0003\u000b\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002)-,(-\u001a:oKR,7o\u00117jK:$x\fJ3r)\u0011\t\t$!\u0015\t\u0013\u0005e\u0002$!AA\u0002\u0005\u0005\u0013!E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8uA!\u001a\u0011$a\u0016\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u00189\u0003\u001diwnY6ji>LA!!\u0019\u0002\\\t!Qj\\2l\u00035\u0001x\u000eZ(qKJ\fG/[8ogV\u0011\u0011q\r\t\u0005\u0003S\nyI\u0004\u0003\u0002l\u0005%e\u0002BA7\u0003\u000bsA!a\u001c\u0002\u0002:!\u0011\u0011OA@\u001d\u0011\t\u0019(! \u000f\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f;\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u00028q%\u0011QGN\u0005\u0004\u0003\u0007#\u0014A\u00023fa2|\u00170C\u00020\u0003\u000fS1!a!5\u0013\u0011\tY)!$\u0002\u001d\u0019\u000b'M]5dq\u0005c\u0017.Y:fg*\u0019q&a\"\n\t\u0005E\u00151\u0013\u0002\u0005!>#5K\u0003\u0003\u0002\f\u00065\u0015!\u00059pI>\u0003XM]1uS>t7o\u0018\u0013fcR!\u0011\u0011GAM\u0011%\tIdGA\u0001\u0002\u0004\t9'\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0007q\t9&A\u0006mC\n,G.\u001a3Q_\u0012\u001cXCAAR!\u0011\tI'!*\n\t\u0005\u001d\u00161\u0013\u0002\r\u0019\u0006\u0013U\tT#E?B{EiU\u0001\u0010Y\u0006\u0014W\r\\3e!>$7o\u0018\u0013fcR!\u0011\u0011GAW\u0011%\tIDHA\u0001\u0002\u0004\t\u0019+\u0001\u0007mC\n,G.\u001a3Q_\u0012\u001c\b\u0005K\u0002 \u0003/\n1\u0003\u001a:jm\u0016\u0014\bk\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!a.\u0011\u000f\u0005e\u0016qX,\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000b)%A\u0002eg2LA!!1\u0002<\nY\u0001k\u001c3SKN|WO]2f!\rA\u0016QY\u0005\u0004\u0003\u000fL&a\u0003#p]\u0016\f'\r\\3Q_\u0012\fq\u0003\u001a:jm\u0016\u0014\bk\u001c3Pa\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\t\u0005E\u0012Q\u001a\u0005\n\u0003s\t\u0013\u0011!a\u0001\u0003o\u000bA\u0003\u001a:jm\u0016\u0014\bk\u001c3Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003f\u0001\u0012\u0002X\u0005yQ\r_3dkR|'OQ;jY\u0012,'/\u0006\u0002\u0002XB\u0019\u0011*!7\n\u0007\u0005mgFA\rLk\n,'O\\3uKN,\u00050Z2vi>\u0014()^5mI\u0016\u0014\u0018aE3yK\u000e,Ho\u001c:Ck&dG-\u001a:`I\u0015\fH\u0003BA\u0019\u0003CD\u0011\"!\u000f%\u0003\u0003\u0005\r!a6\u0002!\u0015DXmY;u_J\u0014U/\u001b7eKJ\u0004\u0003fA\u0013\u0002X\u0005q1O\\1qg\"|Go]*u_J,WCAAv!\rI\u0015Q^\u0005\u0004\u0003_t#a\n#fi\u0016\u0014X.\u001b8jgRL7-\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\f!c\u001d8baNDw\u000e^:Ti>\u0014Xm\u0018\u0013fcR!\u0011\u0011GA{\u0011%\tIdJA\u0001\u0002\u0004\tY/A\bt]\u0006\u00048\u000f[8ugN#xN]3!\u0003Y\u0001x\u000eZ:BY2|7-\u0019;peVsG-\u001a:UKN$XCAA\u007f!\rI\u0015q`\u0005\u0004\u0005\u0003q#!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u001ba>$7/\u00117m_\u000e\fGo\u001c:V]\u0012,'\u000fV3ti~#S-\u001d\u000b\u0005\u0003c\u00119\u0001C\u0005\u0002:)\n\t\u00111\u0001\u0002~\u00069\u0002o\u001c3t\u00032dwnY1u_J,f\u000eZ3s)\u0016\u001cH\u000fI\u0001\u0012Kb,7-\u001e;peB{G-\u00118to\u0016\u0014HC\u0001B\b!\u0019\u0011\tBa\u0006\u0003\u001c5\u0011!1\u0003\u0006\u0005\u0005+\tY&\u0001\u0005tiV\u0014'-\u001b8h\u0013\u0011\u0011IBa\u0005\u0003\r\u0005s7o^3s!\u0011\u0011iBa\b\u000e\u0005\u00055\u0015\u0002\u0002B\u0011\u0003\u001b\u0013acS;cKJtW\r^3t\u000bb,7-\u001e;peN\u0003Xm\u0019")
public class ExecutorPodsAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final ResourceProfile defaultProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long executorIdleTimeout;
    private final long podCreationTimeout;
    private final SecurityManager secMgr;
    private ManualClock waitForExecutorPodsClock;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch> labeledPods;
    @Mock
    private PodResource<Pod, DoneablePod> driverPodOperations;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsAllocator podsAllocatorUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private ManualClock waitForExecutorPodsClock() {
        return this.waitForExecutorPodsClock;
    }

    private void waitForExecutorPodsClock_$eq(ManualClock x$1) {
        this.waitForExecutorPodsClock = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch> x$1) {
        this.labeledPods = x$1;
    }

    private PodResource<Pod, DoneablePod> driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.driverPodOperations = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(ExecutorPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    private Answer<KubernetesExecutorSpec> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(new StringOps(Predef$.MODULE$.augmentString(k8sConf.executorId())).toInt(), k8sConf.resourceProfileId()), (Seq)Seq$.MODULE$.empty());
        };
    }

    public static final /* synthetic */ Pod $anonfun$new$3(ExecutorPodsAllocatorSuite $this, int nextId) {
        return (Pod)((Createable)Mockito.verify($this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(nextId, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
    }

    public ExecutorPodsAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT().key(), "10s");
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.driverPodName())).thenReturn(this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.waitForExecutorPodsClock_$eq(new ManualClock(0L));
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("Initially request executors in batches. Do not request another batch if the first has not finished.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach((Function1 & Serializable & scala.Serializable)nextId -> ExecutorPodsAllocatorSuite.$anonfun$new$3(this, BoxesRunTime.unboxToInt((Object)nextId)));
            return (Pod)((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Request executors in batches. Allow another batch to be requested if all pending executors start running.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            return (Pod)((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)(this.podAllocationSize() + 1)))).create(ArgumentMatchers.any(Pod.class));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("When a current batch reaches error states immediately, re-request them on the next batch.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.podAllocationSize()))})));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("When an executor is requested but the API does not report it in a reasonable time, retry requesting that executor.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podCreationTimeout() + 1L);
            this.snapshotsStore().notifySubscribers();
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("SPARK-28487: scale up and down on target executor count changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4))})));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"3", "4"});
            ((Deletable)Mockito.verify(this.podOperations())).delete();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("SPARK-34334: correctly identify timed out pending pod requests as excess", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create(ArgumentMatchers.any());
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            return (Boolean)((Deletable)Mockito.verify(this.podOperations())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("SPARK-33099: Respect executor idle timeout configuration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)5))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)5))).create(ArgumentMatchers.any());
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)0))})));
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2", "3", "4", "5"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2", "3", "4", "5"});
            return (Boolean)((Deletable)Mockito.verify(this.podOperations())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("SPARK-33288: multiple resource profiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)2))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, rp.id()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)3))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, this.defaultProfile().id()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, this.defaultProfile().id()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, this.defaultProfile().id()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(7L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(5L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(7L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"5", "6"});
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"7"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)2))).delete();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(6L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(7L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("SPARK-33262: pod allocator does not stall with pending pods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"2", "3", "4", "5", "6"})).thenReturn(this.podOperations());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)6))})));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podAllocationDelay() + 1L);
            this.snapshotsStore().notifySubscribers();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
    }
}

