/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileManager;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B A\u00015CQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004i\u0001\u0001\u0006IA\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019q\u0007\u0001)A\u0005W\"Iq\u000e\u0001a\u0001\u0002\u0004%I\u0001\u001d\u0005\ni\u0002\u0001\r\u00111A\u0005\nUD\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015B9\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0002C\u0006\u0002\u001e\u0001\u0001\r\u0011!Q!\n\u0005E\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0013\u0011-\tY\u0004\u0001a\u0001\u0002\u0004%I!!\u0010\t\u0017\u0005\u0015\u0003\u00011AA\u0002\u0013%\u0011q\t\u0005\f\u0003\u0017\u0002\u0001\u0019!A!B\u0013\ty\u0004C\u0006\u0002P\u0001\u0001\r\u00111A\u0005\n\u0005E\u0003bCA6\u0001\u0001\u0007\t\u0019!C\u0005\u0003[B1\"!\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002T!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\t9\u000b\u0001a\u0001\u0002\u0004%I!!+\t\u0017\u00055\u0006\u00011A\u0001B\u0003&\u0011\u0011\u0010\u0005\f\u0003c\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\fC\u0006\u0002<\u0002\u0001\r\u00111A\u0005\n\u0005u\u0006bCAa\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kC1\"!2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\"Y\u0011q\u001a\u0001A\u0002\u0003\u0007I\u0011BAi\u0011-\t)\u000e\u0001a\u0001\u0002\u0003\u0006K!!3\t\u0017\u0005e\u0007\u00011AA\u0002\u0013%\u00111\u001c\u0005\f\u0003G\u0004\u0001\u0019!a\u0001\n\u0013\t)\u000fC\u0006\u0002j\u0002\u0001\r\u0011!Q!\n\u0005u\u0007bCAw\u0001\u0001\u0007\t\u0019!C\u0005\u0003_D1\"!?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002|\"Y\u0011q \u0001A\u0002\u0003\u0005\u000b\u0015BAy\u0011-\u0011\u0019\u0001\u0001a\u0001\u0002\u0004%IA!\u0002\t\u0017\t5\u0001\u00011AA\u0002\u0013%!q\u0002\u0005\f\u0005'\u0001\u0001\u0019!A!B\u0013\u00119\u0001C\u0006\u0003\u0018\u0001\u0001\r\u00111A\u0005\n\te\u0001b\u0003B\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0005GA1Ba\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001c!Y!1\u0006\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0017\u0011-\u0011)\u0004\u0001a\u0001\u0002\u0004%IAa\u000e\t\u0017\tm\u0002\u00011A\u0001B\u0003&!q\u0006\u0005\f\u0005\u007f\u0001\u0001\u0019!a\u0001\n\u0013\u0011\t\u0005C\u0006\u0003J\u0001\u0001\r\u00111A\u0005\n\t-\u0003b\u0003B(\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0007B1Ba\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003V!Y!Q\f\u0001A\u0002\u0003\u0007I\u0011\u0002B0\u0011-\u0011\u0019\u0007\u0001a\u0001\u0002\u0003\u0006KAa\u0016\t\u0017\t\u001d\u0004\u00011AA\u0002\u0013%!\u0011\u000e\u0005\f\u0005o\u0002\u0001\u0019!a\u0001\n\u0013\u0011I\bC\u0006\u0003~\u0001\u0001\r\u0011!Q!\n\t-\u0004b\u0003B@\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0003C1B!#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\f\"Y!q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BB\u0011%\u0011\t\n\u0001b\u0001\n\u0013\u0011\u0019\n\u0003\u0005\u0003\u001c\u0002\u0001\u000b\u0011\u0002BK\u0011%\u0011i\n\u0001b\u0001\n\u0013\u0011y\n\u0003\u0005\u0003.\u0002\u0001\u000b\u0011\u0002BQ\u0011%\u0011y\u000b\u0001b\u0001\n\u0013\u0011\t\f\u0003\u0005\u0003:\u0002\u0001\u000b\u0011\u0002BZ\u0005\u0019ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e'VLG/\u001a\u0006\u0003\u0003\n\u000b1a\u001b\u001dt\u0015\t\u0019E)A\u0004dYV\u001cH/\u001a:\u000b\u0005\u00153\u0015!C:dQ\u0016$W\u000f\\3s\u0015\t9\u0005*A\u0003ta\u0006\u00148N\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0013\u0006CA(Q\u001b\u00051\u0015BA)G\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111KV\u0007\u0002)*\u0011QKS\u0001\ng\u000e\fG.\u0019;fgRL!a\u0016+\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u00061A(\u001b8jiz\"\u0012A\u0017\t\u00037\u0002i\u0011\u0001Q\u0001\u0019g\u000eDW\rZ;mKJ,\u00050Z2vi>\u00148+\u001a:wS\u000e,W#\u00010\u0011\u0005}3W\"\u00011\u000b\u0005\u0005\u0014\u0017AC2p]\u000e,(O]3oi*\u00111\rZ\u0001\u0004Y&\u0014'BA3K\u0003\u0015QWn\\2l\u0013\t9\u0007M\u0001\fEKR,'/\\5oSN$\u0018nY*dQ\u0016$W\u000f\\3s\u0003e\u00198\r[3ek2,'/\u0012=fGV$xN]*feZL7-\u001a\u0011\u0002\u0013M\u0004\u0018M]6D_:4W#A6\u0011\u0005=c\u0017BA7G\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006ta\u0006\u00148nQ8oM\u0002\n!a]2\u0016\u0003E\u0004\"a\u0014:\n\u0005M4%\u0001D*qCJ\\7i\u001c8uKb$\u0018AB:d?\u0012*\u0017\u000f\u0006\u0002wyB\u0011qO_\u0007\u0002q*\t\u00110A\u0003tG\u0006d\u0017-\u0003\u0002|q\n!QK\\5u\u0011\u001dix!!AA\u0002E\f1\u0001\u001f\u00132\u0003\r\u00198\r\t\u0015\u0004\u0011\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d!*A\u0004n_\u000e\\\u0017\u000e^8\n\t\u0005-\u0011Q\u0001\u0002\u0005\u001b>\u001c7.A\u0002f]Z,\"!!\u0005\u0011\u0007=\u000b\u0019\"C\u0002\u0002\u0016\u0019\u0013\u0001b\u00159be.,eN^\u0001\bK:4x\fJ3r)\r1\u00181\u0004\u0005\t{*\t\t\u00111\u0001\u0002\u0012\u0005!QM\u001c<!Q\rY\u0011\u0011A\u0001\u0007eB\u001cWI\u001c<\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-b)A\u0002sa\u000eLA!a\f\u0002*\t1!\u000b]2F]Z\f!B\u001d9d\u000b:4x\fJ3r)\r1\u0018Q\u0007\u0005\t{6\t\t\u00111\u0001\u0002&\u00059!\u000f]2F]Z\u0004\u0003f\u0001\b\u0002\u0002\u0005\tBM]5wKJ,e\u000e\u001a9pS:$(+\u001a4\u0016\u0005\u0005}\u0002\u0003BA\u0014\u0003\u0003JA!a\u0011\u0002*\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017!\u00063sSZ,'/\u00128ea>Lg\u000e\u001e*fM~#S-\u001d\u000b\u0004m\u0006%\u0003\u0002C?\u0011\u0003\u0003\u0005\r!a\u0010\u0002%\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oiJ+g\r\t\u0015\u0004#\u0005\u0005\u0011\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005\u001dTBAA,\u0015\u0011\tI&a\u0017\u0002\r\rd\u0017.\u001a8u\u0015\u0011\ti&a\u0018\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0003\u0002b\u0005\r\u0014a\u00024bEJL7\r\u000f\u0006\u0003\u0003K\n!![8\n\t\u0005%\u0014q\u000b\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fAc[;cKJtW\r^3t\u00072LWM\u001c;`I\u0015\fHc\u0001<\u0002p!AQpEA\u0001\u0002\u0004\t\u0019&A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B3\u0001FA\u0001\u00035\u0001x\u000eZ(qKJ\fG/[8ogV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\tK\u0004\u0003\u0002~\u0005me\u0002BA@\u0003/sA!!!\u0002\u0014:!\u00111QAI\u001d\u0011\t))a$\u000f\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#M\u0003\u0019a$o\\8u}%\t1*\u0003\u0002J\u0015&\u0011q\tS\u0005\u0004\u0003+3\u0015A\u00023fa2|\u00170C\u0002B\u00033S1!!&G\u0013\u0011\ti*a(\u0002\u001d\u0019\u000b'M]5dq\u0005c\u0017.Y:fg*\u0019\u0011)!'\n\t\u0005\r\u0016Q\u0015\u0002\u0005!>#5K\u0003\u0003\u0002\u001e\u0006}\u0015!\u00059pI>\u0003XM]1uS>t7o\u0018\u0013fcR\u0019a/a+\t\u0011u4\u0012\u0011!a\u0001\u0003s\na\u0002]8e\u001fB,'/\u0019;j_:\u001c\b\u0005K\u0002\u0018\u0003\u0003\t1\u0002\\1cK2,G\rU8egV\u0011\u0011Q\u0017\t\u0005\u0003w\n9,\u0003\u0003\u0002:\u0006\u0015&\u0001\u0004'B\u0005\u0016cU\tR0Q\u001f\u0012\u001b\u0016a\u00047bE\u0016dW\r\u001a)pIN|F%Z9\u0015\u0007Y\fy\f\u0003\u0005~3\u0005\u0005\t\u0019AA[\u00031a\u0017MY3mK\u0012\u0004v\u000eZ:!Q\rQ\u0012\u0011A\u0001\u0015G>tg-[4NCB\u001cx\n]3sCRLwN\\:\u0016\u0005\u0005%\u0007\u0003BA>\u0003\u0017LA!!4\u0002&\nY1i\u0014(G\u0013\u001e{V*\u0011)T\u0003a\u0019wN\u001c4jO6\u000b\u0007o](qKJ\fG/[8og~#S-\u001d\u000b\u0004m\u0006M\u0007\u0002C?\u001d\u0003\u0003\u0005\r!!3\u0002+\r|gNZ5h\u001b\u0006\u00048o\u00149fe\u0006$\u0018n\u001c8tA!\u001aQ$!\u0001\u0002!1\f'\r\\3e\u0007>tg-[4NCB\u001cXCAAo!\u0011\tY(a8\n\t\u0005\u0005\u0018Q\u0015\u0002\u0014\u0019\u0006\u0013U\tT#E?\u000e{eJR%H?6\u000b\u0005kU\u0001\u0015Y\u0006\u0014G.\u001a3D_:4\u0017nZ'baN|F%Z9\u0015\u0007Y\f9\u000f\u0003\u0005~?\u0005\u0005\t\u0019AAo\u0003Ea\u0017M\u00197fI\u000e{gNZ5h\u001b\u0006\u00048\u000f\t\u0015\u0004A\u0005\u0005\u0011!\u0004;bg.\u001c6\r[3ek2,'/\u0006\u0002\u0002rB!\u00111_A{\u001b\u0005!\u0015bAA|\t\n\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\u0002#Q\f7o[*dQ\u0016$W\u000f\\3s?\u0012*\u0017\u000fF\u0002w\u0003{D\u0001\" \u0012\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u000fi\u0006\u001c8nU2iK\u0012,H.\u001a:!Q\r\u0019\u0013\u0011A\u0001\u000bKZ,g\u000e^)vKV,WC\u0001B\u0004!\rY&\u0011B\u0005\u0004\u0005\u0017\u0001%AG#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017AD3wK:$\u0018+^3vK~#S-\u001d\u000b\u0004m\nE\u0001\u0002C?&\u0003\u0003\u0005\rAa\u0002\u0002\u0017\u00154XM\u001c;Rk\u0016,X\r\t\u0015\u0004M\u0005\u0005\u0011\u0001\u00049pI\u0006cGn\\2bi>\u0014XC\u0001B\u000e!\rY&QD\u0005\u0004\u0005?\u0001%!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0011a>$\u0017\t\u001c7pG\u0006$xN]0%KF$2A\u001eB\u0013\u0011!i\b&!AA\u0002\tm\u0011!\u00049pI\u0006cGn\\2bi>\u0014\b\u0005K\u0002*\u0003\u0003\tQ\u0003\\5gK\u000eL8\r\\3Fm\u0016tG\u000fS1oI2,'/\u0006\u0002\u00030A\u00191L!\r\n\u0007\tM\u0002I\u0001\u000fFq\u0016\u001cW\u000f^8s!>$7\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:\u000231Lg-Z2zG2,WI^3oi\"\u000bg\u000e\u001a7fe~#S-\u001d\u000b\u0004m\ne\u0002\u0002C?,\u0003\u0003\u0005\rAa\f\u0002-1Lg-Z2zG2,WI^3oi\"\u000bg\u000e\u001a7fe\u0002B3\u0001LA\u0001\u0003-9\u0018\r^2i\u000bZ,g\u000e^:\u0016\u0005\t\r\u0003cA.\u0003F%\u0019!q\t!\u0003?\u0015CXmY;u_J\u0004v\u000eZ:XCR\u001c\u0007n\u00158baNDw\u000e^*pkJ\u001cW-A\bxCR\u001c\u0007.\u0012<f]R\u001cx\fJ3r)\r1(Q\n\u0005\t{:\n\t\u00111\u0001\u0003D\u0005aq/\u0019;dQ\u00163XM\u001c;tA!\u001aq&!\u0001\u0002\u0015A|G\u000e\\#wK:$8/\u0006\u0002\u0003XA\u00191L!\u0017\n\u0007\tm\u0003IA\u0011Fq\u0016\u001cW\u000f^8s!>$7\u000fU8mY&twm\u00158baNDw\u000e^*pkJ\u001cW-\u0001\bq_2dWI^3oiN|F%Z9\u0015\u0007Y\u0014\t\u0007\u0003\u0005~c\u0005\u0005\t\u0019\u0001B,\u0003-\u0001x\u000e\u001c7Fm\u0016tGo\u001d\u0011)\u0007I\n\t!\u0001\bee&4XM]#oIB|\u0017N\u001c;\u0016\u0005\t-\u0004CBA\u0002\u0005[\u0012\t(\u0003\u0003\u0003p\u0005\u0015!AD!sOVlWM\u001c;DCB$xN\u001d\t\u0005\u0003O\u0011\u0019(\u0003\u0003\u0003v\u0005%\"a\u0003*qG\u0016sG\r]8j]R\f!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0019aOa\u001f\t\u0011u$\u0014\u0011!a\u0001\u0005W\nq\u0002\u001a:jm\u0016\u0014XI\u001c3q_&tG\u000fI\u0001\u001ag\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012,f\u000eZ3s)\u0016\u001cH/\u0006\u0002\u0003\u0004B\u00191L!\"\n\u0007\t\u001d\u0005IA\u0011Lk\n,'O\\3uKN\u001cE.^:uKJ\u001c6\r[3ek2,'OQ1dW\u0016tG-A\u000ftG\",G-\u001e7fe\n\u000b7m[3oIVsG-\u001a:UKN$x\fJ3r)\r1(Q\u0012\u0005\t{^\n\t\u00111\u0001\u0003\u0004\u0006Q2o\u00195fIVdWM\u001d\"bG.,g\u000eZ+oI\u0016\u0014H+Z:uA\u0005YA.[:uK:,'OQ;t+\t\u0011)\n\u0005\u0003\u0002t\n]\u0015b\u0001BM\t\nyA*\u001b<f\u0019&\u001cH/\u001a8fe\n+8/\u0001\u0007mSN$XM\\3s\u0005V\u001c\b%\u0001\fsKN|WO]2f!J|g-\u001b7f\u001b\u0006t\u0017mZ3s+\t\u0011\t\u000b\u0005\u0003\u0003$\n%VB\u0001BS\u0015\r\u00119KR\u0001\te\u0016\u001cx.\u001e:dK&!!1\u0016BS\u0005Y\u0011Vm]8ve\u000e,\u0007K]8gS2,W*\u00198bO\u0016\u0014\u0018a\u0006:fg>,(oY3Qe>4\u0017\u000e\\3NC:\fw-\u001a:!\u00039!WMZ1vYR\u0004&o\u001c4jY\u0016,\"Aa-\u0011\t\t\r&QW\u0005\u0005\u0005o\u0013)KA\bSKN|WO]2f!J|g-\u001b7f\u0003=!WMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0003")
public class KubernetesClusterSchedulerBackendSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final DeterministicScheduler schedulerExecutorService;
    private final SparkConf sparkConf;
    @Mock
    private SparkContext sc;
    @Mock
    private SparkEnv env;
    @Mock
    private RpcEnv rpcEnv;
    @Mock
    private RpcEndpointRef driverEndpointRef;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch> labeledPods;
    @Mock
    private MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMapsOperations;
    @Mock
    private FilterWatchListDeletable<ConfigMap, ConfigMapList, Boolean, Watch> labledConfigMaps;
    @Mock
    private TaskSchedulerImpl taskScheduler;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    @Mock
    private ExecutorPodsAllocator podAllocator;
    @Mock
    private ExecutorPodsLifecycleManager lifecycleEventHandler;
    @Mock
    private ExecutorPodsWatchSnapshotSource watchEvents;
    @Mock
    private ExecutorPodsPollingSnapshotSource pollEvents;
    private ArgumentCaptor<RpcEndpoint> driverEndpoint;
    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest;
    private final LiveListenerBus listenerBus;
    private final ResourceProfileManager resourceProfileManager;
    private final ResourceProfile defaultProfile;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private DeterministicScheduler schedulerExecutorService() {
        return this.schedulerExecutorService;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    private RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    private void rpcEnv_$eq(RpcEnv x$1) {
        this.rpcEnv = x$1;
    }

    private RpcEndpointRef driverEndpointRef() {
        return this.driverEndpointRef;
    }

    private void driverEndpointRef_$eq(RpcEndpointRef x$1) {
        this.driverEndpointRef = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch> x$1) {
        this.labeledPods = x$1;
    }

    private MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMapsOperations() {
        return this.configMapsOperations;
    }

    private void configMapsOperations_$eq(MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> x$1) {
        this.configMapsOperations = x$1;
    }

    private FilterWatchListDeletable<ConfigMap, ConfigMapList, Boolean, Watch> labledConfigMaps() {
        return this.labledConfigMaps;
    }

    private void labledConfigMaps_$eq(FilterWatchListDeletable<ConfigMap, ConfigMapList, Boolean, Watch> x$1) {
        this.labledConfigMaps = x$1;
    }

    private TaskSchedulerImpl taskScheduler() {
        return this.taskScheduler;
    }

    private void taskScheduler_$eq(TaskSchedulerImpl x$1) {
        this.taskScheduler = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private ExecutorPodsAllocator podAllocator() {
        return this.podAllocator;
    }

    private void podAllocator_$eq(ExecutorPodsAllocator x$1) {
        this.podAllocator = x$1;
    }

    private ExecutorPodsLifecycleManager lifecycleEventHandler() {
        return this.lifecycleEventHandler;
    }

    private void lifecycleEventHandler_$eq(ExecutorPodsLifecycleManager x$1) {
        this.lifecycleEventHandler = x$1;
    }

    private ExecutorPodsWatchSnapshotSource watchEvents() {
        return this.watchEvents;
    }

    private void watchEvents_$eq(ExecutorPodsWatchSnapshotSource x$1) {
        this.watchEvents = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollEvents() {
        return this.pollEvents;
    }

    private void pollEvents_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollEvents = x$1;
    }

    private ArgumentCaptor<RpcEndpoint> driverEndpoint() {
        return this.driverEndpoint;
    }

    private void driverEndpoint_$eq(ArgumentCaptor<RpcEndpoint> x$1) {
        this.driverEndpoint = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest() {
        return this.schedulerBackendUnderTest;
    }

    private void schedulerBackendUnderTest_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackendUnderTest = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private ResourceProfileManager resourceProfileManager() {
        return this.resourceProfileManager;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public KubernetesClusterSchedulerBackendSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.schedulerExecutorService = new DeterministicScheduler();
        this.sparkConf = new SparkConf(false).set("spark.executor.instances", "3").set("spark.app.id", ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        this.listenerBus = new LiveListenerBus(new SparkConf());
        this.resourceProfileManager = new ResourceProfileManager(this.sparkConf(), this.listenerBus());
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.sparkConf());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Mockito.when((Object)this.taskScheduler().sc()).thenReturn((Object)this.sc());
            Mockito.when((Object)this.sc().conf()).thenReturn((Object)this.sparkConf());
            Mockito.when((Object)this.sc().resourceProfileManager()).thenReturn((Object)this.resourceProfileManager());
            Mockito.when((Object)this.sc().env()).thenReturn((Object)this.env());
            Mockito.when((Object)this.env().rpcEnv()).thenReturn((Object)this.rpcEnv());
            this.driverEndpoint_$eq((ArgumentCaptor<RpcEndpoint>)ArgumentCaptor.forClass(RpcEndpoint.class));
            Mockito.when((Object)this.rpcEnv().setupEndpoint((String)ArgumentMatchers.eq((Object)CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()), (RpcEndpoint)this.driverEndpoint().capture())).thenReturn((Object)this.driverEndpointRef());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.kubernetesClient().configMaps()).thenReturn(this.configMapsOperations());
            this.schedulerBackendUnderTest_$eq(new KubernetesClusterSchedulerBackend(this.taskScheduler(), this.sc(), this.kubernetesClient(), (ScheduledExecutorService)this.schedulerExecutorService(), this.eventQueue(), this.podAllocator(), this.lifecycleEventHandler(), this.watchEvents(), this.pollEvents()));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("Start all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3))})));
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsLifecycleManager)Mockito.verify((Object)this.lifecycleEventHandler())).start(this.schedulerBackendUnderTest());
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return (ConfigMap)((Createable)Mockito.verify(this.configMapsOperations())).create(ArgumentMatchers.any());
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("Stop all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.configMapsOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labledConfigMaps());
            Mockito.when((Object)this.labledConfigMaps().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labledConfigMaps());
            this.schedulerBackendUnderTest().stop();
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).stop();
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).stop();
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).stop();
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            ((Deletable)Mockito.verify(this.labledConfigMaps())).delete();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Remove executor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClusterSchedulerBackend backend = (KubernetesClusterSchedulerBackend)Mockito.spy((Object)this.schedulerBackendUnderTest());
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.eq((Object)"2")))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            backend.start();
            backend.doRemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef(), (VerificationMode)Mockito.never())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            backend.doRemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef(), (VerificationMode)Mockito.never())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("Kill executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.podOperations().withField((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2"})).thenReturn(this.labeledPods());
            PodList podList = (PodList)Mockito.mock(PodList.class);
            Mockito.when((Object)this.labeledPods().list()).thenReturn((Object)podList);
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[0]));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[]{(Pod)Mockito.mock(Pod.class)}));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            return (Boolean)((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("SPARK-34407: CoarseGrainedSchedulerBackend.stop may throw SparkException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.driverEndpointRef().askSync((Object)CoarseGrainedClusterMessages.StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean())).thenThrow(new Throwable[]{new RuntimeException()});
            this.schedulerBackendUnderTest().stop();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("SPARK-34469: Ignore RegisterExecutor when SparkContext is stopped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.sc().isStopped())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            CoarseGrainedSchedulerBackend.DriverEndpoint endpoint = this.schedulerBackendUnderTest().createDriverEndpoint();
            endpoint.receiveAndReply(null).apply((Object)new CoarseGrainedClusterMessages.RegisterExecutor("1", null, "host1", 1, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), 0));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
    }
}

