/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverKubernetesCredentialsFeatureStep;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r3Aa\u0002\u0005\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r=\u0002\u0001\u0015!\u0003,\u0011\u0015\u0001\u0004\u0001\"\u00032\u0005-\"%/\u001b<fe.+(-\u001a:oKR,7o\u0011:fI\u0016tG/[1mg\u001a+\u0017\r^;sKN#X\r]*vSR,'BA\u0005\u000b\u0003!1W-\u0019;ve\u0016\u001c(BA\u0006\r\u0003\rY\u0007h\u001d\u0006\u0003\u001b9\ta\u0001Z3qY>L(BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011AD\u0005\u000339\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\t\u0003a\u0019'/\u001a3f]RL\u0017\r\\:UK6\u0004H)\u001b:fGR|'/_\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0003e\u0019'/\u001a3f]RL\u0017\r\\:UK6\u0004H)\u001b:fGR|'/\u001f\u0011\u0002\u001f\t\u000b5+R0E%&3VIU0Q\u001f\u0012+\u0012a\u000b\t\u0003Y5j\u0011AC\u0005\u0003])\u0011\u0001b\u00159be.\u0004v\u000eZ\u0001\u0011\u0005\u0006\u001bVi\u0018#S\u0013Z+%k\u0018)P\t\u0002\n\u0001c\u001e:ji\u0016\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007\u0001\u0012\u0014\tC\u00034\r\u0001\u0007A'A\nde\u0016$WM\u001c;jC2\u001ch)\u001b7f\u001d\u0006lW\r\u0005\u00026}9\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003sQ\ta\u0001\u0010:p_Rt$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\u001e\t\u000b\t3\u0001\u0019\u0001\u001b\u0002'\r\u0014X\rZ3oi&\fGn]\"p]R,g\u000e^:")
public class DriverKubernetesCredentialsFeatureStepSuite
extends SparkFunSuite {
    private final File credentialsTempDirectory = Utils$.MODULE$.createTempDir();
    private final SparkPod BASE_DRIVER_POD = SparkPod$.MODULE$.initialPod();

    private File credentialsTempDirectory() {
        return this.credentialsTempDirectory;
    }

    private SparkPod BASE_DRIVER_POD() {
        return this.BASE_DRIVER_POD;
    }

    private File writeCredentials(String credentialsFileName, String credentialsContents) {
        File credentialsFile = new File(this.credentialsTempDirectory(), credentialsFileName);
        Files.write((CharSequence)credentialsContents, (File)credentialsFile, (Charset)Charsets.UTF_8);
        return credentialsFile;
    }

    public DriverKubernetesCredentialsFeatureStepSuite() {
        this.test("Don't set any credentials", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(KubernetesTestConf$.MODULE$.createDriverConf$default$1(), KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            DriverKubernetesCredentialsFeatureStep kubernetesCredentialsStep = new DriverKubernetesCredentialsFeatureStep((KubernetesConf)kubernetesConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(kubernetesCredentialsStep.configurePod(this.BASE_DRIVER_POD()));
            SparkPod $org_scalatest_assert_macro_right = this.BASE_DRIVER_POD();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Map $org_scalatest_assert_macro_left2 = kubernetesCredentialsStep.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Seq $org_scalatest_assert_macro_left3 = kubernetesCredentialsStep.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }, new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("Only set credentials that are manually mounted.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf submissionSparkConf = new SparkConf(false).set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString(), "/mnt/secrets/my-token.txt").set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString(), "/mnt/secrets/my-key.pem").set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString(), "/mnt/secrets/my-cert.pem").set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString(), "/mnt/secrets/my-ca.pem");
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(submissionSparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            DriverKubernetesCredentialsFeatureStep kubernetesCredentialsStep = new DriverKubernetesCredentialsFeatureStep((KubernetesConf)kubernetesConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(kubernetesCredentialsStep.configurePod(this.BASE_DRIVER_POD()));
            SparkPod $org_scalatest_assert_macro_right = this.BASE_DRIVER_POD();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Seq $org_scalatest_assert_macro_left2 = kubernetesCredentialsStep.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Map resolvedProperties = kubernetesCredentialsStep.getAdditionalPodSystemProperties();
            resolvedProperties.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String propKey = (String)tuple2._1();
                    String propValue = (String)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(submissionSparkConf.get(propKey));
                    String $org_scalatest_assert_macro_right = propValue;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("Mount credentials from the submission client as a secret.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File caCertFile = this.writeCredentials("ca.pem", "ca-cert");
            File clientKeyFile = this.writeCredentials("key.pem", "key");
            File clientCertFile = this.writeCredentials("cert.pem", "cert");
            SparkConf submissionSparkConf = new SparkConf(false).set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString(), "token").set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString(), clientKeyFile.getAbsolutePath()).set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString(), clientCertFile.getAbsolutePath()).set(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString(), caCertFile.getAbsolutePath());
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(submissionSparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            DriverKubernetesCredentialsFeatureStep kubernetesCredentialsStep = new DriverKubernetesCredentialsFeatureStep((KubernetesConf)kubernetesConf);
            Map resolvedProperties = kubernetesCredentialsStep.getAdditionalPodSystemProperties();
            Map expectedSparkConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString()), (Object)"<present_but_redacted>"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString()), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString()), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString()), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString()), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH())}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(resolvedProperties);
            Map $org_scalatest_assert_macro_right = expectedSparkConf;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)kubernetesCredentialsStep.getAdditionalKubernetesResources().size()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Secret credentialsSecret = (Secret)kubernetesCredentialsStep.getAdditionalKubernetesResources().head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(credentialsSecret.getMetadata().getName());
            String $org_scalatest_assert_macro_right3 = new StringBuilder(23).append(kubernetesConf.resourceNamePrefix()).append("-kubernetes-credentials").toString();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            scala.collection.mutable.Map decodedSecretData = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(credentialsSecret.getData()).asScala()).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2(data._1(), (Object)new String(BaseEncoding.base64().decode((CharSequence)data._2()), Charsets.UTF_8)), Map$.MODULE$.canBuildFrom());
            Map expectedSecretData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME()), (Object)"ca-cert"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()), (Object)"token"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()), (Object)"key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME()), (Object)"cert")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(decodedSecretData);
            Map $org_scalatest_assert_macro_right4 = expectedSecretData;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            SparkPod driverPod = kubernetesCredentialsStep.configurePod(this.BASE_DRIVER_POD());
            Buffer driverPodVolumes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(driverPod.pod().getSpec().getVolumes()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverPodVolumes.size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((Volume)driverPodVolumes.head()).getName());
            String $org_scalatest_assert_macro_right6 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            SecretVolumeSource $org_scalatest_assert_macro_left7 = ((Volume)driverPodVolumes.head()).getSecret();
            Object $org_scalatest_assert_macro_right7 = null;
            SecretVolumeSource secretVolumeSource = $org_scalatest_assert_macro_left7;
            Object var35_34 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "!=", null, secretVolumeSource == null ? var35_34 != null : !secretVolumeSource.equals(var35_34), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((Volume)driverPodVolumes.head()).getSecret().getSecretName());
            String $org_scalatest_assert_macro_right8 = credentialsSecret.getMetadata().getName();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Buffer driverContainerVolumeMount = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(driverPod.container().getVolumeMounts()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverContainerVolumeMount.size()));
            int $org_scalatest_assert_macro_right9 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((VolumeMount)driverContainerVolumeMount.head()).getName());
            String $org_scalatest_assert_macro_right10 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(((VolumeMount)driverContainerVolumeMount.head()).getMountPath());
            String $org_scalatest_assert_macro_right11 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("DriverKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }
}

