/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.HadoopConfDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils$;
import org.apache.spark.util.SparkConfWithEnv;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00057\t\u0001\u0003*\u00193p_B\u001cuN\u001c4Ee&4XM\u001d$fCR,(/Z*uKB\u001cV/\u001b;f\u0015\t)a!\u0001\u0005gK\u0006$XO]3t\u0015\t9\u0001\"A\u0002lqMT!!\u0003\u0006\u0002\r\u0011,\u0007\u000f\\8z\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\tA!\u0001\u0005dQ\u0016\u001c7\u000eU8e)\ta\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\b\"B\u0012\u0003\u0001\u0004!\u0013a\u00019pIB\u0011QEJ\u0007\u0002\r%\u0011qE\u0002\u0002\t'B\f'o\u001b)pI\u0002")
public class HadoopConfDriverFeatureStepSuite
extends SparkFunSuite {
    private void checkPod(SparkPod pod) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(pod.pod(), Constants$.MODULE$.HADOOP_CONF_VOLUME()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(pod.pod, org.apache.spark.deploy.k8s.Constants.HADOOP_CONF_VOLUME)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(pod.container(), Constants$.MODULE$.HADOOP_CONF_VOLUME(), Constants$.MODULE$.HADOOP_CONF_DIR_PATH()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(pod.container, org.apache.spark.deploy.k8s.Constants.HADOOP_CONF_VOLUME, org.apache.spark.deploy.k8s.Constants.HADOOP_CONF_DIR_PATH)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(KubernetesFeaturesTestUtils$.MODULE$.containerHasEnvVar(pod.container(), Constants$.MODULE$.ENV_HADOOP_CONF_DIR()), "KubernetesFeaturesTestUtils.containerHasEnvVar(pod.container, org.apache.spark.deploy.k8s.Constants.ENV_HADOOP_CONF_DIR)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    public static final /* synthetic */ void $anonfun$new$3(File confDir$1, String f) {
        Files.write((CharSequence)"some data", (File)new File(confDir$1, f), (Charset)StandardCharsets.UTF_8);
    }

    public HadoopConfDriverFeatureStepSuite() {
        this.test("mount hadoop config map if defined", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_HADOOP_CONF_CONFIG_MAP(), (Object)"testConfigMap");
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            HadoopConfDriverFeatureStep step = new HadoopConfDriverFeatureStep((KubernetesConf)conf);
            this.checkPod(step.configurePod(SparkPod$.MODULE$.initialPod()));
            Seq $org_scalatest_assert_macro_left = step.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }, new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("create hadoop config map if config dir is defined", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File confDir = Utils$.MODULE$.createTempDir();
            Set confFiles = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core-site.xml", "hdfs-site.xml"}));
            confFiles.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HadoopConfDriverFeatureStepSuite.$anonfun$new$3(confDir, f);
                return BoxedUnit.UNIT;
            });
            SparkConfWithEnv sparkConf = new SparkConfWithEnv((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_HADOOP_CONF_DIR()), (Object)confDir.getAbsolutePath())})));
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf((SparkConf)sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            HadoopConfDriverFeatureStep step = new HadoopConfDriverFeatureStep((KubernetesConf)conf);
            this.checkPod(step.configurePod(SparkPod$.MODULE$.initialPod()));
            ConfigMap hadoopConfMap = (ConfigMap)KubernetesFeaturesTestUtils$.MODULE$.filter((Seq<HasMetadata>)step.getAdditionalKubernetesResources(), ClassTag$.MODULE$.apply(ConfigMap.class)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaSetConverter(hadoopConfMap.getData().keySet()).asScala());
            Set $org_scalatest_assert_macro_right = confFiles;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        }, new Position("HadoopConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
    }
}

