/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Volume;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.KerberosConfDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M3Aa\u0002\u0005\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011%!\u0006C\u0003E\u0001\u0011%Q\tC\u0003J\u0001\u0011%!J\u0001\u0012LKJ\u0014WM]8t\u0007>tg\r\u0012:jm\u0016\u0014h)Z1ukJ,7\u000b^3q'VLG/\u001a\u0006\u0003\u0013)\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u00171\t1a\u001b\u001dt\u0015\tia\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u000f\u0013\tIbBA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003!\ta\u0001^7q\t&\u0014X#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013AA5p\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003I\u0019\u0007.Z2l!>$gi\u001c:Le\n\u001cuN\u001c4\u0015\u0007-\nt\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0003V]&$\b\"\u0002\u001a\u0005\u0001\u0004\u0019\u0014a\u00019pIB\u0011A'N\u0007\u0002\u0015%\u0011aG\u0003\u0002\t'B\f'o\u001b)pI\")\u0001\b\u0002a\u0001s\u0005Y1m\u001c8g\u001b\u0006\u0004h*Y7f!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(L\u0007\u0002{)\u0011a\bF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001k\u0013A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u0017\u0002#\rDWmY6Q_\u00124uN\u001d+pW\u0016t7\u000fF\u0002,\r\u001eCQAM\u0003A\u0002MBQ\u0001S\u0003A\u0002e\nA\u0002\u001a;TK\u000e\u0014X\r\u001e(b[\u0016\f!b\u0019:fCR,7\u000b^3q)\tYe\n\u0005\u0002\u001e\u0019&\u0011Q\n\u0003\u0002\u001e\u0017\u0016\u0014(-\u001a:pg\u000e{gN\u001a#sSZ,'OR3biV\u0014Xm\u0015;fa\")qJ\u0002a\u0001!\u0006!1m\u001c8g!\t9\u0012+\u0003\u0002S\u001d\tI1\u000b]1sW\u000e{gN\u001a")
public class KerberosConfDriverFeatureStepSuite
extends SparkFunSuite {
    private final File tmpDir = Utils$.MODULE$.createTempDir();

    private File tmpDir() {
        return this.tmpDir;
    }

    private void checkPodForKrbConf(SparkPod pod, String confMapName) {
        Option podVolume = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.pod().getSpec().getVolumes()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KerberosConfDriverFeatureStepSuite.$anonfun$checkPodForKrbConf$1(x$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(podVolume.isDefined(), "podVolume.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(pod.container(), Constants$.MODULE$.KRB_FILE_VOLUME(), new StringBuilder(10).append(Constants$.MODULE$.KRB_FILE_DIR_PATH()).append("/krb5.conf").toString()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(pod.container, org.apache.spark.deploy.k8s.Constants.KRB_FILE_VOLUME, org.apache.spark.deploy.k8s.Constants.KRB_FILE_DIR_PATH.+(\"/krb5.conf\"))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Volume)podVolume.get()).getConfigMap().getName());
        String $org_scalatest_assert_macro_right = confMapName;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }

    public void org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$checkPodForTokens(SparkPod pod, String dtSecretName) {
        Option podVolume = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.pod().getSpec().getVolumes()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KerberosConfDriverFeatureStepSuite.$anonfun$checkPodForTokens$1(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(podVolume.isDefined(), "podVolume.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(pod.container(), Constants$.MODULE$.SPARK_APP_HADOOP_SECRET_VOLUME_NAME(), Constants$.MODULE$.SPARK_APP_HADOOP_CREDENTIALS_BASE_DIR()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(pod.container, org.apache.spark.deploy.k8s.Constants.SPARK_APP_HADOOP_SECRET_VOLUME_NAME, org.apache.spark.deploy.k8s.Constants.SPARK_APP_HADOOP_CREDENTIALS_BASE_DIR)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(KubernetesFeaturesTestUtils$.MODULE$.containerHasEnvVar(pod.container(), Constants$.MODULE$.ENV_HADOOP_TOKEN_FILE_LOCATION()), "KubernetesFeaturesTestUtils.containerHasEnvVar(pod.container, org.apache.spark.deploy.k8s.Constants.ENV_HADOOP_TOKEN_FILE_LOCATION)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Volume)podVolume.get()).getSecret().getSecretName());
        String $org_scalatest_assert_macro_right = dtSecretName;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }

    public KerberosConfDriverFeatureStep org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(SparkConf conf) {
        KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(conf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
        return new KerberosConfDriverFeatureStep(kconf);
    }

    public static final /* synthetic */ boolean $anonfun$checkPodForKrbConf$1(Volume x$1) {
        String string = x$1.getName();
        String string2 = Constants$.MODULE$.KRB_FILE_VOLUME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkPodForTokens$1(Volume x$2) {
        String string = x$2.getName();
        String string2 = Constants$.MODULE$.SPARK_APP_HADOOP_SECRET_VOLUME_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public KerberosConfDriverFeatureStepSuite() {
        this.test("mount krb5 config map if defined", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String configMap = "testConfigMap";
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(new SparkConf(false).set(Config$.MODULE$.KUBERNETES_KERBEROS_KRB5_CONFIG_MAP(), (Object)configMap));
            this.checkPodForKrbConf(step.configurePod(SparkPod$.MODULE$.initialPod()), configMap);
            Map $org_scalatest_assert_macro_left = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Seq $org_scalatest_assert_macro_left2 = KubernetesFeaturesTestUtils$.MODULE$.filter((Seq<HasMetadata>)step.getAdditionalKubernetesResources(), ClassTag$.MODULE$.apply(ConfigMap.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("create krb5.conf config map if local config provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File krbConf = File.createTempFile("krb5", ".conf", this.tmpDir());
            Files.write((CharSequence)"some data", (File)krbConf, (Charset)StandardCharsets.UTF_8);
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_KERBEROS_KRB5_FILE(), (Object)krbConf.getAbsolutePath());
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(sparkConf);
            ConfigMap confMap = (ConfigMap)KubernetesFeaturesTestUtils$.MODULE$.filter((Seq<HasMetadata>)step.getAdditionalKubernetesResources(), ClassTag$.MODULE$.apply(ConfigMap.class)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaSetConverter(confMap.getData().keySet()).asScala());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{krbConf.getName()}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            this.checkPodForKrbConf(step.configurePod(SparkPod$.MODULE$.initialPod()), confMap.getMetadata().getName());
            Map $org_scalatest_assert_macro_left2 = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("create keytab secret if client keytab file used", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File keytab = File.createTempFile("keytab", ".bin", this.tmpDir());
            Files.write((CharSequence)"some data", (File)keytab, (Charset)StandardCharsets.UTF_8);
            SparkConf sparkConf = new SparkConf(false).set(package$.MODULE$.KEYTAB(), (Object)keytab.getAbsolutePath()).set(package$.MODULE$.PRINCIPAL(), (Object)"alice");
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(sparkConf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(pod.pod(), Constants$.MODULE$.KERBEROS_KEYTAB_VOLUME()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(pod.pod, org.apache.spark.deploy.k8s.Constants.KERBEROS_KEYTAB_VOLUME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(pod.container(), Constants$.MODULE$.KERBEROS_KEYTAB_VOLUME(), Constants$.MODULE$.KERBEROS_KEYTAB_MOUNT_POINT()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(pod.container, org.apache.spark.deploy.k8s.Constants.KERBEROS_KEYTAB_VOLUME, org.apache.spark.deploy.k8s.Constants.KERBEROS_KEYTAB_MOUNT_POINT)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(step.getAdditionalPodSystemProperties().keys());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.KEYTAB().key()}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Secret secret = (Secret)KubernetesFeaturesTestUtils$.MODULE$.filter((Seq<HasMetadata>)step.getAdditionalKubernetesResources(), ClassTag$.MODULE$.apply(Secret.class)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaSetConverter(secret.getData().keySet()).asScala());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{keytab.getName()}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("do nothing if container-local keytab used", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(package$.MODULE$.KEYTAB(), (Object)"local:/my.keytab").set(package$.MODULE$.PRINCIPAL(), (Object)"alice");
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(sparkConf);
            SparkPod initial = SparkPod$.MODULE$.initialPod();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(step.configurePod(initial));
            SparkPod $org_scalatest_assert_macro_right = initial;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Map $org_scalatest_assert_macro_left2 = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Seq $org_scalatest_assert_macro_left3 = step.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("mount delegation tokens if provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String dtSecret = "tokenSecret";
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_KERBEROS_DT_SECRET_NAME(), (Object)dtSecret).set(Config$.MODULE$.KUBERNETES_KERBEROS_DT_SECRET_ITEM_KEY(), (Object)"dtokens");
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(sparkConf);
            this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$checkPodForTokens(step.configurePod(SparkPod$.MODULE$.initialPod()), dtSecret);
            Map $org_scalatest_assert_macro_left = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Seq $org_scalatest_assert_macro_left2 = step.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("create delegation tokens if needed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)"k8s", (String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(this, testUser){
                private final /* synthetic */ KerberosConfDriverFeatureStepSuite $outer;
                private final UserGroupInformation testUser$1;

                public void run() {
                    Credentials creds = this.testUser$1.getCredentials();
                    creds.addSecretKey(new Text("K8S_TEST_KEY"), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4, 2}), ClassTag$.MODULE$.Byte()));
                    this.testUser$1.addCredentials(creds);
                    byte[] tokens = SparkHadoopUtil$.MODULE$.get().serialize(creds);
                    KerberosConfDriverFeatureStep step = this.$outer.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(new SparkConf(false));
                    Secret dtSecret = (Secret)KubernetesFeaturesTestUtils$.MODULE$.filter((Seq<HasMetadata>)step.getAdditionalKubernetesResources(), ClassTag$.MODULE$.apply(Secret.class)).head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dtSecret.getData().get(Constants$.MODULE$.KERBEROS_SECRET_KEY()));
                    String $org_scalatest_assert_macro_right = Base64.encodeBase64String((byte[])tokens);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                    this.$outer.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$checkPodForTokens(step.configurePod(SparkPod$.MODULE$.initialPod()), dtSecret.getMetadata().getName());
                    Map $org_scalatest_assert_macro_left2 = step.getAdditionalPodSystemProperties();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.testUser$1 = testUser$1;
                }
            });
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("do nothing if no config and no tokens", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KerberosConfDriverFeatureStep step = this.org$apache$spark$deploy$k8s$features$KerberosConfDriverFeatureStepSuite$$createStep(new SparkConf(false));
            SparkPod initial = SparkPod$.MODULE$.initialPod();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(step.configurePod(initial));
            SparkPod $org_scalatest_assert_macro_right = initial;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Map $org_scalatest_assert_macro_left2 = step.getAdditionalPodSystemProperties();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Seq $org_scalatest_assert_macro_left3 = step.getAdditionalKubernetesResources();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("KerberosConfDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }
}

