/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KillApplication;
import org.apache.spark.deploy.k8s.submit.ListStatus;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0015+\u0001]BQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003H\u0011\u0019\u0011\u0006\u0001)A\u0005\u0011\"91\u000b\u0001b\u0001\n\u0013!\u0006BB2\u0001A\u0003%Q\u000bC\u0004e\u0001\t\u0007I\u0011\u0002+\t\r\u0015\u0004\u0001\u0015!\u0003V\u0011\u001d1\u0007A1A\u0005\n\u001dDaA\u001d\u0001!\u0002\u0013A\u0007bB:\u0001\u0005\u0004%Ia\u0012\u0005\u0007i\u0002\u0001\u000b\u0011\u0002%\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\bbCA\f\u0001\u0001\u0007\t\u0019!C\u0005\u00033A!\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003x\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%I!!\u000f\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\tY\u0004C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\n\u00055\u0003bCA0\u0001\u0001\u0007\t\u0019!C\u0005\u0003CB1\"!\u001a\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002P!Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011BA'\u0011-\tY\u0007\u0001a\u0001\u0002\u0004%I!!\u001c\t\u0017\u0005E\u0004\u00011A\u0001B\u0003&\u0011q\n\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0013\t9\bC\u0006\u0002\u0002\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0005bCAD\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sB1\"a#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0007I\u0011BAZ\u0011-\ty\n\u0001a\u0001\u0002\u0003\u0006K!a$\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u001f\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u000eC\u0006\u0002V\u0002\u0001\r\u0011!Q!\n\u0005\r\u0007bCAm\u0001\u0001\u0007\t\u0019!C\u0005\u00037D1\"a:\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002j\"Y\u0011Q\u001e\u0001A\u0002\u0003\u0005\u000b\u0015BAo\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003&\u0001!IAa\n\u0003!-C4oU;c[&$x\n]*vSR,'BA\u0016-\u0003\u0019\u0019XOY7ji*\u0011QFL\u0001\u0004Wb\u001a(BA\u00181\u0003\u0019!W\r\u001d7ps*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001AD\b\u0005\u0002:u5\t\u0001'\u0003\u0002<a\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u001b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA!?\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\fa\u0001P5oSRtD#\u0001#\u0011\u0005\u0015\u0003Q\"\u0001\u0016\u0002\u001d\u0011\u0014\u0018N^3s!>$g*Y7fcU\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\rM#(/\u001b8h\u0003=!'/\u001b<feB{GMT1nKF\u0002\u0013A\u00043sSZ,'\u000fU8e\u001d\u0006lWMM\u0001\u0010IJLg/\u001a:Q_\u0012t\u0015-\\33A\u0005QAM]5wKJ\u0004v\u000eZ\u0019\u0016\u0003U\u0003\"AV1\u000e\u0003]S!\u0001W-\u0002\u000b5|G-\u001a7\u000b\u0005i[\u0016aA1qS*\u0011A,X\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u00010`\u0003\u001d1\u0017M\u0019:jGbR\u0011\u0001Y\u0001\u0003S>L!AY,\u0003\u0007A{G-A\u0006ee&4XM\u001d)pIF\u0002\u0013A\u00033sSZ,'\u000fU8ee\u0005YAM]5wKJ\u0004v\u000e\u001a\u001a!\u0003\u001d\u0001x\u000e\u001a'jgR,\u0012\u0001\u001b\t\u0004SB,V\"\u00016\u000b\u0005-d\u0017!C5n[V$\u0018M\u00197f\u0015\tig.\u0001\u0006d_2dWm\u0019;j_:T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c*\u0014A\u0001T5ti\u0006A\u0001o\u001c3MSN$\b%A\u0005oC6,7\u000f]1dK\u0006Qa.Y7fgB\f7-\u001a\u0011\u0002\u001bA|Gm\u00149fe\u0006$\u0018n\u001c8t+\u00059\bc\u0001=\u0002\u00129\u0019\u00110!\u0004\u000f\u0007i\fYAD\u0002|\u0003\u0013q1\u0001`A\u0004\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005a'\u0001\u0004=e>|GOP\u0005\u0002k%\u00111\u0007N\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013bAA\bY\u0005qa)\u00192sS\u000eD\u0014\t\\5bg\u0016\u001c\u0018\u0002BA\n\u0003+\u0011A\u0001U(E'*\u0019\u0011q\u0002\u0017\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005\r\u0002\u0003BA\u000f\u0003?i\u0011A\\\u0005\u0004\u0003Cq'\u0001B+oSRD\u0001\"!\n\u0010\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\n\u0014A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u0004!\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005EB'A\u0004n_\u000e\\\u0017\u000e^8\n\t\u0005U\u0012q\u0006\u0002\u0005\u001b>\u001c7.A\tq_\u0012\u001cx+\u001b;i\u001d\u0006lWm\u001d9bG\u0016,\"!a\u000f\u0011\u0007a\fi$\u0003\u0003\u0002@\u0005U!a\u0005)P\tN{v+\u0013+I?:\u000bU*R*Q\u0003\u000e+\u0015!\u00069pIN<\u0016\u000e\u001e5OC6,7\u000f]1dK~#S-\u001d\u000b\u0005\u00037\t)\u0005C\u0005\u0002&I\t\t\u00111\u0001\u0002<\u0005\u0011\u0002o\u001c3t/&$\bNT1nKN\u0004\u0018mY3!Q\r\u0019\u00121F\u0001\u0015IJLg/\u001a:Q_\u0012|\u0005/\u001a:bi&|gn]\u0019\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0004INd'bAA-7\u000611\r\\5f]RLA!!\u0018\u0002T\tY\u0001k\u001c3SKN|WO]2f\u0003a!'/\u001b<feB{Gm\u00149fe\u0006$\u0018n\u001c8tc}#S-\u001d\u000b\u0005\u00037\t\u0019\u0007C\u0005\u0002&U\t\t\u00111\u0001\u0002P\u0005)BM]5wKJ\u0004v\u000eZ(qKJ\fG/[8ogF\u0002\u0003f\u0001\f\u0002,\u0005!BM]5wKJ\u0004v\u000eZ(qKJ\fG/[8ogJ\n\u0001\u0004\u001a:jm\u0016\u0014\bk\u001c3Pa\u0016\u0014\u0018\r^5p]N\u0014t\fJ3r)\u0011\tY\"a\u001c\t\u0013\u0005\u0015\u0002$!AA\u0002\u0005=\u0013!\u00063sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001c(\u0007\t\u0015\u00043\u0005-\u0012\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u+\t\tI\b\u0005\u0003\u0002|\u0005uTBAA,\u0013\u0011\ty(a\u0016\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005\u0015\u0005\"CA\u00137\u0005\u0005\t\u0019AA=\u0003EYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\t\u0015\u00049\u0005-\u0012!\u00033fY\u0016$\u0018M\u00197f+\t\ty\t\r\u0003\u0002\u0012\u0006m\u0005CBA>\u0003'\u000b9*\u0003\u0003\u0002\u0016\u0006]#!\b)s_B\fw-\u0019;j_:\u0004v\u000e\\5ds\u000e{gNZ5hkJ\f'\r\\3\u0011\t\u0005e\u00151\u0014\u0007\u0001\t-\tijHA\u0001\u0002\u0003\u0015\t!a)\u0003\u0007}#\u0013'\u0001\u0006eK2,G/\u00192mK\u0002B3aHA\u0016#\u0011\t)+a+\u0011\t\u0005u\u0011qU\u0005\u0004\u0003Ss'a\u0002(pi\"Lgn\u001a\t\u0005\u0003#\ni+\u0003\u0003\u00020\u0006M#!\u0003#fY\u0016$\u0018M\u00197f\u00035!W\r\\3uC\ndWm\u0018\u0013fcR!\u00111DA[\u0011%\t)CHA\u0001\u0002\u0004\t9\f\r\u0003\u0002:\u0006u\u0006CBA>\u0003'\u000bY\f\u0005\u0003\u0002\u001a\u0006uF\u0001DAO\u0003k\u000b\t\u0011!A\u0003\u0002\u0005\r\u0016!\u00043fY\u0016$\u0018M\u00197f\u0019&\u001cH/\u0006\u0002\u0002DB1\u0011\u0011KAc\u0003\u0013LA!a2\u0002T\tYd*Y7fgB\f7-\u001a'jgR4\u0016n]5u\rJ|WnU3sm\u0016\u0014x)\u001a;EK2,G/\u001a*fGJ,\u0017\r^3XC&$\u0018\t\u001d9mS\u000e\f'\r\\3\u0011\u0007Y\u000bY-C\u0002\u0002N^\u00131\u0002S1t\u001b\u0016$\u0018\rZ1uC\u0006\tB-\u001a7fi\u0006\u0014G.\u001a'jgR|F%Z9\u0015\t\u0005m\u00111\u001b\u0005\n\u0003K\t\u0013\u0011!a\u0001\u0003\u0007\fa\u0002Z3mKR\f'\r\\3MSN$\b\u0005K\u0002#\u0003W\t1!\u001a:s+\t\ti\u000e\u0005\u0003\u0002`\u0006\rXBAAq\u0015\t\u0001G*\u0003\u0003\u0002f\u0006\u0005(a\u0003)sS:$8\u000b\u001e:fC6\fq!\u001a:s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005-\b\"CA\u0013I\u0005\u0005\t\u0019AAo\u0003\u0011)'O\u001d\u0011)\u0007\u0015\nY#\u0001\u0005e_J+G/\u001e:o)\u0011\t)P!\u0001\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sTA!a?\u00020\u0005A1\u000f^;cE&tw-\u0003\u0003\u0002\u0000\u0006e(aB*uk\n\u0014WM\u001d\u0005\b\u0005\u00071\u0003\u0019\u0001B\u0003\u0003\u00151\u0018\r\\;f!\u0011\tiBa\u0002\n\u0007\t%aNA\u0002B]f\faBY;jY\u0012$%/\u001b<feB{G\rF\u0003V\u0005\u001f\u0011\t\u0003C\u0004\u0003\u0012\u001d\u0002\rAa\u0005\u0002\u000fA|GMT1nKB!!Q\u0003B\u000f\u001d\u0011\u00119B!\u0007\u0011\u0005yt\u0017b\u0001B\u000e]\u00061\u0001K]3eK\u001aL1a\u0014B\u0010\u0015\r\u0011YB\u001c\u0005\b\u0005G9\u0003\u0019\u0001B\n\u0003\tIG-\u0001\u0007hKR\u0004v\u000eZ*uCR,8\u000f\u0006\u0004\u0003\u0014\t%\"1\u0006\u0005\b\u0005#A\u0003\u0019\u0001B\n\u0011\u001d\u0011\u0019\u0003\u000ba\u0001\u0005'\u0001")
public class K8sSubmitOpSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName1;
    private final String driverPodName2;
    private final Pod driverPod1;
    private final Pod driverPod2;
    private final List<Pod> podList;
    private final String namespace;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private PodResource driverPodOperations1;
    @Mock
    private PodResource driverPodOperations2;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private PropagationPolicyConfigurable<? extends Deletable> deletable;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> deletableList;
    @Mock
    private PrintStream err;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName1() {
        return this.driverPodName1;
    }

    private String driverPodName2() {
        return this.driverPodName2;
    }

    private Pod driverPod1() {
        return this.driverPod1;
    }

    private Pod driverPod2() {
        return this.driverPod2;
    }

    private List<Pod> podList() {
        return this.podList;
    }

    private String namespace() {
        return this.namespace;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private PodResource driverPodOperations1() {
        return this.driverPodOperations1;
    }

    private void driverPodOperations1_$eq(PodResource x$1) {
        this.driverPodOperations1 = x$1;
    }

    private PodResource driverPodOperations2() {
        return this.driverPodOperations2;
    }

    private void driverPodOperations2_$eq(PodResource x$1) {
        this.driverPodOperations2 = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private PropagationPolicyConfigurable<? extends Deletable> deletable() {
        return this.deletable;
    }

    private void deletable_$eq(PropagationPolicyConfigurable<? extends Deletable> x$1) {
        this.deletable = x$1;
    }

    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> deletableList() {
        return this.deletableList;
    }

    private void deletableList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> x$1) {
        this.deletableList = x$1;
    }

    private PrintStream err() {
        return this.err;
    }

    private void err_$eq(PrintStream x$1) {
        this.err = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Nil$.MODULE$).toArray(ClassTag$.MODULE$.Any())));
    }

    private Pod buildDriverPod(String podName, String id) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName).withNamespace(this.namespace()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid(new StringBuilder(11).append("driver-pod-").append(id).toString())).endMetadata()).withNewSpec().withServiceAccountName(new StringBuilder(4).append("test").append(id).toString()).withVolumes(new Volume[0]).withNodeName(new StringBuilder(8).append("testNode").append(id).toString())).endSpec()).withNewStatus().withPhase("Running")).endStatus()).build();
    }

    private String getPodStatus(String podName, String id) {
        return new StringBuilder(29).append("Application status (driver): ").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(377).append("|").append("\n\t").append(" pod name: ").append(podName).append("\n          |").append("\t").append(" namespace: N/A\n          |").append("\t").append(" labels: spark-app-selector -> spark-app-id, spark-role -> driver\n          |").append("\t").append(" pod uid: driver-pod-").append(id).append("\n          |").append("\t").append(" creation time: N/A\n          |").append("\t").append(" service account name: test").append(id).append("\n          |").append("\t").append(" volumes: N/A\n          |").append("\t").append(" node name: testNode").append(id).append("\n          |").append("\t").append(" start time: N/A\n          |").append("\t").append(" phase: Running\n          |").append("\t").append(" container status: N/A").toString())).stripMargin()).toString();
    }

    public K8sSubmitOpSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName1 = "driver1";
        this.driverPodName2 = "driver2";
        this.driverPod1 = this.buildDriverPod(this.driverPodName1(), "1");
        this.driverPod2 = this.buildDriverPod(this.driverPodName2(), "2");
        this.podList = new .colon.colon((Object)this.driverPod1(), (List)new .colon.colon((Object)this.driverPod2(), (List)Nil$.MODULE$));
        this.namespace = "test";
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace(this.namespace())).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.podsWithNamespace().withName(this.driverPodName1())).thenReturn((Object)this.driverPodOperations1());
            Mockito.when((Object)this.podsWithNamespace().withName(this.driverPodName2())).thenReturn((Object)this.driverPodOperations2());
            Mockito.when((Object)this.driverPodOperations1().get()).thenReturn((Object)this.driverPod1());
            Mockito.when((Object)this.driverPodOperations1().delete()).thenReturn(Arrays.asList((Object[])new StatusDetails[]{new StatusDetails()}));
            Mockito.when((Object)this.driverPodOperations2().get()).thenReturn((Object)this.driverPod2());
            return Mockito.when((Object)this.driverPodOperations2().delete()).thenReturn(Arrays.asList((Object[])new StatusDetails[]{new StatusDetails()}));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("List app status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            ListStatus listStatus = new ListStatus();
            listStatus.printStream_$eq(this.err());
            listStatus.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName1(), "1")));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("List status for multiple apps with glob", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            ListStatus listStatus = new ListStatus();
            listStatus.printStream_$eq(this.err());
            listStatus.executeOnGlob(this.podList(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName1(), "1")));
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName2(), "2")));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("Kill app", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            killApp.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            return ((Deletable)Mockito.verify((Object)this.driverPodOperations1(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("Kill app with gracePeriod", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            SparkConf conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_SUBMIT_GRACE_PERIOD(), (Object)BoxesRunTime.boxToLong((long)1L));
            ((GracePeriodConfigurable)this.doReturn(this.deletable()).when((Object)this.driverPodOperations1())).withGracePeriod(1L);
            killApp.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), conf, kubeClient);
            ((GracePeriodConfigurable)Mockito.verify((Object)this.driverPodOperations1(), (VerificationMode)Mockito.times((int)1))).withGracePeriod(1L);
            return ((Deletable)Mockito.verify(this.deletable(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("Kill multiple apps with glob without gracePeriod", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            killApp.printStream_$eq(this.err());
            ((KubernetesClient)this.doReturn(this.deletableList()).when((Object)this.kubernetesClient())).resourceList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.podList()).asJava());
            killApp.executeOnGlob(this.podList(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((Deletable)Mockito.verify(this.deletableList(), (VerificationMode)Mockito.times((int)1))).delete();
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)new StringBuilder(22).append("Deleting driver pod: ").append(this.driverPodName1()).append(".").toString()));
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)new StringBuilder(22).append("Deleting driver pod: ").append(this.driverPodName2()).append(".").toString()));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }
}

