/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\r\u001b\u0001\u001dBQA\r\u0001\u0005\u0002MB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011B\u001c\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0013a\u0006\"C2\u0001\u0001\u0004\u0005\t\u0015)\u00039\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a!Q\u0011Q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015B<\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111\u0005\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u00022\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B!Y\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001d\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\ti\u0005C\u0006\u0002\\\u0001\u0001\r\u00111A\u0005\n\u0005u\u0003bCA3\u0001\u0001\u0007\t\u0019!C\u0005\u0003OB1\"a\u001b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002`!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBAJ\u0001\u0011%\u0011Q\u0013\u0002\"\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s'VLG/\u001a\u0006\u00037q\t1a\u001b\u001dt\u0015\tib$A\u0004dYV\u001cH/\u001a:\u000b\u0005}\u0001\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0004\u0001!b\u0003CA\u0015+\u001b\u0005\u0001\u0013BA\u0016!\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006J\u0001\ng\u000e\fG.\u0019;fgRL!!\r\u0018\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011AG\u0001\u0012]\u0006lW\rZ#yK\u000e,Ho\u001c:Q_\u0012\u001cX#\u0001\u001d\u0011\te\u0002%)T\u0007\u0002u)\u00111\bP\u0001\b[V$\u0018M\u00197f\u0015\tid(\u0001\u0006d_2dWm\u0019;j_:T\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003j\u00121!T1q!\t\u0019%J\u0004\u0002E\u0011B\u0011QIP\u0007\u0002\r*\u0011qIJ\u0001\u0007yI|w\u000e\u001e \n\u0005%s\u0014A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!\u0013 \u0011\u00059KV\"A(\u000b\u0005A\u000b\u0016a\u00013tY*\u0011!kU\u0001\u0007G2LWM\u001c;\u000b\u0005Q+\u0016AC6vE\u0016\u0014h.\u001a;fg*\u0011akV\u0001\bM\u0006\u0014'/[29\u0015\u0005A\u0016AA5p\u0013\tQvJA\u0006Q_\u0012\u0014Vm]8ve\u000e,\u0017!\u00068b[\u0016$W\t_3dkR|'\u000fU8eg~#S-\u001d\u000b\u0003;\u0006\u0004\"AX0\u000e\u0003yJ!\u0001\u0019 \u0003\tUs\u0017\u000e\u001e\u0005\bE\u000e\t\t\u00111\u00019\u0003\rAH%M\u0001\u0013]\u0006lW\rZ#yK\u000e,Ho\u001c:Q_\u0012\u001c\b%\u0001\tlk\n,'O\\3uKN\u001cE.[3oiV\ta\r\u0005\u0002hQ6\t\u0011+\u0003\u0002j#\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0015WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R|F%Z9\u0015\u0005uc\u0007b\u00022\u0007\u0003\u0003\u0005\rAZ\u0001\u0012WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\u0003FA\u0004p!\t\u00018/D\u0001r\u0015\t\u0011H%A\u0004n_\u000e\\\u0017\u000e^8\n\u0005Q\f(\u0001B'pG.\fQ\u0002]8e\u001fB,'/\u0019;j_:\u001cX#A<\u0011\u0007a\f\tBD\u0002z\u0003\u0017q1A_A\u0004\u001d\rY\u00181\u0001\b\u0004y\u0006\u0005aBA?\u0000\u001d\t)e0C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0019\u0011Q\u0001\u0011\u0002\r\u0011,\u0007\u000f\\8z\u0013\rY\u0012\u0011\u0002\u0006\u0004\u0003\u000b\u0001\u0013\u0002BA\u0007\u0003\u001f\taBR1ce&\u001c\u0007(\u00117jCN,7OC\u0002\u001c\u0003\u0013IA!a\u0005\u0002\u0016\t!\u0001k\u0014#T\u0015\u0011\ti!a\u0004\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002^\u00037AqAY\u0005\u0002\u0002\u0003\u0007q/\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0005)y\u0017!\u00059pIN<\u0016\u000e\u001e5OC6,7\u000f]1dKV\u0011\u0011Q\u0005\t\u0004q\u0006\u001d\u0012\u0002BA\u0015\u0003+\u00111\u0003U(E'~;\u0016\n\u0016%`\u001d\u0006kUi\u0015)B\u0007\u0016\u000bQ\u0003]8eg^KG\u000f\u001b(b[\u0016\u001c\b/Y2f?\u0012*\u0017\u000fF\u0002^\u0003_A\u0001B\u0019\u0007\u0002\u0002\u0003\u0007\u0011QE\u0001\u0013a>$7oV5uQ:\u000bW.Z:qC\u000e,\u0007\u0005\u000b\u0002\u000e_\u0006\u00012o\u00195fIVdWM\u001d\"bG.,g\u000eZ\u000b\u0003\u0003s\u00012!NA\u001e\u0013\r\tiD\u0007\u0002\"\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0001\u0015g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012|F%Z9\u0015\u0007u\u000b\u0019\u0005\u0003\u0005c\u001f\u0005\u0005\t\u0019AA\u001d\u0003E\u00198\r[3ek2,'OQ1dW\u0016tG\r\t\u0015\u0003!=\fab\u001d8baNDw\u000e^:Ti>\u0014X-\u0006\u0002\u0002NA\u0019Q'a\u0014\n\u0007\u0005E#DA\u0014EKR,'/\\5oSN$\u0018nY#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017AE:oCB\u001c\bn\u001c;t'R|'/Z0%KF$2!XA,\u0011!\u0011'#!AA\u0002\u00055\u0013aD:oCB\u001c\bn\u001c;t'R|'/\u001a\u0011\u0002+\u00154XM\u001c;IC:$G.\u001a:V]\u0012,'\u000fV3tiV\u0011\u0011q\f\t\u0004k\u0005\u0005\u0014bAA25\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018!G3wK:$\b*\u00198eY\u0016\u0014XK\u001c3feR+7\u000f^0%KF$2!XA5\u0011!\u0011W#!AA\u0002\u0005}\u0013AF3wK:$\b*\u00198eY\u0016\u0014XK\u001c3feR+7\u000f\u001e\u0011\u0002#\u0015D\u0018\u000e\u001e*fCN|g.T3tg\u0006<W\rF\u0004C\u0003c\nY(a$\t\u000f\u0005Mt\u00031\u0001\u0002v\u00051Q\r_3d\u0013\u0012\u00042AXA<\u0013\r\tIH\u0010\u0002\u0004\u0013:$\bbBA?/\u0001\u0007\u0011qP\u0001\nM\u0006LG.\u001a3Q_\u0012\u0004B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0003n_\u0012,GNC\u0002\u0002\nN\u000b1!\u00199j\u0013\u0011\ti)a!\u0003\u0007A{G\rC\u0004\u0002\u0012^\u0001\r!!\u001e\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016\fqB\\1nK\u0012\u0004v\u000eZ:B]N<XM\u001d\u000b\u0003\u0003/\u0003R!!'\u0002 6k!!a'\u000b\u0007\u0005u\u0015/\u0001\u0005tiV\u0014'-\u001b8h\u0013\u0011\t\t+a'\u0003\r\u0005s7o^3s\u0001")
public class ExecutorPodsLifecycleManagerSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private Map<String, PodResource> namedExecutorPods;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsLifecycleManager eventHandlerUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Map<String, PodResource> namedExecutorPods() {
        return this.namedExecutorPods;
    }

    private void namedExecutorPods_$eq(Map<String, PodResource> x$1) {
        this.namedExecutorPods = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsLifecycleManager eventHandlerUnderTest() {
        return this.eventHandlerUnderTest;
    }

    private void eventHandlerUnderTest_$eq(ExecutorPodsLifecycleManager x$1) {
        this.eventHandlerUnderTest = x$1;
    }

    private String exitReasonMessage(int execId, Pod failedPod, int exitCode) {
        Option reason = Option$.MODULE$.apply((Object)failedPod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)failedPod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = new StringBuilder(45).append("The executor with id ").append(execId).append(" exited with exit code ").append(explained).append(".").toString();
        Option reasonStr = reason.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(41).append("The API gave the following brief reason: ").append((String)r).toString());
        Option msgStr = message.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(36).append("The API gave the following message: ").append((String)m).toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n       |").append(exitMsg).append("\n       |").append(reasonStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |").append(msgStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(failedPod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private Answer<PodResource> namedPodsAnswer() {
        return invocation -> {
            String podName = (String)invocation.getArgument(0);
            return (PodResource)this.namedExecutorPods().getOrElseUpdate((Object)podName, (Function0 & Serializable & scala.Serializable)() -> (PodResource)Mockito.mock(PodResource.class));
        };
    }

    public ExecutorPodsLifecycleManagerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.namedExecutorPods_$eq((Map<String, PodResource>)Map$.MODULE$.empty());
            Mockito.when((Object)this.schedulerBackend().getExecutorsWithRegistrationTs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace(ArgumentMatchers.anyString())).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.podsWithNamespace().withName((String)ArgumentMatchers.any(String.class))).thenAnswer(this.namedPodsAnswer());
            this.eventHandlerUnderTest_$eq(new ExecutorPodsLifecycleManager(new SparkConf(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore()));
            this.eventHandlerUnderTest().start(this.schedulerBackend());
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("When an executor reaches error states immediately, remove from the scheduler backend.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("Don't remove executors twice from Spark but remove from K8s repeatedly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend(), (VerificationMode)Mockito.times((int)1))).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.times((int)2))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("When the scheduler backend lists executor ids that aren't present in the cluster, remove those executors from Spark.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.schedulerBackend().getExecutorsWithRegistrationTs()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)BoxesRunTime.boxToLong((long)7L))})));
            long missingPodDelta = BoxesRunTime.unboxToLong((Object)this.eventHandlerUnderTest().conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
            this.snapshotsStore().clock().advance(missingPodDelta + 7L);
            this.snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Nil$.MODULE$));
            this.snapshotsStore().notifySubscribers();
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend(), (VerificationMode)Mockito.never())).doRemoveExecutor((String)ArgumentMatchers.any(), (ExecutorLossReason)ArgumentMatchers.any());
            this.snapshotsStore().clock().advance(1L);
            this.snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Nil$.MODULE$));
            this.snapshotsStore().notifySubscribers();
            String msg = "The executor with ID 1 (registered at 7 ms) was not found in the cluster at the polling time (30008 ms) which is after the accepted detect delta time (30000 ms) configured by `spark.kubernetes.executor.missingPodDetectDelta`. The executor may have been deleted but the driver missed the deletion event. Marking this executor as failed.";
            ExecutorExited expectedLossReason = new ExecutorExited(-1, false, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("SPARK-40458: test executor inactivation function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            Pod inactivated = (Pod)ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn().apply(failedPod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(inactivated.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL()));
            String $org_scalatest_assert_macro_right = "true";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("Keep executor pods in k8s if configured.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.eventHandlerUnderTest().conf().set(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.never())).delete();
            return (Pod)((EditReplacePatchable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).edit((UnaryOperator)ArgumentMatchers.any());
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }
}

