/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\u0010 \u00011BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019I\u0005\u0001)A\u0005\u0007\"I!\n\u0001a\u0001\u0002\u0004%Ia\u0013\u0005\n1\u0002\u0001\r\u00111A\u0005\neC\u0011b\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007bCA\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007A!\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%I!!\u0004\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011q\u0003\u0005\f\u00037\u0001\u0001\u0019!A!B\u0013\ty\u0001C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u00055\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010!Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0002\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wA1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N!Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011BA3\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0014\t\u0017\u0005-\u0004\u00011AA\u0002\u0013%\u0011Q\u000e\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0013\t9\bC\u0006\u0002|\u0001\u0001\r\u0011!Q!\n\u0005=$AJ#yK\u000e,Ho\u001c:Q_\u0012\u001c\bk\u001c7mS:<7K\\1qg\"|GoU8ve\u000e,7+^5uK*\u0011\u0001%I\u0001\u0004Wb\u001a(B\u0001\u0012$\u0003\u001d\u0019G.^:uKJT!\u0001J\u0013\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u0019\u0011\u00059zS\"A\u0013\n\u0005A*#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00023k5\t1G\u0003\u00025S\u0005I1oY1mCR,7\u000f^\u0005\u0003mM\u0012aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002sA\u0011!\bA\u0007\u0002?\u0005YA-\u001a4bk2$8i\u001c8g+\u0005i\u0004C\u0001\u0018?\u0013\tyTEA\u0005Ta\u0006\u00148nQ8oM\u0006aA-\u001a4bk2$8i\u001c8gA\u0005y\u0001o\u001c7mS:<\u0017J\u001c;feZ\fG.F\u0001D!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0011auN\\4\u0002!A|G\u000e\\5oO&sG/\u001a:wC2\u0004\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u+\u0005a\u0005CA'W\u001b\u0005q%BA(Q\u0003\u0019\u0019G.[3oi*\u0011\u0011KU\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA*U\u0003\u001d1\u0017M\u0019:jGbR\u0011!V\u0001\u0003S>L!a\u0016(\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002[;B\u0011AiW\u0005\u00039\u0016\u0013A!\u00168ji\"9alBA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005\t2.\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0011)\u0005!\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013*\u0003\u001diwnY6ji>L!AZ2\u0003\t5{7m[\u0001\u000ea>$w\n]3sCRLwN\\:\u0016\u0003%\u0004\"A[?\u000f\u0005-ThB\u00017y\u001d\tigO\u0004\u0002ok:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e.\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\t9X%\u0001\u0004eKBdw._\u0005\u0003AeT!a^\u0013\n\u0005md\u0018A\u0004$bEJL7\rO!mS\u0006\u001cXm\u001d\u0006\u0003AeL!A`@\u0003\tA{Ei\u0015\u0006\u0003wr\f\u0011\u0003]8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\rQ\u0016Q\u0001\u0005\b=*\t\t\u00111\u0001j\u00039\u0001x\u000eZ(qKJ\fG/[8og\u0002B#aC1\u0002!\u0005\u0004\b/\u00133MC\n,G.\u001a3Q_\u0012\u001cXCAA\b!\rQ\u0017\u0011C\u0005\u0004\u0003'y(\u0001\u0004'B\u0005\u0016cU\tR0Q\u001f\u0012\u001b\u0016\u0001F1qa&#G*\u00192fY\u0016$\u0007k\u001c3t?\u0012*\u0017\u000fF\u0002[\u00033A\u0001BX\u0007\u0002\u0002\u0003\u0007\u0011qB\u0001\u0012CB\u0004\u0018\n\u001a'bE\u0016dW\r\u001a)pIN\u0004\u0003F\u0001\bb\u0003])\u00070Z2vi>\u0014(k\u001c7f\u0019\u0006\u0014W\r\\3e!>$7/A\u000efq\u0016\u001cW\u000f^8s%>dW\rT1cK2,G\rU8eg~#S-\u001d\u000b\u00045\u0006\u0015\u0002\u0002\u00030\u0011\u0003\u0003\u0005\r!a\u0004\u00021\u0015DXmY;u_J\u0014v\u000e\\3MC\n,G.\u001a3Q_\u0012\u001c\b\u0005\u000b\u0002\u0012C\u0006\u0011\u0012m\u0019;jm\u0016,\u00050Z2vi>\u0014\bk\u001c3t\u0003Y\t7\r^5wK\u0016CXmY;u_J\u0004v\u000eZ:`I\u0015\fHc\u0001.\u00022!AalEA\u0001\u0002\u0004\ty!A\nbGRLg/Z#yK\u000e,Ho\u001c:Q_\u0012\u001c\b\u0005\u000b\u0002\u0015C\u0006QQM^3oiF+X-^3\u0016\u0005\u0005m\u0002c\u0001\u001e\u0002>%\u0019\u0011qH\u0010\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002\u001d\u00154XM\u001c;Rk\u0016,Xm\u0018\u0013fcR\u0019!,!\u0012\t\u0011y3\u0012\u0011!a\u0001\u0003w\t1\"\u001a<f]R\fV/Z;fA!\u0012q#Y\u0001\u0010a>dG.\u001b8h\u000bb,7-\u001e;peV\u0011\u0011q\n\t\u0005\u0003#\ny&\u0004\u0002\u0002T)!\u0011QKA,\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u00033\nY&A\u0002mS\nT1!!\u0018*\u0003\u0015QWn\\2l\u0013\u0011\t\t'a\u0015\u0003-\u0011+G/\u001a:nS:L7\u000f^5d'\u000eDW\rZ;mKJ\f1\u0003]8mY&tw-\u0012=fGV$xN]0%KF$2AWA4\u0011!q\u0016$!AA\u0002\u0005=\u0013\u0001\u00059pY2LgnZ#yK\u000e,Ho\u001c:!\u0003Y\u0001x\u000e\u001c7j]\u001e\u001cv.\u001e:dKVsG-\u001a:UKN$XCAA8!\rQ\u0014\u0011O\u0005\u0004\u0003gz\"!I#yK\u000e,Ho\u001c:Q_\u0012\u001c\bk\u001c7mS:<7K\\1qg\"|GoU8ve\u000e,\u0017A\u00079pY2LgnZ*pkJ\u001cW-\u00168eKJ$Vm\u001d;`I\u0015\fHc\u0001.\u0002z!Aa\fHA\u0001\u0002\u0004\ty'A\fq_2d\u0017N\\4T_V\u00148-Z+oI\u0016\u0014H+Z:uA\u0001")
public class ExecutorPodsPollingSnapshotSourceSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf defaultConf;
    private final long pollingInterval;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> appIdLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> executorRoleLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> activeExecutorPods;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    private DeterministicScheduler pollingExecutor;
    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf defaultConf() {
        return this.defaultConf;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> appIdLabeledPods() {
        return this.appIdLabeledPods;
    }

    private void appIdLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.appIdLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> executorRoleLabeledPods() {
        return this.executorRoleLabeledPods;
    }

    private void executorRoleLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.executorRoleLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> activeExecutorPods() {
        return this.activeExecutorPods;
    }

    private void activeExecutorPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.activeExecutorPods = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private DeterministicScheduler pollingExecutor() {
        return this.pollingExecutor;
    }

    private void pollingExecutor_$eq(DeterministicScheduler x$1) {
        this.pollingExecutor = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest() {
        return this.pollingSourceUnderTest;
    }

    private void pollingSourceUnderTest_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollingSourceUnderTest = x$1;
    }

    public static final /* synthetic */ PodList $anonfun$new$5(ExecutorPodsPollingSnapshotSourceSuite $this, boolean value) {
        SparkConf sparkConf = new SparkConf();
        ExecutorPodsPollingSnapshotSource source = new ExecutorPodsPollingSnapshotSource(sparkConf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_WITH_RESOURCE_VERSION(), (Object)BoxesRunTime.boxToBoolean((boolean)value)), $this.kubernetesClient(), $this.eventQueue(), (ScheduledExecutorService)$this.pollingExecutor());
        source.start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        $this.pollingExecutor().tick($this.pollingInterval(), TimeUnit.MILLISECONDS);
        if (value) {
            return (PodList)((Listable)Mockito.verify($this.activeExecutorPods())).list(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("0")).build());
        }
        return (PodList)((Listable)Mockito.verify($this.activeExecutorPods())).list();
    }

    public ExecutorPodsPollingSnapshotSourceSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.defaultConf = new SparkConf();
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)this.defaultConf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            this.pollingExecutor_$eq(new DeterministicScheduler());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.appIdLabeledPods());
            Mockito.when((Object)this.appIdLabeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.executorRoleLabeledPods());
            return Mockito.when((Object)this.executorRoleLabeledPods().withoutLabel(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL(), "true")).thenReturn(this.activeExecutorPods());
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Items returned by the API should be pushed to the event queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf();
            this.pollingSourceUnderTest_$eq(new ExecutorPodsPollingSnapshotSource(sparkConf, this.kubernetesClient(), this.eventQueue(), (ScheduledExecutorService)this.pollingExecutor()));
            this.pollingSourceUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            Pod exec1 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            Pod exec2 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            Mockito.when((Object)this.activeExecutorPods().list()).thenReturn((Object)((PodListBuilder)new PodListBuilder().addToItems(new Pod[]{exec1, exec2})).build());
            this.pollingExecutor().tick(this.pollingInterval(), TimeUnit.MILLISECONDS);
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).replaceSnapshot((Seq)new .colon.colon((Object)exec1, (List)new .colon.colon((Object)exec2, (List)Nil$.MODULE$)));
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("SPARK-36462: If polling is disabled we don't call pods() on the client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf();
            ExecutorPodsPollingSnapshotSource source = new ExecutorPodsPollingSnapshotSource(sparkConf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_ENABLE_API_POLLING(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), this.kubernetesClient(), this.eventQueue(), (ScheduledExecutorService)this.pollingExecutor());
            source.start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            this.pollingExecutor().tick(this.pollingInterval(), TimeUnit.MILLISECONDS);
            return ((KubernetesClient)Mockito.verify((Object)this.kubernetesClient(), (VerificationMode)Mockito.never())).pods();
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("SPARK-36334: Support pod listing with resource version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)value -> ExecutorPodsPollingSnapshotSourceSuite.$anonfun$new$5(this, BoxesRunTime.unboxToBoolean((Object)value))), new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }
}

