/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted$;
import org.apache.spark.scheduler.cluster.k8s.PodFailed$;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodPending$;
import org.apache.spark.scheduler.cluster.k8s.PodRunning$;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded$;
import org.apache.spark.scheduler.cluster.k8s.PodUnknown$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\b\u0001C\u0001y\tIR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001cV/\u001b;f\u0015\t1q!A\u0002lqMT!\u0001C\u0005\u0002\u000f\rdWo\u001d;fe*\u0011!bC\u0001\ng\u000eDW\rZ;mKJT!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\t1\"\u0003\u0002\u0017\u0017\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0003\u0002\u0011Q,7\u000f^\"bg\u0016$2!\b\u001b7!\u0011q\u0012eI\u0019\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u00130\u001b\u0005)#B\u0001\u0014(\u0003\u0015iw\u000eZ3m\u0015\tA\u0013&A\u0002ba&T!AK\u0016\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002-[\u00059a-\u00192sS\u000eD$\"\u0001\u0018\u0002\u0005%|\u0017B\u0001\u0019&\u0005\r\u0001v\u000e\u001a\t\u00035IJ!aM\u0003\u0003!\u0015CXmY;u_J\u0004v\u000eZ*uCR,\u0007\"B\u001b\u0003\u0001\u0004\u0019\u0013a\u00019pI\")qG\u0001a\u0001q\u0005)1\u000f^1uKB!a$O\u00122\u0013\tQtDA\u0005Gk:\u001cG/[8oc\u00051Am\u001c+fgR$\"!\u0010!\u0011\u0005yq\u0014BA  \u0005\u0011)f.\u001b;\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002\u0013Q,7\u000f^\"bg\u0016\u001c\bcA\"L;9\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fF\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005){\u0012a\u00029bG.\fw-Z\u0005\u0003\u00196\u00131aU3r\u0015\tQu\u0004")
public class ExecutorPodsSnapshotSuite
extends SparkFunSuite {
    public Tuple2<Pod, ExecutorPodState> testCase(Pod pod, Function1<Pod, ExecutorPodState> state) {
        return new Tuple2((Object)pod, state.apply((Object)pod));
    }

    public void doTest(Seq<Tuple2<Pod, ExecutorPodState>> testCases) {
        ExecutorPodsSnapshot snapshot = ExecutorPodsSnapshot$.MODULE$.apply((Seq)testCases.map((Function1 & Serializable & scala.Serializable)x$1 -> (Pod)x$1._1(), Seq$.MODULE$.canBuildFrom()), 0L);
        ((TraversableLike)testCases.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsSnapshotSuite.$anonfun$doTest$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    ExecutorPodState state = (ExecutorPodState)tuple22._2();
                    return this.assertResult(state.getClass().getName(), new StringBuilder(12).append("executor ID ").append(i).toString(), snapshot.executorPods().apply((Object)BoxesRunTime.boxToLong((long)i)).getClass().getName(), Prettifier$.MODULE$.default(), new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$doTest$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        return tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
    }

    public ExecutorPodsSnapshotSuite() {
        this.test("States are interpreted correctly from pod metadata.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(false);
            Seq testCases = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.testCase(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(0L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodPending$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodRunning$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodSucceeded$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(3L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2()), (Function1<Pod, ExecutorPodState>)PodFailed$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodDeleted$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.unknownExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.unknownExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodUnknown$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.finishedExecutorWithRunningSidecar(6L, 0), (Function1<Pod, ExecutorPodState>)PodSucceeded$.MODULE$), this.testCase(ExecutorLifecycleTestUtils$.MODULE$.finishedExecutorWithRunningSidecar(7L, 1), (Function1<Pod, ExecutorPodState>)PodFailed$.MODULE$)}));
            this.doTest((Seq<Tuple2<Pod, ExecutorPodState>>)testCases);
        }, new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("SPARK-30821: States are interpreted correctly from pod metadata when configured to check all containers.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(true);
            Seq testCases = (Seq)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(0L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodPending$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodRunning$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.runningExecutorWithFailedContainer(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutorWithFailedContainer$default$2()), (Function1<Pod, ExecutorPodState>)PodFailed$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodSucceeded$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(4L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2()), (Function1<Pod, ExecutorPodState>)PodFailed$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodDeleted$.MODULE$), (List)new .colon.colon(this.testCase(ExecutorLifecycleTestUtils$.MODULE$.unknownExecutor(6L, ExecutorLifecycleTestUtils$.MODULE$.unknownExecutor$default$2()), (Function1<Pod, ExecutorPodState>)PodUnknown$.MODULE$), (List)Nil$.MODULE$)))))));
            this.doTest((Seq<Tuple2<Pod, ExecutorPodState>>)testCases);
        }, new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("Updates add new pods for non-matching ids and edit existing pods for matching ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(false);
            Seq originalPods = (Seq)new .colon.colon((Object)ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(0L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()), (List)new .colon.colon((Object)ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()), (List)Nil$.MODULE$));
            ExecutorPodsSnapshot originalSnapshot = ExecutorPodsSnapshot$.MODULE$.apply(originalPods, 0L);
            ExecutorPodsSnapshot snapshotWithUpdatedPod = originalSnapshot.withUpdate(ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor$default$2()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(snapshotWithUpdatedPod.executorPods());
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new PodPending((Pod)originalPods.apply(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)new PodSucceeded(ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor$default$2())))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Pod pendingExec = ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2());
            ExecutorPodsSnapshot snapshotWithNewPod = snapshotWithUpdatedPod.withUpdate(pendingExec);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(snapshotWithNewPod.executorPods());
            Map $org_scalatest_assert_macro_right2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new PodPending((Pod)originalPods.apply(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)new PodSucceeded(ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.succeededExecutor$default$2()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)new PodPending(pendingExec))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("ExecutorPodsSnapshotSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
    }
}

