/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileManager;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rb\u0001B&M\u0001eCQ\u0001\u001a\u0001\u0005\u0002\u0015Dq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004u\u0001\u0001\u0006IA\u001b\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0011\u0019Q\b\u0001)A\u0005o\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\nuD1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(!Y\u0011q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0019\u0011-\t)\u0004\u0001a\u0001\u0002\u0003\u0006K!!\u000b\t\u0017\u0005e\u0002\u00011AA\u0002\u0013%\u00111\b\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0005C\u0006\u0002P\u0001\u0001\r\u0011!Q!\n\u0005u\u0002bCA*\u0001\u0001\u0007\t\u0019!C\u0005\u0003+B1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`!Y\u00111\r\u0001A\u0002\u0003\u0005\u000b\u0015BA,\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%I!!\u001b\t\u0017\u0005\r\u0005\u00011AA\u0002\u0013%\u0011Q\u0011\u0005\f\u0003\u0013\u0003\u0001\u0019!A!B\u0013\tY\u0007C\u0006\u0002\u000e\u0002\u0001\r\u00111A\u0005\n\u0005=\u0005bCA`\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003D1\"!2\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0012\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0007I\u0011BAf\u0011-\t\u0019\u000e\u0001a\u0001\u0002\u0004%I!!6\t\u0017\u0005e\u0007\u00011A\u0001B\u0003&\u0011Q\u001a\u0005\f\u0003;\u0004\u0001\u0019!a\u0001\n\u0013\ty\u000eC\u0006\u0002h\u0002\u0001\r\u00111A\u0005\n\u0005%\bbCAw\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CD1\"!=\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002t\"Y\u00111 \u0001A\u0002\u0003\u0007I\u0011BA\u007f\u0011-\u0011\t\u0001\u0001a\u0001\u0002\u0003\u0006K!!>\t\u0017\t\u0015\u0001\u00011AA\u0002\u0013%!q\u0001\u0005\f\u0005\u001f\u0001\u0001\u0019!a\u0001\n\u0013\u0011\t\u0002C\u0006\u0003\u0016\u0001\u0001\r\u0011!Q!\n\t%\u0001b\u0003B\r\u0001\u0001\u0007\t\u0019!C\u0005\u00057A1Ba\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003&!Y!\u0011\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u000f\u0011-\u0011i\u0003\u0001a\u0001\u0002\u0004%IAa\f\t\u0017\t]\u0002\u00011AA\u0002\u0013%!\u0011\b\u0005\f\u0005{\u0001\u0001\u0019!A!B\u0013\u0011\t\u0004C\u0006\u0003B\u0001\u0001\r\u00111A\u0005\n\t\r\u0003b\u0003B'\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u001fB1Ba\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003F!Y!q\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002B-\u0011-\u0011\t\u0007\u0001a\u0001\u0002\u0004%IAa\u0019\t\u0017\t\u001d\u0004\u00011A\u0001B\u0003&!1\f\u0005\f\u0005W\u0002\u0001\u0019!a\u0001\n\u0013\u0011i\u0007C\u0006\u0003v\u0001\u0001\r\u00111A\u0005\n\t]\u0004b\u0003B>\u0001\u0001\u0007\t\u0011)Q\u0005\u0005_B1Ba \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0002\"Y!\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002BF\u0011-\u0011y\t\u0001a\u0001\u0002\u0003\u0006KAa!\t\u0017\tM\u0005\u00011AA\u0002\u0013%!Q\u0013\u0005\f\u0005;\u0003\u0001\u0019!a\u0001\n\u0013\u0011y\nC\u0006\u0003$\u0002\u0001\r\u0011!Q!\n\t]\u0005b\u0003BT\u0001\u0001\u0007\t\u0019!C\u0005\u0005SC1B!-\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00034\"Y!q\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BV\u0011-\u0011Y\f\u0001a\u0001\u0002\u0004%IA!0\t\u0017\t\u0015\u0007\u00011AA\u0002\u0013%!q\u0019\u0005\f\u0005\u0017\u0004\u0001\u0019!A!B\u0013\u0011y\fC\u0006\u0003P\u0002\u0001\r\u00111A\u0005\n\tE\u0007b\u0003Bp\u0001\u0001\u0007\t\u0019!C\u0005\u0005CD1B!:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003T\"Y!q\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002Bu\u0011-\u0011\t\u0010\u0001a\u0001\u0002\u0004%IAa=\t\u0017\t]\b\u00011A\u0001B\u0003&!1\u001e\u0005\n\u0005s\u0004!\u0019!C\u0005\u0005wD\u0001ba\u0001\u0001A\u0003%!Q \u0005\n\u0007\u000b\u0001!\u0019!C\u0005\u0007\u000fA\u0001b!\u0006\u0001A\u0003%1\u0011\u0002\u0005\n\u0007/\u0001!\u0019!C\u0005\u00073A\u0001b!\t\u0001A\u0003%11\u0004\u0002'\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000eZ*vSR,'BA'O\u0003\rY\u0007h\u001d\u0006\u0003\u001fB\u000bqa\u00197vgR,'O\u0003\u0002R%\u0006I1o\u00195fIVdWM\u001d\u0006\u0003'R\u000bQa\u001d9be.T!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0016aA8sO\u000e\u00011c\u0001\u0001[=B\u00111\fX\u0007\u0002%&\u0011QL\u0015\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u00054\u0016!C:dC2\fG/Z:u\u0013\t\u0019\u0007M\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u00051\u0007CA4\u0001\u001b\u0005a\u0015\u0001G:dQ\u0016$W\u000f\\3s\u000bb,7-\u001e;peN+'O^5dKV\t!\u000e\u0005\u0002le6\tAN\u0003\u0002n]\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=\u0004\u0018a\u00017jE*\u0011\u0011OV\u0001\u0006U6|7m[\u0005\u0003g2\u0014a\u0003R3uKJl\u0017N\\5ti&\u001c7k\u00195fIVdWM]\u0001\u001ag\u000eDW\rZ;mKJ,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\u0005ta\u0006\u00148nQ8oMV\tq\u000f\u0005\u0002\\q&\u0011\u0011P\u0015\u0002\n'B\f'o[\"p]\u001a\f!b\u001d9be.\u001cuN\u001c4!\u0003\t\u00198-F\u0001~!\tYf0\u0003\u0002\u0000%\na1\u000b]1sW\u000e{g\u000e^3yi\u000611oY0%KF$B!!\u0002\u0002\u0012A!\u0011qAA\u0007\u001b\t\tIA\u0003\u0002\u0002\f\u0005)1oY1mC&!\u0011qBA\u0005\u0005\u0011)f.\u001b;\t\u0011\u0005Mq!!AA\u0002u\f1\u0001\u001f\u00132\u0003\r\u00198\r\t\u0015\u0004\u0011\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a+A\u0004n_\u000e\\\u0017\u000e^8\n\t\u0005\r\u0012Q\u0004\u0002\u0005\u001b>\u001c7.A\u0002f]Z,\"!!\u000b\u0011\u0007m\u000bY#C\u0002\u0002.I\u0013\u0001b\u00159be.,eN^\u0001\bK:4x\fJ3r)\u0011\t)!a\r\t\u0013\u0005M!\"!AA\u0002\u0005%\u0012\u0001B3om\u0002B3aCA\r\u0003\u0019\u0011\boY#omV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t*\u0002\u0007I\u00048-\u0003\u0003\u0002H\u0005\u0005#A\u0002*qG\u0016sg/\u0001\u0006sa\u000e,eN^0%KF$B!!\u0002\u0002N!I\u00111C\u0007\u0002\u0002\u0003\u0007\u0011QH\u0001\beB\u001cWI\u001c<!Q\rq\u0011\u0011D\u0001\u0012IJLg/\u001a:F]\u0012\u0004x.\u001b8u%\u00164WCAA,!\u0011\ty$!\u0017\n\t\u0005m\u0013\u0011\t\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0003U!'/\u001b<fe\u0016sG\r]8j]R\u0014VMZ0%KF$B!!\u0002\u0002b!I\u00111\u0003\t\u0002\u0002\u0003\u0007\u0011qK\u0001\u0013IJLg/\u001a:F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0005K\u0002\u0012\u00033\t\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0016\u0005\u0005-\u0004\u0003BA7\u0003\u007fj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0007G2LWM\u001c;\u000b\t\u0005U\u0014qO\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA=\u0003w\nqAZ1ce&\u001c\u0007H\u0003\u0002\u0002~\u0005\u0011\u0011n\\\u0005\u0005\u0003\u0003\u000byG\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u0006!2.\u001e2fe:,G/Z:DY&,g\u000e^0%KF$B!!\u0002\u0002\b\"I\u00111C\n\u0002\u0002\u0003\u0007\u00111N\u0001\u0012WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\u0003f\u0001\u000b\u0002\u001a\u0005i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!!%\u0011\t\u0005M\u0015\u0011\u0018\b\u0005\u0003+\u000b\u0019L\u0004\u0003\u0002\u0018\u0006=f\u0002BAM\u0003WsA!a'\u0002*:!\u0011QTAT\u001d\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR1\u00061AH]8pizJ\u0011aV\u0005\u0003+ZK!a\u0015+\n\u0007\u00055&+\u0001\u0004eKBdw._\u0005\u0004\u001b\u0006E&bAAW%&!\u0011QWA\\\u000391\u0015M\u0019:jGb\nE.[1tKNT1!TAY\u0013\u0011\tY,!0\u0003\tA{Ei\u0015\u0006\u0005\u0003k\u000b9,A\tq_\u0012|\u0005/\u001a:bi&|gn]0%KF$B!!\u0002\u0002D\"I\u00111\u0003\f\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u000fa>$w\n]3sCRLwN\\:!Q\r9\u0012\u0011D\u0001\u0012a>$7oV5uQ:\u000bW.Z:qC\u000e,WCAAg!\u0011\t\u0019*a4\n\t\u0005E\u0017Q\u0018\u0002\u0014!>#5kX,J)\"{f*Q'F'B\u000b5)R\u0001\u0016a>$7oV5uQ:\u000bW.Z:qC\u000e,w\fJ3r)\u0011\t)!a6\t\u0013\u0005M\u0011$!AA\u0002\u00055\u0017A\u00059pIN<\u0016\u000e\u001e5OC6,7\u000f]1dK\u0002B3AGA\r\u0003-a\u0017MY3mK\u0012\u0004v\u000eZ:\u0016\u0005\u0005\u0005\b\u0003BAJ\u0003GLA!!:\u0002>\naA*\u0011\"F\u0019\u0016#u\fU(E'\u0006yA.\u00192fY\u0016$\u0007k\u001c3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\b\"CA\n9\u0005\u0005\t\u0019AAq\u00031a\u0017MY3mK\u0012\u0004v\u000eZ:!Q\ri\u0012\u0011D\u0001\u0015G>tg-[4NCB\u001cx\n]3sCRLwN\\:\u0016\u0005\u0005U\b\u0003BAJ\u0003oLA!!?\u0002>\nY1i\u0014(G\u0013\u001e{V*\u0011)T\u0003a\u0019wN\u001c4jO6\u000b\u0007o](qKJ\fG/[8og~#S-\u001d\u000b\u0005\u0003\u000b\ty\u0010C\u0005\u0002\u0014}\t\t\u00111\u0001\u0002v\u0006)2m\u001c8gS\u001el\u0015\r]:Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003f\u0001\u0011\u0002\u001a\u000592m\u001c8gS\u001el\u0015\r]:XSRDg*Y7fgB\f7-Z\u000b\u0003\u0005\u0013\u0001B!a%\u0003\f%!!QBA_\u0005i\u0019uJ\u0014$J\u000f~k\u0015\tU*`/&#\u0006j\u0018(B\u001b\u0016\u001b\u0006+Q\"F\u0003m\u0019wN\u001c4jO6\u000b\u0007o],ji\"t\u0015-\\3ta\u0006\u001cWm\u0018\u0013fcR!\u0011Q\u0001B\n\u0011%\t\u0019BIA\u0001\u0002\u0004\u0011I!\u0001\rd_:4\u0017nZ'baN<\u0016\u000e\u001e5OC6,7\u000f]1dK\u0002B3aIA\r\u0003E\u0019wN\u001c4jO6\u000b\u0007OU3t_V\u00148-Z\u000b\u0003\u0005;\u0001B!a%\u0003 %!!\u0011EA_\u0005Q\u0019uJ\u0014$J\u000f~k\u0015\tU*`%\u0016\u001bv*\u0016*D\u000b\u0006)2m\u001c8gS\u001el\u0015\r\u001d*fg>,(oY3`I\u0015\fH\u0003BA\u0003\u0005OA\u0011\"a\u0005&\u0003\u0003\u0005\rA!\b\u0002%\r|gNZ5h\u001b\u0006\u0004(+Z:pkJ\u001cW\r\t\u0015\u0004M\u0005e\u0011!\u00057bE\u0016dW\rZ\"p]\u001aLw-T1qgV\u0011!\u0011\u0007\t\u0005\u0003'\u0013\u0019$\u0003\u0003\u00036\u0005u&a\u0005'B\u0005\u0016cU\tR0D\u001f:3\u0015jR0N\u0003B\u001b\u0016!\u00067bE\u0016dW\rZ\"p]\u001aLw-T1qg~#S-\u001d\u000b\u0005\u0003\u000b\u0011Y\u0004C\u0005\u0002\u0014!\n\t\u00111\u0001\u00032\u0005\u0011B.\u00192fY\u0016$7i\u001c8gS\u001el\u0015\r]:!Q\rI\u0013\u0011D\u0001\u000ei\u0006\u001c8nU2iK\u0012,H.\u001a:\u0016\u0005\t\u0015\u0003\u0003\u0002B$\u0005\u0013j\u0011\u0001U\u0005\u0004\u0005\u0017\u0002&!\u0005+bg.\u001c6\r[3ek2,'/S7qY\u0006\tB/Y:l'\u000eDW\rZ;mKJ|F%Z9\u0015\t\u0005\u0015!\u0011\u000b\u0005\n\u0003'Y\u0013\u0011!a\u0001\u0005\u000b\na\u0002^1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005K\u0002-\u00033\t!\"\u001a<f]R\fV/Z;f+\t\u0011Y\u0006E\u0002h\u0005;J1Aa\u0018M\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u00039)g/\u001a8u#V,W/Z0%KF$B!!\u0002\u0003f!I\u00111\u0003\u0018\u0002\u0002\u0003\u0007!1L\u0001\fKZ,g\u000e^)vKV,\u0007\u0005K\u00020\u00033\tA\u0002]8e\u00032dwnY1u_J,\"Aa\u001c\u0011\u0007\u001d\u0014\t(C\u0002\u0003t1\u0013Q#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'/\u0001\tq_\u0012\fE\u000e\\8dCR|'o\u0018\u0013fcR!\u0011Q\u0001B=\u0011%\t\u0019\"MA\u0001\u0002\u0004\u0011y'A\u0007q_\u0012\fE\u000e\\8dCR|'\u000f\t\u0015\u0004e\u0005e\u0011!\u00067jM\u0016\u001c\u0017p\u00197f\u000bZ,g\u000e\u001e%b]\u0012dWM]\u000b\u0003\u0005\u0007\u00032a\u001aBC\u0013\r\u00119\t\u0014\u0002\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0003ea\u0017NZ3ds\u000edW-\u0012<f]RD\u0015M\u001c3mKJ|F%Z9\u0015\t\u0005\u0015!Q\u0012\u0005\n\u0003'!\u0014\u0011!a\u0001\u0005\u0007\u000ba\u0003\\5gK\u000eL8\r\\3Fm\u0016tG\u000fS1oI2,'\u000f\t\u0015\u0004k\u0005e\u0011aC<bi\u000eDWI^3oiN,\"Aa&\u0011\u0007\u001d\u0014I*C\u0002\u0003\u001c2\u0013q$\u0012=fGV$xN\u001d)pIN<\u0016\r^2i':\f\u0007o\u001d5piN{WO]2f\u0003=9\u0018\r^2i\u000bZ,g\u000e^:`I\u0015\fH\u0003BA\u0003\u0005CC\u0011\"a\u00058\u0003\u0003\u0005\rAa&\u0002\u0019]\fGo\u00195Fm\u0016tGo\u001d\u0011)\u0007a\nI\"\u0001\u0006q_2dWI^3oiN,\"Aa+\u0011\u0007\u001d\u0014i+C\u0002\u000302\u0013\u0011%\u0012=fGV$xN\u001d)pIN\u0004v\u000e\u001c7j]\u001e\u001cf.\u00199tQ>$8k\\;sG\u0016\fa\u0002]8mY\u00163XM\u001c;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\tU\u0006\"CA\nu\u0005\u0005\t\u0019\u0001BV\u0003-\u0001x\u000e\u001c7Fm\u0016tGo\u001d\u0011)\u0007m\nI\"A\u0004d_:$X\r\u001f;\u0016\u0005\t}\u0006\u0003BA \u0005\u0003LAAa1\u0002B\tq!\u000b]2DC2d7i\u001c8uKb$\u0018aC2p]R,\u0007\u0010^0%KF$B!!\u0002\u0003J\"I\u00111C\u001f\u0002\u0002\u0003\u0007!qX\u0001\tG>tG/\u001a=uA!\u001aa(!\u0007\u0002\u001d\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oiV\u0011!1\u001b\t\u0007\u00037\u0011)N!7\n\t\t]\u0017Q\u0004\u0002\u000f\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s!\u0011\tyDa7\n\t\tu\u0017\u0011\t\u0002\f%B\u001cWI\u001c3q_&tG/\u0001\nee&4XM]#oIB|\u0017N\u001c;`I\u0015\fH\u0003BA\u0003\u0005GD\u0011\"a\u0005A\u0003\u0003\u0005\rAa5\u0002\u001f\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oi\u0002\n\u0011d]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3V]\u0012,'\u000fV3tiV\u0011!1\u001e\t\u0004O\n5\u0018b\u0001Bx\u0019\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI\u0006i2o\u00195fIVdWM\u001d\"bG.,g\u000eZ+oI\u0016\u0014H+Z:u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\tU\b\"CA\n\u0007\u0006\u0005\t\u0019\u0001Bv\u0003i\u00198\r[3ek2,'OQ1dW\u0016tG-\u00168eKJ$Vm\u001d;!\u0003-a\u0017n\u001d;f]\u0016\u0014()^:\u0016\u0005\tu\b\u0003\u0002B$\u0005\u007fL1a!\u0001Q\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\u0018\u0001\u00047jgR,g.\u001a:CkN\u0004\u0013A\u0006:fg>,(oY3Qe>4\u0017\u000e\\3NC:\fw-\u001a:\u0016\u0005\r%\u0001\u0003BB\u0006\u0007#i!a!\u0004\u000b\u0007\r=!+\u0001\u0005sKN|WO]2f\u0013\u0011\u0019\u0019b!\u0004\u0003-I+7o\\;sG\u0016\u0004&o\u001c4jY\u0016l\u0015M\\1hKJ\fqC]3t_V\u00148-\u001a)s_\u001aLG.Z'b]\u0006<WM\u001d\u0011\u0002\u001d\u0011,g-Y;miB\u0013xNZ5mKV\u001111\u0004\t\u0005\u0007\u0017\u0019i\"\u0003\u0003\u0004 \r5!a\u0004*fg>,(oY3Qe>4\u0017\u000e\\3\u0002\u001f\u0011,g-Y;miB\u0013xNZ5mK\u0002\u0002")
public class KubernetesClusterSchedulerBackendSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final DeterministicScheduler schedulerExecutorService;
    private final SparkConf sparkConf;
    @Mock
    private SparkContext sc;
    @Mock
    private SparkEnv env;
    @Mock
    private RpcEnv rpcEnv;
    @Mock
    private RpcEndpointRef driverEndpointRef;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> labeledPods;
    @Mock
    private MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsOperations;
    @Mock
    private NonNamespaceOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsWithNamespace;
    @Mock
    private Resource<ConfigMap> configMapResource;
    @Mock
    private FilterWatchListDeletable<ConfigMap, ConfigMapList, Resource<ConfigMap>> labeledConfigMaps;
    @Mock
    private TaskSchedulerImpl taskScheduler;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    @Mock
    private ExecutorPodsAllocator podAllocator;
    @Mock
    private ExecutorPodsLifecycleManager lifecycleEventHandler;
    @Mock
    private ExecutorPodsWatchSnapshotSource watchEvents;
    @Mock
    private ExecutorPodsPollingSnapshotSource pollEvents;
    @Mock
    private RpcCallContext context;
    private ArgumentCaptor<RpcEndpoint> driverEndpoint;
    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest;
    private final LiveListenerBus listenerBus;
    private final ResourceProfileManager resourceProfileManager;
    private final ResourceProfile defaultProfile;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private DeterministicScheduler schedulerExecutorService() {
        return this.schedulerExecutorService;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    private RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    private void rpcEnv_$eq(RpcEnv x$1) {
        this.rpcEnv = x$1;
    }

    private RpcEndpointRef driverEndpointRef() {
        return this.driverEndpointRef;
    }

    private void driverEndpointRef_$eq(RpcEndpointRef x$1) {
        this.driverEndpointRef = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.labeledPods = x$1;
    }

    private MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsOperations() {
        return this.configMapsOperations;
    }

    private void configMapsOperations_$eq(MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> x$1) {
        this.configMapsOperations = x$1;
    }

    private NonNamespaceOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsWithNamespace() {
        return this.configMapsWithNamespace;
    }

    private void configMapsWithNamespace_$eq(NonNamespaceOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> x$1) {
        this.configMapsWithNamespace = x$1;
    }

    private Resource<ConfigMap> configMapResource() {
        return this.configMapResource;
    }

    private void configMapResource_$eq(Resource<ConfigMap> x$1) {
        this.configMapResource = x$1;
    }

    private FilterWatchListDeletable<ConfigMap, ConfigMapList, Resource<ConfigMap>> labeledConfigMaps() {
        return this.labeledConfigMaps;
    }

    private void labeledConfigMaps_$eq(FilterWatchListDeletable<ConfigMap, ConfigMapList, Resource<ConfigMap>> x$1) {
        this.labeledConfigMaps = x$1;
    }

    private TaskSchedulerImpl taskScheduler() {
        return this.taskScheduler;
    }

    private void taskScheduler_$eq(TaskSchedulerImpl x$1) {
        this.taskScheduler = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private ExecutorPodsAllocator podAllocator() {
        return this.podAllocator;
    }

    private void podAllocator_$eq(ExecutorPodsAllocator x$1) {
        this.podAllocator = x$1;
    }

    private ExecutorPodsLifecycleManager lifecycleEventHandler() {
        return this.lifecycleEventHandler;
    }

    private void lifecycleEventHandler_$eq(ExecutorPodsLifecycleManager x$1) {
        this.lifecycleEventHandler = x$1;
    }

    private ExecutorPodsWatchSnapshotSource watchEvents() {
        return this.watchEvents;
    }

    private void watchEvents_$eq(ExecutorPodsWatchSnapshotSource x$1) {
        this.watchEvents = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollEvents() {
        return this.pollEvents;
    }

    private void pollEvents_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollEvents = x$1;
    }

    private RpcCallContext context() {
        return this.context;
    }

    private void context_$eq(RpcCallContext x$1) {
        this.context = x$1;
    }

    private ArgumentCaptor<RpcEndpoint> driverEndpoint() {
        return this.driverEndpoint;
    }

    private void driverEndpoint_$eq(ArgumentCaptor<RpcEndpoint> x$1) {
        this.driverEndpoint = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest() {
        return this.schedulerBackendUnderTest;
    }

    private void schedulerBackendUnderTest_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackendUnderTest = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private ResourceProfileManager resourceProfileManager() {
        return this.resourceProfileManager;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public KubernetesClusterSchedulerBackendSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.schedulerExecutorService = new DeterministicScheduler();
        this.sparkConf = new SparkConf(false).set("spark.executor.instances", "3").set("spark.app.id", ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL().key(), "soLong").set(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE().key(), "cruelWorld");
        this.listenerBus = new LiveListenerBus(new SparkConf());
        this.resourceProfileManager = new ResourceProfileManager(this.sparkConf(), this.listenerBus());
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.sparkConf());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.taskScheduler().sc()).thenReturn((Object)this.sc());
            Mockito.when((Object)this.sc().conf()).thenReturn((Object)this.sparkConf());
            Mockito.when((Object)this.sc().resourceProfileManager()).thenReturn((Object)this.resourceProfileManager());
            Mockito.when((Object)this.sc().env()).thenReturn((Object)this.env());
            Mockito.when((Object)this.env().rpcEnv()).thenReturn((Object)this.rpcEnv());
            this.driverEndpoint_$eq((ArgumentCaptor<RpcEndpoint>)ArgumentCaptor.forClass(RpcEndpoint.class));
            Mockito.when((Object)this.rpcEnv().setupEndpoint((String)ArgumentMatchers.eq((Object)CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()), (RpcEndpoint)this.driverEndpoint().capture())).thenReturn((Object)this.driverEndpointRef());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace("default")).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.kubernetesClient().configMaps()).thenReturn(this.configMapsOperations());
            Mockito.when((Object)this.configMapsOperations().inNamespace("default")).thenReturn(this.configMapsWithNamespace());
            Mockito.when((Object)this.configMapsWithNamespace().resource(ArgumentMatchers.any())).thenReturn(this.configMapResource());
            Mockito.when((Object)this.podAllocator().driverPod()).thenReturn((Object)None$.MODULE$);
            this.schedulerBackendUnderTest_$eq(new KubernetesClusterSchedulerBackend(this.taskScheduler(), this.sc(), this.kubernetesClient(), (ScheduledExecutorService)this.schedulerExecutorService(), this.eventQueue(), (AbstractPodsAllocator)this.podAllocator(), this.lifecycleEventHandler(), this.watchEvents(), this.pollEvents()));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ResourceProfile$.MODULE$.clearDefaultProfile(), new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("Start all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3))})));
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackendUnderTest());
            ((ExecutorPodsLifecycleManager)Mockito.verify((Object)this.lifecycleEventHandler())).start(this.schedulerBackendUnderTest());
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return (ConfigMap)((CreateOrReplaceable)Mockito.verify(this.configMapResource())).create();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("Stop all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.configMapsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledConfigMaps());
            Mockito.when((Object)this.labeledConfigMaps().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledConfigMaps());
            this.schedulerBackendUnderTest().stop();
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).stop();
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).stop();
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).stop();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).stop(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((Deletable)Mockito.verify(this.labeledConfigMaps())).delete();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("Remove executor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClusterSchedulerBackend backend = (KubernetesClusterSchedulerBackend)Mockito.spy((Object)this.schedulerBackendUnderTest());
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.eq((Object)"2")))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            backend.start();
            backend.doRemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            backend.doRemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("Kill executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.podsWithNamespace().withField((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2"})).thenReturn(this.labeledPods());
            PodResource pod1op = (PodResource)Mockito.mock(PodResource.class);
            PodResource pod2op = (PodResource)Mockito.mock(PodResource.class);
            Mockito.when((Object)this.labeledPods().resources()).thenReturn(Arrays.asList((Object[])new PodResource[0]).stream());
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerBackendUnderTest().doKillExecutors((Seq)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)Nil$.MODULE$)));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            ((EditReplacePatchable)Mockito.verify((Object)pod1op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((EditReplacePatchable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            ((EditReplacePatchable)Mockito.verify((Object)pod1op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((EditReplacePatchable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            Mockito.when((Object)this.labeledPods().resources()).thenReturn(Arrays.asList((Object[])new PodResource[]{pod1op}).stream());
            PodList podList = (PodList)Mockito.mock(PodList.class);
            Mockito.when((Object)this.labeledPods().list()).thenReturn((Object)podList);
            Pod pod1 = (Pod)Mockito.mock(Pod.class);
            Pod pod2 = (Pod)Mockito.mock(Pod.class);
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[]{pod1, pod2}));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)Nil$.MODULE$)));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().runUntilIdle();
            ((EditReplacePatchable)Mockito.verify((Object)pod1op)).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((EditReplacePatchable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("SPARK-34407: CoarseGrainedSchedulerBackend.stop may throw SparkException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.driverEndpointRef().askSync((Object)CoarseGrainedClusterMessages.StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean())).thenThrow(new Throwable[]{new RuntimeException()});
            this.schedulerBackendUnderTest().stop();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("SPARK-34469: Ignore RegisterExecutor when SparkContext is stopped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.sc().isStopped())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            CoarseGrainedSchedulerBackend.DriverEndpoint endpoint = this.schedulerBackendUnderTest().createDriverEndpoint();
            endpoint.receiveAndReply(null).apply((Object)new CoarseGrainedClusterMessages.RegisterExecutor("1", null, "host1", 1, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), 0));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("Dynamically fetch an executor ID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CoarseGrainedSchedulerBackend.DriverEndpoint endpoint = this.schedulerBackendUnderTest().createDriverEndpoint();
            endpoint.receiveAndReply(this.context()).apply((Object)new GenerateExecID("cheeseBurger"));
            ((RpcCallContext)Mockito.verify((Object)this.context())).reply((Object)"1");
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
    }
}

