/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.scheduler.cluster.k8s.PodTerminating;
import org.apache.spark.scheduler.cluster.k8s.PodUnknown;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ExecutorPodsSnapshot$
implements Logging,
scala.Serializable {
    public static ExecutorPodsSnapshot$ MODULE$;
    private boolean shouldCheckAllContainers;
    private String sparkContainerName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExecutorPodsSnapshot$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean shouldCheckAllContainers() {
        return this.shouldCheckAllContainers;
    }

    private void shouldCheckAllContainers_$eq(boolean x$1) {
        this.shouldCheckAllContainers = x$1;
    }

    private String sparkContainerName() {
        return this.sparkContainerName;
    }

    private void sparkContainerName_$eq(String x$1) {
        this.sparkContainerName = x$1;
    }

    public ExecutorPodsSnapshot apply(Seq<Pod> executorPods, long fullSnapshotTs) {
        return new ExecutorPodsSnapshot(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(executorPods), fullSnapshotTs);
    }

    public ExecutorPodsSnapshot apply() {
        return new ExecutorPodsSnapshot((Map<Object, ExecutorPodState>)Predef$.MODULE$.Map().empty(), 0L);
    }

    public void setShouldCheckAllContainers(boolean watchAllContainers) {
        this.shouldCheckAllContainers_$eq(watchAllContainers);
    }

    public void setSparkContainerName(String containerName) {
        this.sparkContainerName_$eq(containerName);
    }

    public Map<Object, ExecutorPodState> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(Seq<Pod> executorPods) {
        return ((TraversableOnce)executorPods.flatMap((Function1 & Serializable & scala.Serializable)pod -> {
            String string = (String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL());
            if ("EXECID".equals(string) ? true : string == null) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong()), (Object)MODULE$.toState((Pod)pod))));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private ExecutorPodState toState(Pod pod) {
        if (this.isDeleted(pod)) {
            return new PodDeleted(pod);
        }
        String phase = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
        String string = phase;
        if ("pending".equals(string)) {
            return new PodPending(pod);
        }
        if ("running".equals(string)) {
            if (this.shouldCheckAllContainers() && "Never".equals(pod.getSpec().getRestartPolicy()) && pod.getStatus().getContainerStatuses().stream().map(cs -> cs.getState().getTerminated()).anyMatch(t -> t != null && !BoxesRunTime.equalsNumObject((Number)t.getExitCode(), (Object)BoxesRunTime.boxToInteger((int)0)))) {
                return new PodFailed(pod);
            }
            Option sparkContainerExitCode = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsSnapshot$.$anonfun$toState$3(x$1))).flatMap((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.apply((Object)x.getState())).flatMap((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.apply((Object)x.getTerminated())).flatMap((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.apply((Object)x.getExitCode())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)));
            Option option = sparkContainerExitCode;
            if (option instanceof Some) {
                int t2;
                Some some = (Some)option;
                int n = t2 = BoxesRunTime.unboxToInt((Object)some.value());
                switch (n) {
                    case 0: {
                        return new PodSucceeded(pod);
                    }
                }
                return new PodFailed(pod);
            }
            return new PodRunning(pod);
        }
        if ("failed".equals(string)) {
            return new PodFailed(pod);
        }
        if ("succeeded".equals(string)) {
            return new PodSucceeded(pod);
        }
        if ("terminating".equals(string)) {
            return new PodTerminating(pod);
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Received unknown phase ").append(phase).append(" for executor pod with name").append(" ").append(pod.getMetadata().getName()).append(" in namespace ").append(pod.getMetadata().getNamespace()).toString());
        return new PodUnknown(pod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeleted(Pod pod) {
        if (pod.getMetadata().getDeletionTimestamp() == null) return false;
        if (pod.getStatus() == null) return true;
        if (pod.getStatus().getPhase() == null) return true;
        String string = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
        String string2 = "terminating";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
        String string4 = "running";
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    public ExecutorPodsSnapshot apply(Map<Object, ExecutorPodState> executorPods, long fullSnapshotTs) {
        return new ExecutorPodsSnapshot(executorPods, fullSnapshotTs);
    }

    public Option<Tuple2<Map<Object, ExecutorPodState>, Object>> unapply(ExecutorPodsSnapshot x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.executorPods(), (Object)BoxesRunTime.boxToLong((long)x$0.fullSnapshotTs())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$toState$3(ContainerStatus x$1) {
        String string = x$1.getName();
        String string2 = MODULE$.sparkContainerName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ExecutorPodsSnapshot$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.sparkContainerName = Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME();
    }
}

