/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.squaredDistance$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005]2AAC\u0006\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0016\u0001A\u0003%\u0011\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u001d\t\u0004A1A\u0005\u0002IBa\u0001\u000e\u0001!\u0002\u0013\u0019\u0004bB\u001b\u0001\u0005\u0004%\t\u0001\t\u0005\u0007m\u0001\u0001\u000b\u0011B\u0011\u0003\u0019Y+7\r^8sgN+\u0018\u000e^3\u000b\u00051i\u0011A\u00027j]\u0006dwM\u0003\u0002\u000f\u001f\u0005\u0011Q\u000e\u001c\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\u000e\u0013\tQRBA\bTa\u0006\u00148.\u0014'Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t1\"A\u0002beJ,\u0012!\t\t\u0004E\u0015:S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tB\u0013BA\u0015$\u0005\u0019!u.\u001e2mK\u0006!\u0011M\u001d:!\u0003\u0005qW#A\u0017\u0011\u0005\tr\u0013BA\u0018$\u0005\rIe\u000e^\u0001\u0003]\u0002\nq!\u001b8eS\u000e,7/F\u00014!\r\u0011S%L\u0001\tS:$\u0017nY3tA\u00051a/\u00197vKN\fqA^1mk\u0016\u001c\b\u0005")
public class VectorsSuite
extends SparkMLFunSuite {
    private final double[] arr = new double[]{0.1, 0.0, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 2, 3};
    private final double[] values = new double[]{0.1, 0.3, 0.4};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public static final /* synthetic */ Assertion $anonfun$new$30(Random random$1, int m) {
        int nnz = random$1.nextInt(m);
        int[] indices1 = (int[])((IterableOnceOps)((SeqOps)((IndexedSeqOps)random$1.shuffle((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), m - 1), BuildFrom$.MODULE$.buildFromIterableOps())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        double[] values1 = (double[])Array$.MODULE$.fill(nnz, (Function0)(JFunction0.mcD.sp & Serializable)() -> random$1.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        Vector sparseVector1 = Vectors$.MODULE$.sparse(m, indices1, values1);
        int[] indices2 = (int[])((IterableOnceOps)((SeqOps)((IndexedSeqOps)random$1.shuffle((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), m - 1), BuildFrom$.MODULE$.buildFromIterableOps())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        double[] values2 = (double[])Array$.MODULE$.fill(nnz, (Function0)(JFunction0.mcD.sp & Serializable)() -> random$1.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        Vector sparseVector2 = Vectors$.MODULE$.sparse(m, indices2, values2);
        Vector denseVector1 = Vectors$.MODULE$.dense(sparseVector1.toArray());
        Vector denseVector2 = Vectors$.MODULE$.dense(sparseVector2.toArray());
        double squaredDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)sparseVector1.asBreeze(), (Object)sparseVector2.asBreeze(), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)HasOps$.MODULE$.zipValuesImpl_V_V_Double())));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(sparseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(sparseVector1, sparseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, sparseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, denseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, denseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    public VectorsSuite() {
        this.n = 4;
        this.test("dense vector construction with varargs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.arr().length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            double[] $org_scalatest_assert_macro_left2 = vec.values();
            double[] $org_scalatest_assert_macro_right2 = this.arr();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("dense vector construction from a double array", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.arr().length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            double[] $org_scalatest_assert_macro_left2 = vec.values();
            double[] $org_scalatest_assert_macro_right2 = this.arr();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("sparse vector construction", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.n();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            int[] $org_scalatest_assert_macro_left2 = vec.indices();
            int[] $org_scalatest_assert_macro_right2 = this.indices();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            double[] $org_scalatest_assert_macro_left3 = vec.values();
            double[] $org_scalatest_assert_macro_right3 = this.values();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("sparse vector construction with unordered elements", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.n(), (Seq)ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.intArrayOps(this.indices()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.values()))))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.n();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(vec.indices());
            int[] $org_scalatest_assert_macro_right2 = this.indices();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(vec.values());
            double[] $org_scalatest_assert_macro_right3 = this.values();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("sparse vector construction with mismatched indices/values array", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0, 7.0, 9.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("sparse vector construction with too many indices vs size", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(3, new int[]{1, 2, 3, 4}, new double[]{3.0, 5.0, 7.0, 9.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73)), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("sparse vector construction with negative indices", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(3, new int[]{-1, 1}, new double[]{3.0, 5.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("dense to array", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double[] $org_scalatest_assert_macro_right;
            double[] $org_scalatest_assert_macro_left;
            DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.arr());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = vec.toArray()) == ($org_scalatest_assert_macro_right = this.arr()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("dense argmax", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DenseVector vec = (DenseVector)Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
            int $org_scalatest_assert_macro_right = -1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            DenseVector vec2 = (DenseVector)Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            DenseVector vec3 = (DenseVector)Vectors$.MODULE$.dense(new double[]{-1.0, 0.0, -2.0, 1.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("sparse to array", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(vec.toArray());
            double[] $org_scalatest_assert_macro_right = this.arr();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("sparse argmax", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(0, (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
            int $org_scalatest_assert_macro_right = -1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            SparseVector vec2 = (SparseVector)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Vector vec3 = Vectors$.MODULE$.sparse(5, new int[]{2, 3, 4}, new double[]{1.0, 0.0, -0.7});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Vector vec4 = Vectors$.MODULE$.sparse(5, new int[]{2, 3}, new double[]{-1.0, -0.7});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec4.argmax()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Vector vec5 = Vectors$.MODULE$.sparse(11, new int[]{0, 3, 10}, new double[]{-1.0, -0.7, 0.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec5.argmax()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Vector vec6 = Vectors$.MODULE$.sparse(11, new int[]{0, 1, 2}, new double[]{-1.0, -0.7, 0.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec6.argmax()));
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Vector vec7 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{-1.0, 0.0, -0.7});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec7.argmax()));
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Vector vec8 = Vectors$.MODULE$.sparse(5, new int[]{1, 2}, new double[]{0.0, -1.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec8.argmax()));
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            SparseVector vec9 = (SparseVector)Vectors$.MODULE$.sparse(100, (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec9.argmax()));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            SparseVector vec10 = (SparseVector)Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec10.argmax()));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("vector equals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Vector dv1 = Vectors$.MODULE$.dense((double[])this.arr().clone());
            Vector dv2 = Vectors$.MODULE$.dense((double[])this.arr().clone());
            Vector sv1 = Vectors$.MODULE$.sparse(this.n(), (int[])this.indices().clone(), (double[])this.values().clone());
            Vector sv2 = Vectors$.MODULE$.sparse(this.n(), (int[])this.indices().clone(), (double[])this.values().clone());
            .colon.colon vectors = new .colon.colon((Object)dv1, (List)new .colon.colon((Object)dv2, (List)new .colon.colon((Object)sv1, (List)new .colon.colon((Object)sv2, (List)Nil$.MODULE$))));
            vectors.foreach(arg_0 -> VectorsSuite.$anonfun$new$17$adapted(this, (Seq)vectors, arg_0));
            Vector another = Vectors$.MODULE$.dense(0.1, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4}));
            vectors.foreach((Function1 & Serializable)v -> {
                Vector $org_scalatest_assert_macro_left = v;
                Vector $org_scalatest_assert_macro_right = another;
                Vector vector = $org_scalatest_assert_macro_left;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector == null ? vector2 != null : !vector.equals(vector2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                int $org_scalatest_assert_macro_left2 = Statics.anyHash((Object)v);
                int $org_scalatest_assert_macro_right2 = Statics.anyHash((Object)another);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            });
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("vectors equals with explicit 0", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Vector dv1 = Vectors$.MODULE$.dense(new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
            Vector sv1 = Vectors$.MODULE$.sparse(5, new int[]{1, 3}, new double[]{0.9, 0.8});
            Vector sv2 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 2, 3, 4}, new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
            .colon.colon vectors = new .colon.colon((Object)dv1, (List)new .colon.colon((Object)sv1, (List)new .colon.colon((Object)sv2, (List)Nil$.MODULE$)));
            vectors.foreach(arg_0 -> VectorsSuite.$anonfun$new$21$adapted(this, (Seq)vectors, arg_0));
            Vector another = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{0.0, 0.9, 0.2});
            vectors.foreach((Function1 & Serializable)v -> {
                Vector $org_scalatest_assert_macro_left = v;
                Vector $org_scalatest_assert_macro_right = another;
                Vector vector = $org_scalatest_assert_macro_left;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector == null ? vector2 != null : !vector.equals(vector2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                int $org_scalatest_assert_macro_left2 = Statics.anyHash((Object)v);
                int $org_scalatest_assert_macro_right2 = Statics.anyHash((Object)another);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            });
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("indexing dense vectors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector vec = Vectors$.MODULE$.dense(1.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
            double $org_scalatest_assert_macro_right2 = 4.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("indexing sparse vectors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector vec = Vectors$.MODULE$.sparse(7, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(1)));
            double $org_scalatest_assert_macro_right2 = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(2)));
            double $org_scalatest_assert_macro_right3 = 2.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(6)));
            double $org_scalatest_assert_macro_right5 = 4.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Vector vec2 = Vectors$.MODULE$.sparse(8, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(6)));
            double $org_scalatest_assert_macro_right6 = 4.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(7)));
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("zeros", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Vectors$.MODULE$.zeros(3));
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("Vector.copy", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector sparseVector;
            Vector svCopy;
            block7: {
                Vector svCopy2;
                Vector sv;
                block6: {
                    sv = Vectors$.MODULE$.sparse(4, new int[]{0, 2}, new double[]{1.0, 2.0});
                    Tuple2 tuple2 = new Tuple2((Object)sv, (Object)(svCopy2 = sv.copy()));
                    if (tuple2 == null) break block6;
                    Vector sv2 = (Vector)tuple2._1();
                    svCopy = (Vector)tuple2._2();
                    if (!(sv2 instanceof SparseVector)) break block6;
                    sparseVector = (SparseVector)sv2;
                    if (svCopy instanceof SparseVector) break block7;
                }
                throw new RuntimeException("copy returned " + svCopy2.getClass() + " on " + sv.getClass() + ".");
            }
            SparseVector sparseVector2 = (SparseVector)svCopy;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparseVector.size()));
            int $org_scalatest_assert_macro_right = sparseVector2.size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sparseVector.indices());
            int[] $org_scalatest_assert_macro_right2 = sparseVector2.indices();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(sparseVector.values());
            double[] $org_scalatest_assert_macro_right3 = sparseVector2.values();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            int[] $org_scalatest_assert_macro_left4 = sparseVector.indices();
            int[] $org_scalatest_assert_macro_right4 = sparseVector2.indices();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            double[] $org_scalatest_assert_macro_left5 = sparseVector.values();
            double[] $org_scalatest_assert_macro_right5 = sparseVector2.values();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Vector dv = Vectors$.MODULE$.dense(1.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0}));
            Vector dvCopy = dv.copy();
            Tuple2 tuple2 = new Tuple2((Object)dv, (Object)dvCopy);
            if (tuple2 != null) {
                Vector dv2 = (Vector)tuple2._1();
                Vector dvCopy2 = (Vector)tuple2._2();
                if (dv2 instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dv2;
                    if (dvCopy2 instanceof DenseVector) {
                        DenseVector denseVector2 = (DenseVector)dvCopy2;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)denseVector.size()));
                        int $org_scalatest_assert_macro_right6 = denseVector2.size();
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(denseVector.values());
                        double[] $org_scalatest_assert_macro_right7 = denseVector2.values();
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
                        double[] $org_scalatest_assert_macro_left8 = denseVector.values();
                        double[] $org_scalatest_assert_macro_right8 = denseVector2.values();
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
                    }
                }
            }
            throw new RuntimeException("copy returned " + dvCopy.getClass() + " on " + dv.getClass() + ".");
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("fromBreeze", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DenseMatrix x = DenseMatrix$.MODULE$.zeros$mDc$sp(10, 10, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            Vector v = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)0), HasOps$.MODULE$.canSliceCol()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)v.size()));
            int $org_scalatest_assert_macro_right = x.rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("sqdist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Random random = new Random();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 1000).by(100).foreach((Function1 & Serializable)m -> VectorsSuite.$anonfun$new$30(random, BoxesRunTime.unboxToInt((Object)m)));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("foreach", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.2, 3.1, 0.0}));
            Vector sv = Vectors$.MODULE$.sparse(4, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 1.2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.1), (List)new .colon.colon((Object)new Tuple2.mcID.sp(3, 0.0), (List)Nil$.MODULE$))));
            Map dvMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            dv.foreach((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> dvMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dvMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToDouble((double)0.0))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            Map svMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            sv.foreach((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> svMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(svMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToDouble((double)0.0))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("foreachActive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.2, 3.1, 0.0}));
            Vector sv = Vectors$.MODULE$.sparse(4, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 1.2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.1), (List)new .colon.colon((Object)new Tuple2.mcID.sp(3, 0.0), (List)Nil$.MODULE$))));
            Map dvMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            dv.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> dvMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dvMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToDouble((double)0.0))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Map svMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            sv.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> svMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(svMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToDouble((double)0.0))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("foreachNonZero", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.2, 3.1, 0.0}));
            Vector sv = Vectors$.MODULE$.sparse(4, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 1.2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.1), (List)new .colon.colon((Object)new Tuple2.mcID.sp(3, 0.0), (List)Nil$.MODULE$))));
            Map dvMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            dv.foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> dvMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dvMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            Map svMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            sv.foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(index, value) -> svMap.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dvMap);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)1.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)3.1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("vector p-norm", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-1.2, 3.1, 0.0, -4.5, 1.9}));
            Vector sv = Vectors$.MODULE$.sparse(6, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, -1.2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 3.1), (List)new .colon.colon((Object)new Tuple2.mcID.sp(3, 0.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, -4.5), (List)new .colon.colon((Object)new Tuple2.mcID.sp(5, 1.9), (List)Nil$.MODULE$))))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(dv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + scala.math.package$.MODULE$.abs(v)))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(sv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + scala.math.package$.MODULE$.abs(v)))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(dv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + v * v)))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(sv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + v * v)))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(dv.toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)x -> scala.math.package$.MODULE$.abs(x), (ClassTag)ClassTag$.MODULE$.Double())).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, Infinity)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.wrapDoubleArray(scala.Predef.doubleArrayOps(dv.toArray).map[Double](((x: Double) => scala.math.`package`.abs(x)))((ClassTag.Double: scala.reflect.ClassTag[Double]))).max[Double](math.this.Ordering.DeprecatedDoubleOrdering)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(sv.toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)x -> scala.math.package$.MODULE$.abs(x), (ClassTag)ClassTag$.MODULE$.Double())).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, Infinity)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.wrapDoubleArray(scala.Predef.doubleArrayOps(sv.toArray).map[Double](((x: Double) => scala.math.`package`.abs(x)))((ClassTag.Double: scala.reflect.ClassTag[Double]))).max[Double](math.this.Ordering.DeprecatedDoubleOrdering)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(dv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7))), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 3.7)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(sv.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, v) -> a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7))), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 3.7)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("Vector numActive and numNonzeros", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numActives()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numNonzeros()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            Vector sv = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numActives()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numNonzeros()));
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("Vector toSparse and toDense", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv0 = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dv0.toDense());
            Vector $org_scalatest_assert_macro_right = dv0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            SparseVector dv0s = dv0.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv0s.numActives()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dv0s);
            Vector $org_scalatest_assert_macro_right3 = dv0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dv0.toSparseWithSize(dv0.numNonzeros()));
            Vector $org_scalatest_assert_macro_right4 = dv0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            SparseVector dv0s2 = dv0.toSparseWithSize(dv0.numNonzeros());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv0s2.numActives()));
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(dv0s2);
            SparseVector $org_scalatest_assert_macro_right6 = dv0s;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sv0.toDense());
            Vector $org_scalatest_assert_macro_right7 = sv0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            SparseVector sv0s = sv0.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0s.numActives()));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(sv0s);
            Vector $org_scalatest_assert_macro_right9 = sv0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(sv0.toSparseWithSize(sv0.numNonzeros()));
            Vector $org_scalatest_assert_macro_right10 = sv0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            SparseVector sv0s2 = sv0.toSparseWithSize(sv0.numNonzeros());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0s2.numActives()));
            int $org_scalatest_assert_macro_right11 = 2;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(sv0s2);
            SparseVector $org_scalatest_assert_macro_right12 = sv0s;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        this.test("Vector.compressed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv0 = Vectors$.MODULE$.dense(1.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
            DenseVector dv0c = (DenseVector)dv0.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dv0c);
            Vector $org_scalatest_assert_macro_right = dv0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            Vector dv1 = Vectors$.MODULE$.dense(0.0, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0, 0.0}));
            SparseVector dv1c = (SparseVector)dv1.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dv1);
            SparseVector $org_scalatest_assert_macro_right2 = dv1c;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv1c.numActives()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{1, 2}, new double[]{2.0, 0.0});
            SparseVector sv0c = (SparseVector)sv0.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sv0);
            SparseVector $org_scalatest_assert_macro_right4 = sv0c;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0c.numActives()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            Vector sv1 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{1.0, 2.0, 3.0});
            DenseVector sv1c = (DenseVector)sv1.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sv1);
            DenseVector $org_scalatest_assert_macro_right6 = sv1c;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            Vector sv2 = Vectors$.MODULE$.sparse(Integer.MAX_VALUE, new int[]{0}, new double[]{3.4});
            SparseVector sv2c = (SparseVector)sv2.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sv2c);
            Vector $org_scalatest_assert_macro_right7 = sv2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv2c.numActives()));
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        this.test("SparseVector.slice", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector v = new SparseVector(5, new int[]{1, 2, 4}, new double[]{1.1, 2.2, 4.4});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(v.slice(new int[]{0, 2}, v.slice$default$2()));
            SparseVector $org_scalatest_assert_macro_right = new SparseVector(2, new int[]{1}, new double[]{2.2});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(v.slice(new int[]{2, 0}, v.slice$default$2()));
            SparseVector $org_scalatest_assert_macro_right2 = new SparseVector(2, new int[]{0}, new double[]{2.2});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(v.slice(new int[]{2, 0, 3, 4}, v.slice$default$2()));
            SparseVector $org_scalatest_assert_macro_right3 = new SparseVector(4, new int[]{0, 3}, new double[]{2.2, 4.4});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        this.test("SparseVector.slice with sorted indices", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparseVector v = new SparseVector(5, new int[]{1, 2, 4}, new double[]{1.1, 2.2, 4.4});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(v.slice(new int[]{0, 2}, true));
            SparseVector $org_scalatest_assert_macro_right = v.slice(new int[]{0, 2}, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(v.slice(new int[]{0, 2, 4}, true));
            SparseVector $org_scalatest_assert_macro_right2 = v.slice(new int[]{0, 2, 4}, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(v.slice(new int[]{1, 3}, true));
            SparseVector $org_scalatest_assert_macro_right3 = v.slice(new int[]{1, 3}, false);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("sparse vector only support non-negative length", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector v1 = Vectors$.MODULE$.sparse(0, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
            Vector v2 = Vectors$.MODULE$.sparse(0, (Seq)ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)v1.size()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)v2.size()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(-1, new int[]{1}, new double[]{2.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> Vectors$.MODULE$.sparse(-1, (Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("dot product only supports vectors of same size", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector vSize4 = Vectors$.MODULE$.dense(this.arr());
            Vector vSize1 = Vectors$.MODULE$.zeros(1);
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable)() -> vSize1.dot(vSize4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("dense vector dot product", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector dv = Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dv.dot(dv)));
            double $org_scalatest_assert_macro_right = 0.26;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("sparse vector dot product", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector sv = Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sv.dot(sv)));
            double $org_scalatest_assert_macro_right = 0.26;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("mixed sparse and dense vector dot product", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Vector sv = Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            Vector dv = Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sv.dot(dv)));
            double $org_scalatest_assert_macro_right = 0.26;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dv.dot(sv)));
            double $org_scalatest_assert_macro_right2 = 0.26;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.test("iterator", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Vectors$.MODULE$.dense(this.arr()), (List)new .colon.colon((Object)Vectors$.MODULE$.zeros(this.n()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray()), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)vec -> {
            Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])vec.iterator().toArray(ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] indices = (int[])tuple2._1();
            double[] values = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
            int[] indices2 = (int[])tuple22._1();
            double[] values2 = (double[])tuple22._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Array$.MODULE$.range(0, vec.size()));
            int[] $org_scalatest_assert_macro_right = indices2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(vec.toArray());
            double[] $org_scalatest_assert_macro_right2 = values2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        }), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("activeIterator", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Vectors$.MODULE$.dense(this.arr()), (List)new .colon.colon((Object)Vectors$.MODULE$.zeros(this.n()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray()), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)vec -> {
            ArrayBuilder indicesBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
            ArrayBuilder valuesBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
            vec.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable)(x0$1, x1$1) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
                if (sp2 != null) {
                    int i = sp2._1$mcI$sp();
                    double v = sp2._2$mcD$sp();
                    indicesBuilder.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    valuesBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                    return;
                }
                throw new MatchError((Object)sp2);
            });
            Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])vec.activeIterator().toArray(ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] indices = (int[])tuple2._1();
            double[] values = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
            int[] indices2 = (int[])tuple22._1();
            double[] values2 = (double[])tuple22._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(indicesBuilder.result());
            int[] $org_scalatest_assert_macro_right = indices2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(valuesBuilder.result());
            double[] $org_scalatest_assert_macro_right2 = values2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        }), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        this.test("nonZeroIterator", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Vectors$.MODULE$.dense(this.arr()), (List)new .colon.colon((Object)Vectors$.MODULE$.zeros(this.n()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values()), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(this.n(), Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray()), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)vec -> {
            ArrayBuilder indicesBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
            ArrayBuilder valuesBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
            vec.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable)(x0$2, x1$2) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$2);
                if (sp2 != null) {
                    int i = sp2._1$mcI$sp();
                    double v = sp2._2$mcD$sp();
                    if (v != 0.0) {
                        indicesBuilder.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                        valuesBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)sp2);
            });
            Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])vec.nonZeroIterator().toArray(ClassTag$.MODULE$.apply(Tuple2.class))), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] indices = (int[])tuple2._1();
            double[] values = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
            int[] indices2 = (int[])tuple22._1();
            double[] values2 = (double[])tuple22._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(indicesBuilder.result());
            int[] $org_scalatest_assert_macro_right = indices2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(valuesBuilder.result());
            double[] $org_scalatest_assert_macro_right2 = values2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
    }

    public static final /* synthetic */ Object $anonfun$new$17$adapted(VectorsSuite $this, Seq vectors$1, Vector v) {
        vectors$1.foreach((Function1 & Serializable)u -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(v);
            Vector $org_scalatest_assert_macro_right = u;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Statics.anyHash((Object)v)));
            int $org_scalatest_assert_macro_right2 = Statics.anyHash((Object)u);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$21$adapted(VectorsSuite $this, Seq vectors$2, Vector v) {
        vectors$2.foreach((Function1 & Serializable)u -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(v);
            Vector $org_scalatest_assert_macro_right = u;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Statics.anyHash((Object)v)));
            int $org_scalatest_assert_macro_right2 = Statics.anyHash((Object)u);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        });
        return BoxedUnit.UNIT;
    }
}

