/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.File;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.PipelineSuite$;
import org.apache.spark.ml.PipelineSuite$$anonfun$6$;
import org.apache.spark.ml.PipelineSuite$$anonfun$9$;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.UnWritableStage;
import org.apache.spark.ml.WritableStage;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.MinMaxScaler;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import org.scalatest.mock.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u0017\ti\u0001+\u001b9fY&tWmU;ji\u0016T!a\u0001\u0003\u0002\u00055d'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0004\t\u0019!\tia\"D\u0001\u0005\u0013\tyAAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003B\u0001\u0006[2d\u0017NY\u0005\u0003/I\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001a75\t!D\u0003\u0002\u0014\u0005%\u0011AD\u0007\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011a!B\u0012\u0001\u0003\u0003!#aB'z\u001b>$W\r\\\n\u0003E\u0015\u00022!\t\u0014)\u0013\t9#AA\u0003N_\u0012,G\u000e\u0005\u0002*E5\t\u0001\u0001C\u0003\u001fE\u0011\u00051\u0006F\u0001)\u0001")
public class PipelineSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public PipelineSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("pipeline", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset output;
                Estimator estimator0 = (Estimator)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Estimator.class, ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                MyModel model0 = (MyModel)((Object)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                Transformer transformer1 = (Transformer)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Transformer.class));
                Estimator estimator2 = (Estimator)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Estimator.class, ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                MyModel model2 = (MyModel)((Object)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                Transformer transformer3 = (Transformer)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Transformer.class));
                Dataset dataset0 = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Dataset dataset1 = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Dataset dataset2 = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Dataset dataset3 = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Dataset dataset4 = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)dataset0.toDF()).thenReturn((Object)dataset0);
                Mockito.when((Object)dataset1.toDF()).thenReturn((Object)dataset1);
                Mockito.when((Object)dataset2.toDF()).thenReturn((Object)dataset2);
                Mockito.when((Object)dataset3.toDF()).thenReturn((Object)dataset3);
                Mockito.when((Object)dataset4.toDF()).thenReturn((Object)dataset4);
                Mockito.when((Object)estimator0.copy((ParamMap)Matchers.any())).thenReturn((Object)estimator0);
                Mockito.when((Object)model0.copy((ParamMap)Matchers.any())).thenReturn((Object)((Object)model0));
                Mockito.when((Object)transformer1.copy((ParamMap)Matchers.any())).thenReturn((Object)transformer1);
                Mockito.when((Object)estimator2.copy((ParamMap)Matchers.any())).thenReturn((Object)estimator2);
                Mockito.when((Object)model2.copy((ParamMap)Matchers.any())).thenReturn((Object)((Object)model2));
                Mockito.when((Object)transformer3.copy((ParamMap)Matchers.any())).thenReturn((Object)transformer3);
                Mockito.when((Object)estimator0.fit((Dataset)Matchers.eq((Object)dataset0))).thenReturn((Object)((Object)model0));
                Mockito.when((Object)model0.transform((Dataset)Matchers.eq((Object)dataset0))).thenReturn((Object)dataset1);
                Mockito.when((Object)model0.parent()).thenReturn((Object)estimator0);
                Mockito.when((Object)transformer1.transform((Dataset)Matchers.eq((Object)dataset1))).thenReturn((Object)dataset2);
                Mockito.when((Object)estimator2.fit((Dataset)Matchers.eq((Object)dataset2))).thenReturn((Object)((Object)model2));
                Mockito.when((Object)model2.transform((Dataset)Matchers.eq((Object)dataset2))).thenReturn((Object)dataset3);
                Mockito.when((Object)model2.parent()).thenReturn((Object)estimator2);
                Mockito.when((Object)transformer3.transform((Dataset)Matchers.eq((Object)dataset3))).thenReturn((Object)dataset4);
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{estimator0, transformer1, estimator2, transformer3}));
                PipelineModel pipelineModel = pipeline.fit(dataset0);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)pipelineModel);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipelineModel.stages().length));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Transformer $org_scalatest_assert_macro_left2 = pipelineModel.stages()[0];
                MyModel $org_scalatest_assert_macro_right2 = model0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)((Object)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Transformer $org_scalatest_assert_macro_left3 = pipelineModel.stages()[1];
                Transformer $org_scalatest_assert_macro_right3 = transformer1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Transformer $org_scalatest_assert_macro_left4 = pipelineModel.stages()[2];
                MyModel $org_scalatest_assert_macro_right4 = model2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)((Object)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Transformer $org_scalatest_assert_macro_left5 = pipelineModel.stages()[3];
                Transformer $org_scalatest_assert_macro_right5 = transformer3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Dataset $org_scalatest_assert_macro_left6 = output = pipelineModel.transform(dataset0);
                Dataset $org_scalatest_assert_macro_right6 = dataset4;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "eq", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pipeline with duplicate stages", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Estimator estimator = (Estimator)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Estimator.class, ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])new Estimator[]{estimator, estimator});
                Dataset dataset = (Dataset)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Dataset.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                this.$outer.intercept((Function0)new Serializable(this, pipeline, dataset){
                    public static final long serialVersionUID = 0L;
                    private final Pipeline pipeline$1;
                    private final Dataset dataset$1;

                    public final PipelineModel apply() {
                        return this.pipeline$1.fit(this.dataset$1);
                    }
                    {
                        this.pipeline$1 = pipeline$1;
                        this.dataset$1 = dataset$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PipelineModel.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashingTF hashingTF = new HashingTF().setNumFeatures(100);
                PipelineModel model = new PipelineModel("pipeline", (Transformer[])((Object[])new Transformer[]{hashingTF}));
                PipelineModel copied = model.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{hashingTF.numFeatures().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
                Predef$.MODULE$.require(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((HashingTF)copied.stages()[0]).getNumFeatures())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "copy should handle extra stage params";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pipeline model constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Transformer transform0 = (Transformer)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Transformer.class));
                MyModel model1 = (MyModel)((Object)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)this.$outer), MyModel.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                Transformer[] stages = (Transformer[])((Object[])new Transformer[]{transform0, model1});
                PipelineModel pipelineModel0 = new PipelineModel("pipeline0", stages);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(pipelineModel0.uid());
                String $org_scalatest_assert_macro_right = "pipeline0";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(pipelineModel0.stages());
                Transformer[] $org_scalatest_assert_macro_right2 = stages;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                List stagesAsList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])stages).toList()).asJava();
                PipelineModel pipelineModel1 = new PipelineModel("pipeline1", stagesAsList);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(pipelineModel1.uid());
                String $org_scalatest_assert_macro_right3 = "pipeline1";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(pipelineModel1.stages());
                Transformer[] $org_scalatest_assert_macro_right4 = stages;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Pipeline read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                WritableStage writableStage = new WritableStage("writableStage").setIntParam(56);
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new WritableStage[]{writableStage}));
                Pipeline pipeline2 = this.$outer.testDefaultReadWrite(pipeline, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipeline2.getStages().length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                PipelineStage $org_scalatest_assert_macro_left2 = pipeline2.getStages()[0];
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.WritableStage", $org_scalatest_assert_macro_left2 instanceof WritableStage);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                WritableStage writableStage2 = (WritableStage)pipeline2.getStages()[0];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)writableStage.getIntParam()));
                int $org_scalatest_assert_macro_right2 = writableStage2.getIntParam();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Pipeline read/write with non-Writable stage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnWritableStage unWritableStage = new UnWritableStage("unwritableStage");
                Pipeline unWritablePipeline = new Pipeline().setStages((PipelineStage[])((Object[])new UnWritableStage[]{unWritableStage}));
                this.$outer.withClue("Pipeline.write should fail when Pipeline contains non-Writable stage", (Function0)new Serializable(this, unWritablePipeline){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final Pipeline unWritablePipeline$1;

                    public final UnsupportedOperationException apply() {
                        return (UnsupportedOperationException)this.$outer.org$apache$spark$ml$PipelineSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$3 $outer;

                            public final MLWriter apply() {
                                return this.$outer.unWritablePipeline$1.write();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.unWritablePipeline$1 = unWritablePipeline$1;
                    }
                });
            }

            public /* synthetic */ PipelineSuite org$apache$spark$ml$PipelineSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PipelineModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                WritableStage writableStage = new WritableStage("writableStage").setIntParam(56);
                PipelineModel pipeline = new PipelineModel("pipeline_89329327", (Transformer[])((Object[])new Transformer[]{writableStage}));
                PipelineModel pipeline2 = this.$outer.testDefaultReadWrite(pipeline, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipeline2.stages().length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Transformer $org_scalatest_assert_macro_left2 = pipeline2.stages()[0];
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.WritableStage", $org_scalatest_assert_macro_left2 instanceof WritableStage);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                WritableStage writableStage2 = (WritableStage)pipeline2.stages()[0];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)writableStage.getIntParam()));
                int $org_scalatest_assert_macro_right2 = writableStage2.getIntParam();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PipelineModel read/write: getStagePath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String stageUid = "myStage";
                String stagesDir = new Path("pipeline", "stages").toString();
                this.testStage$1(0, 1, "0", stageUid, stagesDir);
                this.testStage$1(0, 9, "0", stageUid, stagesDir);
                this.testStage$1(0, 10, "00", stageUid, stagesDir);
                this.testStage$1(1, 10, "01", stageUid, stagesDir);
                this.testStage$1(12, 999, "012", stageUid, stagesDir);
            }

            private final void testStage$1(int stageIdx, int numStages, String expectedPrefix, String stageUid$1, String stagesDir$1) {
                String path = Pipeline.SharedReadWrite$.MODULE$.getStagePath(stageUid$1, stageIdx, numStages, stagesDir$1);
                String expected = new Path(stagesDir$1, new StringBuilder().append((Object)expectedPrefix).append((Object)"_").append((Object)stageUid$1).toString()).toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(path);
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PipelineModel read/write with non-Writable stage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnWritableStage unWritableStage = new UnWritableStage("unwritableStage");
                PipelineModel unWritablePipeline = new PipelineModel("pipeline_328957", (Transformer[])((Object[])new Transformer[]{unWritableStage}));
                this.$outer.withClue("PipelineModel.write should fail when PipelineModel contains non-Writable stage", (Function0)new Serializable(this, unWritablePipeline){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    public final PipelineModel unWritablePipeline$2;

                    public final UnsupportedOperationException apply() {
                        return (UnsupportedOperationException)this.$outer.org$apache$spark$ml$PipelineSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$4 $outer;

                            public final MLWriter apply() {
                                return this.$outer.unWritablePipeline$2.write();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.unWritablePipeline$2 = unWritablePipeline$2;
                    }
                });
            }

            public /* synthetic */ PipelineSuite org$apache$spark$ml$PipelineSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pipeline validateParams", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipelineSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PipelineSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)4.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "features", "label"}));
                this.$outer.intercept((Function0)new Serializable(this, df){
                    public static final long serialVersionUID = 0L;
                    private final Dataset df$1;

                    public final PipelineModel apply() {
                        MinMaxScaler scaler = new MinMaxScaler().setInputCol("features").setOutputCol("features_scaled").setMin(10.0).setMax(0.0);
                        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])new MinMaxScaler[]{scaler});
                        return pipeline.fit(this.df$1);
                    }
                    {
                        this.df$1 = df$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Pipeline.setStages should handle Java Arrays being non-covariant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnWritableStage[] stages0 = (UnWritableStage[])((Object[])new UnWritableStage[]{new UnWritableStage("b")});
                WritableStage[] stages1 = (WritableStage[])((Object[])new WritableStage[]{new WritableStage("a")});
                Transformer[] steps = (Transformer[])Predef$.MODULE$.refArrayOps((Object[])stages0).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])stages1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Transformer.class)));
                Pipeline p = new Pipeline().setStages((PipelineStage[])steps);
            }
        });
    }

    public abstract class MyModel
    extends Model<MyModel> {
        public /* synthetic */ PipelineSuite org$apache$spark$ml$PipelineSuite$MyModel$$$outer() {
            return PipelineSuite.this;
        }

        public MyModel() {
            if (PipelineSuite.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

