/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.ClassifierSuite$;
import org.apache.spark.ml.classification.ClassifierSuite$$anonfun$1$;
import org.apache.spark.ml.classification.ClassifierSuite$$anonfun$6$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00015\u0011qb\u00117bgNLg-[3s'VLG/\u001a\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B;uS2T!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\t9Q\u0001\t\u0002\t\u0002\u0005\nqb\u00117bgNLg-[3s'VLG/\u001a\t\u0003=\t2Q!\u0001\u0002\t\u0002\r\u001a2A\t\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u0011QeK\u0005\u0003Y\u0019\u0012AbU3sS\u0006d\u0017N_1cY\u0016DQa\u0007\u0012\u0005\u00029\"\u0012!\t\u0005\ba\t\u0012\r\u0011\"\u00012\u0003A\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7/F\u00013!\u0011\u0019d'\u000f\u001f\u000f\u0005\u0015\"\u0014BA\u001b'\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0004\u001b\u0006\u0004(BA\u001b'!\t\u0019$(\u0003\u0002<q\t11\u000b\u001e:j]\u001e\u0004\"!J\u001f\n\u0005y2#aA!os\"1\u0001I\tQ\u0001\nI\n\u0011#\u00197m!\u0006\u0014\u0018-\\*fiRLgnZ:!\r\u0011\u0011%\u0005A\"\u0003\u001d5{7m[\"mCN\u001c\u0018NZ5feN\u0011\u0011\t\u0012\t\u0006=\u0015;UjT\u0005\u0003\r\n\u0011!b\u00117bgNLg-[3s!\tA5*D\u0001J\u0015\tQE!\u0001\u0004mS:\fGnZ\u0005\u0003\u0019&\u0013aAV3di>\u0014\bC\u0001(B\u001b\u0005\u0011\u0003C\u0001(Q\r\u0011\t&\u0005\u0001*\u0003/5{7m[\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d7C\u0001)T!\u0011qBkR(\n\u0005U\u0013!aE\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007\u0002C,Q\u0005\u000b\u0007I\u0011\t-\u0002\u0007ULG-F\u0001:\u0011!Q\u0006K!A!\u0002\u0013I\u0014\u0001B;jI\u0002BQa\u0007)\u0005\u0002q#\"aT/\t\u000b][\u0006\u0019A\u001d\t\u000bm\u0001F\u0011A0\u0015\u0003=CQ!\u0019)\u0005\u0012\t\f!\u0002\u001d:fI&\u001cGOU1x)\t95\rC\u0003eA\u0002\u0007q)\u0001\u0005gK\u0006$XO]3t\u0011\u00151\u0007\u000b\"\u0011h\u0003\u0011\u0019w\u000e]=\u0015\u0005=C\u0007\"B5f\u0001\u0004Q\u0017!B3yiJ\f\u0007CA6o\u001b\u0005a'BA7\u0005\u0003\u0015\u0001\u0018M]1n\u0013\tyGN\u0001\u0005QCJ\fW.T1q\u0011\u0015\t\b\u000b\"\u0011s\u0003)qW/\\\"mCN\u001cXm]\u000b\u0002gB\u0011Q\u0005^\u0005\u0003k\u001a\u00121!\u00138u\u0011!9\u0016I!b\u0001\n\u0003B\u0006\u0002\u0003.B\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000bm\tE\u0011A=\u0015\u00055S\b\"B,y\u0001\u0004I\u0004\"B\u000eB\t\u0003aH#A'\t\u000b\u0019\fE\u0011\t@\u0015\u00055{\b\"B5~\u0001\u0004Q\u0007bBA\u0002\u0003\u0012\u0005\u0013QA\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004\u001f\u0006\u001d\u0001\u0002CA\u0005\u0003\u0003\u0001\r!a\u0003\u0002\u000f\u0011\fG/Y:fiB\"\u0011QBA\u000f!\u0019\ty!!\u0006\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0004\u0003'1\u0011aA:rY&!\u0011qCA\t\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0007\u0002\u001e1\u0001A\u0001DA\u0010\u0003\u000f\t\t\u0011!A\u0003\u0002\u0005\u0005\"aA0%cE\u0019\u00111\u0005\u001f\u0011\u0007\u0015\n)#C\u0002\u0002(\u0019\u0012qAT8uQ&tw\rC\u0004\u0002,\u0005#\t%!\f\u0002)\u0015DHO]1di2\u000b'-\u001a7fIB{\u0017N\u001c;t)\u0019\ty#a\u0012\u0002TA1\u0011\u0011GA\u001c\u0003wi!!a\r\u000b\u0007\u0005Ub!A\u0002sI\u0012LA!!\u000f\u00024\t\u0019!\u000b\u0012#\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011\u0005\u0003\u001d1W-\u0019;ve\u0016LA!!\u0012\u0002@\taA*\u00192fY\u0016$\u0007k\\5oi\"A\u0011\u0011BA\u0015\u0001\u0004\tI\u0005\r\u0003\u0002L\u0005=\u0003CBA\b\u0003+\ti\u0005\u0005\u0003\u0002\u001c\u0005=C\u0001DA)\u0003\u000f\n\t\u0011!A\u0003\u0002\u0005\u0005\"aA0%e!1\u0011/!\u000bA\u0002MDq!a\u0016B\t\u0003\tI&A\u0007hKRtU/\\\"mCN\u001cXm\u001d\u000b\u0004g\u0006m\u0003\u0002CA\u0005\u0003+\u0002\r!!\u00181\t\u0005}\u00131\r\t\u0007\u0003\u001f\t)\"!\u0019\u0011\t\u0005m\u00111\r\u0003\r\u0003K\nY&!A\u0001\u0002\u000b\u0005\u0011\u0011\u0005\u0002\u0004?\u0012\u001a\u0004\"CA5E\u0005\u0005I\u0011BA6\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0005Y\u0006twM\u0003\u0002\u0002x\u0005!!.\u0019<b\u0013\u0011\tY(!\u001d\u0003\r=\u0013'.Z2u\u0001")
public class ClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return ClassifierSuite$.MODULE$.allParamSettings();
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public ClassifierSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("extractLabeledPoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClassifier c = new MockClassifier();
                Dataset df0 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.0})));
                c.extractLabeledPoints(df0, 6).count();
                Dataset df1 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0, 1.0, 5.0})));
                this.$outer.withClue("Classifier should fail if label is negative", (Function0)new Serializable(this, c, df1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final MockClassifier c$1;
                    public final Dataset df1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.$outer.c$1.extractLabeledPoints(this.$outer.df1$1, 6).count();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                        this.df1$1 = df1$1;
                    }
                });
                Dataset df2 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.1, 1.0, 5.0})));
                this.$outer.withClue("Classifier should fail if label is not an integer", (Function0)new Serializable(this, c, df2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final MockClassifier c$1;
                    public final Dataset df2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2 $outer;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.$outer.c$1.extractLabeledPoints(this.$outer.df2$1, 6).count();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                        this.df2$1 = df2$1;
                    }
                });
                this.$outer.withClue("Classifier should fail if label is >= numClasses", (Function0)new Serializable(this, c, df0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final MockClassifier c$1;
                    public final Dataset df0$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$3 $outer;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.$outer.c$1.extractLabeledPoints(this.$outer.df0$1, 5).count();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                        this.df0$1 = df0$1;
                    }
                });
                this.$outer.withClue("Classifier.extractLabeledPoints should fail if numClasses <= 0", (Function0)new Serializable(this, c, df0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final MockClassifier c$1;
                    public final Dataset df0$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        IllegalArgumentException e = (IllegalArgumentException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$4 $outer;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.$outer.c$1.extractLabeledPoints(this.$outer.df0$1, 0).count();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "but requires numClasses > 0";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                        this.df0$1 = df0$1;
                    }
                });
            }

            public /* synthetic */ ClassifierSuite org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Dataset getTestData$1(Seq labels) {
                Seq data = (Seq)labels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(double label) {
                        return new LabeledPoint(label, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClassifierSuite.class.getClassLoader());
                return this.$outer.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("getNumClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClassifier c = new MockClassifier();
                Dataset df0 = this.getTestData$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.0})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)c.getNumClasses(df0)));
                int $org_scalatest_assert_macro_right = 6;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Dataset df1 = this.getTestData$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.1})));
                this.$outer.withClue("getNumClasses should fail if label is max label not an integer", (Function0)new Serializable(this, c, df1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final MockClassifier c$2;
                    public final Dataset df1$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        IllegalArgumentException e = (IllegalArgumentException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$5 $outer;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.$outer.c$2.getNumClasses(this.$outer.df1$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "requires integers in range";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$2 = c$2;
                        this.df1$2 = df1$2;
                    }
                });
                Dataset df2 = this.getTestData$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, Integer.MAX_VALUE})));
                this.$outer.withClue("getNumClasses should fail if label is max label is >= Int.MaxValue", (Function0)new Serializable(this, c, df2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final MockClassifier c$2;
                    public final Dataset df2$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        IllegalArgumentException e = (IllegalArgumentException)this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$6 $outer;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.$outer.c$2.getNumClasses(this.$outer.df2$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "requires integers in range";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.c$2 = c$2;
                        this.df2$2 = df2$2;
                    }
                });
            }

            public /* synthetic */ ClassifierSuite org$apache$spark$ml$classification$ClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Dataset getTestData$2(Seq labels) {
                Seq data = (Seq)labels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(double label) {
                        return new LabeledPoint(label, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClassifierSuite.class.getClassLoader());
                return this.$outer.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class MockClassifier
    extends Classifier<Vector, MockClassifier, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public MockClassifier copy(ParamMap extra) {
            throw new NotImplementedError();
        }

        public MockClassificationModel train(Dataset<?> dataset) {
            throw new NotImplementedError();
        }

        public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
            return super.extractLabeledPoints(dataset, numClasses);
        }

        public int getNumClasses(Dataset<?> dataset) {
            return super.getNumClasses(dataset, super.getNumClasses$default$2());
        }

        public MockClassifier(String uid) {
            this.uid = uid;
        }

        public MockClassifier() {
            this(Identifiable$.MODULE$.randomUID("mockclassifier"));
        }
    }

    public static class MockClassificationModel
    extends ClassificationModel<Vector, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public Vector predictRaw(Vector features) {
            throw new NotImplementedError();
        }

        public MockClassificationModel copy(ParamMap extra) {
            throw new NotImplementedError();
        }

        public int numClasses() {
            throw new NotImplementedError();
        }

        public MockClassificationModel(String uid) {
            this.uid = uid;
        }

        public MockClassificationModel() {
            this(Identifiable$.MODULE$.randomUID("mockclassificationmodel"));
        }
    }
}

