/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.classification.GBTClassifierSuite$;
import org.apache.spark.ml.classification.GBTClassifierSuite$$anonfun$6$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u00015\u0011!c\u0012\"U\u00072\f7o]5gS\u0016\u00148+^5uK*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!C\u0007\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011)H/\u001b7\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"aG\u000f\u000e\u0003qQ!!\u0006\u0003\n\u0005ya\"\u0001\u0006#fM\u0006,H\u000e\u001e*fC\u0012<&/\u001b;f)\u0016\u001cH\u000fC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u0005!9Q\u0005\u0001b\u0001\n\u00131\u0013\u0001\u0005;fgR\u001cu.\u001c2j]\u0006$\u0018n\u001c8t+\u00059\u0003c\u0001\u0015,[5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0003BeJ\f\u0017\u0010E\u0003)]A\u001a4'\u0003\u00020S\t1A+\u001e9mKN\u0002\"\u0001K\u0019\n\u0005IJ#aA%oiB\u0011\u0001\u0006N\u0005\u0003k%\u0012a\u0001R8vE2,\u0007BB\u001c\u0001A\u0003%q%A\tuKN$8i\\7cS:\fG/[8og\u0002B\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002\t\u0011\fG/Y\u000b\u0002wA\u0019AhP!\u000e\u0003uR!A\u0010\u0004\u0002\u0007I$G-\u0003\u0002A{\t\u0019!\u000b\u0012#\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0011a\u00024fCR,(/Z\u0005\u0003\r\u000e\u0013A\u0002T1cK2,G\rU8j]RD\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\u0002\u0011\u0011\fG/Y0%KF$\"AS'\u0011\u0005!Z\u0015B\u0001'*\u0005\u0011)f.\u001b;\t\u000f9;\u0015\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\t\rA\u0003\u0001\u0015)\u0003<\u0003\u0015!\u0017\r^1!\u0011%\u0011\u0006\u00011AA\u0002\u0013%!(A\u0005ue\u0006Lg\u000eR1uC\"IA\u000b\u0001a\u0001\u0002\u0004%I!V\u0001\u000eiJ\f\u0017N\u001c#bi\u0006|F%Z9\u0015\u0005)3\u0006b\u0002(T\u0003\u0003\u0005\ra\u000f\u0005\u00071\u0002\u0001\u000b\u0015B\u001e\u0002\u0015Q\u0014\u0018-\u001b8ECR\f\u0007\u0005C\u0005[\u0001\u0001\u0007\t\u0019!C\u0005u\u0005qa/\u00197jI\u0006$\u0018n\u001c8ECR\f\u0007\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0003I1\u0018\r\\5eCRLwN\u001c#bi\u0006|F%Z9\u0015\u0005)s\u0006b\u0002(\\\u0003\u0003\u0005\ra\u000f\u0005\u0007A\u0002\u0001\u000b\u0015B\u001e\u0002\u001fY\fG.\u001b3bi&|g\u000eR1uC\u0002BQA\u0019\u0001\u0005B\r\f\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003);Q!\u001a\u0002\t\n\u0019\f!c\u0012\"U\u00072\f7o]5gS\u0016\u00148+^5uKB\u00111e\u001a\u0004\u0006\u0003\tAI\u0001[\n\u0003O:AQ\u0001I4\u0005\u0002)$\u0012A\u001a\u0005\u0006Y\u001e$\t!\\\u0001\fG>l\u0007/\u0019:f\u0003BK5\u000fF\u0003K]>\u001c\b\u0010C\u0003:W\u0002\u00071\bC\u0003[W\u0002\u0007\u0001\u000fE\u0002)cnJ!A]\u0015\u0003\r=\u0003H/[8o\u0011\u0015!8\u000e1\u0001v\u0003\r9'\r\u001e\t\u0003GYL!a\u001e\u0002\u0003\u001b\u001d\u0013Ek\u00117bgNLg-[3s\u0011\u0015I8\u000e1\u0001{\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u0011Yh\u0010\r\u0019\u000f\u0005!b\u0018BA?*\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\u00075\u000b\u0007O\u0003\u0002~S!I\u0011QA4\u0002\u0002\u0013%\u0011qA\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tiA\u0001\u0004PE*,7\r\u001e")
public class GBTClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private final Tuple3<Object, Object, Object>[] org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$GBTClassifierSuite$$data;
    private RDD<LabeledPoint> trainData;
    private RDD<LabeledPoint> validationData;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareAPIs(RDD<LabeledPoint> rDD, Option<RDD<LabeledPoint>> option, GBTClassifier gBTClassifier, Map<Object, Object> map) {
        GBTClassifierSuite$.MODULE$.compareAPIs(rDD, option, gBTClassifier, map);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations() {
        return this.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$GBTClassifierSuite$$data() {
        return this.org$apache$spark$ml$classification$GBTClassifierSuite$$data;
    }

    private void org$apache$spark$ml$classification$GBTClassifierSuite$$data_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$data = x$1;
    }

    private RDD<LabeledPoint> trainData() {
        return this.trainData;
    }

    private void trainData_$eq(RDD<LabeledPoint> x$1) {
        this.trainData = x$1;
    }

    private RDD<LabeledPoint> validationData() {
        return this.validationData;
    }

    private void validationData_$eq(RDD<LabeledPoint> x$1) {
        this.validationData = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$data_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(10, 100)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.trainData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 120)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                return x$2.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.validationData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 80)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$3) {
                return x$3.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public GBTClassifierSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.75)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)0.75))});
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new GBTClassifier());
                DecisionTreeRegressionModel[] decisionTreeRegressionModelArray = new DecisionTreeRegressionModel[1];
                decisionTreeRegressionModelArray[0] = new DecisionTreeRegressionModel("dtr", (Node)new LeafNode(0.0, 0.0, null), 1);
                GBTClassificationModel model = new GBTClassificationModel("gbtc", (DecisionTreeRegressionModel[])((Object[])decisionTreeRegressionModelArray), new double[]{1.0}, 1);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Binary classification with continuous features: Log Loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations()).foreach((Function1)new Serializable(this, categoricalFeatures){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Map categoricalFeatures$1;

                    public final void apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 != null) {
                            int maxIter = BoxesRunTime.unboxToInt((Object)tuple3._1());
                            double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            GBTClassifier gbt = new GBTClassifier().setMaxDepth(2).setSubsamplingRate(subsamplingRate).setLossType("logistic").setMaxIter(maxIter).setStepSize(learningRate).setSeed(123L);
                            GBTClassifierSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().org$apache$spark$ml$classification$GBTClassifierSuite$$data(), (Option<RDD<LabeledPoint>>)None$.MODULE$, gbt, (Map<Object, Object>)this.categoricalFeatures$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.categoricalFeatures$1 = categoricalFeatures$1;
                    }
                });
            }

            public /* synthetic */ GBTClassifierSuite org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$data(), (Map<Object, Object>)categoricalFeatures, 2);
                GBTClassifier gbt = new GBTClassifier().setMaxDepth(2).setLossType("logistic").setMaxIter(5).setStepSize(0.1).setCheckpointInterval(2).setSeed(123L);
                GBTClassificationModel model = (GBTClassificationModel)gbt.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTClassifier gbt = new GBTClassifier().setMaxDepth(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(gbt, this.$outer.spark(), MLTestingUtils$.MODULE$.checkNumericTypes$default$3(), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(GBTClassificationModel expected, GBTClassificationModel actual) {
                        TreeTests$.MODULE$.checkEqual(expected, actual);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Fitting without numClasses in metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassifierSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame(TreeTests$.MODULE$.featureImportanceData(this.$outer.sc()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                GBTClassifier gbt = new GBTClassifier().setMaxDepth(1).setMaxIter(1);
                gbt.fit(df);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extractLabeledPoints with bad data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTClassifier gbt = new GBTClassifier().setMaxDepth(1).setMaxIter(1);
                Dataset df1 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -1.0, 1.0, 0.0})));
                this.$outer.withClue("Classifier should fail if label is negative", (Function0)new Serializable(this, gbt, df1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final GBTClassifier gbt$1;
                    public final Dataset df1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$1 $outer;

                            public final GBTClassificationModel apply() {
                                return (GBTClassificationModel)this.$outer.gbt$1.fit(this.$outer.df1$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "currently only supports binary classification";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.gbt$1 = gbt$1;
                        this.df1$1 = df1$1;
                    }
                });
                Dataset df2 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.1, 1.0, 0.0})));
                this.$outer.withClue("Classifier should fail if label is not an integer", (Function0)new Serializable(this, gbt, df2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final GBTClassifier gbt$1;
                    public final Dataset df2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$2 $outer;

                            public final GBTClassificationModel apply() {
                                return (GBTClassificationModel)this.$outer.gbt$1.fit(this.$outer.df2$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "currently only supports binary classification";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.gbt$1 = gbt$1;
                        this.df2$1 = df2$1;
                    }
                });
                Dataset df3 = this.getTestData$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 0.0})));
                this.$outer.withClue("Classifier should fail if label is >= 2", (Function0)new Serializable(this, gbt, df3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final GBTClassifier gbt$1;
                    public final Dataset df3$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SparkException e = (SparkException)this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$3 $outer;

                            public final GBTClassificationModel apply() {
                                return (GBTClassificationModel)this.$outer.gbt$1.fit(this.$outer.df3$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                        String $org_scalatest_assert_macro_left = e.getMessage();
                        String $org_scalatest_assert_macro_right = "currently only supports binary classification";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.gbt$1 = gbt$1;
                        this.df3$1 = df3$1;
                    }
                });
            }

            public /* synthetic */ GBTClassifierSuite org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Dataset getTestData$1(Seq labels) {
                Seq data = (Seq)labels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(double label) {
                        return new LabeledPoint(label, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassifierSuite.class.getClassLoader());
                return this.$outer.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 2;
                GBTClassifier gbt = new GBTClassifier().setImpurity("Gini").setMaxDepth(3).setMaxIter(5).setSubsamplingRate(1.0).setStepSize(0.5).setSeed(123L);
                RDD<LabeledPoint> data = TreeTests$.MODULE$.featureImportanceData(this.$outer.sc());
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(data, (Map<Object, Object>)categoricalFeatures, numClasses);
                Vector importances = ((GBTClassificationModel)gbt.fit(df)).featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(importances.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(importances.toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$4) {
                        return this.apply$mcZD$sp(x$4);
                    }

                    public boolean apply$mcZD$sp(double x$4) {
                        return x$4 >= 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(importances.toArray).forall(((x$4: Double) => x$4.>=(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTClassifier gbt = new GBTClassifier();
                RDD<LabeledPoint> rdd = TreeTests$.MODULE$.getTreeReadWriteData(this.$outer.sc());
                Map allParamSettings = TreeTests$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lossType"), (Object)"logistic")})));
                Dataset<Row> continuousData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), 2);
                this.$outer.testEstimatorAndModelReadWrite(gbt, continuousData, (Map<String, Object>)allParamSettings, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(GBTClassificationModel model, GBTClassificationModel model2) {
                        this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$checkModelData$1(GBTClassificationModel model, GBTClassificationModel model2) {
                TreeTests$.MODULE$.checkEqual(model, model2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

