/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.util.List;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.classification.LogisticRegressionSuite$$anonfun$30$;
import org.apache.spark.ml.classification.ProbabilisticClassifierSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import scala.util.control.Breaks$;

public final class LogisticRegressionSuite$
implements Serializable {
    public static final LogisticRegressionSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new LogisticRegressionSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public List<LabeledPoint> generateLogisticInputAsList(double offset, double scale, int nPoints, int seed) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.generateLogisticInput(offset, scale, nPoints, seed)).asJava();
    }

    public Seq<LabeledPoint> generateLogisticInput(double offset, double scale, int nPoints, int seed) {
        Random rnd = new Random(seed);
        double[] x1 = (double[])Array$.MODULE$.fill(nPoints, (Function0)new Serializable(rnd){
            public static final long serialVersionUID = 0L;
            private final Random rnd$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rnd$2.nextGaussian();
            }
            {
                this.rnd$2 = rnd$2;
            }
        }, ClassTag$.MODULE$.Double());
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(offset, scale, rnd, x1){
            public static final long serialVersionUID = 0L;
            private final double offset$1;
            private final double scale$1;
            private final Random rnd$2;
            private final double[] x1$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                double p = 1.0 / (1.0 + package$.MODULE$.exp(-(this.offset$1 + this.scale$1 * this.x1$1[i])));
                return this.rnd$2.nextDouble() < p ? 1.0 : 0.0;
            }
            {
                this.offset$1 = offset$1;
                this.scale$1 = scale$1;
                this.rnd$2 = rnd$2;
                this.x1$1 = x1$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(x1, y){
            public static final long serialVersionUID = 0L;
            private final double[] x1$1;
            private final IndexedSeq y$1;

            public final LabeledPoint apply(int i) {
                return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)this.y$1.apply(i)), Vectors$.MODULE$.dense(new double[]{this.x1$1[i]}));
            }
            {
                this.x1$1 = x1$1;
                this.y$1 = y$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    public Seq<LabeledPoint> generateMultinomialLogisticInput(double[] weights, double[] xMean, double[] xVariance, boolean addIntercept, int nPoints, int seed) {
        Random rnd = new Random(seed);
        int xDim = xMean.length;
        int xWithInterceptsDim = addIntercept ? xDim + 1 : xDim;
        int nClasses = weights.length / xWithInterceptsDim + 1;
        Vector[] x = (Vector[])Array$.MODULE$.fill(nPoints, (Function0)new Serializable(rnd, xDim){
            public static final long serialVersionUID = 0L;
            public final Random rnd$3;
            private final int xDim$1;

            public final Vector apply() {
                return Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.xDim$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.43 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rnd$3.nextGaussian();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.rnd$3 = rnd$3;
                this.xDim$1 = xDim$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        Predef$.MODULE$.refArrayOps((Object[])x).foreach((Function1)new Serializable(xMean, xVariance){
            public static final long serialVersionUID = 0L;
            private final double[] xMean$1;
            private final double[] xVariance$1;

            public final void apply(Vector vector) {
                double[] vectorArray = vector.toArray();
                int len = vectorArray.length;
                for (int i = 0; i < len; ++i) {
                    vectorArray[i] = vectorArray[i] * package$.MODULE$.sqrt(this.xVariance$1[i]) + this.xMean$1[i];
                }
            }
            {
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
            }
        });
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(weights, addIntercept, rnd, xDim, xWithInterceptsDim, nClasses, x){
            public static final long serialVersionUID = 0L;
            public final double[] weights$1;
            public final boolean addIntercept$1;
            private final Random rnd$3;
            public final int xDim$1;
            public final int xWithInterceptsDim$1;
            public final int nClasses$1;
            private final Vector[] x$68;

            public final int apply(int idx2) {
                return this.apply$mcII$sp(idx2);
            }

            public int apply$mcII$sp(int idx2) {
                double[] xArray = this.x$68[idx2].toArray();
                double[] margins = (double[])Array$.MODULE$.ofDim(this.nClasses$1, ClassTag$.MODULE$.Double());
                double[] probs = (double[])Array$.MODULE$.ofDim(this.nClasses$1, ClassTag$.MODULE$.Double());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nClasses$1 - 1).foreach$mVc$sp((Function1)new Serializable(this, xArray, margins){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.30 $outer;
                    public final double[] xArray$1;
                    public final double[] margins$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.xDim$1).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$30$$anonfun$apply$mcII$sp$1 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                int n = this.i$1 + 1;
                                this.$outer.margins$1[n] = this.$outer.margins$1[n] + this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$anonfun$$$outer().weights$1[this.i$1 * this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$anonfun$$$outer().xWithInterceptsDim$1 + j] * this.$outer.xArray$1[j];
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                        if (this.$outer.addIntercept$1) {
                            int n = i + 1;
                            this.margins$1[n] = this.margins$1[n] + this.$outer.weights$1[(i + 1) * this.$outer.xWithInterceptsDim$1 - 1];
                        }
                    }

                    public /* synthetic */ anonfun.30 org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.xArray$1 = xArray$1;
                        this.margins$1 = margins$1;
                    }
                });
                double maxMargin = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(margins).max((Ordering)Ordering.Double$.MODULE$));
                if (maxMargin > 0.0) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nClasses$1).foreach$mVc$sp((Function1)new Serializable(this, margins, maxMargin){
                        public static final long serialVersionUID = 0L;
                        private final double[] margins$1;
                        private final double maxMargin$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.margins$1[i] = this.margins$1[i] - this.maxMargin$1;
                        }
                        {
                            this.margins$1 = margins$1;
                            this.maxMargin$1 = maxMargin$1;
                        }
                    });
                }
                DoubleRef temp = new DoubleRef(0.0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nClasses$1).foreach$mVc$sp((Function1)new Serializable(this, margins, probs, temp){
                    public static final long serialVersionUID = 0L;
                    private final double[] margins$1;
                    private final double[] probs$1;
                    private final DoubleRef temp$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.probs$1[i] = package$.MODULE$.exp(this.margins$1[i]);
                        this.temp$1.elem += this.probs$1[i];
                    }
                    {
                        this.margins$1 = margins$1;
                        this.probs$1 = probs$1;
                        this.temp$1 = temp$1;
                    }
                });
                double norm = temp.elem;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nClasses$1).foreach$mVc$sp((Function1)new Serializable(this, probs, norm){
                    public static final long serialVersionUID = 0L;
                    private final double[] probs$1;
                    private final double norm$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.probs$1[i] = this.probs$1[i] / this.norm$1;
                    }
                    {
                        this.probs$1 = probs$1;
                        this.norm$1 = norm$1;
                    }
                });
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.nClasses$1).foreach$mVc$sp((Function1)new Serializable(this, probs){
                    public static final long serialVersionUID = 0L;
                    private final double[] probs$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.probs$1[i] = this.probs$1[i] + this.probs$1[i - 1];
                    }
                    {
                        this.probs$1 = probs$1;
                    }
                });
                double p = this.rnd$3.nextDouble();
                IntRef y = new IntRef(0);
                Breaks$.MODULE$.breakable((Function0)new Serializable(this, probs, p, y){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.30 $outer;
                    public final double[] probs$1;
                    public final double p$1;
                    public final IntRef y$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.nClasses$1).foreach$mVc$sp((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$30$$anonfun$apply$mcII$sp$5 $outer;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                if (this.$outer.p$1 < this.$outer.probs$1[i]) {
                                    this.$outer.y$3.elem = i;
                                    throw Breaks$.MODULE$.break();
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.probs$1 = probs$1;
                        this.p$1 = p$1;
                        this.y$3 = y$3;
                    }
                });
                return y.elem;
            }
            {
                this.weights$1 = weights$1;
                this.addIntercept$1 = addIntercept$1;
                this.rnd$3 = rnd$3;
                this.xDim$1 = xDim$1;
                this.xWithInterceptsDim$1 = xWithInterceptsDim$1;
                this.nClasses$1 = nClasses$1;
                this.x$68 = x$68;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(x, y){
            public static final long serialVersionUID = 0L;
            private final Vector[] x$68;
            private final IndexedSeq y$2;

            public final LabeledPoint apply(int i) {
                return new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)this.y$2.apply(i)), this.x$68[i]);
            }
            {
                this.x$68 = x$68;
                this.y$2 = y$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LogisticRegressionSuite$() {
        MODULE$ = this;
        this.allParamSettings = ProbabilisticClassifierSuite$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"probabilityCol"), (Object)"myProbability"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"thresholds"), (Object)new double[]{0.4, 0.6}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"elasticNetParam"), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"standardization"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"threshold"), (Object)BoxesRunTime.boxToDouble((double)0.6))})));
    }
}

