/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifierSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u001b\t\u0019S*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aLWM]*vSR,'BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u001b!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001c;5\tAD\u0003\u0002\u0016\t%\u0011a\u0004\b\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"C\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001'\u0003\u001d!\u0017\r^1tKR,\u0012a\n\u0019\u0003QA\u00022!\u000b\u0017/\u001b\u0005Q#BA\u0016\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003[)\u0012q\u0001R1uCN,G\u000f\u0005\u00020a1\u0001A!C\u00193\u0003\u0003\u0005\tQ!\u00019\u0005\ryF%\r\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u001b\u0002\u0011\u0011\fG/Y:fi\u0002\u0002$!N\u001c\u0011\u0007%bc\u0007\u0005\u00020o\u0011I\u0011GMA\u0001\u0002\u0003\u0015\t\u0001O\t\u0003s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAT8uQ&tw\r\u0005\u0002;\u0001&\u0011\u0011i\u000f\u0002\u0004\u0003:L\bF\u0001\u001aD!\tQD)\u0003\u0002Fw\tIAO]1og&,g\u000e\u001e\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!\u000b1\u0002Z1uCN,Go\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003u)K!aS\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u001a\u000b\t\u00111\u0001O\u0003\rAH%\r\u0019\u0003\u001fF\u00032!\u000b\u0017Q!\ty\u0013\u000bB\u00052e\u0005\u0005\t\u0011!B\u0001q!)1\u000b\u0001C!)\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u0013\u0002")
public class MultilayerPerceptronClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dataset;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MultilayerPerceptronClassifierSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_MultilayerPerceptronClassifierSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_classification_MultilayerPerceptronClassifierSuite$$typecreator1$1(MultilayerPerceptronClassifierSuite $outer) {
            }
        }
        this.dataset_$eq(this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_MultilayerPerceptronClassifierSuite$$typecreator1$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "label"})));
    }

    public MultilayerPerceptronClassifierSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("Input Validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MultilayerPerceptronClassifier mlpc = new MultilayerPerceptronClassifier();
                this.$outer.intercept((Function0)new Serializable(this, mlpc){
                    public static final long serialVersionUID = 0L;
                    private final MultilayerPerceptronClassifier mlpc$1;

                    public final MultilayerPerceptronClassifier apply() {
                        return this.mlpc$1.setLayers((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
                    }
                    {
                        this.mlpc$1 = mlpc$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, mlpc){
                    public static final long serialVersionUID = 0L;
                    private final MultilayerPerceptronClassifier mlpc$1;

                    public final MultilayerPerceptronClassifier apply() {
                        return this.mlpc$1.setLayers((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), ClassTag$.MODULE$.Int()));
                    }
                    {
                        this.mlpc$1 = mlpc$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, mlpc){
                    public static final long serialVersionUID = 0L;
                    private final MultilayerPerceptronClassifier mlpc$1;

                    public final MultilayerPerceptronClassifier apply() {
                        return this.mlpc$1.setLayers((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), ClassTag$.MODULE$.Int()));
                    }
                    {
                        this.mlpc$1 = mlpc$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, mlpc){
                    public static final long serialVersionUID = 0L;
                    private final MultilayerPerceptronClassifier mlpc$1;

                    public final MultilayerPerceptronClassifier apply() {
                        return this.mlpc$1.setLayers((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}), ClassTag$.MODULE$.Int()));
                    }
                    {
                        this.mlpc$1 = mlpc$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                mlpc.setLayers((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1}), ClassTag$.MODULE$.Int()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("XOR function learning as binary classification problem with two outputs.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 2}), ClassTag$.MODULE$.Int());
                MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(1).setSeed(123L).setMaxIter(100).setSolver("l-bfgs");
                MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(this.$outer.dataset());
                Dataset result = model.transform(this.$outer.dataset());
                Row[] predictionAndLabels = (Row[])result.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictionAndLabels).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object p = ((SeqLike)some.get()).apply(0);
                            Object l = ((SeqLike)some.get()).apply(1);
                            if (p instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)p);
                                if (l instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)l);
                                    Double $org_scalatest_assert_macro_left = BoxesRunTime.boxToDouble((double)d);
                                    double $org_scalatest_assert_macro_right = d2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), BoxesRunTime.unboxToDouble((Object)$org_scalatest_assert_macro_left) == $org_scalatest_assert_macro_right);
                                    this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MultilayerPerceptronClassifierSuite org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Test setWeights by training restart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MultilayerPerceptronClassifierSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "label"}));
                int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 2}), ClassTag$.MODULE$.Int());
                MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(1).setSeed(12L).setMaxIter(1).setTol(1.0E-6);
                org.apache.spark.ml.linalg.Vector initialWeights = ((MultilayerPerceptronClassificationModel)trainer.fit(dataFrame)).weights();
                trainer.setInitialWeights(initialWeights.copy());
                org.apache.spark.ml.linalg.Vector weights1 = ((MultilayerPerceptronClassificationModel)trainer.fit(dataFrame)).weights();
                trainer.setInitialWeights(initialWeights.copy());
                org.apache.spark.ml.linalg.Vector weights2 = ((MultilayerPerceptronClassificationModel)trainer.fit(dataFrame)).weights();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(weights1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(weights2).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(weights1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(weights2).absTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Training should produce the same weights given equal initial weights and number of steps");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("3 class classification with 2 hidden layers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
                double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
                double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
                RDD rdd = this.$outer.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MultilayerPerceptronClassifierSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame(rdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
                int numClasses = 3;
                int numIterations = 100;
                int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 4, numClasses}), ClassTag$.MODULE$.Int());
                MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(1).setSeed(11L).setMaxIter(numIterations);
                MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(dataFrame);
                int numFeatures = ((org.apache.spark.ml.linalg.Vector)((Row)dataFrame.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getAs(0)).size();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = numFeatures;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD mlpPredictionAndLabels = model.transform(dataFrame).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object p = ((SeqLike)some.get()).apply(0);
                            Object l = ((SeqLike)some.get()).apply(1);
                            if (p instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)p);
                                if (l instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)l);
                                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                    return sp2;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(numClasses);
                lr.optimizer().setRegParam(0.0).setNumIterations(numIterations);
                LogisticRegressionModel lrModel = lr.run(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final org.apache.spark.mllib.regression.LabeledPoint apply(LabeledPoint point) {
                        return LabeledPoint$.MODULE$.fromML(point);
                    }
                }, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)));
                RDD lrPredictionAndLabels = lrModel.predict(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint p) {
                        return Vectors$.MODULE$.fromML(p.features());
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).zip(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(LabeledPoint x$1) {
                        return x$1.label();
                    }
                }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
                MulticlassMetrics lrMetrics = new MulticlassMetrics(lrPredictionAndLabels);
                MulticlassMetrics mlpMetrics = new MulticlassMetrics(mlpPredictionAndLabels);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(mlpMetrics.confusionMatrix().asML()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(lrMetrics.confusionMatrix().asML()).absTol(100.0)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(mlpMetrics.confusionMatrix.asML).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(lrMetrics.confusionMatrix.asML).absTol(100.0))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: MultilayerPerceptronClassifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MultilayerPerceptronClassifier mlp = (MultilayerPerceptronClassifier)new MultilayerPerceptronClassifier().setLayers(new int[]{2, 3, 2}).setMaxIter(5).setBlockSize(2).setSeed(42L).setTol(0.1).setFeaturesCol("myFeatures").setLabelCol("myLabel").setPredictionCol("myPrediction");
                this.$outer.testDefaultReadWrite(mlp, true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: MultilayerPerceptronClassificationModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MultilayerPerceptronClassifier mlp = new MultilayerPerceptronClassifier().setLayers(new int[]{2, 3, 2}).setMaxIter(5);
                MultilayerPerceptronClassificationModel mlpModel = (MultilayerPerceptronClassificationModel)mlp.fit(this.$outer.dataset());
                MultilayerPerceptronClassificationModel newMlpModel = this.$outer.testDefaultReadWrite(mlpModel, true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newMlpModel.layers());
                int[] $org_scalatest_assert_macro_right = mlpModel.layers();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(newMlpModel.weights());
                org.apache.spark.ml.linalg.Vector $org_scalatest_assert_macro_right2 = mlpModel.weights();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] layers = new int[]{3, 2};
                MultilayerPerceptronClassifier mpc = new MultilayerPerceptronClassifier().setLayers(layers).setMaxIter(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(mpc, this.$outer.spark(), MLTestingUtils$.MODULE$.checkNumericTypes$default$3(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(MultilayerPerceptronClassificationModel expected, MultilayerPerceptronClassificationModel actual) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().convertToEqualizer(expected.layers());
                        int[] $org_scalatest_assert_macro_right = actual.layers();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().convertToEqualizer(expected.weights());
                        org.apache.spark.ml.linalg.Vector $org_scalatest_assert_macro_right2 = actual.weights();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MultilayerPerceptronClassifierSuite org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

