/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.generic.UFunc;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.NaiveBayesSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t'VLG/\u001a\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003vi&d'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005miR\"\u0001\u000f\u000b\u0005U!\u0011B\u0001\u0010\u001d\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\nq\u0001Z1uCN,G/F\u0001(a\tA\u0003\u0007E\u0002*Y9j\u0011A\u000b\u0006\u0003W\u0019\t1a]9m\u0013\ti#FA\u0004ECR\f7/\u001a;\u0011\u0005=\u0002D\u0002\u0001\u0003\ncI\n\t\u0011!A\u0003\u0002a\u00121a\u0018\u00132\u0011\u0019\u0019\u0004\u0001)Q\u0005i\u0005AA-\u0019;bg\u0016$\b\u0005\r\u00026oA\u0019\u0011\u0006\f\u001c\u0011\u0005=:D!C\u00193\u0003\u0003\u0005\tQ!\u00019#\tIt\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0004O_RD\u0017N\\4\u0011\u0005i\u0002\u0015BA!<\u0005\r\te.\u001f\u0015\u0003e\r\u0003\"A\u000f#\n\u0005\u0015[$!\u0003;sC:\u001c\u0018.\u001a8u\u0011%9\u0005\u00011AA\u0002\u0013\u0005\u0001*A\u0006eCR\f7/\u001a;`I\u0015\fHCA%M!\tQ$*\u0003\u0002Lw\t!QK\\5u\u0011\u001die)!AA\u00029\u000b1\u0001\u001f\u00132a\ty\u0015\u000bE\u0002*YA\u0003\"aL)\u0005\u0013E\u0012\u0014\u0011!A\u0001\u0006\u0003A\u0004\"B*\u0001\t\u0003\"\u0016!\u00032fM>\u0014X-\u00117m)\u0005I\u0005\"\u0002,\u0001\t\u00039\u0016A\u0005<bY&$\u0017\r^3Qe\u0016$\u0017n\u0019;j_:$\"!\u0013-\t\u000be+\u0006\u0019\u0001.\u0002'A\u0014X\rZ5di&|g.\u00118e\u0019\u0006\u0014W\r\\:\u0011\u0005mKgB\u0001/h\u001d\tifM\u0004\u0002_K:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003E2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tYc!\u0003\u0002iU\u00059\u0001/Y2lC\u001e,\u0017B\u00016l\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002iU!)Q\u000e\u0001C\u0001]\u0006\u0001b/\u00197jI\u0006$X-T8eK24\u0015\u000e\u001e\u000b\u0005\u0013><H\u0010C\u0003qY\u0002\u0007\u0011/\u0001\u0004qS\u0012\u000bG/\u0019\t\u0003eVl\u0011a\u001d\u0006\u0003i\u0012\ta\u0001\\5oC2<\u0017B\u0001<t\u0005\u00191Vm\u0019;pe\")\u0001\u0010\u001ca\u0001s\u0006IA\u000f[3uC\u0012\u000bG/\u0019\t\u0003ejL!a_:\u0003\r5\u000bGO]5y\u0011\u0015iH\u000e1\u0001\u007f\u0003\u0015iw\u000eZ3m!\t\u0019s0C\u0002\u0002\u0002\t\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0001*\u0007\u0010]3di\u0016$W*\u001e7uS:|W.[1m!J|'-\u00192jY&$\u0018.Z:\u0015\u000bE\fI!a\u0003\t\ru\f\u0019\u00011\u0001\u007f\u0011\u001d\ti!a\u0001A\u0002E\fqAZ3biV\u0014X\rC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002=\u0015D\b/Z2uK\u0012\u0014UM\u001d8pk2d\u0017\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cH#B9\u0002\u0016\u0005]\u0001BB?\u0002\u0010\u0001\u0007a\u0010C\u0004\u0002\u000e\u0005=\u0001\u0019A9\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005)b/\u00197jI\u0006$X\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHcB%\u0002 \u0005\r\u0012Q\u0005\u0005\b\u0003C\tI\u00021\u0001[\u0003]1W-\u0019;ve\u0016\fe\u000e\u001a)s_\n\f'-\u001b7ji&,7\u000f\u0003\u0004~\u00033\u0001\rA \u0005\t\u0003O\tI\u00021\u0001\u0002*\u0005IQn\u001c3fYRK\b/\u001a\t\u0005\u0003W\t\tDD\u0002;\u0003[I1!a\f<\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011qF\u001e\b\u000f\u0005e\"\u0001#\u0001\u0002<\u0005ya*Y5wK\n\u000b\u00170Z:Tk&$X\rE\u0002$\u0003{1a!\u0001\u0002\t\u0002\u0005}2CBA\u001f\u0003\u0003\n9\u0005E\u0002;\u0003\u0007J1!!\u0012<\u0005\u0019\te.\u001f*fMB\u0019!(!\u0013\n\u0007\u0005-3H\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004!\u0003{!\t!a\u0014\u0015\u0005\u0005m\u0002BCA*\u0003{\u0011\r\u0011\"\u0001\u0002V\u0005\u0001\u0012\r\u001c7QCJ\fWnU3ui&twm]\u000b\u0003\u0003/\u0002r!a\u000b\u0002Z\u0005%r(\u0003\u0003\u0002\\\u0005U\"aA'ba\"I\u0011qLA\u001fA\u0003%\u0011qK\u0001\u0012C2d\u0007+\u0019:b[N+G\u000f^5oON\u0004\u0003\u0002CA2\u0003{!I!!\u001a\u0002\u0013\r\fGn\u0019'bE\u0016dGCBA4\u0003[\n9\bE\u0002;\u0003SJ1!a\u001b<\u0005\rIe\u000e\u001e\u0005\t\u0003_\n\t\u00071\u0001\u0002r\u0005\t\u0001\u000fE\u0002;\u0003gJ1!!\u001e<\u0005\u0019!u.\u001e2mK\"A\u0011\u0011PA1\u0001\u0004\tY(\u0001\u0002qSB)!(! \u0002r%\u0019\u0011qP\u001e\u0003\u000b\u0005\u0013(/Y=\t\u0011\u0005\r\u0015Q\bC\u0001\u0003\u000b\u000bqcZ3oKJ\fG/\u001a(bSZ,')Y=fg&s\u0007/\u001e;\u0015\u001d\u0005\u001d\u0015\u0011UAR\u0003S\u000bi+!-\u00024B1\u0011\u0011RAI\u0003/sA!a#\u0002\u0010:\u0019\u0001-!$\n\u0003qJ!\u0001[\u001e\n\t\u0005M\u0015Q\u0013\u0002\u0004'\u0016\f(B\u00015<!\u0011\tI*!(\u000e\u0005\u0005m%bAA\u0007\t%!\u0011qTAN\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011!\tI(!!A\u0002\u0005m\u0004\u0002CAS\u0003\u0003\u0003\r!a*\u0002\u000bQDW\r^1\u0011\u000bi\ni(a\u001f\t\u0011\u0005-\u0016\u0011\u0011a\u0001\u0003O\nqA\u001c)pS:$8\u000f\u0003\u0005\u00020\u0006\u0005\u0005\u0019AA4\u0003\u0011\u0019X-\u001a3\t\u0015\u0005\u001d\u0012\u0011\u0011I\u0001\u0002\u0004\tI\u0003\u0003\u0006\u00026\u0006\u0005\u0005\u0013!a\u0001\u0003O\naa]1na2,\u0007BCA]\u0003{\t\n\u0011\"\u0001\u0002<\u0006\ts-\u001a8fe\u0006$XMT1jm\u0016\u0014\u0015-_3t\u0013:\u0004X\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0018\u0016\u0005\u0003S\tyl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tYmO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\u0019.!\u0010\u0012\u0002\u0013\u0005\u0011Q[\u0001\"O\u0016tWM]1uK:\u000b\u0017N^3CCf,7/\u00138qkR$C-\u001a4bk2$HEN\u000b\u0003\u0003/TC!a\u001a\u0002@\"Q\u00111\\A\u001f\u0003\u0003%I!!8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003mC:<'BAAu\u0003\u0011Q\u0017M^1\n\t\u00055\u00181\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class NaiveBayesSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dataset;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static int generateNaiveBayesInput$default$6() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6();
    }

    public static String generateNaiveBayesInput$default$5() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$5();
    }

    public static Seq<LabeledPoint> generateNaiveBayesInput(double[] dArray, double[][] dArray2, int n, int n2, String string, int n3) {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(dArray, dArray2, n, n2, string, n3);
    }

    public static Map<String, Object> allParamSettings() {
        return NaiveBayesSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        double[] pi = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4}).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.log(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[][] theta = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}}).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double[] apply(double[] x$1) {
                return (double[])Predef$.MODULE$.doubleArrayOps(x$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1(NaiveBayesSuite $outer) {
            }
        }
        this.dataset_$eq(this.spark().createDataFrame(NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, 100, 42, NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$5(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1(this))));
    }

    public void validatePrediction(Dataset<Row> predictionAndLabels) {
        int numOfErrorPredictions;
        int $org_scalatest_assert_macro_left = numOfErrorPredictions = Predef$.MODULE$.refArrayOps((Object[])predictionAndLabels.collect()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            boolean bl = d != d2;
                            return bl;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        });
        long $org_scalatest_assert_macro_right = predictionAndLabels.count() / 5L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public void validateModelFit(org.apache.spark.ml.linalg.Vector piData, Matrix thetaData, NaiveBayesModel model) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(model.pi().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(piData.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).absTol(0.05)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.this.Predef.doubleArrayOps(model.pi.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.exp(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double)))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.this.Predef.doubleArrayOps(piData.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.exp(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double)))).absTol(0.05))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"pi mismatch");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(model.theta().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        })).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(thetaData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        })).absTol(0.05)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(model.theta.map({\n  ((x: Double) => scala.math.`package`.exp(x))\n})).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(thetaData.map({\n  ((x: Double) => scala.math.`package`.exp(x))\n})).absTol(0.05))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"theta mismatch");
    }

    public org.apache.spark.ml.linalg.Vector expectedMultinomialProbabilities(NaiveBayesModel model, org.apache.spark.ml.linalg.Vector feature) {
        Vector logClassProbs = (Vector)model.pi().asBreeze().$plus((Object)model.theta().multiply(feature).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$1;

            public final double apply(double x$2) {
                return this.apply$mcDD$sp(x$2);
            }

            public double apply$mcDD$sp(double x$2) {
                return x$2 / this.classProbsSum$1;
            }
            {
                this.classProbsSum$1 = classProbsSum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public org.apache.spark.ml.linalg.Vector expectedBernoulliProbabilities(NaiveBayesModel model, org.apache.spark.ml.linalg.Vector feature) {
        Matrix negThetaMatrix = model.theta().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return scala.math.package$.MODULE$.log(1.0 - scala.math.package$.MODULE$.exp(v));
            }
        });
        org.apache.spark.ml.linalg.Vector negFeature = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(feature.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return 1.0 - v;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        Vector piTheta = (Vector)model.pi().asBreeze().$plus((Object)model.theta().multiply(feature).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        Vector logClassProbs = (Vector)piTheta.$plus((Object)negThetaMatrix.multiply(negFeature).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$2;

            public final double apply(double x$3) {
                return this.apply$mcDD$sp(x$3);
            }

            public double apply$mcDD$sp(double x$3) {
                return x$3 / this.classProbsSum$2;
            }
            {
                this.classProbsSum$2 = classProbsSum$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public void validateProbabilities(Dataset<Row> featureAndProbabilities, NaiveBayesModel model, String modelType) {
        Predef$.MODULE$.refArrayOps((Object[])featureAndProbabilities.collect()).foreach((Function1)new Serializable(this, model, modelType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;
            private final NaiveBayesModel model$1;
            private final String modelType$2;

            public final void apply(Row x0$2) {
                Row row;
                block2: {
                    block5: {
                        org.apache.spark.ml.linalg.Vector vector;
                        org.apache.spark.ml.linalg.Vector vector2;
                        block4: {
                            String string;
                            org.apache.spark.ml.linalg.Vector vector3;
                            block3: {
                                row = x0$2;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                                Object features = ((SeqLike)some.get()).apply(0);
                                Object probability = ((SeqLike)some.get()).apply(1);
                                if (!(features instanceof org.apache.spark.ml.linalg.Vector)) break block2;
                                vector3 = (org.apache.spark.ml.linalg.Vector)features;
                                if (!(probability instanceof org.apache.spark.ml.linalg.Vector)) break block2;
                                vector2 = (org.apache.spark.ml.linalg.Vector)probability;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector2.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(probability.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                string = this.modelType$2;
                                String string2 = NaiveBayes$.MODULE$.Multinomial();
                                String string3 = string;
                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                                vector = this.$outer.expectedMultinomialProbabilities(this.model$1, vector3);
                                break block4;
                            }
                            String string4 = NaiveBayes$.MODULE$.Bernoulli();
                            String string5 = string;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block5;
                            vector = this.$outer.expectedBernoulliProbabilities(this.model$1, vector3);
                        }
                        org.apache.spark.ml.linalg.Vector expected = vector;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(1.0E-10)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(probability).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(1.0E-10))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.modelType$2})));
                }
                throw new MatchError((Object)row);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.model$1 = model$1;
                this.modelType$2 = modelType$2;
            }
        });
    }

    public NaiveBayesSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new NaiveBayes());
                NaiveBayesModel model = new NaiveBayesModel("nb", Vectors$.MODULE$.dense(new double[]{0.2, 0.8}), (Matrix)new DenseMatrix(2, 3, new double[]{0.1, 0.2, 0.3, 0.4, 0.6, 0.4}));
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("naive bayes: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(nb.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(nb.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(nb.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getSmoothing()));
                double $org_scalatest_assert_macro_right4 = 1.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(nb.getModelType());
                String $org_scalatest_assert_macro_right5 = "multinomial";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] piArray = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] thetaArray = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$4) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$4).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return scala.math.package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                org.apache.spark.ml.linalg.Vector pi = Vectors$.MODULE$.dense(piArray);
                DenseMatrix theta = new DenseMatrix(3, 4, (double[])Predef$.MODULE$.refArrayOps((Object[])thetaArray).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Object> apply(double[] xs) {
                        return Predef$.MODULE$.wrapDoubleArray(xs);
                    }
                }, ClassTag$.MODULE$.Double()), true);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                Dataset testDataset = this.$outer.spark().createDataFrame(NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 42, "multinomial", NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                NaiveBayes nb = new NaiveBayes().setSmoothing(1.0).setModelType("multinomial");
                NaiveBayesModel model = (NaiveBayesModel)nb.fit(testDataset);
                this.$outer.validateModelFit(pi, (Matrix)theta, model);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                Dataset validationDataset = this.$outer.spark().createDataFrame(NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 17, "multinomial", NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                Dataset predictionAndLabels = model.transform(validationDataset).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
                this.$outer.validatePrediction((Dataset<Row>)predictionAndLabels);
                Dataset featureAndProbabilities = model.transform(validationDataset).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"}));
                this.$outer.validateProbabilities((Dataset<Row>)featureAndProbabilities, model, "multinomial");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double[] piArray = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.3, 0.2}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] thetaArray = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.5, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.4}, {0.02, 0.7, 0.1, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02}, {0.02, 0.02, 0.6, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.3}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$5) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$5).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return scala.math.package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                org.apache.spark.ml.linalg.Vector pi = Vectors$.MODULE$.dense(piArray);
                DenseMatrix theta = new DenseMatrix(3, 12, (double[])Predef$.MODULE$.refArrayOps((Object[])thetaArray).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Object> apply(double[] xs) {
                        return Predef$.MODULE$.wrapDoubleArray(xs);
                    }
                }, ClassTag$.MODULE$.Double()), true);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                Dataset testDataset = this.$outer.spark().createDataFrame(NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 45, "bernoulli", NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                NaiveBayes nb = new NaiveBayes().setSmoothing(1.0).setModelType("bernoulli");
                NaiveBayesModel model = (NaiveBayesModel)nb.fit(testDataset);
                this.$outer.validateModelFit(pi, (Matrix)theta, model);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                Dataset validationDataset = this.$outer.spark().createDataFrame(NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 20, "bernoulli", NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                Dataset predictionAndLabels = model.transform(validationDataset).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
                this.$outer.validatePrediction((Dataset<Row>)predictionAndLabels);
                Dataset featureAndProbabilities = model.transform(validationDataset).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"}));
                this.$outer.validateProbabilities((Dataset<Row>)featureAndProbabilities, model, "bernoulli");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                this.$outer.testEstimatorAndModelReadWrite(nb, this.$outer.dataset(), NaiveBayesSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(NaiveBayesModel model, NaiveBayesModel model2) {
                        this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$checkModelData$1(NaiveBayesModel model, NaiveBayesModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(model.pi());
                org.apache.spark.ml.linalg.Vector $org_scalatest_assert_macro_right = model2.pi();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.theta());
                Matrix $org_scalatest_assert_macro_right2 = model2.theta();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                MLTestingUtils$.MODULE$.checkNumericTypes(nb, this.$outer.spark(), MLTestingUtils$.MODULE$.checkNumericTypes$default$3(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;

                    public final void apply(NaiveBayesModel expected, NaiveBayesModel actual) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(expected.pi());
                        org.apache.spark.ml.linalg.Vector $org_scalatest_assert_macro_right = actual.pi();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(expected.theta());
                        Matrix $org_scalatest_assert_macro_right2 = actual.theta();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

