/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.classification.MockLogisticRegression;
import org.apache.spark.ml.classification.OneVsRest;
import org.apache.spark.ml.classification.OneVsRestModel;
import org.apache.spark.ml.classification.OneVsRestSuite$;
import org.apache.spark.ml.classification.OneVsRestSuite$$anonfun$9$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001b\tqqJ\\3WgJ+7\u000f^*vSR,'BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u001b!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001c;5\tAD\u0003\u0002\u0016\t%\u0011a\u0004\b\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"C\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001'\u0003\u001d!\u0017\r^1tKR,\u0012a\n\u0019\u0003QA\u00022!\u000b\u0017/\u001b\u0005Q#BA\u0016\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003[)\u0012q\u0001R1uCN,G\u000f\u0005\u00020a1\u0001A!C\u00193\u0003\u0003\u0005\tQ!\u00019\u0005\ryF%\r\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u001b\u0002\u0011\u0011\fG/Y:fi\u0002\u0002$!N\u001c\u0011\u0007%bc\u0007\u0005\u00020o\u0011I\u0011GMA\u0001\u0002\u0003\u0015\t\u0001O\t\u0003s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAT8uQ&tw\r\u0005\u0002;\u0001&\u0011\u0011i\u000f\u0002\u0004\u0003:L\bF\u0001\u001aD!\tQD)\u0003\u0002Fw\tIAO]1og&,g\u000e\u001e\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!\u000b1\u0002Z1uCN,Go\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003u)K!aS\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u001a\u000b\t\u00111\u0001O\u0003\rAH%\r\u0019\u0003\u001fF\u00032!\u000b\u0017Q!\ty\u0013\u000bB\u00052e\u0005\u0005\t\u0011!B\u0001q!I1\u000b\u0001a\u0001\u0002\u0004%\t\u0001V\u0001\u0004e\u0012$W#A+\u0011\u0007YC&,D\u0001X\u0015\t\u0019f!\u0003\u0002Z/\n\u0019!\u000b\u0012#\u0011\u0005msV\"\u0001/\u000b\u0005u#\u0011a\u00024fCR,(/Z\u0005\u0003?r\u0013A\u0002T1cK2,G\rU8j]RD\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00012\u0002\u000fI$Gm\u0018\u0013fcR\u0011\u0011j\u0019\u0005\b\u001b\u0002\f\t\u00111\u0001V\u0011\u0019)\u0007\u0001)Q\u0005+\u0006!!\u000f\u001a3!Q\t!7\tC\u0003i\u0001\u0011\u0005\u0013.A\u0005cK\u001a|'/Z!mYR\t\u0011\n")
public class OneVsRestSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dataset;
    private transient RDD<LabeledPoint> rdd;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    public RDD<LabeledPoint> rdd() {
        return this.rdd;
    }

    public void rdd_$eq(RDD<LabeledPoint> x$1) {
        this.rdd = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        int nPoints = 1000;
        double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
        double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
        double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
        this.rdd_$eq((RDD<LabeledPoint>)this.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneVsRestSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1(OneVsRestSuite $outer) {
            }
        }
        this.dataset_$eq(this.spark().createDataFrame(this.rdd(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1(this))));
    }

    public OneVsRestSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new OneVsRest());
                LogisticRegressionModel lrModel = new LogisticRegressionModel("lr", org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0);
                OneVsRestModel model = new OneVsRestModel("ovr", Metadata$.MODULE$.empty(), (ClassificationModel[])new LogisticRegressionModel[]{lrModel});
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("one-vs-rest: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 3;
                OneVsRest ova = new OneVsRest().setClassifier((Classifier)new LogisticRegression());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ova.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ova.getPredictionCol());
                String $org_scalatest_assert_macro_right2 = "prediction";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                OneVsRestModel ovaModel = ova.fit(this.$outer.dataset());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)ovaModel);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ovaModel.models().length));
                int $org_scalatest_assert_macro_right3 = numClasses;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Dataset transformedDataset = ovaModel.transform(this.$outer.dataset());
                StructField predictionColSchema = transformedDataset.schema().apply(ovaModel.getPredictionCol());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(MetadataUtils$.MODULE$.getNumClasses(predictionColSchema));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                RDD ovaResults = transformedDataset.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Row row) {
                        return new Tuple2.mcDD.sp(row.getDouble(0), row.getDouble(1));
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(numClasses);
                lr.optimizer().setRegParam(0.1).setNumIterations(100);
                org.apache.spark.mllib.classification.LogisticRegressionModel model = lr.run(this.$outer.rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final org.apache.spark.mllib.regression.LabeledPoint apply(LabeledPoint point) {
                        return LabeledPoint$.MODULE$.fromML(point);
                    }
                }, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)));
                RDD results = model.predict(this.$outer.rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint p) {
                        return Vectors$.MODULE$.fromML(p.features());
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).zip(this.$outer.rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(LabeledPoint x$1) {
                        return x$1.label();
                    }
                }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
                MulticlassMetrics expectedMetrics = new MulticlassMetrics(results);
                MulticlassMetrics ovaMetrics = new MulticlassMetrics(ovaResults);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(expectedMetrics.confusionMatrix()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(ovaMetrics.confusionMatrix()).absTol(400.0)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(expectedMetrics.confusionMatrix).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(ovaMetrics.confusionMatrix).absTol(400.0))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("one-vs-rest: pass label metadata correctly during train", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 3;
                OneVsRest ova = new OneVsRest();
                ova.setClassifier((Classifier)new MockLogisticRegression());
                NominalAttribute labelMetadata = NominalAttribute$.MODULE$.defaultAttr().withName("label").withNumValues(numClasses);
                Column labelWithMetadata = this.$outer.dataset().apply("label").as("label", labelMetadata.toMetadata());
                Column features = this.$outer.dataset().apply("features").as("features");
                Dataset datasetWithLabelMetadata = this.$outer.dataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{labelWithMetadata, features}));
                ova.fit(datasetWithLabelMetadata);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-8092: ensure label features and prediction cols are configurable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set outputFields;
                StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexed");
                Dataset indexedDataset = labelIndexer.fit(this.$outer.dataset()).transform(this.$outer.dataset()).drop("label").withColumnRenamed("features", "f");
                OneVsRest ova = new OneVsRest();
                ova.setClassifier((Classifier)new LogisticRegression()).setLabelCol(labelIndexer.getOutputCol()).setFeaturesCol("f").setPredictionCol("p");
                OneVsRestModel ovaModel = ova.fit(indexedDataset);
                Dataset transformedDataset = ovaModel.transform(indexedDataset);
                Set $org_scalatest_assert_macro_left = outputFields = Predef$.MODULE$.refArrayOps((Object[])transformedDataset.schema().fieldNames()).toSet();
                String $org_scalatest_assert_macro_right = "p";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-8049: OneVsRest shouldn't output temp columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression logReg = new LogisticRegression().setMaxIter(1);
                OneVsRest ovr = new OneVsRest().setClassifier((Classifier)logReg);
                Dataset output = ovr.fit(this.$outer.dataset()).transform(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])output.schema().fieldNames()).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features", "prediction"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OneVsRest.copy and OneVsRestModel.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(1);
                OneVsRest ovr = new OneVsRest();
                this.$outer.withClue("copy with classifier unset should work", (Function0)new Serializable(this, lr, ovr){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegression lr$1;
                    private final OneVsRest ovr$1;

                    public final OneVsRest apply() {
                        return this.ovr$1.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lr$1.maxIter().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
                    }
                    {
                        this.lr$1 = lr$1;
                        this.ovr$1 = ovr$1;
                    }
                });
                ovr.setClassifier((Classifier)lr);
                OneVsRest ovr1 = ovr.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{lr.maxIter().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
                Predef$.MODULE$.require(this.$outer.convertToEqualizer(ovr.getClassifier().getOrDefault((Param)lr.maxIter())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "copy should have no side-effects";
                    }
                });
                Predef$.MODULE$.require(this.$outer.convertToEqualizer(ovr1.getClassifier().getOrDefault((Param)lr.maxIter())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "copy should handle extra classifier params";
                    }
                });
                OneVsRestModel ovrModel = ovr1.fit(this.$outer.dataset()).copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{lr.thresholds().$minus$greater((Object)new double[]{0.9, 0.1})})));
                Predef$.MODULE$.refArrayOps((Object[])ovrModel.models()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(ClassificationModel x0$1) {
                        ClassificationModel classificationModel = x0$1;
                        if (classificationModel instanceof LogisticRegressionModel) {
                            LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)classificationModel;
                            Predef$.MODULE$.require(this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)logisticRegressionModel.getThreshold())).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.1), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "copy should handle extra model params";
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)classificationModel);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OneVsRestSuite org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: OneVsRest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.01);
                OneVsRest ova = new OneVsRest().setClassifier((Classifier)lr).setLabelCol("myLabel").setFeaturesCol("myFeature").setPredictionCol("myPrediction");
                OneVsRest ova2 = this.$outer.testDefaultReadWrite(ova, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ova.uid());
                String $org_scalatest_assert_macro_right = ova2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ova.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = ova2.getFeaturesCol();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(ova.getLabelCol());
                String $org_scalatest_assert_macro_right3 = ova2.getLabelCol();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(ova.getPredictionCol());
                String $org_scalatest_assert_macro_right4 = ova2.getPredictionCol();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Classifier classifier = ova2.getClassifier();
                if (classifier instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)classifier;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(lr.uid());
                    String $org_scalatest_assert_macro_right5 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)lr.getMaxIter()));
                    int $org_scalatest_assert_macro_right6 = logisticRegression.getMaxIter();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lr.getRegParam()));
                    double $org_scalatest_assert_macro_right7 = logisticRegression.getRegParam();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded OneVsRest expected classifier of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{classifier.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: OneVsRestModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.01);
                OneVsRest ova = new OneVsRest().setClassifier((Classifier)lr);
                OneVsRestModel ovaModel = ova.fit(this.$outer.dataset());
                OneVsRestModel newOvaModel = this.$outer.testDefaultReadWrite(ovaModel, false);
                this.checkModelData$1(ovaModel, newOvaModel);
            }

            public /* synthetic */ OneVsRestSuite org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkModelData$1(OneVsRestModel model, OneVsRestModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(model.uid());
                String $org_scalatest_assert_macro_right = model2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = model2.getFeaturesCol();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(model.getLabelCol());
                String $org_scalatest_assert_macro_right3 = model2.getLabelCol();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right4 = model2.getPredictionCol();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                LogisticRegression classifier = (LogisticRegression)model.getClassifier();
                Classifier classifier2 = model2.getClassifier();
                if (classifier2 instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)classifier2;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(classifier.uid());
                    String $org_scalatest_assert_macro_right5 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)classifier.getMaxIter()));
                    int $org_scalatest_assert_macro_right6 = logisticRegression.getMaxIter();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)classifier.getRegParam()));
                    double $org_scalatest_assert_macro_right7 = logisticRegression.getRegParam();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.labelMetadata());
                    Metadata $org_scalatest_assert_macro_right8 = model2.labelMetadata();
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.models()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])model2.models()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;

                        public final void apply(Tuple2<ClassificationModel, ClassificationModel> x0$2) {
                            Tuple2<ClassificationModel, ClassificationModel> tuple2 = x0$2;
                            if (tuple2 != null) {
                                ClassificationModel lrModel1 = (ClassificationModel)tuple2._1();
                                ClassificationModel lrModel2 = (ClassificationModel)tuple2._2();
                                if (lrModel1 instanceof LogisticRegressionModel) {
                                    LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)lrModel1;
                                    if (lrModel2 instanceof LogisticRegressionModel) {
                                        LogisticRegressionModel logisticRegressionModel2 = (LogisticRegressionModel)lrModel2;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(logisticRegressionModel.uid());
                                        String $org_scalatest_assert_macro_right = logisticRegressionModel2.uid();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(logisticRegressionModel.coefficients());
                                        org.apache.spark.ml.linalg.Vector $org_scalatest_assert_macro_right2 = logisticRegressionModel2.coefficients();
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)logisticRegressionModel.intercept()));
                                        double $org_scalatest_assert_macro_right3 = logisticRegressionModel2.intercept();
                                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                            throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded OneVsRestModel expected model of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegressionModel but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2.getClass().getName()}))).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded OneVsRestModel expected classifier of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{classifier2.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OneVsRest ovr = new OneVsRest().setClassifier((Classifier)new LogisticRegression().setMaxIter(1));
                MLTestingUtils$.MODULE$.checkNumericTypes(ovr, this.$outer.spark(), MLTestingUtils$.MODULE$.checkNumericTypes$default$3(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(OneVsRestModel expected, OneVsRestModel actual) {
                        LogisticRegressionModel[] expectedModels = (LogisticRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])expected.models()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LogisticRegressionModel apply(ClassificationModel m) {
                                return (LogisticRegressionModel)m;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogisticRegressionModel.class)));
                        LogisticRegressionModel[] actualModels = (LogisticRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])actual.models()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LogisticRegressionModel apply(ClassificationModel m) {
                                return (LogisticRegressionModel)m;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogisticRegressionModel.class)));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedModels.length));
                        int $org_scalatest_assert_macro_right = actualModels.length;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])expectedModels).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])actualModels), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$5 $outer;

                            public final void apply(Tuple2<LogisticRegressionModel, LogisticRegressionModel> x0$3) {
                                Tuple2<LogisticRegressionModel, LogisticRegressionModel> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    LogisticRegressionModel e = (LogisticRegressionModel)tuple2._1();
                                    LogisticRegressionModel a = (LogisticRegressionModel)tuple2._2();
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)e.intercept()));
                                    double $org_scalatest_assert_macro_right = a.intercept();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(e.coefficients().toArray());
                                    double[] $org_scalatest_assert_macro_right2 = a.coefficients().toArray();
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OneVsRestSuite org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

