/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.classification.RandomForestClassifierSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001b\tY\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&,'oU;ji\u0016T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\u000e\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\u000e\u001e\u001b\u0005a\"BA\u000b\u0005\u0013\tqBD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f\u001e\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\tA\u0011\"\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0014\u00027=\u0014H-\u001a:fI2\u000b'-\u001a7fIB{\u0017N\u001c;tkAz\u0016\u0007\r\u00191+\u00059\u0003c\u0001\u0015,[5\t\u0011F\u0003\u0002+\r\u0005\u0019!\u000f\u001a3\n\u00051J#a\u0001*E\tB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\bM\u0016\fG/\u001e:f\u0013\t\u0011tF\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u00055\u0001\u0001\u0007\t\u0019!C\u0005k\u0005yrN\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN,\u0004gX\u00191aAzF%Z9\u0015\u0005Yb\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$\u0001B+oSRDq!P\u001a\u0002\u0002\u0003\u0007q%A\u0002yIEBaa\u0010\u0001!B\u00139\u0013\u0001H8sI\u0016\u0014X\r\u001a'bE\u0016dW\r\u001a)pS:$8/\u000e\u0019`cA\u0002\u0004\u0007\t\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\u0019\n\u0001d\u001c:eKJ,G\rT1cK2,G\rU8j]R\u001cXg\u0018\u001a1\u0011%\u0019\u0005\u00011AA\u0002\u0013%A)\u0001\u000fpe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo]\u001b`eAzF%Z9\u0015\u0005Y*\u0005bB\u001fC\u0003\u0003\u0005\ra\n\u0005\u0007\u000f\u0002\u0001\u000b\u0015B\u0014\u00023=\u0014H-\u001a:fI2\u000b'-\u001a7fIB{\u0017N\u001c;tk}\u0013\u0004\u0007\t\u0005\u0006\u0013\u0002!\tES\u0001\nE\u00164wN]3BY2$\u0012A\u000e\u0005\u0006\u0019\u0002!\t!T\u0001/E&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8UKN$x+\u001b;i\u0007>tG/\u001b8v_V\u001ch)Z1ukJ,7\u000f\u0006\u00027\u001d\")qj\u0013a\u0001!\u0006\u0011!O\u001a\t\u0003GEK!A\u0015\u0002\u0003-I\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jKJ<Q\u0001\u0016\u0002\t\nU\u000b1DU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM]*vSR,\u0007CA\u0012W\r\u0015\t!\u0001#\u0003X'\t1f\u0002C\u0003!-\u0012\u0005\u0011\fF\u0001V\u0011\u0015Yf\u000b\"\u0001]\u0003-\u0019w.\u001c9be\u0016\f\u0005+S:\u0015\u000bYjv\f\u00197\t\u000byS\u0006\u0019A\u0014\u0002\t\u0011\fG/\u0019\u0005\u0006\u001fj\u0003\r\u0001\u0015\u0005\u0006Cj\u0003\rAY\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0005G\u001aL\u0017N\u0004\u00028I&\u0011Q\rO\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'aA'ba*\u0011Q\r\u000f\t\u0003o)L!a\u001b\u001d\u0003\u0007%sG\u000fC\u0003n5\u0002\u0007\u0011.\u0001\u0006ok6\u001cE.Y:tKNDqa\u001c,\u0002\u0002\u0013%\u0001/A\u0006sK\u0006$'+Z:pYZ,G#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00027b]\u001eT\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\n1qJ\u00196fGR\u0004")
public class RandomForestClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private RDD<LabeledPoint> orderedLabeledPoints50_1000;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareAPIs(RDD<LabeledPoint> rDD, RandomForestClassifier randomForestClassifier, Map<Object, Object> map, int n) {
        RandomForestClassifierSuite$.MODULE$.compareAPIs(rDD, randomForestClassifier, map, n);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    private RDD<LabeledPoint> orderedLabeledPoints50_1000() {
        return this.orderedLabeledPoints50_1000;
    }

    private void orderedLabeledPoints50_1000_$eq(RDD<LabeledPoint> x$1) {
        this.orderedLabeledPoints50_1000 = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20() {
        return this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20;
    }

    private void org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000));
        int x$6 = qual$1.parallelize$default$2();
        this.orderedLabeledPoints50_1000_$eq((RDD<LabeledPoint>)qual$1.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$2 = this.sc();
        WrappedArray x$7 = Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(5, 20));
        int x$8 = qual$2.parallelize$default$2();
        this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20_$eq((RDD<LabeledPoint>)qual$2.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                return x$2.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public void binaryClassificationTestWithContinuousFeatures(RandomForestClassifier rf) {
        Map categoricalFeatures = Predef$.MODULE$.Map().empty();
        int numClasses = 2;
        RandomForestClassifier newRF = rf.setImpurity("Gini").setMaxDepth(2).setNumTrees(1).setFeatureSubsetStrategy("auto").setSeed(123L);
        RandomForestClassifierSuite$.MODULE$.compareAPIs(this.orderedLabeledPoints50_1000(), newRF, (Map<Object, Object>)categoricalFeatures, numClasses);
    }

    public RandomForestClassifierSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new RandomForestClassifier());
                DecisionTreeClassificationModel[] decisionTreeClassificationModelArray = new DecisionTreeClassificationModel[1];
                decisionTreeClassificationModelArray[0] = new DecisionTreeClassificationModel("dtc", (Node)new LeafNode(0.0, 0.0, null), 1, 2);
                RandomForestClassificationModel model = new RandomForestClassificationModel("rfc", (DecisionTreeClassificationModel[])((Object[])decisionTreeClassificationModelArray), 2, 2);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Binary classification with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier();
                this.$outer.binaryClassificationTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier().setCacheNodeIds(true);
                this.$outer.binaryClassificationTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alternating categorical and continuous features with multiclass labels to test indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 3.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 3.0}))), new LabeledPoint(2.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 3.0, 2.0})))});
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$10 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4))}));
                int numClasses = 3;
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(5).setNumTrees(2).setFeatureSubsetStrategy("sqrt").setSeed(12345L);
                RandomForestClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, rf, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("subsampling rate in RandomForest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20();
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                int numClasses = 2;
                RandomForestClassifier rf1 = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(2).setCacheNodeIds(true).setNumTrees(3).setFeatureSubsetStrategy("auto").setSeed(123L);
                RandomForestClassifierSuite$.MODULE$.compareAPIs(rdd, rf1, (Map<Object, Object>)categoricalFeatures, numClasses);
                RandomForestClassifier rf2 = rf1.setSubsamplingRate(0.5);
                RandomForestClassifierSuite$.MODULE$.compareAPIs(rdd, rf2, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictRaw and predictProbability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20();
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(3).setNumTrees(3).setSeed(123L);
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                int numClasses = 2;
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)categoricalFeatures, numClasses);
                RandomForestClassificationModel model = (RandomForestClassificationModel)rf.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                Row[] predictions = (Row[])model.transform(df).select(rf.getPredictionCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rf.getRawPredictionCol(), rf.getProbabilityCol()})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictions).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object rawPred = ((SeqLike)some.get()).apply(1);
                            Object probPred = ((SeqLike)some.get()).apply(2);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (rawPred instanceof Vector) {
                                    Vector vector = (Vector)rawPred;
                                    if (probPred instanceof Vector) {
                                        Vector vector2 = (Vector)probPred;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                        int $org_scalatest_assert_macro_right = vector.argmax();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected prediction ", " but calculated ", " from rawPrediction."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d), BoxesRunTime.boxToInteger((int)vector.argmax())})));
                                        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().convertToEqualizer(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this, sum){
                                            public static final long serialVersionUID = 0L;
                                            private final double sum$1;

                                            public final double apply(double x$3) {
                                                return this.apply$mcDD$sp(x$3);
                                            }

                                            public double apply$mcDD$sp(double x$3) {
                                                return x$3 / this.sum$1;
                                            }
                                            {
                                                this.sum$1 = sum$1;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                                        Vector $org_scalatest_assert_macro_right2 = vector2;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"probability prediction mismatch");
                                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector2.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(probPred.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RandomForestClassifierSuite org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Fitting without numClasses in metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassifierSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame(TreeTests$.MODULE$.featureImportanceData(this.$outer.sc()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                RandomForestClassifier rf = new RandomForestClassifier().setMaxDepth(1).setNumTrees(1);
                rf.fit(df);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 2;
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(3).setNumTrees(3).setFeatureSubsetStrategy("all").setSubsamplingRate(1.0).setSeed(123L);
                RDD<LabeledPoint> data = TreeTests$.MODULE$.featureImportanceData(this.$outer.sc());
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(data, (Map<Object, Object>)categoricalFeatures, numClasses);
                Vector importances = ((RandomForestClassificationModel)rf.fit(df)).featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(importances.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(importances.toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$4) {
                        return this.apply$mcZD$sp(x$4);
                    }

                    public boolean apply$mcZD$sp(double x$4) {
                        return x$4 >= 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(importances.toArray).forall(((x$4: Double) => x$4.>=(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier().setMaxDepth(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(rf, this.$outer.spark(), MLTestingUtils$.MODULE$.checkNumericTypes$default$3(), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(RandomForestClassificationModel expected, RandomForestClassificationModel actual) {
                        TreeTests$.MODULE$.checkEqual(expected, actual);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier().setNumTrees(2);
                RDD<LabeledPoint> rdd = TreeTests$.MODULE$.getTreeReadWriteData(this.$outer.sc());
                Map allParamSettings = TreeTests$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"impurity"), (Object)"entropy")})));
                Dataset<Row> continuousData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), 2);
                this.$outer.testEstimatorAndModelReadWrite(rf, continuousData, (Map<String, Object>)allParamSettings, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply(RandomForestClassificationModel model, RandomForestClassificationModel model2) {
                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$checkModelData$1(RandomForestClassificationModel model, RandomForestClassificationModel model2) {
                TreeTests$.MODULE$.checkEqual(model, model2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numClasses()));
                int $org_scalatest_assert_macro_right2 = model2.numClasses();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

