/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.BisectingKMeans;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.clustering.BisectingKMeansSuite$;
import org.apache.spark.ml.clustering.KMeansSuite$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u00015\u0011ACQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn]*vSR,'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dIQ\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tYR$D\u0001\u001d\u0015\t)B!\u0003\u0002\u001f9\t!B)\u001a4bk2$(+Z1e/JLG/\u001a+fgRDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0002\t\u000f\u0015\u0002!\u0019!C\u0003M\u0005\t1.F\u0001(\u001f\u0005AS$A\u0003\t\r)\u0002\u0001\u0015!\u0004(\u0003\tY\u0007\u0005C\u0005-\u0001\u0001\u0007\t\u0019!C\u0001[\u00059A-\u0019;bg\u0016$X#\u0001\u00181\u0005=:\u0004c\u0001\u00194k5\t\u0011G\u0003\u00023\r\u0005\u00191/\u001d7\n\u0005Q\n$a\u0002#bi\u0006\u001cX\r\u001e\t\u0003m]b\u0001\u0001B\u00059s\u0005\u0005\t\u0011!B\u0001\u007f\t\u0019q\fJ\u0019\t\ri\u0002\u0001\u0015)\u0003<\u0003!!\u0017\r^1tKR\u0004\u0003G\u0001\u001f?!\r\u00014'\u0010\t\u0003my\"\u0011\u0002O\u001d\u0002\u0002\u0003\u0005)\u0011A \u0012\u0005\u00013\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%a\u0002(pi\"Lgn\u001a\t\u0003\u0003\u001eK!\u0001\u0013\"\u0003\u0007\u0005s\u0017\u0010\u000b\u0002:\u0015B\u0011\u0011iS\u0005\u0003\u0019\n\u0013\u0011\u0002\u001e:b]NLWM\u001c;\t\u00139\u0003\u0001\u0019!a\u0001\n\u0003y\u0015a\u00033bi\u0006\u001cX\r^0%KF$\"\u0001U*\u0011\u0005\u0005\u000b\u0016B\u0001*C\u0005\u0011)f.\u001b;\t\u000fQk\u0015\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u00191\u0005YC\u0006c\u0001\u00194/B\u0011a\u0007\u0017\u0003\nqe\n\t\u0011!A\u0003\u0002}BQA\u0017\u0001\u0005Bm\u000b\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003A;Q!\u0018\u0002\t\u0002y\u000bACQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn]*vSR,\u0007CA\u0012`\r\u0015\t!\u0001#\u0001a'\ry\u0016\r\u001a\t\u0003\u0003\nL!a\u0019\"\u0003\r\u0005s\u0017PU3g!\t\tU-\u0003\u0002g\u0005\na1+\u001a:jC2L'0\u00192mK\")\u0001e\u0018C\u0001QR\ta\fC\u0004k?\n\u0007I\u0011A6\u0002!\u0005dG\u000eU1sC6\u001cV\r\u001e;j]\u001e\u001cX#\u00017\u0011\t5\u00048O\u0012\b\u0003\u0003:L!a\u001c\"\u0002\rA\u0013X\rZ3g\u0013\t\t(OA\u0002NCBT!a\u001c\"\u0011\u00055$\u0018BA;s\u0005\u0019\u0019FO]5oO\"1qo\u0018Q\u0001\n1\f\u0011#\u00197m!\u0006\u0014\u0018-\\*fiRLgnZ:!\u0011\u001dIx,!A\u0005\ni\f1B]3bIJ+7o\u001c7wKR\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fA\u0001\\1oO*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014aa\u00142kK\u000e$\b")
public class BisectingKMeansSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private final int k;
    private transient Dataset<?> dataset;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return BisectingKMeansSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public final int k() {
        return 5;
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.dataset_$eq(KMeansSuite$.MODULE$.generateKMeansData(this.spark(), 50, 3, 5));
    }

    public BisectingKMeansSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("default parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BisectingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BisectingKMeans bkm = new BisectingKMeans();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bkm.getK()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(bkm.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(bkm.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bkm.getMaxIter()));
                int $org_scalatest_assert_macro_right4 = 20;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)bkm.getMinDivisibleClusterSize()));
                double $org_scalatest_assert_macro_right5 = 1.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("setter/getter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BisectingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BisectingKMeans bkm = new BisectingKMeans().setK(9).setMinDivisibleClusterSize(2.0).setFeaturesCol("test_feature").setPredictionCol("test_prediction").setMaxIter(33).setSeed(123L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bkm.getK()));
                int $org_scalatest_assert_macro_right = 9;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(bkm.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "test_feature";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(bkm.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "test_prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bkm.getMaxIter()));
                int $org_scalatest_assert_macro_right4 = 33;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)bkm.getMinDivisibleClusterSize()));
                double $org_scalatest_assert_macro_right5 = 2.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)bkm.getSeed()));
                int $org_scalatest_assert_macro_right6 = 123;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BisectingKMeans apply() {
                        return new BisectingKMeans().setK(1);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BisectingKMeans apply() {
                        return new BisectingKMeans().setMinDivisibleClusterSize(0.0);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fit & transform", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BisectingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String predictionColName = "bisecting_kmeans_prediction";
                BisectingKMeans bkm = new BisectingKMeans().setK(5).setPredictionCol(predictionColName).setSeed(1L);
                BisectingKMeansModel model = bkm.fit(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.clusterCenters().length));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Dataset transformed = model.transform(this.$outer.dataset());
                String[] expectedColumns = (String[])((Object[])new String[]{"features", predictionColName});
                Predef$.MODULE$.refArrayOps((Object[])expectedColumns).foreach((Function1)new Serializable(this, transformed){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Dataset transformed$1;

                    public final void apply(String column) {
                        ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.transformed$1.columns());
                        String $org_scalatest_assert_macro_right = column;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$clustering$BisectingKMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.transformed$1 = transformed$1;
                    }
                });
                Set clusters = Predef$.MODULE$.intArrayOps((int[])transformed.select(predictionColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Row x$1) {
                        return x$1.getInt(0);
                    }
                }, ClassTag$.MODULE$.Int()).distinct().collect()).toSet();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)clusters.size()));
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(clusters);
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left4 = model.computeCost(this.$outer.dataset());
                double $org_scalatest_assert_macro_right4 = 0.1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }

            public /* synthetic */ BisectingKMeansSuite org$apache$spark$ml$clustering$BisectingKMeansSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BisectingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BisectingKMeans bisectingKMeans = new BisectingKMeans();
                this.$outer.testEstimatorAndModelReadWrite(bisectingKMeans, this.$outer.dataset(), BisectingKMeansSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(BisectingKMeansModel model, BisectingKMeansModel model2) {
                        this.$outer.org$apache$spark$ml$clustering$BisectingKMeansSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$clustering$BisectingKMeansSuite$$anonfun$$checkModelData$1(BisectingKMeansModel model, BisectingKMeansModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(model.clusterCenters());
                Vector[] $org_scalatest_assert_macro_right = model2.clusterCenters();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

