/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Binarizer;
import org.apache.spark.ml.feature.BinarizerSuite$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u001b\tq!)\u001b8be&TXM]*vSR,'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u001b!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001c;5\tAD\u0003\u0002\u0016\t%\u0011a\u0004\b\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"C\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001'\u0003\u0011!\u0017\r^1\u0016\u0003\u001d\u00022\u0001K\u0016.\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#!B!se\u0006L\bC\u0001\u0015/\u0013\ty\u0013F\u0001\u0004E_V\u0014G.\u001a\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002I\n\u0001\u0002Z1uC~#S-\u001d\u000b\u0003gY\u0002\"\u0001\u000b\u001b\n\u0005UJ#\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007q%A\u0002yIEBa!\u000f\u0001!B\u00139\u0013!\u00023bi\u0006\u0004\u0003F\u0001\u001d<!\tAC(\u0003\u0002>S\tIAO]1og&,g\u000e\u001e\u0005\u0006\u007f\u0001!\t\u0005Q\u0001\nE\u00164wN]3BY2$\u0012a\r")
public class BinarizerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient double[] data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public double[] data() {
        return this.data;
    }

    public void data_$eq(double[] x$1) {
        this.data = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.data_$eq(new double[]{0.1, -0.5, 0.2, -0.3, 0.8, 0.7, -0.1, -0.4});
    }

    public BinarizerSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new Binarizer());
            }
        });
        this.test("Binarize continuous features with default parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinarizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] defaultBinarized = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x > 0.0 ? 1.0 : 0.0;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BinarizerSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(defaultBinarized), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"feature", "expected"}));
                Binarizer binarizer = new Binarizer().setInputCol("feature").setOutputCol("binarized_feature");
                Predef$.MODULE$.refArrayOps((Object[])binarizer.transform(dataFrame).select("binarized_feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)x);
                                if (y instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)y);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                    double $org_scalatest_assert_macro_right = d2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The feature value is not correct after binarization.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BinarizerSuite org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binarize continuous features with setter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinarizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double threshold = 0.2;
                double[] thresholdBinarized = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).map((Function1)new Serializable(this, threshold){
                    public static final long serialVersionUID = 0L;
                    private final double threshold$1;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x > this.threshold$1 ? 1.0 : 0.0;
                    }
                    {
                        this.threshold$1 = threshold$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BinarizerSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(thresholdBinarized), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"feature", "expected"}));
                Binarizer binarizer = new Binarizer().setInputCol("feature").setOutputCol("binarized_feature").setThreshold(threshold);
                Predef$.MODULE$.refArrayOps((Object[])binarizer.transform(dataFrame).select("binarized_feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)x);
                                if (y instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)y);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                    double $org_scalatest_assert_macro_right = d2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The feature value is not correct after binarization.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BinarizerSuite org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binarize vector of continuous features with default parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinarizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] defaultBinarized = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x > 0.0 ? 1.0 : 0.0;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BinarizerSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Vectors$.MODULE$.dense(this.$outer.data()), (Object)Vectors$.MODULE$.dense(defaultBinarized))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"feature", "expected"}));
                Binarizer binarizer = new Binarizer().setInputCol("feature").setOutputCol("binarized_feature");
                Predef$.MODULE$.refArrayOps((Object[])binarizer.transform(dataFrame).select("binarized_feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Vector) {
                                Vector vector = (Vector)x;
                                if (y instanceof Vector) {
                                    Vector vector2 = (Vector)y;
                                    Vector $org_scalatest_assert_macro_left = vector;
                                    Vector $org_scalatest_assert_macro_right = vector2;
                                    Vector vector3 = $org_scalatest_assert_macro_left;
                                    Vector vector4 = $org_scalatest_assert_macro_right;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector3 != null ? !vector3.equals(vector4) : vector4 != null));
                                    this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The feature value is not correct after binarization.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BinarizerSuite org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binarize vector of continuous features with setter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinarizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double threshold = 0.2;
                double[] defaultBinarized = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.data()).map((Function1)new Serializable(this, threshold){
                    public static final long serialVersionUID = 0L;
                    private final double threshold$2;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x > this.threshold$2 ? 1.0 : 0.0;
                    }
                    {
                        this.threshold$2 = threshold$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BinarizerSuite.class.getClassLoader());
                Dataset dataFrame = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Vectors$.MODULE$.dense(this.$outer.data()), (Object)Vectors$.MODULE$.dense(defaultBinarized))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"feature", "expected"}));
                Binarizer binarizer = new Binarizer().setInputCol("feature").setOutputCol("binarized_feature").setThreshold(threshold);
                Predef$.MODULE$.refArrayOps((Object[])binarizer.transform(dataFrame).select("binarized_feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Vector) {
                                Vector vector = (Vector)x;
                                if (y instanceof Vector) {
                                    Vector vector2 = (Vector)y;
                                    Vector $org_scalatest_assert_macro_left = vector;
                                    Vector $org_scalatest_assert_macro_right = vector2;
                                    Vector vector3 = $org_scalatest_assert_macro_left;
                                    Vector vector4 = $org_scalatest_assert_macro_right;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector3 != null ? !vector3.equals(vector4) : vector4 != null));
                                    this.$outer.org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The feature value is not correct after binarization.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BinarizerSuite org$apache$spark$ml$feature$BinarizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinarizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Binarizer t = new Binarizer().setInputCol("myInputCol").setOutputCol("myOutputCol").setThreshold(0.1);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

