/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.CountVectorizer;
import org.apache.spark.ml.feature.CountVectorizerModel;
import org.apache.spark.ml.feature.CountVectorizerSuite$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\t!2i\\;oiZ+7\r^8sSj,'oU;ji\u0016T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\u000e\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\u000e\u001e\u001b\u0005a\"BA\u000b\u0005\u0013\tqBD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f\u001e\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\tAQ!\n\u0001\u0005\n\u0019\nQa\u001d9mSR$\"aJ\u001f\u0011\u0007!\u0012TG\u0004\u0002*_9\u0011!&L\u0007\u0002W)\u0011A\u0006D\u0001\u0007yI|w\u000e\u001e \n\u00039\nQa]2bY\u0006L!\u0001M\u0019\u0002\u000fA\f7m[1hK*\ta&\u0003\u00024i\t\u00191+Z9\u000b\u0005A\n\u0004C\u0001\u001c;\u001d\t9\u0004(D\u00012\u0013\tI\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d2\u0011\u0015qD\u00051\u00016\u0003\u0005\u0019\b")
public class CountVectorizerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Seq<String> org$apache$spark$ml$feature$CountVectorizerSuite$$split(String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])s.split("\\s+"));
    }

    public CountVectorizerSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new CountVectorizer());
                ParamsSuite$.MODULE$.checkParams((Params)new CountVectorizerModel((String[])((Object[])new String[]{"empty"})));
            }
        });
        this.test("CountVectorizerModel common cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b c d"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 1.0), new Tuple2.mcID.sp(3, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b b c d  a"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 2.0), new Tuple2.mcID.sp(1, 2.0), new Tuple2.mcID.sp(2, 1.0), new Tuple2.mcID.sp(3, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split(""), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a notInDict d"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(3, 1.0)}))))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cv = new CountVectorizerModel((String[])((Object[])new String[]{"a", "b", "c", "d"})).setInputCol("words").setOutputCol("features");
                Predef$.MODULE$.refArrayOps((Object[])cv.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizer common cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b c d e"), (Object)Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 1.0), new Tuple2.mcID.sp(3, 1.0), new Tuple2.mcID.sp(4, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a a a a a a"), (Object)Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 6.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("c c"), (Object)Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(2, 2.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("d"), (Object)Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(3, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("b b b b b"), (Object)Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 5.0)}))))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cv = new CountVectorizer().setInputCol("words").setOutputCol("features").fit(df);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])cv.vocabulary()).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])cv.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizer vocabSize and minDF", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b c d"), (Object)Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b c"), (Object)Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a b"), (Object)Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a"), (Object)Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cvModel = new CountVectorizer().setInputCol("words").setOutputCol("features").setVocabSize(3).fit(df);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cvModel.vocabulary());
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"a", "b", "c"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                CountVectorizerModel cvModel2 = new CountVectorizer().setInputCol("words").setOutputCol("features").setMinDF(3.0).fit(df);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(cvModel2.vocabulary());
                String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"a", "b"});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])cvModel2.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                CountVectorizerModel cvModel3 = new CountVectorizer().setInputCol("words").setOutputCol("features").setMinDF(3.0 / (double)df.count()).fit(df);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(cvModel3.vocabulary());
                String[] $org_scalatest_assert_macro_right3 = (String[])((Object[])new String[]{"a", "b"});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])cvModel3.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizer throws exception when vocab is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                        Dataset df = this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().org$apache$spark$ml$feature$CountVectorizerSuite$$split("a a b b c c")), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().org$apache$spark$ml$feature$CountVectorizerSuite$$split("aa bb cc"))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)})))})));
                            }
                        })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words"}));
                        CountVectorizerModel cvModel = new CountVectorizer().setInputCol("words").setOutputCol("features").setVocabSize(3).setMinDF(3.0).fit(df);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizerModel with minTF count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a a a b b c c c d "), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 3.0), new Tuple2.mcID.sp(2, 3.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("c c c c c c"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(2, 6.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("e e e e e"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cv = new CountVectorizerModel((String[])((Object[])new String[]{"a", "b", "c", "d"})).setInputCol("words").setOutputCol("features").setMinTF(3.0);
                Predef$.MODULE$.refArrayOps((Object[])cv.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Row x0$5) {
                        Row row = x0$5;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizerModel with minTF freq", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a a a b b c c c d "), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 3.0), new Tuple2.mcID.sp(2, 3.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("c c c c c c"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(2, 6.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("e e e e e"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cv = new CountVectorizerModel((String[])((Object[])new String[]{"a", "b", "c", "d"})).setInputCol("words").setOutputCol("features").setMinTF(0.3);
                Predef$.MODULE$.refArrayOps((Object[])cv.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(Row x0$6) {
                        Row row = x0$6;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizerModel and CountVectorizer with binary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CountVectorizerSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a a a a b b b b c d"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 1.0), new Tuple2.mcID.sp(3, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("c c c"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(2, 1.0)})))), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$split("a"), (Object)Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "words", "expected"}));
                CountVectorizerModel cv = new CountVectorizer().setInputCol("words").setOutputCol("features").setBinary(true).fit(df);
                Predef$.MODULE$.refArrayOps((Object[])cv.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Row x0$7) {
                        Row row = x0$7;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                CountVectorizerModel cv2 = new CountVectorizerModel(cv.vocabulary()).setInputCol("words").setOutputCol("features").setBinary(true);
                Predef$.MODULE$.refArrayOps((Object[])cv2.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Row x0$8) {
                        Row row = x0$8;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object expected = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (expected instanceof Vector) {
                                    Vector vector2 = (Vector)expected;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-14)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(features).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CountVectorizerSuite org$apache$spark$ml$feature$CountVectorizerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizer read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CountVectorizer t = new CountVectorizer().setInputCol("myInputCol").setOutputCol("myOutputCol").setMinDF(0.5).setMinTF(3.0).setVocabSize(10);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CountVectorizerModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountVectorizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CountVectorizerModel instance = new CountVectorizerModel("myCountVectorizerModel", (String[])((Object[])new String[]{"a", "b", "c"})).setInputCol("myInputCol").setOutputCol("myOutputCol").setMinTF(3.0);
                CountVectorizerModel newInstance = this.$outer.testDefaultReadWrite(instance, this.$outer.testDefaultReadWrite$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newInstance.vocabulary());
                String[] $org_scalatest_assert_macro_right = instance.vocabulary();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

