/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.IDF;
import org.apache.spark.ml.feature.IDFModel;
import org.apache.spark.ml.feature.IDFSuite$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\tA\u0011\n\u0012$Tk&$XM\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00135A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B;uS2T!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\t\u00037ui\u0011\u0001\b\u0006\u0003+\u0011I!A\b\u000f\u0003)\u0011+g-Y;miJ+\u0017\rZ,sSR,G+Z:u\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0003&\u0001\u0011\u0005a%\u0001\ttG\u0006dW\rR1uC^KG\u000f[%E\rR\u0019qeM\u001b\u0011\u0007!ZS&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0015\t%O]1z!\tq\u0013'D\u00010\u0015\t\u0001D!\u0001\u0004mS:\fGnZ\u0005\u0003e=\u0012aAV3di>\u0014\b\"\u0002\u001b%\u0001\u00049\u0013a\u00023bi\u0006\u001cV\r\u001e\u0005\u0006m\u0011\u0002\r!L\u0001\u0006[>$W\r\u001c")
public class IDFSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Vector[] scaleDataWithIDF(Vector[] dataSet, Vector model) {
        return (Vector[])Predef$.MODULE$.refArrayOps((Object[])dataSet).map((Function1)new Serializable(this, model){
            public static final long serialVersionUID = 0L;
            public final Vector model$1;

            public final Vector apply(Vector x0$1) {
                Vector vector;
                block4: {
                    Vector vector2;
                    block3: {
                        block2: {
                            vector = x0$1;
                            if (!(vector instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)vector;
                            double[] res = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(denseVector.toArray()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.model$1.toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, Object> x0$2) {
                                    Tuple2<Object, Object> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        double x = tuple2._1$mcD$sp();
                                        double y = tuple2._2$mcD$sp();
                                        double d = x * y;
                                        return d;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                            vector2 = Vectors$.MODULE$.dense(res);
                            break block3;
                        }
                        if (!(vector instanceof SparseVector)) break block4;
                        SparseVector sparseVector = (SparseVector)vector;
                        Tuple2[] res = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(sparseVector.indices()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(sparseVector.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$scaleDataWithIDF$1 $outer;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$3) {
                                Tuple2<Object, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int id = tuple2._1$mcI$sp();
                                    double value = tuple2._2$mcD$sp();
                                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, value * this.$outer.model$1.apply(id));
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                        vector2 = Vectors$.MODULE$.sparse(sparseVector.size(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])res));
                    }
                    return vector2;
                }
                throw new MatchError((Object)vector);
            }
            {
                this.model$1 = model$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
    }

    public IDFSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new IDF());
                IDFModel model = new IDFModel("idf", new org.apache.spark.mllib.feature.IDFModel(VectorImplicits$.MODULE$.mlVectorToMLlibVector(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))));
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("compute IDF with default parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numOfFeatures = 4;
                Vector[] data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(numOfFeatures, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(numOfFeatures, new int[]{1}, new double[]{1.0})});
                int numOfData = Predef$.MODULE$.refArrayOps((Object[])data).size();
                Vector idf = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2}).map((Function1)new Serializable(this, numOfData){
                    public static final long serialVersionUID = 0L;
                    private final int numOfData$1;

                    public final double apply(int x) {
                        return this.apply$mcDI$sp(x);
                    }

                    public double apply$mcDI$sp(int x) {
                        return scala.math.package$.MODULE$.log(((double)this.numOfData$1 + 1.0) / ((double)x + 1.0));
                    }
                    {
                        this.numOfData$1 = numOfData$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                Vector[] expected = this.$outer.scaleDataWithIDF(data, idf);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(IDFSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expected), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "expected"}));
                IDFModel idfModel = new IDF().setInputCol("features").setOutputCol("idfValue").fit(df);
                Predef$.MODULE$.refArrayOps((Object[])idfModel.transform(df).select("idfValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Vector) {
                                Vector vector = (Vector)x;
                                if (y instanceof Vector) {
                                    Vector vector2 = (Vector)y;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(x).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y).absTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Transformed vector is different with expected vector.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ IDFSuite org$apache$spark$ml$feature$IDFSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute IDF with setter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numOfFeatures = 4;
                Vector[] data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(numOfFeatures, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(numOfFeatures, new int[]{1}, new double[]{1.0})});
                int numOfData = Predef$.MODULE$.refArrayOps((Object[])data).size();
                Vector idf = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2}).map((Function1)new Serializable(this, numOfData){
                    public static final long serialVersionUID = 0L;
                    private final int numOfData$2;

                    public final double apply(int x) {
                        return this.apply$mcDI$sp(x);
                    }

                    public double apply$mcDI$sp(int x) {
                        return x > 0 ? scala.math.package$.MODULE$.log(((double)this.numOfData$2 + 1.0) / ((double)x + 1.0)) : 0.0;
                    }
                    {
                        this.numOfData$2 = numOfData$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                Vector[] expected = this.$outer.scaleDataWithIDF(data, idf);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(IDFSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expected), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "expected"}));
                IDFModel idfModel = new IDF().setInputCol("features").setOutputCol("idfValue").setMinDocFreq(1).fit(df);
                Predef$.MODULE$.refArrayOps((Object[])idfModel.transform(df).select("idfValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(Row x0$5) {
                        Row row = x0$5;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object x = ((SeqLike)some.get()).apply(0);
                            Object y = ((SeqLike)some.get()).apply(1);
                            if (x instanceof Vector) {
                                Vector vector = (Vector)x;
                                if (y instanceof Vector) {
                                    Vector vector2 = (Vector)y;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(x).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(y).absTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Transformed vector is different with expected vector.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ IDFSuite org$apache$spark$ml$feature$IDFSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IDF read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IDF t = new IDF().setInputCol("myInputCol").setOutputCol("myOutputCol").setMinDocFreq(5);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IDFModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IDFModel instance = new IDFModel("myIDFModel", new org.apache.spark.mllib.feature.IDFModel(VectorImplicits$.MODULE$.mlVectorToMLlibVector(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))))).setInputCol("myInputCol").setOutputCol("myOutputCol");
                IDFModel newInstance = this.$outer.testDefaultReadWrite(instance, this.$outer.testDefaultReadWrite$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newInstance.idf());
                Vector $org_scalatest_assert_macro_right = instance.idf();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

