/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaBucketizerSuite
extends SharedSparkSession {
    @Test
    public void bucketizerTest() {
        double[] splits = new double[]{-0.5, 0.0, 0.5};
        StructType schema = new StructType(new StructField[]{new StructField("feature", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset dataset = this.spark.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5}), RowFactory.create((Object[])new Object[]{-0.3}), RowFactory.create((Object[])new Object[]{0.0}), RowFactory.create((Object[])new Object[]{0.2})), schema);
        Bucketizer bucketizer = new Bucketizer().setInputCol("feature").setOutputCol("result").setSplits(splits);
        List result = bucketizer.transform(dataset).select("result", new String[0]).collectAsList();
        for (Row r : result) {
            double index = r.getDouble(0);
            Assert.assertTrue((index >= 0.0 && index <= 1.0 ? 1 : 0) != 0);
        }
    }
}

