/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.ml.feature.PCA;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;

public class JavaPCASuite
extends SharedSparkSession {
    @Test
    public void testPCA() {
        List<Vector> points = Arrays.asList(Vectors.sparse((int)5, (int[])new int[]{1, 3}, (double[])new double[]{1.0, 7.0}), Vectors.dense((double)2.0, (double[])new double[]{0.0, 3.0, 4.0, 5.0}), Vectors.dense((double)4.0, (double[])new double[]{0.0, 0.0, 6.0, 7.0}));
        JavaRDD dataRDD = this.jsc.parallelize(points, 2);
        RowMatrix mat = new RowMatrix(dataRDD.map((Function)new Function<Vector, org.apache.spark.mllib.linalg.Vector>(){

            public org.apache.spark.mllib.linalg.Vector call(Vector vector) {
                return new DenseVector(vector.toArray());
            }
        }).rdd());
        Matrix pc = mat.computePrincipalComponents(3);
        mat.multiply(pc).rows().toJavaRDD();
        JavaRDD expected = mat.multiply(pc).rows().toJavaRDD().map((Function)new Function<org.apache.spark.mllib.linalg.Vector, Vector>(){

            public Vector call(org.apache.spark.mllib.linalg.Vector vector) {
                return vector.asML();
            }
        });
        JavaRDD featuresExpected = dataRDD.zip((JavaRDDLike)expected).map((Function)new Function<Tuple2<Vector, Vector>, VectorPair>(){

            public VectorPair call(Tuple2<Vector, Vector> pair) {
                VectorPair featuresExpected = new VectorPair();
                featuresExpected.setFeatures((Vector)pair._1());
                featuresExpected.setExpected((Vector)pair._2());
                return featuresExpected;
            }
        });
        Dataset df = this.spark.createDataFrame(featuresExpected, VectorPair.class);
        PCAModel pca = new PCA().setInputCol("features").setOutputCol("pca_features").setK(3).fit(df);
        List result = pca.transform(df).select("pca_features", new String[]{"expected"}).toJavaRDD().collect();
        for (Row r : result) {
            Assert.assertEquals((Object)r.get(1), (Object)r.get(0));
        }
    }

    public static class VectorPair
    implements Serializable {
        private Vector features = Vectors.dense((double)0.0, (double[])new double[0]);
        private Vector expected = Vectors.dense((double)0.0, (double[])new double[0]);

        public void setFeatures(Vector features) {
            this.features = features;
        }

        public Vector getFeatures() {
            return this.features;
        }

        public void setExpected(Vector expected) {
            this.expected = expected;
        }

        public Vector getExpected() {
            return this.expected;
        }
    }
}

