/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.Word2Vec;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaWord2VecSuite
extends SharedSparkSession {
    @Test
    public void testJavaWord2Vec() {
        StructType schema = new StructType(new StructField[]{new StructField("text", (DataType)new ArrayType(DataTypes.StringType, true), false, Metadata.empty())});
        Dataset documentDF = this.spark.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("Hi I heard about Spark".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("I wish Java could use case classes".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("Logistic regression models are neat".split(" "))})), schema);
        Word2Vec word2Vec = new Word2Vec().setInputCol("text").setOutputCol("result").setVectorSize(3).setMinCount(0);
        Word2VecModel model = word2Vec.fit(documentDF);
        Dataset result = model.transform(documentDF);
        for (Row r : result.select("result", new String[0]).collectAsList()) {
            double[] polyFeatures = ((Vector)r.get(0)).toArray();
            Assert.assertEquals((long)polyFeatures.length, (long)3L);
        }
    }
}

